/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.abc.RenameType;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppDialog;
import com.jpexs.decompiler.flash.gui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RenameDialog
extends AppDialog {
    private final JRadioButton typeNumberRadioButton = new JRadioButton(this.translate("rename.type.typenumber"));
    private final JRadioButton randomWordRadioButton = new JRadioButton(this.translate("rename.type.randomword"));
    private final JButton okButton = new JButton(this.translate("button.ok"));
    private final JButton cancelButton = new JButton(this.translate("button.cancel"));
    private int result = -1;

    public RenameDialog(Window owner) {
        super(owner);
        this.setSize(300, 150);
        this.setDefaultCloseOperation(1);
        int renameType = (Integer)Configuration.lastRenameType.get();
        ButtonGroup group = new ButtonGroup();
        group.add(this.typeNumberRadioButton);
        group.add(this.randomWordRadioButton);
        JPanel pan = new JPanel();
        pan.setLayout(new BoxLayout(pan, 1));
        pan.add(this.typeNumberRadioButton);
        pan.add(this.randomWordRadioButton);
        this.typeNumberRadioButton.setSelected(renameType == 1);
        this.randomWordRadioButton.setSelected(renameType == 2);
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(this.translate("rename.type")), "North");
        this.add((Component)pan, "Center");
        JPanel panButtons = new JPanel(new FlowLayout());
        this.okButton.addActionListener(this::okButtonActionPerformed);
        this.cancelButton.addActionListener(this::cancelButtonActionPerformed);
        panButtons.add(this.okButton);
        panButtons.add(this.cancelButton);
        this.add((Component)panButtons, "South");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        View.setWindowIcon(this);
        this.setTitle(this.translate("dialog.title"));
        this.getRootPane().setDefaultButton(this.okButton);
        this.pack();
        View.centerScreen(this);
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.result = -1;
        }
        super.setVisible(b);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.result = 0;
        Configuration.lastRenameType.set((Object)(this.getRenameType() == RenameType.TYPENUMBER ? 1 : 2));
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = 1;
        this.setVisible(false);
    }

    public RenameType getRenameType() {
        if (this.result == -1) {
            return null;
        }
        if (this.typeNumberRadioButton.isSelected()) {
            return RenameType.TYPENUMBER;
        }
        return RenameType.RANDOMWORD;
    }

    public int showRenameDialog() {
        this.setVisible(true);
        return this.result;
    }
}

