/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.ErrorState;
import com.jpexs.decompiler.flash.gui.LoadingPanel;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.helpers.CancellableWorker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class MainFrameStatusPanel
extends JPanel {
    private final MainPanel mainPanel;
    private final LoadingPanel loadingPanel = new LoadingPanel(20, 20);
    private final JLabel statusLabel = new JLabel("");
    private final JButton cancelButton = new JButton();
    private JButton errorNotificationButton;
    private Icon currentIcon;
    private Timer blinkTimer;
    private int blinkPos;
    private CancellableWorker currentWorker;

    public MainFrameStatusPanel(MainPanel mainPanel) {
        this.mainPanel = mainPanel;
        this.createStatusPanel();
    }

    private void createStatusPanel() {
        JPanel statusLeftPanel = new JPanel();
        statusLeftPanel.setLayout(new BoxLayout(statusLeftPanel, 0));
        this.loadingPanel.setPreferredSize(new Dimension(30, 30));
        this.cancelButton.setText(this.translate("button.cancel"));
        this.cancelButton.setPreferredSize(new Dimension(100, 30));
        this.cancelButton.setBorderPainted(false);
        this.cancelButton.setOpaque(false);
        this.cancelButton.addActionListener(e -> {
            if (this.currentWorker != null) {
                this.currentWorker.cancel(true);
            }
        });
        statusLeftPanel.add(this.loadingPanel);
        statusLeftPanel.add(this.cancelButton);
        statusLeftPanel.add(this.statusLabel);
        this.setPreferredSize(new Dimension(1, 30));
        this.setBorder(new BevelBorder(1));
        this.setLayout(new BorderLayout());
        this.add((Component)statusLeftPanel, "West");
        this.errorNotificationButton = new JButton("");
        this.errorNotificationButton.setIcon(View.getIcon("okay16"));
        this.errorNotificationButton.setBorderPainted(false);
        this.errorNotificationButton.setFocusPainted(false);
        this.errorNotificationButton.setContentAreaFilled(false);
        this.errorNotificationButton.setMargin(new Insets(2, 2, 2, 2));
        this.errorNotificationButton.setCursor(Cursor.getPredefinedCursor(12));
        this.errorNotificationButton.addActionListener(this::showErrorLogButtonActionPerformed);
        this.errorNotificationButton.setToolTipText(this.translate("errors.none"));
        this.add((Component)this.errorNotificationButton, "East");
        this.loadingPanel.setVisible(false);
        this.cancelButton.setVisible(false);
    }

    private void showErrorLogButtonActionPerformed(ActionEvent evt) {
        Main.displayErrorFrame();
    }

    private String translate(String key) {
        return this.mainPanel.translate(key);
    }

    public void setStatus(String s) {
        this.statusLabel.setText(s);
    }

    public void setWorkStatus(String s, CancellableWorker worker) {
        if (s.isEmpty()) {
            this.loadingPanel.setVisible(false);
        } else {
            this.loadingPanel.setVisible(true);
        }
        this.statusLabel.setText(s);
        this.currentWorker = worker;
        this.cancelButton.setVisible(worker != null);
    }

    public void setErrorState(ErrorState errorState) {
        switch (errorState) {
            case NO_ERROR: {
                this.currentIcon = View.getIcon("okay16");
                this.errorNotificationButton.setToolTipText(this.translate("errors.none"));
                this.blinkPos = 0;
                break;
            }
            case INFO: {
                this.currentIcon = View.getIcon("information16");
                this.errorNotificationButton.setToolTipText(this.translate("errors.info"));
                break;
            }
            case WARNING: {
                this.currentIcon = View.getIcon("warning16");
                this.errorNotificationButton.setToolTipText(this.translate("errors.warning"));
                break;
            }
            case ERROR: {
                this.currentIcon = View.getIcon("error16");
                this.errorNotificationButton.setToolTipText(this.translate("errors.present"));
            }
        }
        this.errorNotificationButton.setIcon(this.currentIcon);
        if (errorState != ErrorState.NO_ERROR) {
            if (this.blinkTimer != null) {
                this.blinkTimer.cancel();
            }
            this.blinkTimer = new Timer();
            this.blinkTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    View.execInEventDispatch(() -> {
                        MainFrameStatusPanel.this.blinkPos++;
                        if (MainFrameStatusPanel.this.blinkPos % 2 == 0 || MainFrameStatusPanel.this.blinkPos >= 4) {
                            MainFrameStatusPanel.this.errorNotificationButton.setIcon(MainFrameStatusPanel.this.currentIcon);
                        } else {
                            MainFrameStatusPanel.this.errorNotificationButton.setIcon(null);
                            MainFrameStatusPanel.this.errorNotificationButton.setSize(16, 16);
                        }
                    });
                    if (MainFrameStatusPanel.this.blinkPos >= 4) {
                        this.cancel();
                    }
                }
            }, 500L, 500L);
        }
    }
}

