/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppRibbonFrame;
import com.jpexs.decompiler.flash.gui.FlashUnsupportedException;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.MainFrameMenu;
import com.jpexs.decompiler.flash.gui.MainFrameRibbonMenu;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.player.FlashPlayerPanel;
import com.jpexs.decompiler.flash.treeitems.SWFList;
import com.jpexs.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.io.File;
import java.util.List;
import org.pushingpixels.flamingo.api.ribbon.JRibbon;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;

public final class MainFrameRibbon
extends AppRibbonFrame {
    private final MainPanel panel;
    private final MainFrameMenu mainMenu;

    public MainFrameRibbon() {
        FlashPlayerPanel flashPanel = null;
        FlashPlayerPanel flashPanel2 = null;
        if (((Boolean)Configuration.useAdobeFlashPlayerForPreviews.get()).booleanValue()) {
            try {
                flashPanel = new FlashPlayerPanel((Component)((Object)this));
                flashPanel2 = new FlashPlayerPanel((Component)((Object)this));
            }
            catch (FlashUnsupportedException flashUnsupportedException) {
                // empty catch block
            }
        }
        Container cnt = this.getContentPane();
        cnt.setLayout(new BorderLayout());
        JRibbon ribbon = this.getRibbon();
        cnt.add((Component)ribbon, "North");
        boolean externalFlashPlayerUnavailable = flashPanel == null;
        this.mainMenu = new MainFrameRibbonMenu(this, ribbon, externalFlashPlayerUnavailable);
        this.mainMenu.createMenuBar();
        this.panel = new MainPanel(this, this.mainMenu, flashPanel, flashPanel2);
        this.panel.setBackground(Color.yellow);
        cnt.add((Component)this.panel, "Center");
        int w = (Integer)Configuration.guiWindowWidth.get();
        int h = (Integer)Configuration.guiWindowHeight.get();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        if (w > dim.width) {
            w = dim.width;
        }
        if (h > dim.height) {
            h = dim.height;
        }
        this.setSize(w, h);
        boolean maximizedHorizontal = (Boolean)Configuration.guiWindowMaximizedHorizontal.get();
        boolean maximizedVertical = (Boolean)Configuration.guiWindowMaximizedVertical.get();
        int state = 0;
        if (maximizedHorizontal) {
            state |= 2;
        }
        if (maximizedVertical) {
            state |= 4;
        }
        this.setExtendedState(state);
        View.setWindowIcon((Window)((Object)this));
        this.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                int state = e.getNewState();
                Configuration.guiWindowMaximizedHorizontal.set((Object)((state & 2) == 2 ? 1 : 0));
                Configuration.guiWindowMaximizedVertical.set((Object)((state & 4) == 4 ? 1 : 0));
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int state = MainFrameRibbon.this.getExtendedState();
                if ((state & 2) == 0) {
                    Configuration.guiWindowWidth.set((Object)MainFrameRibbon.this.getWidth());
                }
                if ((state & 4) == 0) {
                    Configuration.guiWindowHeight.set((Object)MainFrameRibbon.this.getHeight());
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                boolean closeResult;
                if (((Boolean)Configuration.saveSessionOnExit.get()).booleanValue()) {
                    StringBuilder sb = new StringBuilder();
                    StringBuilder sbt = new StringBuilder();
                    boolean first = true;
                    for (SWFList swf : MainFrameRibbon.this.panel.getSwfs()) {
                        if (!first) {
                            sb.append(File.pathSeparator);
                            sbt.append(File.pathSeparator);
                        }
                        first = false;
                        String file = swf.sourceInfo.getFile();
                        if (file == null) continue;
                        sb.append(file);
                        String t = swf.sourceInfo.getFileTitle();
                        sbt.append(t == null ? "" : t);
                    }
                    Configuration.lastSessionFiles.set((Object)sb.toString());
                    Configuration.lastSessionFileTitles.set((Object)sbt.toString());
                    String path = ((MainFrameRibbon)MainFrameRibbon.this).panel.tagTree.getSelectionPathString();
                    if (path != null) {
                        Configuration.lastSessionSelection.set((Object)path);
                    }
                }
                if (closeResult = MainFrameRibbon.this.panel.closeAll(true)) {
                    Main.exit();
                }
            }
        });
        View.centerScreen((Window)((Object)this));
    }

    private static void getApplicationMenuButtons(Component comp, List<JRibbonApplicationMenuButton> ret) {
        if (comp instanceof JRibbonApplicationMenuButton) {
            ret.add((JRibbonApplicationMenuButton)comp);
            return;
        }
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                MainFrameRibbon.getApplicationMenuButtons(cont.getComponent(i), ret);
            }
        }
    }

    @Override
    public MainPanel getPanel() {
        return this.panel;
    }

    @Override
    public Window getWindow() {
        return this;
    }

    @Override
    public void dispose() {
        this.removeAll();
        this.mainMenu.dispose();
        Helper.emptyObject((Object)this.mainMenu);
        this.panel.dispose();
        Helper.emptyObject((Object)this);
        super.dispose();
    }

    @Override
    public MainFrameMenu getMenu() {
        return this.mainMenu;
    }
}

