/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ListLayout
implements LayoutManager {
    private int border;

    public ListLayout() {
        this(5);
    }

    public ListLayout(int border) {
        this.border = border;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int h = 0;
        int maxw = 0;
        Insets ins = parent.getInsets();
        boolean first = true;
        for (Component c : parent.getComponents()) {
            if (!c.isVisible()) continue;
            h += this.border;
            Dimension pref = c.getPreferredSize();
            if (pref.width > maxw) {
                maxw = pref.width;
            }
            h += pref.height;
            first = false;
        }
        maxw = (parent.getSize().width == 0 ? maxw : parent.getSize().width) - ins.left - ins.right;
        return new Dimension(maxw, h += this.border);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension dim = this.preferredLayoutSize(parent);
        Insets ins = parent.getInsets();
        int top = ins.top;
        boolean first = true;
        for (Component c : parent.getComponents()) {
            if (!c.isVisible()) continue;
            if (!first) {
                top += this.border;
            }
            Dimension pref = c.getPreferredSize();
            c.setPreferredSize(new Dimension(dim.width, pref.height));
            c.setMinimumSize(new Dimension(dim.width, pref.height));
            c.setBounds(0, top, dim.width, pref.height);
            top += pref.height;
            first = false;
        }
    }
}

