/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.LocalDataArea;
import com.jpexs.decompiler.flash.action.Stage;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.SoundTagPlayer;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.player.MediaDisplay;
import com.jpexs.decompiler.flash.gui.player.MediaDisplayListener;
import com.jpexs.decompiler.flash.gui.player.Zoom;
import com.jpexs.decompiler.flash.tags.DefineButton2Tag;
import com.jpexs.decompiler.flash.tags.DefineButtonSoundTag;
import com.jpexs.decompiler.flash.tags.DefineButtonTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DisplayObjectCacheKey;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.SoundTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.Timeline;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.ConstantColorColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.Cache;
import com.jpexs.helpers.Reference;
import com.jpexs.helpers.SerializableImage;
import com.jpexs.helpers.Stopwatch;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public final class ImagePanel
extends JPanel
implements MediaDisplay {
    private static final Logger logger = Logger.getLogger(ImagePanel.class.getName());
    private final List<MediaDisplayListener> listeners = new ArrayList<MediaDisplayListener>();
    private Timelined timelined;
    private boolean stillFrame = false;
    private volatile Timer timer;
    private int frame = -1;
    private int prevFrame = -1;
    private boolean loop;
    private LocalDataArea lda;
    private boolean zoomAvailable = false;
    private SWF swf;
    private boolean loaded;
    private int mouseButton;
    private final JLabel debugLabel = new JLabel("-");
    private Point cursorPosition = null;
    private MouseEvent lastMouseEvent = null;
    private final List<SoundTagPlayer> soundPlayers = new ArrayList<SoundTagPlayer>();
    private final Cache<DisplayObjectCacheKey, SerializableImage> displayObjectCache = Cache.getInstance((boolean)false, (boolean)false, (String)"displayObject");
    private final IconPanel iconPanel;
    private int time = 0;
    private int selectedDepth = -1;
    private int freeTransformDepth = -1;
    private Zoom zoom = new Zoom();
    private final Object delayObject = new Object();
    private boolean drawReady;
    private final int drawWaitLimit = 50;
    private TextTag textTag;
    private TextTag newTextTag;
    private int msPerFrame;
    private final boolean lowQuality = false;
    private Object lock = new Object();
    private Point2D registrationPoint = null;
    private Point2D registrationPointUpdated = null;
    private int mode = 0;
    private Rectangle2D bounds;
    private Matrix transform;
    private AffineTransform transformUpdated;
    private final double LQ_FACTOR = 2.0;
    private static final int TOLERANCE_SCALESHEAR = 8;
    private static final int TOLERANCE_ROTATE = 30;
    private static final int REGISTRATION_TOLERANCE = 8;
    private static final double CENTER_POINT_SIZE = 8.0;
    private static final double HANDLES_WIDTH = 5.0;
    private static final int HANDLES_STROKE_WIDTH = 2;
    private static final int MODE_ROTATE_NE = -1;
    private static final int MODE_ROTATE_SE = -2;
    private static final int MODE_ROTATE_NW = -3;
    private static final int MODE_ROTATE_SW = -4;
    private static final int MODE_SHEAR_S = -5;
    private static final int MODE_SHEAR_E = -6;
    private static final int MODE_SHEAR_N = -7;
    private static final int MODE_SHEAR_W = -8;
    private static Cursor moveCursor;
    private static Cursor moveRegPointCursor;
    private static Cursor resizeNWSECursor;
    private static Cursor resizeSWNECursor;
    private static Cursor resizeXCursor;
    private static Cursor resizeYCursor;
    private static Cursor rotateCursor;
    private static Cursor selectCursor;
    private static Cursor shearXCursor;
    private static Cursor shearYCursor;
    private Point offsetPoint = new Point(0, 0);
    private Rectangle _rect = null;
    private ExportRectangle _viewRect = new ExportRectangle(0.0, 0.0, 1.0, 1.0);
    private boolean playing = false;
    private long startRun = 0L;
    private final long startDrop = 0L;
    private int skippedFrames = 0;
    private float fpsShouldBe = 0.0f;
    private float fpsIs = 0.0f;
    private Timer fpsTimer;
    private int startFrame = 0;
    private static final int ZOOM_DECADE_STEPS = 10;
    private static final double ZOOM_MULTIPLIER;
    private final double MAX_ZOOM = 1000000.0;

    private static Cursor loadCursor(String name, int x, int y) throws IOException {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        BufferedImage image = ImageIO.read(MainPanel.class.getResource("/com/jpexs/decompiler/flash/gui/graphics/cursors/" + name + ".png"));
        return toolkit.createCustomCursor(image, new Point(x, y), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MATRIX getNewMatrix() {
        Object object = this.lock;
        synchronized (object) {
            CharacterTag cht;
            DepthState ds = null;
            Timeline timeline = this.timelined.getTimeline();
            if (this.freeTransformDepth > -1 && timeline.getFrameCount() > this.frame) {
                ds = (DepthState)timeline.getFrame((int)this.frame).layers.get(this.freeTransformDepth);
            }
            if (ds != null && (cht = this.swf.getCharacter(ds.characterId)) != null && cht instanceof DrawableTag) {
                double zoomDouble;
                RECT rect = this.timelined.getRect();
                Matrix m = new Matrix();
                double zoom = zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
                m.translate((double)(-rect.Xmin) * zoom, (double)(-rect.Ymin) * zoom);
                m.scale(zoom);
                Matrix eMatrix = Matrix.getScaleInstance((double)0.05).concatenate(m).inverse();
                return this.transform.preConcatenate(eMatrix).toMATRIX();
            }
            return null;
        }
    }

    public synchronized void selectDepth(int depth) {
        if (depth != this.selectedDepth) {
            this.selectedDepth = depth;
            this.freeTransformDepth = -1;
        }
        this.hideMouseSelection();
        this.redraw();
    }

    private void calculateFreeTransform() {
        CharacterTag cht;
        DepthState ds = null;
        Timeline timeline = this.timelined.getTimeline();
        if (this.freeTransformDepth > -1 && timeline.getFrameCount() > this.frame) {
            ds = (DepthState)timeline.getFrame((int)this.frame).layers.get(this.freeTransformDepth);
        }
        if (ds != null && (cht = this.swf.getCharacter(ds.characterId)) != null && cht instanceof DrawableTag) {
            double zoomDouble;
            DrawableTag dt = (DrawableTag)cht;
            int drawableFrameCount = dt.getNumFrames();
            if (drawableFrameCount == 0) {
                drawableFrameCount = 1;
            }
            Matrix m = new Matrix();
            double zoom = zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
            m.translate(-this._viewRect.xMin * zoom, -this._viewRect.yMin * zoom);
            m.scale(zoom);
            this.transform = Matrix.getScaleInstance((double)0.05).concatenate(m).concatenate(new Matrix(ds.matrix));
        }
    }

    public synchronized void freeTransformDepth(int depth) {
        if (depth != this.freeTransformDepth) {
            this.freeTransformDepth = depth;
        }
        this.registrationPoint = null;
        this.calculateFreeTransform();
        this.hideMouseSelection();
    }

    public void fireMediaDisplayStateChanged() {
        for (MediaDisplayListener l : this.listeners) {
            l.mediaDisplayStateChanged(this);
        }
    }

    @Override
    public void addEventListener(MediaDisplayListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEventListener(MediaDisplayListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Color getBackgroundColor() {
        if (this.swf != null && this.swf.getBackgroundColor() != null) {
            return this.swf.getBackgroundColor().backgroundColor.toColor();
        }
        return Color.white;
    }

    @Override
    public void setBackground(Color bg) {
        if (this.iconPanel != null) {
            this.iconPanel.setBackground(bg);
        }
        super.setBackground(bg);
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        this.iconPanel.addMouseListener(l);
    }

    @Override
    public synchronized void removeMouseListener(MouseListener l) {
        this.iconPanel.removeMouseListener(l);
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        this.iconPanel.addMouseMotionListener(l);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener l) {
        this.iconPanel.removeMouseMotionListener(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updatePos(Timelined timelined, MouseEvent lastMouseEvent, Timer thisTimer) {
        if (timelined == null) return;
        Timelined bounded = timelined;
        RECT rect = bounded.getRect();
        int width = rect.getWidth();
        double scale = 1.0;
        Matrix m = Matrix.getTranslateInstance((double)(-rect.Xmin), (double)(-rect.Ymin));
        m.scale(scale);
        Point p = lastMouseEvent == null ? null : lastMouseEvent.getPoint();
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            if (this.timer != thisTimer) return;
            this.cursorPosition = p;
            // ** MonitorExit[var11_10] (shouldn't be in output)
            return;
        }
    }

    private void showSelectedName() {
        CharacterTag cht;
        DepthState ds;
        if (this.selectedDepth > -1 && this.frame > -1 && this.timelined != null && (ds = (DepthState)this.timelined.getTimeline().getFrame((int)this.frame).layers.get(this.selectedDepth)) != null && (cht = this.timelined.getTimeline().swf.getCharacter(ds.characterId)) != null) {
            this.debugLabel.setText(cht.getName());
        }
    }

    public void hideMouseSelection() {
        if (this.selectedDepth > -1) {
            this.showSelectedName();
        } else {
            this.debugLabel.setText(" - ");
        }
    }

    public ImagePanel() {
        super(new BorderLayout());
        this.setOpaque(true);
        this.setBackground(View.getDefaultBackgroundColor());
        this.loop = true;
        this.iconPanel = new IconPanel();
        this.add((Component)this.iconPanel, "Center");
        this.add((Component)this.debugLabel, "North");
        this.iconPanel.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseEntered(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseExited(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    ImagePanel.this.lastMouseEvent = null;
                    ImagePanel.this.hideMouseSelection();
                    ImagePanel.this.redraw();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mousePressed(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    ImagePanel.this.mouseButton = e.getButton();
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    ButtonTag button = ImagePanel.this.iconPanel.mouseOverButton;
                    if (button != null && ImagePanel.this.freeTransformDepth == -1) {
                        DefineButtonSoundTag sounds = button.getSounds();
                        if (sounds != null && sounds.buttonSoundChar2 != 0) {
                            ImagePanel.this.playSound((SoundTag)ImagePanel.this.swf.getCharacter(sounds.buttonSoundChar2), sounds.buttonSoundInfo2, ImagePanel.this.timer);
                        }
                        ArrayList<ByteArrayRange> actions = new ArrayList<ByteArrayRange>();
                        if (button instanceof DefineButton2Tag) {
                            DefineButton2Tag button2 = (DefineButton2Tag)button;
                            for (BUTTONCONDACTION ca : button2.actions) {
                                if (!ca.condOverUpToOverDown) continue;
                                actions.add(ca.actionBytes);
                            }
                        }
                        if (button instanceof DefineButtonTag) {
                            DefineButtonTag button1 = (DefineButtonTag)button;
                            actions.add(button1.actionBytes);
                        }
                        for (ByteArrayRange actionBytes : actions) {
                            try {
                                int prevLength = actionBytes.getPos();
                                SWFInputStream rri = new SWFInputStream(ImagePanel.this.swf, actionBytes.getArray(), 0L, prevLength + actionBytes.getLength());
                                if (prevLength != 0) {
                                    rri.seek((long)prevLength);
                                }
                                ImagePanel.this.execute(rri);
                            }
                            catch (IOException ex) {
                                Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseReleased(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    DefineButtonSoundTag sounds;
                    ImagePanel.this.mouseButton = 0;
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    ButtonTag button = ImagePanel.this.iconPanel.mouseOverButton;
                    if (button != null && ImagePanel.this.freeTransformDepth == -1 && (sounds = button.getSounds()) != null && sounds.buttonSoundChar3 != 0) {
                        ImagePanel.this.playSound((SoundTag)ImagePanel.this.swf.getCharacter(sounds.buttonSoundChar3), sounds.buttonSoundInfo3, ImagePanel.this.timer);
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
        this.iconPanel.addMouseMotionListener(new MouseMotionAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseMoved(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDragged(MouseEvent e) {
                Class<ImagePanel> clazz = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    ImagePanel.this.lastMouseEvent = e;
                    ImagePanel.this.redraw();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    private synchronized void redraw() {
        if (this.timer == null && this.timelined != null) {
            this.startTimer(this.timelined.getTimeline(), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void zoom(Zoom zoom) {
        boolean modified;
        double zoomDoubleBefore = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        boolean bl = modified = this.zoom.value != zoom.value || this.zoom.fit != zoom.fit;
        if (modified) {
            ExportRectangle oldViewRect = new ExportRectangle(this._viewRect);
            Rectangle oldRect = new Rectangle(this._rect);
            this.zoom = zoom;
            this.displayObjectCache.clear();
            double zoomDouble = zoom.fit ? this.getZoomToFit() : zoom.value;
            this.offsetPoint.x = (int)((double)this.offsetPoint.x * zoomDouble / zoomDoubleBefore);
            this.offsetPoint.y = (int)((double)this.offsetPoint.y * zoomDouble / zoomDoubleBefore);
            this.iconPanel.calcRect();
            this._viewRect = this.getViewRect();
            Object object = this.lock;
            synchronized (object) {
                if (this.transform != null) {
                    Matrix m = new Matrix();
                    m.scale(0.05);
                    m.translate(-oldViewRect.xMin * zoomDoubleBefore, -oldViewRect.yMin * zoomDoubleBefore);
                    m.scale(zoomDoubleBefore);
                    Matrix mi = m.inverse();
                    this.transform = this.transform.preConcatenate(mi);
                    Matrix m2 = new Matrix();
                    m2.scale(0.05);
                    m2.translate(-this._viewRect.xMin * zoomDouble, -this._viewRect.yMin * zoomDouble);
                    m2.scale(zoomDouble);
                    this.transform = this.transform.preConcatenate(m2);
                    if (this.registrationPoint != null) {
                        double actualRegPointX = oldViewRect.xMin * zoomDoubleBefore / 20.0 + this.registrationPoint.getX();
                        double actualRegPointY = oldViewRect.yMin * zoomDoubleBefore / 20.0 + this.registrationPoint.getY();
                        double sizedRegPointX = actualRegPointX * zoomDouble / zoomDoubleBefore;
                        double sizedRegPointY = actualRegPointY * zoomDouble / zoomDoubleBefore;
                        double regPointX = sizedRegPointX - this._viewRect.xMin * zoomDouble / 20.0;
                        double regPointY = sizedRegPointY - this._viewRect.yMin * zoomDouble / 20.0;
                        this.registrationPoint = new Point2D.Double(regPointX, regPointY);
                    }
                }
            }
            this.redraw();
            if (this.textTag != null) {
                this.setText(this.textTag, this.newTextTag);
            }
            this.fireMediaDisplayStateChanged();
        }
    }

    @Override
    public synchronized BufferedImage printScreen() {
        return this.iconPanel.getLastImage();
    }

    @Override
    public synchronized double getZoomToFit() {
        if (this.timelined != null) {
            double h2;
            double w2;
            RECT bounds = this.timelined.getRectWithStrokes();
            double w1 = (double)bounds.getWidth() / 20.0;
            double h1 = (double)bounds.getHeight() / 20.0;
            double h = h1 * (w2 = (double)this.iconPanel.getWidth()) / w1;
            double w = h > (h2 = (double)this.iconPanel.getHeight()) ? w1 * h2 / h1 : w2;
            if (w1 <= Double.MIN_NORMAL) {
                return 1.0;
            }
            return w / w1;
        }
        return 1.0;
    }

    @Override
    public synchronized boolean zoomAvailable() {
        return this.zoomAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimelined(Timelined drawable, final SWF swf, int frame) {
        Stage stage = new Stage(drawable){

            public void callFrame(int frame) {
                ImagePanel.this.executeFrame(frame);
            }

            public Object callFunction(long functionAddress, long functionLength, List<Object> args, Map<Integer, String> regNames, Object thisObj) {
                try {
                    SWFInputStream sis = new SWFInputStream(swf, swf.uncompressedData, functionAddress, (int)(functionAddress + functionLength));
                    return ImagePanel.this.execute(sis);
                }
                catch (IOException ex) {
                    Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
                    return Undefined.INSTANCE;
                }
            }

            public int getCurrentFrame() {
                return ImagePanel.this.getCurrentFrame();
            }

            public int getTotalFrames() {
                return ImagePanel.this.getTotalFrames();
            }

            public void gotoFrame(int frame) {
                ImagePanel.this.pause();
                ImagePanel.this.gotoFrame(frame);
            }

            public void gotoLabel(String label) {
            }

            public void pause() {
                ImagePanel.this.pause();
            }

            public void play() {
                ImagePanel.this.play();
            }

            public void trace(Object ... val) {
                for (Object o : val) {
                    System.out.println("trace:" + o.toString());
                }
            }
        };
        this.lda = new LocalDataArea(stage);
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            this.stopInternal();
            if (drawable instanceof ButtonTag) {
                frame = ButtonTag.FRAME_UP;
            }
            this.displayObjectCache.clear();
            this.timelined = drawable;
            this.swf = swf;
            this.zoomAvailable = true;
            this.timer = null;
            if (frame > -1) {
                this.frame = frame;
                this.stillFrame = true;
            } else {
                this.frame = 0;
                this.stillFrame = false;
            }
            this.prevFrame = -1;
            this.loaded = true;
            if (drawable.getTimeline().getFrameCount() == 0) {
                this.clearImagePanel();
                this.fireMediaDisplayStateChanged();
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            this.time = 0;
            this.drawReady = false;
            this.redraw();
            this.play();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            clazz = this.delayObject;
            synchronized (clazz) {
                try {
                    this.delayObject.wait(50L);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            clazz = ImagePanel.class;
            synchronized (ImagePanel.class) {
                if (!this.drawReady) {
                    this.clearImagePanel();
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                this.fireMediaDisplayStateChanged();
                return;
            }
        }
    }

    public synchronized void setImage(SerializableImage image) {
        this.lda = null;
        this.setBackground(View.getSwfBackgroundColor());
        this.clear();
        this.timelined = null;
        this.loaded = true;
        this.stillFrame = true;
        this.zoomAvailable = false;
        this.iconPanel.setImg(image);
        this.drawReady = true;
        this.fireMediaDisplayStateChanged();
    }

    public synchronized void setText(TextTag textTag, TextTag newTextTag) {
        this.setBackground(View.getSwfBackgroundColor());
        this.clear();
        this.lda = null;
        this.timelined = null;
        this.loaded = true;
        this.stillFrame = true;
        this.zoomAvailable = true;
        this.textTag = textTag;
        this.newTextTag = newTextTag;
        double zoomDouble = this.zoom.fit ? this.getZoomToFit() : this.zoom.value;
        RECT rect = textTag.getRect();
        int width = (int)((double)rect.Xmax * zoomDouble);
        int height = (int)((double)rect.Ymax * zoomDouble);
        SerializableImage image = new SerializableImage((int)((double)width / 20.0) + 1, (int)((double)height / 20.0) + 1, SerializableImage.TYPE_INT_ARGB);
        image.fillTransparent();
        Matrix m = Matrix.getTranslateInstance((double)((double)(-rect.Xmin) * zoomDouble), (double)((double)(-rect.Ymin) * zoomDouble));
        m.scale(zoomDouble);
        textTag.toImage(0, 0, 0, new RenderContext(), image, image, false, m, m, m, m, (ColorTransform)new ConstantColorColorTransform(-4144960), zoomDouble, false, new ExportRectangle(rect), true, 0);
        if (newTextTag != null) {
            newTextTag.toImage(0, 0, 0, new RenderContext(), image, image, false, m, m, m, m, (ColorTransform)new ConstantColorColorTransform(-16777216), zoomDouble, false, new ExportRectangle(rect), true, 0);
        }
        this.iconPanel.setImg(image);
        this.drawReady = true;
        this.fireMediaDisplayStateChanged();
    }

    private synchronized void clearImagePanel() {
        this.iconPanel.setImg(null);
    }

    @Override
    public synchronized int getCurrentFrame() {
        return this.frame + 1;
    }

    @Override
    public synchronized int getTotalFrames() {
        if (this.timelined == null) {
            return 0;
        }
        if (this.stillFrame) {
            return 0;
        }
        return this.timelined.getTimeline().getFrameCount();
    }

    @Override
    public void pause() {
        this.stopInternal();
        this.redraw();
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public void stop() {
        this.stopInternal();
        this.rewind();
        this.redraw();
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public void close() throws IOException {
        this.stopInternal();
    }

    private void stopAllSounds() {
        for (int i = this.soundPlayers.size() - 1; i >= 0; --i) {
            SoundTagPlayer pl = this.soundPlayers.get(i);
            pl.close();
        }
        this.soundPlayers.clear();
    }

    private void clear() {
        if (this.timer != null) {
            Timer ptimer = this.timer;
            this.timer = null;
            ptimer.cancel();
            this.fireMediaDisplayStateChanged();
        }
        this.textTag = null;
        this.newTextTag = null;
        this.displayObjectCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nextFrame(Timer thisTimer, int cnt, int timeShouldBe) {
        this.drawFrame(thisTimer, true);
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            if (this.timelined != null && this.timer == thisTimer) {
                int frameCount = this.timelined.getTimeline().getFrameCount();
                int oldFrame = this.frame;
                for (int i = 0; i < cnt; ++i) {
                    if (!this.stillFrame && frameCount > 0) {
                        this.frame = (this.frame + 1) % frameCount;
                    }
                    if (!this.stillFrame && this.frame == frameCount - 1 && !this.loop) {
                        this.stopInternal();
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                    if (i >= cnt - 1) continue;
                    this.drawFrame(thisTimer, false);
                }
                if (this.frame != oldFrame) {
                    if (this.frame == 0) {
                        this.stopAllSounds();
                    }
                    this.time = 0;
                } else {
                    this.time = timeShouldBe;
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.fireMediaDisplayStateChanged();
            return;
        }
    }

    private static SerializableImage getFrame(ExportRectangle viewRect, SWF swf, int frame, int time, Timelined drawable, RenderContext renderContext, int selectedDepth, int freeTransformDepth, double zoom, Reference<Point2D> registrationPointRef, Reference<Rectangle2D> boundsRef, Matrix transform, Matrix temporaryMatrix) {
        Rectangle bounds;
        Shape outline;
        int dframe;
        int drawableFrameCount;
        DrawableTag dt;
        CharacterTag cht;
        Timeline timeline = drawable.getTimeline();
        RECT rect = drawable.getRect();
        int width = (int)(viewRect.getWidth() * zoom);
        int height = (int)(viewRect.getHeight() * zoom);
        if (width == 0) {
            width = 1;
        }
        if (height == 0) {
            height = 1;
        }
        SerializableImage image = new SerializableImage((int)Math.ceil((double)width / 20.0), (int)Math.ceil((double)height / 20.0), SerializableImage.TYPE_INT_ARGB);
        image.fillTransparent();
        Matrix m = new Matrix();
        m.translate(-viewRect.xMin * zoom, -viewRect.yMin * zoom);
        m.scale(zoom);
        Matrix fullM = m.clone();
        MATRIX oldMatrix = null;
        if (freeTransformDepth > -1) {
            Matrix eMatrix = Matrix.getScaleInstance((double)0.05).concatenate(m).inverse();
            MATRIX newMatrix = transform.preConcatenate(eMatrix).toMATRIX();
            oldMatrix = ((DepthState)timeline.getFrame((int)frame).layers.get((Object)Integer.valueOf((int)freeTransformDepth))).matrix;
            ((DepthState)timeline.getFrame((int)frame).layers.get((Object)Integer.valueOf((int)freeTransformDepth))).matrix = newMatrix;
        }
        timeline.toImage(frame, time, renderContext, image, image, false, m, new Matrix(), m, null, zoom, false, viewRect, fullM, true, 0);
        Graphics2D gg = (Graphics2D)image.getGraphics();
        gg.setStroke(new BasicStroke(3.0f));
        gg.setPaint(Color.green);
        gg.setTransform(AffineTransform.getTranslateInstance(0.0, 0.0));
        DepthState ds = null;
        if (selectedDepth > -1 && timeline.getFrameCount() > frame) {
            ds = (DepthState)timeline.getFrame((int)frame).layers.get(selectedDepth);
        }
        if (ds != null && (cht = swf.getCharacter(ds.characterId)) != null && cht instanceof DrawableTag) {
            dt = (DrawableTag)cht;
            drawableFrameCount = dt.getNumFrames();
            if (drawableFrameCount == 0) {
                drawableFrameCount = 1;
            }
            dframe = time % drawableFrameCount;
            outline = dt.getOutline(dframe, time, ds.ratio, renderContext, Matrix.getScaleInstance((double)0.05).concatenate(m.concatenate(new Matrix(ds.matrix))), true);
            bounds = outline.getBounds();
            gg.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{10.0f}, 0.0f));
            gg.setPaint(Color.red);
            gg.draw(bounds);
        }
        ds = null;
        if (freeTransformDepth > -1 && timeline.getFrameCount() > frame) {
            ds = (DepthState)timeline.getFrame((int)frame).layers.get(freeTransformDepth);
        }
        if (ds != null && (cht = swf.getCharacter(ds.characterId)) != null && cht instanceof DrawableTag) {
            dt = (DrawableTag)cht;
            drawableFrameCount = dt.getNumFrames();
            if (drawableFrameCount == 0) {
                drawableFrameCount = 1;
            }
            dframe = time % drawableFrameCount;
            outline = dt.getOutline(dframe, time, ds.ratio, renderContext, transform, true);
            if (temporaryMatrix != null) {
                Shape tempOutline = dt.getOutline(dframe, time, ds.ratio, renderContext, temporaryMatrix, true);
                gg.setStroke(new BasicStroke(1.0f));
                gg.setPaint(Color.black);
                gg.draw(tempOutline);
            }
            bounds = outline.getBounds();
            boundsRef.setVal((Object)bounds);
            gg.setStroke(new BasicStroke(1.0f));
            gg.setPaint(Color.black);
            gg.draw(bounds);
            ImagePanel.drawHandles(gg, bounds);
            if (registrationPointRef.getVal() == null) {
                registrationPointRef.setVal((Object)new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()));
            }
            ImagePanel.drawRegistrationPoint(gg, (Point2D)registrationPointRef.getVal());
        }
        if (freeTransformDepth > -1 && timeline != null && timeline.getFrameCount() > frame) {
            ((DepthState)timeline.getFrame((int)frame).layers.get((Object)Integer.valueOf((int)freeTransformDepth))).matrix = oldMatrix;
        }
        SerializableImage img = image;
        return img;
    }

    private static void drawRegistrationPoint(Graphics2D g2, Point2D registrationPoint) {
        BasicStroke stroke = new BasicStroke(1.0f);
        g2.setStroke(stroke);
        g2.setColor(Color.white);
        Ellipse2D.Double registrationPointShape = new Ellipse2D.Double(registrationPoint.getX() - 4.0, registrationPoint.getY() - 4.0, 8.0, 8.0);
        g2.fill(registrationPointShape);
        g2.setColor(Color.black);
        g2.draw(registrationPointShape);
    }

    private static void drawHandles(Graphics2D g2, Rectangle bounds) {
        ImagePanel.drawHandle(g2, bounds.getX(), bounds.getY());
        ImagePanel.drawHandle(g2, bounds.getCenterX(), bounds.getY());
        ImagePanel.drawHandle(g2, bounds.getX() + bounds.getWidth(), bounds.getY());
        ImagePanel.drawHandle(g2, bounds.getX(), bounds.getCenterY());
        ImagePanel.drawHandle(g2, bounds.getX(), bounds.getY() + bounds.getHeight());
        ImagePanel.drawHandle(g2, bounds.getX() + bounds.getWidth(), bounds.getCenterY());
        ImagePanel.drawHandle(g2, bounds.getX() + bounds.getWidth(), bounds.getY() + bounds.getHeight());
        ImagePanel.drawHandle(g2, bounds.getCenterX(), bounds.getY() + bounds.getHeight());
    }

    private static void drawHandle(Graphics2D g2, double x, double y) {
        Rectangle2D.Double handleTopCenter = new Rectangle2D.Double(x - 2.5, y - 2.5, 7.0, 7.0);
        g2.setColor(Color.black);
        g2.fill(handleTopCenter);
        BasicStroke stroke = new BasicStroke(2.0f);
        g2.setStroke(stroke);
        g2.setColor(Color.white);
        g2.draw(handleTopCenter);
    }

    private Object execute(SWFInputStream sis) throws IOException {
        Action a;
        if (!((Boolean)Configuration.internalFlashViewerExecuteAs12.get()).booleanValue()) {
            return Undefined.INSTANCE;
        }
        if (this.lda == null) {
            return Undefined.INSTANCE;
        }
        long ip = sis.getPos();
        while ((a = sis.readAction()) != null) {
            int actionLengthWithHeader = a.getTotalActionLength();
            a.setAddress(ip);
            a.execute(this.lda);
            if (this.lda.returnValue != null) {
                return this.lda.returnValue;
            }
            if (this.lda.jump != null) {
                ip = this.lda.jump;
                this.lda.jump = null;
            } else {
                ip += (long)actionLengthWithHeader;
            }
            sis.seek(ip);
        }
        return Undefined.INSTANCE;
    }

    private void executeFrame(int frame) {
        if (!((Boolean)Configuration.internalFlashViewerExecuteAs12.get()).booleanValue()) {
            return;
        }
        if (this.timelined == null) {
            return;
        }
        Frame f = this.timelined.getTimeline().getFrame(frame);
        List actions = f.actions;
        if (this.lda != null) {
            this.lda.clear();
        }
        for (DoActionTag src : actions) {
            try {
                ByteArrayRange actionBytes = src.getActionBytes();
                int prevLength = actionBytes.getPos();
                SWFInputStream rri = new SWFInputStream(this.swf, actionBytes.getArray(), 0L, prevLength + actionBytes.getLength());
                if (prevLength != 0) {
                    rri.seek((long)prevLength);
                }
                this.execute(rri);
            }
            catch (IOException ex) {
                Logger.getLogger(ImagePanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportRectangle getViewRect() {
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            double zoomDouble;
            Zoom zoom = this.zoom;
            if (this.timelined == null) {
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return new ExportRectangle(0.0, 0.0, 1.0, 1.0);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            double d = zoomDouble = zoom.fit ? this.getZoomToFit() : zoom.value;
            if (this._rect == null) {
                this.iconPanel.calcRect();
            }
            ExportRectangle aRect = new ExportRectangle((Rectangle2D)this._rect);
            ExportRectangle viewRect = new ExportRectangle(new RECT());
            RECT timRect = this.timelined.getRectWithStrokes();
            double w = (double)timRect.getWidth() * zoomDouble / 20.0;
            viewRect.xMin = aRect.xMin >= 0.0 ? 0.0 : -aRect.xMin;
            if (w + aRect.xMin > (double)this.iconPanel.getWidth()) {
                w = -aRect.xMin + (double)this.iconPanel.getWidth();
            }
            viewRect.xMax = w;
            double h = (double)timRect.getHeight() * zoomDouble / 20.0;
            viewRect.yMin = aRect.yMin >= 0.0 ? 0.0 : -aRect.yMin;
            if (h + aRect.yMin > (double)this.iconPanel.getHeight()) {
                h = -aRect.yMin + (double)this.iconPanel.getHeight();
            }
            viewRect.yMax = h;
            viewRect.xMin *= 20.0;
            viewRect.xMax *= 20.0;
            viewRect.yMin *= 20.0;
            viewRect.yMax *= 20.0;
            viewRect.xMin /= zoomDouble;
            viewRect.xMax /= zoomDouble;
            viewRect.yMin /= zoomDouble;
            viewRect.yMax /= zoomDouble;
            viewRect.xMin += (double)timRect.Xmin;
            viewRect.yMin += (double)timRect.Ymin;
            viewRect.xMax += (double)timRect.Xmin;
            viewRect.yMax += (double)timRect.Ymin;
            return viewRect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawFrame(Timer thisTimer, boolean display) {
        Class<ImagePanel> clazz = ImagePanel.class;
        synchronized (ImagePanel.class) {
            Timelined timelined = this.timelined;
            MouseEvent lastMouseEvent = this.lastMouseEvent;
            // ** MonitorExit[var12_3] (shouldn't be in output)
            boolean shownAgain = false;
            Class<ImagePanel> clazz2 = ImagePanel.class;
            synchronized (ImagePanel.class) {
                Object object;
                SerializableImage img;
                int frame = this.frame;
                int time = this.time;
                if (this.frame == this.prevFrame) {
                    shownAgain = true;
                }
                this.prevFrame = this.frame;
                Point cursorPosition = this.cursorPosition;
                if (cursorPosition != null) {
                    cursorPosition = this.iconPanel.toImagePoint(cursorPosition);
                }
                int mouseButton = this.mouseButton;
                int selectedDepth = this.selectedDepth;
                Zoom zoom = this.zoom;
                SWF swf = this.swf;
                // ** MonitorExit[var13_8] (shouldn't be in output)
                if (timelined == null) {
                    return;
                }
                this.iconPanel.calcRect();
                RenderContext renderContext = new RenderContext();
                renderContext.displayObjectCache = this.displayObjectCache;
                if (cursorPosition != null && this.freeTransformDepth == -1) {
                    renderContext.cursorPosition = new Point((int)((double)cursorPosition.x * 20.0), (int)((double)cursorPosition.y * 20.0));
                }
                renderContext.mouseButton = mouseButton;
                renderContext.stateUnderCursor = new ArrayList();
                try {
                    Object boundsRef;
                    Timeline timeline = timelined.getTimeline();
                    if (frame >= timeline.getFrameCount()) {
                        return;
                    }
                    double zoomDouble = zoom.fit ? this.getZoomToFit() : zoom.value;
                    this.updatePos(timelined, lastMouseEvent, thisTimer);
                    Matrix mat = new Matrix();
                    mat.translateX = swf.displayRect.Xmin;
                    mat.translateY = swf.displayRect.Ymin;
                    img = null;
                    if (display) {
                        Stopwatch sw = Stopwatch.startNew();
                        object = this.lock;
                        synchronized (object) {
                            Reference registrationPointRef = new Reference((Object)this.registrationPoint);
                            boundsRef = new Reference((Object)this.bounds);
                            this._viewRect = this.getViewRect();
                            img = this._viewRect.getHeight() < 0.0 || this._viewRect.getWidth() < 0.0 ? new SerializableImage(1, 1, 6) : ImagePanel.getFrame(this._viewRect, swf, frame, time, timelined, renderContext, selectedDepth, this.freeTransformDepth, zoomDouble, (Reference<Point2D>)registrationPointRef, (Reference<Rectangle2D>)boundsRef, this.transform, this.transformUpdated == null ? null : new Matrix(this.transformUpdated));
                            this.bounds = (Rectangle2D)boundsRef.getVal();
                            this.registrationPoint = (Point2D)registrationPointRef.getVal();
                        }
                        sw.stop();
                        if (sw.getElapsedMilliseconds() > 100L && ((Boolean)Configuration.showSlowRenderingWarning.get()).booleanValue()) {
                            logger.log(Level.WARNING, "Slow rendering. {0}. frame, time={1}, {2}ms", new Object[]{frame, time, sw.getElapsedMilliseconds()});
                        }
                        if (renderContext.borderImage != null) {
                            img = renderContext.borderImage;
                        }
                    }
                    if (!shownAgain) {
                        CharacterTag c;
                        ArrayList<Integer> sounds = new ArrayList<Integer>();
                        ArrayList soundClasses = new ArrayList();
                        ArrayList soundInfos = new ArrayList();
                        timeline.getSounds(frame, time, renderContext.mouseOverButton, mouseButton, sounds, soundClasses, soundInfos);
                        boundsRef = swf.getCharacters().keySet().iterator();
                        while (boundsRef.hasNext()) {
                            int cid = (Integer)boundsRef.next();
                            c = swf.getCharacter(cid);
                            for (int k = 0; k < soundClasses.size(); ++k) {
                                String cls = (String)soundClasses.get(k);
                                if (cls == null || !cls.equals(c.getClassName())) continue;
                                sounds.set(k, cid);
                            }
                        }
                        for (int s = 0; s < sounds.size(); ++s) {
                            int sndId = (Integer)sounds.get(s);
                            if (sndId == -1 || !((c = swf.getCharacter(sndId)) instanceof SoundTag)) continue;
                            SoundTag st = (SoundTag)c;
                            this.playSound(st, (SOUNDINFO)soundInfos.get(s), thisTimer);
                        }
                        this.executeFrame(frame);
                    }
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    return;
                }
                if (!display) return;
                StringBuilder ret = new StringBuilder();
                if (cursorPosition != null) {
                    ret.append(" [").append(cursorPosition.x).append(",").append(cursorPosition.y).append("] : ");
                }
                boolean handCursor = renderContext.mouseOverButton != null;
                boolean first = true;
                for (int i = renderContext.stateUnderCursor.size() - 1; i >= 0; --i) {
                    DepthState ds = (DepthState)renderContext.stateUnderCursor.get(i);
                    if (!first) {
                        ret.append(", ");
                    }
                    first = false;
                    CharacterTag c = swf.getCharacter(ds.characterId);
                    ret.append(c.toString());
                    if (ds.depth <= 0) continue;
                    ret.append(" ");
                    ret.append(AppStrings.translate("imagePanel.depth"));
                    ret.append(" ");
                    ret.append(ds.depth);
                }
                if (first) {
                    ret.append(" - ");
                }
                Class<ImagePanel> clazz3 = ImagePanel.class;
                synchronized (ImagePanel.class) {
                    if (this.timer != thisTimer) return;
                    this.iconPanel.setImg(img);
                    ButtonTag lastMouseOverButton = this.iconPanel.mouseOverButton;
                    this.iconPanel.mouseOverButton = renderContext.mouseOverButton;
                    this.debugLabel.setText(ret.toString());
                    if (this.freeTransformDepth == -1) {
                        if (handCursor) {
                            this.iconPanel.setCursor(Cursor.getPredefinedCursor(12));
                        } else if (this.iconPanel.hasAllowMove()) {
                            this.iconPanel.setCursor(Cursor.getPredefinedCursor(13));
                        } else {
                            this.iconPanel.setCursor(Cursor.getPredefinedCursor(0));
                        }
                    }
                    if (lastMouseOverButton != renderContext.mouseOverButton) {
                        DefineButtonSoundTag sounds;
                        ButtonTag b = renderContext.mouseOverButton;
                        if (b != null && this.freeTransformDepth == -1 && (sounds = b.getSounds()) != null && sounds.buttonSoundChar1 != 0) {
                            this.playSound((SoundTag)swf.getCharacter(sounds.buttonSoundChar1), sounds.buttonSoundInfo1, this.timer);
                        }
                        if ((b = lastMouseOverButton) != null && this.freeTransformDepth == -1 && (sounds = b.getSounds()) != null && sounds.buttonSoundChar0 != 0) {
                            this.playSound((SoundTag)swf.getCharacter(sounds.buttonSoundChar0), sounds.buttonSoundInfo0, this.timer);
                        }
                    }
                    this.drawReady = true;
                    object = this.delayObject;
                    synchronized (object) {
                        this.delayObject.notify();
                    }
                    // ** MonitorExit[var19_25] (shouldn't be in output)
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void playSound(SoundTag st, SOUNDINFO soundInfo, Timer thisTimer) {
        try {
            int loopCount = 1;
            if (soundInfo != null && soundInfo.hasLoops) {
                loopCount = Math.max(1, soundInfo.loopCount);
            }
            final SoundTagPlayer sp = new SoundTagPlayer(soundInfo, st, loopCount, false);
            sp.addEventListener(new MediaDisplayListener(){

                @Override
                public void mediaDisplayStateChanged(MediaDisplay source) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void playingFinished(MediaDisplay source) {
                    Class<ImagePanel> clazz = ImagePanel.class;
                    synchronized (ImagePanel.class) {
                        sp.close();
                        ImagePanel.this.soundPlayers.remove(sp);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            Class<ImagePanel> clazz = ImagePanel.class;
            synchronized (ImagePanel.class) {
                if (this.timer != null && this.timer == thisTimer) {
                    this.soundPlayers.add(sp);
                    sp.play();
                } else {
                    sp.close();
                }
                // ** MonitorExit[var6_7] (shouldn't be in output)
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
            logger.log(Level.SEVERE, "Error during playing sound", ex);
        }
        {
            return;
        }
    }

    public synchronized void clearAll() {
        this.stopInternal();
        this.clearImagePanel();
        this.timelined = null;
        this.swf = null;
        this.lda = null;
        this.fireMediaDisplayStateChanged();
    }

    private synchronized void stopInternal() {
        this.clear();
        this.stopAllSounds();
    }

    @Override
    public synchronized void play() {
        this.stopInternal();
        if (this.timelined != null) {
            Timeline timeline = this.timelined.getTimeline();
            if (!this.stillFrame && this.frame == timeline.getFrameCount() - 1) {
                this.frame = 0;
                this.prevFrame = -1;
            }
            this.startTimer(timeline, true);
        }
    }

    private synchronized void setMsPerFrame(int val) {
        this.msPerFrame = val;
    }

    private synchronized int getMsPerFrame() {
        return this.msPerFrame;
    }

    private synchronized void setFpsIs(float val) {
        this.fpsIs = val;
    }

    private synchronized float getFpsIs() {
        return this.fpsIs;
    }

    private synchronized void setSkippedFrames(int val) {
        this.skippedFrames = val;
    }

    private synchronized void addSkippedFrames(int val) {
        this.skippedFrames += val;
    }

    private synchronized int getSkippedFrames() {
        return this.skippedFrames;
    }

    private synchronized int getAndResetSkippedFrames() {
        int ret = this.skippedFrames;
        this.skippedFrames = 0;
        return ret;
    }

    private void scheduleTask(final boolean singleFrame, long msDelay) {
        TimerTask task = new TimerTask(){
            public final Timer thisTimer;
            public final boolean isSingleFrame;
            private long lastRun;
            {
                this.thisTimer = ImagePanel.this.timer;
                this.isSingleFrame = singleFrame;
                this.lastRun = 0L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                try {
                    Class<ImagePanel> clazz = ImagePanel.class;
                    synchronized (ImagePanel.class) {
                        if (ImagePanel.this.timer != this.thisTimer) {
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        this.lastRun = System.currentTimeMillis();
                        int curFrame = ImagePanel.this.frame;
                        long delay = ImagePanel.this.getMsPerFrame();
                        if (this.isSingleFrame) {
                            ImagePanel.this.drawFrame(this.thisTimer, true);
                            ImagePanel.this.fireMediaDisplayStateChanged();
                        } else {
                            long frameTimeMsIs = System.currentTimeMillis();
                            int frameCount = ImagePanel.this.timelined.getTimeline().getFrameCount();
                            if (frameCount == 0) {
                                return;
                            }
                            int ticksFromStart = (int)Math.floor((double)(frameTimeMsIs - ImagePanel.this.startRun) / (double)ImagePanel.this.getMsPerFrame()) + 1;
                            int frameOverMaxShouldBeNow = ImagePanel.this.startFrame + ticksFromStart;
                            int frameShouldBeNow = frameOverMaxShouldBeNow % frameCount;
                            int skipFrames = frameShouldBeNow - curFrame;
                            if (skipFrames < 0) {
                                skipFrames += frameCount;
                            }
                            if (skipFrames > 1) {
                                ImagePanel.this.addSkippedFrames(skipFrames - 1);
                            }
                            int currentFrameTicks = 0;
                            if (frameCount == 1 || ImagePanel.this.stillFrame) {
                                currentFrameTicks = ticksFromStart;
                            }
                            ImagePanel.this.nextFrame(this.thisTimer, skipFrames, currentFrameTicks);
                            long afterDrawFrameTimeMsIs = System.currentTimeMillis();
                            int nextFrameOverMax = frameOverMaxShouldBeNow;
                            while (delay < 0L) {
                                long nextFrameOverMaxTimeMsShouldBe = ImagePanel.this.startRun + (long)(ImagePanel.this.getMsPerFrame() * ++nextFrameOverMax);
                                delay = nextFrameOverMaxTimeMsShouldBe - afterDrawFrameTimeMsIs;
                            }
                        }
                        Class<ImagePanel> clazz2 = ImagePanel.class;
                        synchronized (ImagePanel.class) {
                            if (ImagePanel.this.timer != this.thisTimer) {
                                // ** MonitorExit[var4_7] (shouldn't be in output)
                                return;
                            }
                            // ** MonitorExit[var4_7] (shouldn't be in output)
                            ImagePanel.this.scheduleTask(this.isSingleFrame, delay);
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Frame drawing error", ex);
                }
            }
        };
        if (this.timer != null) {
            this.timer.schedule(task, msDelay);
        }
    }

    private synchronized void startTimer(Timeline timeline, boolean playing) {
        boolean singleFrame;
        this.playing = playing;
        this.startRun = System.currentTimeMillis();
        this.startFrame = this.frame;
        float frameRate = timeline.frameRate;
        this.setMsPerFrame(frameRate == 0.0f ? 1000 : (int)(1000.0 / (double)frameRate));
        boolean bl = singleFrame = !playing || this.stillFrame && timeline.isSingleFrame(this.frame) || !this.stillFrame && timeline.getRealFrameCount() <= 1 && timeline.isSingleFrame();
        if (this.fpsTimer == null) {
            this.fpsTimer = new Timer();
            this.fpsTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    float skipped = ImagePanel.this.getAndResetSkippedFrames();
                    ImagePanel.this.setFpsIs(ImagePanel.this.fpsShouldBe - skipped);
                }
            }, 1000L, 1000L);
        }
        this.timer = new Timer();
        this.fpsIs = this.fpsShouldBe = timeline.frameRate;
        this.scheduleTask(singleFrame, 0L);
    }

    @Override
    public synchronized void rewind() {
        this.frame = 0;
        this.prevFrame = -1;
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public synchronized boolean isPlaying() {
        if (this.timelined == null || this.stillFrame) {
            return false;
        }
        return this.playing;
    }

    @Override
    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    @Override
    public synchronized void gotoFrame(int frame) {
        if (this.timelined == null) {
            return;
        }
        Timeline timeline = this.timelined.getTimeline();
        if (frame > timeline.getFrameCount()) {
            return;
        }
        if (frame < 1) {
            return;
        }
        this.frame = frame - 1;
        this.prevFrame = -1;
        this.stopInternal();
        this.redraw();
        this.fireMediaDisplayStateChanged();
    }

    @Override
    public synchronized float getFrameRate() {
        if (this.timelined == null) {
            return 1.0f;
        }
        if (this.stillFrame) {
            return 1.0f;
        }
        return this.timelined.getTimeline().frameRate;
    }

    @Override
    public synchronized boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean loopAvailable() {
        return false;
    }

    @Override
    public boolean screenAvailable() {
        return true;
    }

    @Override
    public synchronized Zoom getZoom() {
        if (this.zoom.fit) {
            this.zoom.value = this.getZoomToFit();
        }
        return this.zoom;
    }

    private double getRealZoom() {
        if (this.zoom.fit) {
            return this.getZoomToFit();
        }
        return this.zoom.value;
    }

    private synchronized void zoomIn() {
        double currentRealZoom = this.getRealZoom();
        if (currentRealZoom >= 1000000.0) {
            return;
        }
        Zoom newZoom = new Zoom();
        newZoom.value = currentRealZoom * ZOOM_MULTIPLIER;
        newZoom.fit = false;
        if (this.cursorPosition != null) {
            Point aCursor = this.iconPanel.toImagePoint(this.cursorPosition);
            Rectangle curRect = this.iconPanel.calcRect(this.zoom);
            Rectangle newRect = this.iconPanel.calcRect(newZoom);
            this.offsetPoint.x = (int)((double)(aCursor.x + curRect.x + this.offsetPoint.x) - (double)aCursor.x * newZoom.value / this.zoom.value - (double)newRect.x);
            this.offsetPoint.y = (int)((double)(aCursor.y + curRect.y + this.offsetPoint.y) - (double)aCursor.y * newZoom.value / this.zoom.value - (double)newRect.y);
            this.offsetPoint.x = (int)((double)this.offsetPoint.x * this.zoom.value / newZoom.value);
            this.offsetPoint.y = (int)((double)this.offsetPoint.y * this.zoom.value / newZoom.value);
        }
        this.zoom(newZoom);
    }

    private synchronized void zoomOut() {
        Zoom newZoom = new Zoom();
        newZoom.value = this.getRealZoom() / ZOOM_MULTIPLIER;
        newZoom.fit = false;
        if (this.cursorPosition != null) {
            Point aCursor = this.iconPanel.toImagePoint(this.cursorPosition);
            Rectangle curRect = this.iconPanel.calcRect(this.zoom);
            Rectangle newRect = this.iconPanel.calcRect(newZoom);
            this.offsetPoint.x = (int)((double)(aCursor.x + curRect.x + this.offsetPoint.x) - (double)aCursor.x * newZoom.value / this.zoom.value - (double)newRect.x);
            this.offsetPoint.y = (int)((double)(aCursor.y + curRect.y + this.offsetPoint.y) - (double)aCursor.y * newZoom.value / this.zoom.value - (double)newRect.y);
            this.offsetPoint.x = (int)((double)this.offsetPoint.x * this.zoom.value / newZoom.value);
            this.offsetPoint.y = (int)((double)this.offsetPoint.y * this.zoom.value / newZoom.value);
        }
        this.zoom(newZoom);
    }

    static {
        try {
            moveCursor = ImagePanel.loadCursor("move", 0, 0);
            moveRegPointCursor = ImagePanel.loadCursor("move_regpoint", 0, 0);
            resizeNWSECursor = ImagePanel.loadCursor("resize_nw_se", 5, 5);
            resizeSWNECursor = ImagePanel.loadCursor("resize_sw_ne", 5, 5);
            resizeXCursor = ImagePanel.loadCursor("resize_x", 7, 4);
            resizeYCursor = ImagePanel.loadCursor("resize_y", 4, 7);
            rotateCursor = ImagePanel.loadCursor("rotate", 10, 7);
            selectCursor = ImagePanel.loadCursor("select", 0, 0);
            shearXCursor = ImagePanel.loadCursor("shear_x", 9, 5);
            shearYCursor = ImagePanel.loadCursor("shear_y", 5, 9);
        }
        catch (IOException ex) {
            Logger.getLogger(MainPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        ZOOM_MULTIPLIER = Math.pow(10.0, 0.1);
    }

    private class IconPanel
    extends JPanel {
        private SerializableImage _img;
        private ButtonTag mouseOverButton = null;
        private boolean autoFit = false;
        private boolean allowMove = true;
        private Point dragStart = null;
        VolatileImage renderImage;
        private boolean ctrlDown = false;

        private synchronized SerializableImage getImg() {
            return this._img;
        }

        public synchronized Rectangle getRect() {
            return ImagePanel.this._rect;
        }

        public boolean hasAllowMove() {
            return this.allowMove;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void render() {
            VolatileImage ri;
            SerializableImage img = this.getImg();
            Rectangle rect = this.getRect();
            Graphics2D g2 = null;
            do {
                if ((ri = this.renderImage) == null) {
                    return;
                }
                int valid = ri.validate(View.getDefaultConfiguration());
                if (valid == 2) {
                    ri = View.createRenderImage(this.getWidth(), this.getHeight(), 3);
                }
                try {
                    g2 = ri.createGraphics();
                    g2.setPaint(View.transparentPaint);
                    g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                    g2.setComposite(AlphaComposite.SrcOver);
                    g2.setPaint(View.getSwfBackgroundColor());
                    g2.fill(new Rectangle(0, 0, this.getWidth(), this.getHeight()));
                    g2.setComposite(AlphaComposite.SrcOver);
                    if (rect == null || img == null) continue;
                    int x = rect.x < 0 ? 0 : rect.x;
                    int y = rect.y < 0 ? 0 : rect.y;
                    g2.drawImage(img.getBufferedImage(), x, y, x + img.getWidth(), y + img.getHeight(), 0, 0, img.getWidth(), img.getHeight(), null);
                }
                finally {
                    if (g2 != null) {
                        g2.dispose();
                    }
                }
            } while (ri.contentsLost());
        }

        public IconPanel() {
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            manager.addKeyEventDispatcher(new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent e) {
                    if (e.getID() == 401 || e.getID() == 402) {
                        IconPanel.this.ctrlDown = (e.getModifiersEx() & 0x80) == 128;
                    }
                    return false;
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int width = IconPanel.this.getWidth();
                    int height = IconPanel.this.getHeight();
                    IconPanel.this.renderImage = width > 0 && height > 0 ? View.createRenderImage(width, height, 3) : null;
                    IconPanel.this.calcRect();
                    IconPanel.this.render();
                    IconPanel.this.repaint();
                }
            });
            MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        IconPanel.this.dragStart = e.getPoint();
                    }
                    IconPanel.this.requestFocusInWindow();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.getButton() == 1) {
                        IconPanel.this.dragStart = null;
                        if (ImagePanel.this.freeTransformDepth > -1 && ImagePanel.this.mode != 0 && ImagePanel.this.registrationPointUpdated != null && ImagePanel.this.transformUpdated != null) {
                            Object object = ImagePanel.this.lock;
                            synchronized (object) {
                                ImagePanel.this.registrationPoint = new Point2D.Double(ImagePanel.this.registrationPointUpdated.getX(), ImagePanel.this.registrationPointUpdated.getY());
                                ImagePanel.this.transform = new Matrix(ImagePanel.this.transformUpdated);
                                ImagePanel.this.transformUpdated = null;
                            }
                            IconPanel.this.repaint();
                        }
                        ImagePanel.this.mode = 0;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void mouseDragged(MouseEvent e) {
                    if (IconPanel.this.dragStart != null && IconPanel.this.allowMove && ImagePanel.this.mode == 0) {
                        Point dragEnd = e.getPoint();
                        Point delta = new Point(dragEnd.x - ((IconPanel)IconPanel.this).dragStart.x, dragEnd.y - ((IconPanel)IconPanel.this).dragStart.y);
                        ((ImagePanel)ImagePanel.this).offsetPoint.x += delta.x;
                        ((ImagePanel)ImagePanel.this).offsetPoint.y += delta.y;
                        ExportRectangle oldViewRect = new ExportRectangle(ImagePanel.this._viewRect);
                        IconPanel.this.dragStart = dragEnd;
                        ImagePanel.this.iconPanel.calcRect();
                        ImagePanel.this._viewRect = ImagePanel.this.getViewRect();
                        double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                        Object object = ImagePanel.this.lock;
                        synchronized (object) {
                            if (ImagePanel.this.transform != null) {
                                Matrix prevTransform = ImagePanel.this.transform.clone();
                                Matrix m = new Matrix();
                                m.scale(0.05);
                                m.translate(-oldViewRect.xMin * zoomDouble, -oldViewRect.yMin * zoomDouble);
                                Matrix mi = m.inverse();
                                ImagePanel.this.transform = ImagePanel.this.transform.preConcatenate(mi);
                                Matrix m2 = new Matrix();
                                m2.scale(0.05);
                                m2.translate(-((ImagePanel)ImagePanel.this)._viewRect.xMin * zoomDouble, -((ImagePanel)ImagePanel.this)._viewRect.yMin * zoomDouble);
                                ImagePanel.this.transform = ImagePanel.this.transform.preConcatenate(m2);
                                if (ImagePanel.this.registrationPoint != null) {
                                    double deltaX = (oldViewRect.xMin - ((ImagePanel)ImagePanel.this)._viewRect.xMin) * zoomDouble / 20.0;
                                    double deltaY = (oldViewRect.yMin - ((ImagePanel)ImagePanel.this)._viewRect.yMin) * zoomDouble / 20.0;
                                    ImagePanel.this.registrationPoint = new Point2D.Double(ImagePanel.this.registrationPoint.getX() + deltaX, ImagePanel.this.registrationPoint.getY() + deltaY);
                                }
                            }
                        }
                        IconPanel.this.repaint();
                        return;
                    }
                    if (IconPanel.this.dragStart != null && ImagePanel.this.freeTransformDepth > -1) {
                        Point2D.Double newRegistrationPoint;
                        AffineTransform t;
                        AffineTransform newTransform;
                        AffineTransform t2;
                        Point2D.Double newRegistrationPoint2;
                        AffineTransform t3;
                        AffineTransform newTransform2;
                        double deltaTheta;
                        double deltaEndY;
                        double deltaStartX;
                        double shearY;
                        Point2D.Double newRegistrationPoint3;
                        AffineTransform t4;
                        AffineTransform newTransform3;
                        double shearX;
                        if (ImagePanel.this.transform == null) {
                            return;
                        }
                        double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                        int ex = e.getX() - ((ImagePanel)ImagePanel.this)._rect.x - (int)(((ImagePanel)ImagePanel.this)._viewRect.xMin * zoomDouble / 20.0);
                        int ey = e.getY() - ((ImagePanel)ImagePanel.this)._rect.y - (int)(((ImagePanel)ImagePanel.this)._viewRect.yMin * zoomDouble / 20.0);
                        int dsx = ((IconPanel)IconPanel.this).dragStart.x - ((ImagePanel)ImagePanel.this)._rect.x - (int)(((ImagePanel)ImagePanel.this)._viewRect.xMin * zoomDouble / 20.0);
                        int dsy = ((IconPanel)IconPanel.this).dragStart.y - ((ImagePanel)ImagePanel.this)._rect.y - (int)(((ImagePanel)ImagePanel.this)._viewRect.yMin * zoomDouble / 20.0);
                        if (ImagePanel.this.mode == -7) {
                            shearX = (double)(-(ex - dsx)) / ImagePanel.this.bounds.getHeight();
                            newTransform3 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t4 = new AffineTransform();
                            t4.translate(ImagePanel.this.bounds.getX(), ImagePanel.this.bounds.getY());
                            t4.shear(shearX, 0.0);
                            t4.translate(-ImagePanel.this.bounds.getX(), -ImagePanel.this.bounds.getY());
                            t4.translate(ex - dsx, 0.0);
                            newTransform3.preConcatenate(t4);
                            newRegistrationPoint3 = new Point2D.Double();
                            t4.transform(ImagePanel.this.registrationPoint, newRegistrationPoint3);
                            ImagePanel.this.transformUpdated = newTransform3;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint3;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -5) {
                            shearX = (double)(ex - dsx) / ImagePanel.this.bounds.getHeight();
                            newTransform3 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t4 = new AffineTransform();
                            t4.translate(ImagePanel.this.bounds.getX(), ImagePanel.this.bounds.getY());
                            t4.shear(shearX, 0.0);
                            t4.translate(-ImagePanel.this.bounds.getX(), -ImagePanel.this.bounds.getY());
                            newTransform3.preConcatenate(t4);
                            newRegistrationPoint3 = new Point2D.Double();
                            t4.transform(ImagePanel.this.registrationPoint, newRegistrationPoint3);
                            ImagePanel.this.transformUpdated = newTransform3;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint3;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -8) {
                            shearY = (double)(-(ey - dsy)) / ImagePanel.this.bounds.getWidth();
                            newTransform3 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t4 = new AffineTransform();
                            t4.translate(ImagePanel.this.bounds.getX(), ImagePanel.this.bounds.getY());
                            t4.shear(0.0, shearY);
                            t4.translate(-ImagePanel.this.bounds.getX(), -ImagePanel.this.bounds.getY());
                            t4.translate(0.0, ey - dsy);
                            newTransform3.preConcatenate(t4);
                            newRegistrationPoint3 = new Point2D.Double();
                            t4.transform(ImagePanel.this.registrationPoint, newRegistrationPoint3);
                            ImagePanel.this.transformUpdated = newTransform3;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint3;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -6) {
                            shearY = (double)(ey - dsy) / ImagePanel.this.bounds.getWidth();
                            newTransform3 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t4 = new AffineTransform();
                            t4.translate(ImagePanel.this.bounds.getX(), ImagePanel.this.bounds.getY());
                            t4.shear(0.0, shearY);
                            t4.translate(-ImagePanel.this.bounds.getX(), -ImagePanel.this.bounds.getY());
                            newTransform3.preConcatenate(t4);
                            newRegistrationPoint3 = new Point2D.Double();
                            t4.transform(ImagePanel.this.registrationPoint, newRegistrationPoint3);
                            ImagePanel.this.transformUpdated = newTransform3;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint3;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -2) {
                            double thetaEnd;
                            double thetaStart;
                            deltaStartX = Math.abs((double)dsx - ImagePanel.this.registrationPoint.getX());
                            double deltaStartY = Math.abs((double)dsy - ImagePanel.this.registrationPoint.getY());
                            double deltaEndX = Math.abs((double)ex - ImagePanel.this.registrationPoint.getX());
                            deltaEndY = Math.abs((double)ey - ImagePanel.this.registrationPoint.getY());
                            deltaTheta = 0.0;
                            if ((double)ex >= ImagePanel.this.registrationPoint.getX() && (double)ey >= ImagePanel.this.registrationPoint.getY()) {
                                thetaStart = Math.atan(deltaStartY / deltaStartX);
                                thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaEnd - thetaStart;
                            } else if ((double)ex >= ImagePanel.this.registrationPoint.getX() && (double)ey <= ImagePanel.this.registrationPoint.getY()) {
                                thetaStart = Math.atan(deltaStartY / deltaStartX);
                                thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = -(thetaStart + thetaEnd);
                            } else if ((double)ex <= ImagePanel.this.registrationPoint.getX() && (double)ey >= ImagePanel.this.registrationPoint.getY()) {
                                thetaStart = Math.atan(deltaStartX / deltaStartY);
                                thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = thetaStart + thetaEnd;
                            } else if ((double)ex <= ImagePanel.this.registrationPoint.getX() && (double)ey <= ImagePanel.this.registrationPoint.getY()) {
                                thetaStart = Math.atan(deltaStartX / deltaStartY);
                                thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart + Math.toRadians(90.0) + thetaEnd;
                            }
                            newTransform2 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t3 = new AffineTransform();
                            t3.rotate(deltaTheta, ImagePanel.this.registrationPoint.getX(), ImagePanel.this.registrationPoint.getY());
                            newTransform2.preConcatenate(t3);
                            newRegistrationPoint2 = new Point2D.Double();
                            t3.transform(ImagePanel.this.registrationPoint, newRegistrationPoint2);
                            ImagePanel.this.transformUpdated = newTransform2;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint2;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -3) {
                            deltaStartX = Math.abs((double)dsx - ImagePanel.this.registrationPoint.getX());
                            double deltaStartY = Math.abs((double)dsy - ImagePanel.this.registrationPoint.getY());
                            double deltaEndX = Math.abs((double)ex - ImagePanel.this.registrationPoint.getX());
                            deltaEndY = Math.abs((double)ey - ImagePanel.this.registrationPoint.getY());
                            deltaTheta = 0.0;
                            if ((double)ex >= ImagePanel.this.registrationPoint.getX() && (double)ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart + Math.toRadians(90.0) + thetaEnd;
                            } else if ((double)ex >= ImagePanel.this.registrationPoint.getX() && (double)ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = thetaStart + thetaEnd;
                            } else if ((double)ex <= ImagePanel.this.registrationPoint.getX() && (double)ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = -(thetaStart + thetaEnd);
                            } else if ((double)ex <= ImagePanel.this.registrationPoint.getX() && (double)ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaEnd - thetaStart;
                            }
                            newTransform2 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t3 = new AffineTransform();
                            t3.rotate(deltaTheta, ImagePanel.this.registrationPoint.getX(), ImagePanel.this.registrationPoint.getY());
                            newTransform2.preConcatenate(t3);
                            newRegistrationPoint2 = new Point2D.Double();
                            t3.transform(ImagePanel.this.registrationPoint, newRegistrationPoint2);
                            ImagePanel.this.transformUpdated = newTransform2;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint2;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -1) {
                            deltaStartX = Math.abs((double)dsx - ImagePanel.this.registrationPoint.getX());
                            double deltaStartY = Math.abs((double)dsy - ImagePanel.this.registrationPoint.getY());
                            double deltaEndX = Math.abs((double)ex - ImagePanel.this.registrationPoint.getX());
                            deltaEndY = Math.abs((double)ey - ImagePanel.this.registrationPoint.getY());
                            deltaTheta = 0.0;
                            if ((double)ex >= ImagePanel.this.registrationPoint.getX() && (double)ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart + thetaEnd;
                            } else if ((double)ex >= ImagePanel.this.registrationPoint.getX() && (double)ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart - thetaEnd;
                            } else if ((double)ex <= ImagePanel.this.registrationPoint.getX() && (double)ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = thetaStart + Math.toRadians(90.0) + thetaEnd;
                            } else if ((double)ex <= ImagePanel.this.registrationPoint.getX() && (double)ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = -(thetaStart + thetaEnd);
                            }
                            newTransform2 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t3 = new AffineTransform();
                            t3.rotate(deltaTheta, ImagePanel.this.registrationPoint.getX(), ImagePanel.this.registrationPoint.getY());
                            newTransform2.preConcatenate(t3);
                            newRegistrationPoint2 = new Point2D.Double();
                            t3.transform(ImagePanel.this.registrationPoint, newRegistrationPoint2);
                            ImagePanel.this.transformUpdated = newTransform2;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint2;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == -4) {
                            deltaStartX = Math.abs((double)dsx - ImagePanel.this.registrationPoint.getX());
                            double deltaStartY = Math.abs((double)dsy - ImagePanel.this.registrationPoint.getY());
                            double deltaEndX = Math.abs((double)ex - ImagePanel.this.registrationPoint.getX());
                            deltaEndY = Math.abs((double)ey - ImagePanel.this.registrationPoint.getY());
                            deltaTheta = 0.0;
                            if ((double)ex >= ImagePanel.this.registrationPoint.getX() && (double)ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartX / deltaStartY);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = -(thetaStart + thetaEnd);
                            } else if ((double)ex >= ImagePanel.this.registrationPoint.getX() && (double)ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndX / deltaEndY);
                                deltaTheta = thetaStart + Math.toRadians(90.0) + thetaEnd;
                            } else if ((double)ex <= ImagePanel.this.registrationPoint.getX() && (double)ey >= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart - thetaEnd;
                            } else if ((double)ex <= ImagePanel.this.registrationPoint.getX() && (double)ey <= ImagePanel.this.registrationPoint.getY()) {
                                double thetaStart = Math.atan(deltaStartY / deltaStartX);
                                double thetaEnd = Math.atan(deltaEndY / deltaEndX);
                                deltaTheta = thetaStart + thetaEnd;
                            }
                            newTransform2 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t3 = new AffineTransform();
                            t3.rotate(deltaTheta, ImagePanel.this.registrationPoint.getX(), ImagePanel.this.registrationPoint.getY());
                            newTransform2.preConcatenate(t3);
                            newRegistrationPoint2 = new Point2D.Double();
                            t3.transform(ImagePanel.this.registrationPoint, newRegistrationPoint2);
                            ImagePanel.this.transformUpdated = newTransform2;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint2;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 12) {
                            ImagePanel.this.transformUpdated = new AffineTransform(ImagePanel.this.transform.toTransform());
                            ImagePanel.this.registrationPointUpdated = new Point2D.Double(ex, ey);
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 13) {
                            int deltaX = ex - dsx;
                            int deltaY = ey - dsy;
                            AffineTransform newTransform4 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t4 = new AffineTransform();
                            t4.translate(deltaX, deltaY);
                            newTransform4.preConcatenate(t4);
                            Point2D.Double newRegistrationPoint4 = new Point2D.Double();
                            t4.transform(ImagePanel.this.registrationPoint, newRegistrationPoint4);
                            ImagePanel.this.transformUpdated = newTransform4;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint4;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 11) {
                            double deltaBefore = ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() - ImagePanel.this.registrationPoint.getX();
                            double deltaX = (double)ex - ImagePanel.this.registrationPoint.getX();
                            double scaleX = deltaX / deltaBefore;
                            AffineTransform newTransform5 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t2 = new AffineTransform();
                            t2.translate(ImagePanel.this.registrationPoint.getX(), 0.0);
                            t2.scale(scaleX, 1.0);
                            t2.translate(-ImagePanel.this.registrationPoint.getX(), 0.0);
                            newTransform5.preConcatenate(t2);
                            Point2D.Double newRegistrationPoint5 = new Point2D.Double();
                            t2.transform(ImagePanel.this.registrationPoint, newRegistrationPoint5);
                            ImagePanel.this.transformUpdated = newTransform5;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint5;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 10) {
                            double deltaBefore = ImagePanel.this.registrationPoint.getX() - ImagePanel.this.bounds.getX();
                            double deltaX = ImagePanel.this.registrationPoint.getX() - (double)ex;
                            double scaleX = deltaX / deltaBefore;
                            AffineTransform newTransform6 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t2 = new AffineTransform();
                            t2.translate(ImagePanel.this.registrationPoint.getX(), 0.0);
                            t2.scale(scaleX, 1.0);
                            t2.translate(-ImagePanel.this.registrationPoint.getX(), 0.0);
                            newTransform6.preConcatenate(t2);
                            Point2D.Double newRegistrationPoint6 = new Point2D.Double();
                            t2.transform(ImagePanel.this.registrationPoint, newRegistrationPoint6);
                            ImagePanel.this.transformUpdated = newTransform6;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint6;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 9) {
                            double deltaBefore = ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() - ImagePanel.this.registrationPoint.getY();
                            double deltaY = (double)ey - ImagePanel.this.registrationPoint.getY();
                            double scaleY = deltaY / deltaBefore;
                            AffineTransform newTransform7 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t2 = new AffineTransform();
                            t2.translate(0.0, ImagePanel.this.registrationPoint.getY());
                            t2.scale(1.0, scaleY);
                            t2.translate(0.0, -ImagePanel.this.registrationPoint.getY());
                            newTransform7.preConcatenate(t2);
                            Point2D.Double newRegistrationPoint7 = new Point2D.Double();
                            t2.transform(ImagePanel.this.registrationPoint, newRegistrationPoint7);
                            ImagePanel.this.transformUpdated = newTransform7;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint7;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 8) {
                            double deltaBefore = ImagePanel.this.registrationPoint.getY() - ImagePanel.this.bounds.getY();
                            double deltaY = ImagePanel.this.registrationPoint.getY() - (double)ey;
                            double scaleY = deltaY / deltaBefore;
                            AffineTransform newTransform8 = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t2 = new AffineTransform();
                            t2.translate(0.0, ImagePanel.this.registrationPoint.getY());
                            t2.scale(1.0, scaleY);
                            t2.translate(0.0, -ImagePanel.this.registrationPoint.getY());
                            newTransform8.preConcatenate(t2);
                            Point2D.Double newRegistrationPoint8 = new Point2D.Double();
                            t2.transform(ImagePanel.this.registrationPoint, newRegistrationPoint8);
                            ImagePanel.this.transformUpdated = newTransform8;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint8;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 5) {
                            double deltaXBefore = ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() - ImagePanel.this.registrationPoint.getX();
                            double deltaYBefore = ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() - ImagePanel.this.registrationPoint.getY();
                            double deltaX = (double)ex - ImagePanel.this.registrationPoint.getX();
                            double deltaY = (double)ey - ImagePanel.this.registrationPoint.getY();
                            double scaleX = deltaX / deltaXBefore;
                            double scaleY = deltaY / deltaYBefore;
                            newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t = new AffineTransform();
                            t.translate(ImagePanel.this.registrationPoint.getX(), ImagePanel.this.registrationPoint.getY());
                            t.scale(scaleX, scaleY);
                            t.translate(-ImagePanel.this.registrationPoint.getX(), -ImagePanel.this.registrationPoint.getY());
                            newTransform.preConcatenate(t);
                            newRegistrationPoint = new Point2D.Double();
                            t.transform(ImagePanel.this.registrationPoint, newRegistrationPoint);
                            ImagePanel.this.transformUpdated = newTransform;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 7) {
                            double deltaXBefore = ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() - ImagePanel.this.registrationPoint.getX();
                            double deltaYBefore = ImagePanel.this.registrationPoint.getY() - ImagePanel.this.bounds.getY();
                            double deltaX = (double)ex - ImagePanel.this.registrationPoint.getX();
                            double deltaY = ImagePanel.this.registrationPoint.getY() - (double)ey;
                            double scaleX = deltaX / deltaXBefore;
                            double scaleY = deltaY / deltaYBefore;
                            newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t = new AffineTransform();
                            t.translate(ImagePanel.this.registrationPoint.getX(), ImagePanel.this.registrationPoint.getY());
                            t.scale(scaleX, scaleY);
                            t.translate(-ImagePanel.this.registrationPoint.getX(), -ImagePanel.this.registrationPoint.getY());
                            newTransform.preConcatenate(t);
                            newRegistrationPoint = new Point2D.Double();
                            t.transform(ImagePanel.this.registrationPoint, newRegistrationPoint);
                            ImagePanel.this.transformUpdated = newTransform;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 4) {
                            double deltaXBefore = ImagePanel.this.registrationPoint.getX() - ImagePanel.this.bounds.getX();
                            double deltaYBefore = ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() - ImagePanel.this.registrationPoint.getY();
                            double deltaX = ImagePanel.this.registrationPoint.getX() - (double)ex;
                            double deltaY = (double)ey - ImagePanel.this.registrationPoint.getY();
                            double scaleX = deltaX / deltaXBefore;
                            double scaleY = deltaY / deltaYBefore;
                            newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t = new AffineTransform();
                            t.translate(ImagePanel.this.registrationPoint.getX(), ImagePanel.this.registrationPoint.getY());
                            t.scale(scaleX, scaleY);
                            t.translate(-ImagePanel.this.registrationPoint.getX(), -ImagePanel.this.registrationPoint.getY());
                            newTransform.preConcatenate(t);
                            newRegistrationPoint = new Point2D.Double();
                            t.transform(ImagePanel.this.registrationPoint, newRegistrationPoint);
                            ImagePanel.this.transformUpdated = newTransform;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint;
                            IconPanel.this.repaint();
                        }
                        if (ImagePanel.this.mode == 6) {
                            double deltaXBefore = ImagePanel.this.registrationPoint.getX() - ImagePanel.this.bounds.getX();
                            double deltaYBefore = ImagePanel.this.registrationPoint.getY() - ImagePanel.this.bounds.getY();
                            double deltaX = ImagePanel.this.registrationPoint.getX() - (double)ex;
                            double deltaY = ImagePanel.this.registrationPoint.getY() - (double)ey;
                            double scaleX = deltaX / deltaXBefore;
                            double scaleY = deltaY / deltaYBefore;
                            newTransform = new AffineTransform(ImagePanel.this.transform.toTransform());
                            t = new AffineTransform();
                            t.translate(ImagePanel.this.registrationPoint.getX(), ImagePanel.this.registrationPoint.getY());
                            t.scale(scaleX, scaleY);
                            t.translate(-ImagePanel.this.registrationPoint.getX(), -ImagePanel.this.registrationPoint.getY());
                            newTransform.preConcatenate(t);
                            newRegistrationPoint = new Point2D.Double();
                            t.transform(ImagePanel.this.registrationPoint, newRegistrationPoint);
                            ImagePanel.this.transformUpdated = newTransform;
                            ImagePanel.this.registrationPointUpdated = newRegistrationPoint;
                            IconPanel.this.repaint();
                        }
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    if (ImagePanel.this.freeTransformDepth > -1) {
                        Cursor cursor;
                        boolean shearY;
                        if (ImagePanel.this.bounds == null) {
                            return;
                        }
                        if (ImagePanel.this.registrationPoint == null) {
                            return;
                        }
                        double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                        int ex = e.getX() - ((ImagePanel)ImagePanel.this)._rect.x - (int)(((ImagePanel)ImagePanel.this)._viewRect.xMin * zoomDouble / 20.0);
                        int ey = e.getY() - ((ImagePanel)ImagePanel.this)._rect.y - (int)(((ImagePanel)ImagePanel.this)._viewRect.yMin * zoomDouble / 20.0);
                        boolean left = (double)ex >= ImagePanel.this.bounds.getX() - 8.0 && (double)ex <= ImagePanel.this.bounds.getX() + 8.0;
                        boolean right = (double)ex >= ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() - 8.0 && (double)ex <= ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() + 8.0;
                        boolean top = (double)ey >= ImagePanel.this.bounds.getY() - 8.0 && (double)ey <= ImagePanel.this.bounds.getY() + 8.0;
                        boolean bottom = (double)ey >= ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() - 8.0 && (double)ey <= ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() + 8.0;
                        boolean xcenter = (double)ex >= ImagePanel.this.bounds.getCenterX() - 8.0 && (double)ex <= ImagePanel.this.bounds.getCenterX() + 8.0;
                        boolean ycenter = (double)ey >= ImagePanel.this.bounds.getCenterY() - 8.0 && (double)ey <= ImagePanel.this.bounds.getCenterY() + 8.0;
                        boolean registration = (double)ex >= ImagePanel.this.registrationPoint.getX() - 8.0 && (double)ex <= ImagePanel.this.registrationPoint.getX() + 8.0 && (double)ey >= ImagePanel.this.registrationPoint.getY() - 8.0 && (double)ey <= ImagePanel.this.registrationPoint.getY() + 8.0;
                        boolean rightRotate = (double)ex > ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() - 30.0 && (double)ex <= ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth() + 30.0;
                        boolean bottomRotate = (double)ey > ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() - 30.0 && (double)ey <= ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight() + 30.0;
                        boolean leftRotate = (double)ex < ImagePanel.this.bounds.getX() + 30.0 && (double)ex >= ImagePanel.this.bounds.getX() - 30.0;
                        boolean topRotate = (double)ey < ImagePanel.this.bounds.getY() + 30.0 && (double)ey >= ImagePanel.this.bounds.getY() - 30.0;
                        boolean inBounds = ImagePanel.this.bounds.contains(ex, ey);
                        boolean shearX = (double)ex > ImagePanel.this.bounds.getX() && (double)ex < ImagePanel.this.bounds.getX() + ImagePanel.this.bounds.getWidth();
                        boolean bl = shearY = (double)ey > ImagePanel.this.bounds.getY() && (double)ey < ImagePanel.this.bounds.getY() + ImagePanel.this.bounds.getHeight();
                        if (top && left) {
                            ImagePanel.this.mode = 6;
                            cursor = resizeNWSECursor;
                        } else if (bottom && left) {
                            ImagePanel.this.mode = 4;
                            cursor = resizeSWNECursor;
                        } else if (top && right) {
                            ImagePanel.this.mode = 7;
                            cursor = resizeSWNECursor;
                        } else if (bottom && right) {
                            ImagePanel.this.mode = 5;
                            cursor = resizeNWSECursor;
                        } else if (top && xcenter) {
                            ImagePanel.this.mode = 8;
                            cursor = resizeYCursor;
                        } else if (bottom && xcenter) {
                            ImagePanel.this.mode = 9;
                            cursor = resizeYCursor;
                        } else if (left && ycenter) {
                            ImagePanel.this.mode = 10;
                            cursor = resizeXCursor;
                        } else if (right && ycenter) {
                            ImagePanel.this.mode = 11;
                            cursor = resizeXCursor;
                        } else if (registration) {
                            ImagePanel.this.mode = 12;
                            cursor = moveRegPointCursor;
                        } else if (!inBounds && rightRotate && topRotate) {
                            ImagePanel.this.mode = -1;
                            cursor = rotateCursor;
                        } else if (!inBounds && rightRotate && bottomRotate) {
                            ImagePanel.this.mode = -2;
                            cursor = rotateCursor;
                        } else if (!inBounds && leftRotate && topRotate) {
                            ImagePanel.this.mode = -3;
                            cursor = rotateCursor;
                        } else if (!inBounds && leftRotate && bottomRotate) {
                            ImagePanel.this.mode = -4;
                            cursor = rotateCursor;
                        } else if (shearY && (left || right)) {
                            if (left) {
                                ImagePanel.this.mode = -8;
                            } else {
                                ImagePanel.this.mode = -6;
                            }
                            cursor = shearYCursor;
                        } else if (shearX && (top || bottom)) {
                            if (top) {
                                ImagePanel.this.mode = -7;
                            } else {
                                ImagePanel.this.mode = -5;
                            }
                            cursor = shearXCursor;
                        } else if (inBounds) {
                            ImagePanel.this.mode = 13;
                            cursor = moveCursor;
                        } else {
                            ImagePanel.this.mode = 0;
                            cursor = selectCursor;
                        }
                        IconPanel.this.setCursor(cursor);
                    }
                }

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (IconPanel.this.ctrlDown && e.getScrollType() == 0) {
                        int rotation = e.getWheelRotation();
                        if (rotation < 0) {
                            ImagePanel.this.zoomIn();
                        } else {
                            ImagePanel.this.zoomOut();
                        }
                    }
                }
            };
            this.addMouseListener(mouseInputAdapter);
            this.addMouseMotionListener(mouseInputAdapter);
            this.addMouseWheelListener(mouseInputAdapter);
        }

        public void setAutoFit(boolean autoFit) {
            this.autoFit = autoFit;
            this.repaint();
        }

        public synchronized BufferedImage getLastImage() {
            if (this._img == null) {
                return null;
            }
            return this._img.getBufferedImage();
        }

        public synchronized void setImg(SerializableImage img) {
            this._img = img;
            this.calcRect();
            this.render();
            this.repaint();
        }

        public synchronized Point toImagePoint(Point p) {
            if (this._img == null) {
                return null;
            }
            if (ImagePanel.this.timelined != null) {
                double zoomDouble = ((ImagePanel)ImagePanel.this).zoom.fit ? ImagePanel.this.getZoomToFit() : ((ImagePanel)ImagePanel.this).zoom.value;
                int w1 = (int)((double)((ImagePanel)ImagePanel.this).timelined.getRect().Xmin * zoomDouble / 20.0);
                int h1 = (int)((double)((ImagePanel)ImagePanel.this).timelined.getRect().Ymin * zoomDouble / 20.0);
                return new Point(p.x - ((ImagePanel)ImagePanel.this)._rect.x + w1, p.y - ((ImagePanel)ImagePanel.this)._rect.y + h1);
            }
            return new Point(p.x - ((ImagePanel)ImagePanel.this)._rect.x, p.y - ((ImagePanel)ImagePanel.this)._rect.y);
        }

        private void setAllowMove(boolean allowMove) {
            this.allowMove = allowMove;
            if (!allowMove) {
                ImagePanel.this.offsetPoint = new Point();
            }
        }

        private synchronized void calcRect() {
            ImagePanel.this._rect = this.calcRect(ImagePanel.this.zoom);
        }

        private synchronized Rectangle calcRect(Zoom z) {
            if (this._img != null || ImagePanel.this.timelined != null) {
                int h;
                int w;
                int h1;
                int w1;
                double zoomDouble;
                double d = zoomDouble = z.fit ? ImagePanel.this.getZoomToFit() : z.value;
                if (ImagePanel.this.timelined != null) {
                    w1 = (int)((double)ImagePanel.this.timelined.getRectWithStrokes().getWidth() * zoomDouble / 20.0);
                    h1 = (int)((double)ImagePanel.this.timelined.getRectWithStrokes().getHeight() * zoomDouble / 20.0);
                } else {
                    w1 = (int)((double)this._img.getWidth() * 1.0);
                    h1 = (int)((double)this._img.getHeight() * 1.0);
                }
                int w2 = this.getWidth();
                int h2 = this.getHeight();
                if (this.autoFit) {
                    if (w1 <= w2 && h1 <= h2) {
                        w = w1;
                        h = h1;
                    } else {
                        h = h1 * w2 / w1;
                        if (h > h2) {
                            w = w1 * h2 / h1;
                            h = h2;
                        } else {
                            w = w2;
                        }
                    }
                } else {
                    w = w1;
                    h = h1;
                }
                this.setAllowMove(h > h2 || w > w2);
                Rectangle r2 = new Rectangle(this.getWidth() / 2 - w / 2 + ((ImagePanel)ImagePanel.this).offsetPoint.x, this.getHeight() / 2 - h / 2 + ((ImagePanel)ImagePanel.this).offsetPoint.y, w, h);
                return r2;
            }
            return null;
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            VolatileImage ri = this.renderImage;
            if (ri != null) {
                this.calcRect();
                if (ri.validate(View.getDefaultConfiguration()) != 0) {
                    ri = View.createRenderImage(this.getWidth(), this.getHeight(), 3);
                    this.render();
                }
                if (ri != null) {
                    g2d.drawImage(ri, 0, 0, null);
                }
            }
            g2d.setColor(Color.red);
            DecimalFormat df = new DecimalFormat();
            df.setMaximumFractionDigits(2);
            df.setMinimumFractionDigits(0);
            df.setGroupingUsed(false);
            float frameLoss = 100.0f - ImagePanel.this.getFpsIs() / ImagePanel.this.fpsShouldBe * 100.0f;
            if (((Boolean)Configuration._debugMode.get()).booleanValue()) {
                g2d.drawString("frameLoss:" + df.format(frameLoss) + "%", 20, 20);
            }
        }
    }
}

