/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.gui.View;
import java.awt.Color;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;

public class HtmlLabel
extends JEditorPane {
    private JLabel label = new JLabel();
    private String rawText;

    public HtmlLabel() {
        this("");
    }

    public HtmlLabel(String text) {
        super("text/html", "");
        this.setText(text);
        this.setEditable(false);
        this.setFocusable(false);
        this.setOpaque(false);
        this.addHyperlinkListener(hle -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                View.navigateUrl(hle.getURL().toString());
            }
        });
    }

    @Override
    public void setText(String t) {
        String modText = t;
        if (!t.equals("")) {
            Color fgColor = this.label.getForeground();
            modText = "<body style=\"font-size:" + this.label.getFont().getSize() + "pt; font-family: " + this.label.getFont().getFamily() + "; color:rgb(" + fgColor.getRed() + "," + fgColor.getGreen() + "," + fgColor.getBlue() + ");\">" + t + "</body>";
        }
        this.rawText = t;
        super.setText(modText);
        String aRule = "a {color: " + HtmlLabel.getUIColorToHex("List.selectionBackground") + "}";
        ((HTMLDocument)this.getDocument()).getStyleSheet().addRule(aRule);
    }

    @Override
    public String getText() {
        return this.rawText;
    }

    private static String getUIColorToHex(String name) {
        Color c = UIManager.getColor(name);
        return String.format("#%02x%02x%02x", c.getRed(), c.getGreen(), c.getBlue());
    }
}

