/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.FasterScrollPane;
import com.jpexs.decompiler.flash.gui.GenericTagPanel;
import com.jpexs.decompiler.flash.gui.MainPanel;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.generictageditors.Amf3ValueEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.BinaryDataEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.BooleanEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.ColorEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.EnumEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.FullSized;
import com.jpexs.decompiler.flash.gui.generictageditors.GenericTagEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.NumberEditor;
import com.jpexs.decompiler.flash.gui.generictageditors.StringEditor;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.types.ARGB;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.annotations.Conditional;
import com.jpexs.decompiler.flash.types.annotations.ConditionalType;
import com.jpexs.decompiler.flash.types.annotations.EnumValue;
import com.jpexs.decompiler.flash.types.annotations.EnumValues;
import com.jpexs.decompiler.flash.types.annotations.HideInRawEdit;
import com.jpexs.decompiler.flash.types.annotations.Internal;
import com.jpexs.decompiler.flash.types.annotations.Multiline;
import com.jpexs.decompiler.flash.types.annotations.SWFArray;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.Table;
import com.jpexs.decompiler.flash.types.annotations.parser.AnnotationParseException;
import com.jpexs.decompiler.flash.types.annotations.parser.ConditionEvaluator;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.ConcreteClasses;
import com.jpexs.helpers.ReflectionTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.event.TreeModelListener;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class GenericTagTreePanel
extends GenericTagPanel {
    private static final Logger logger = Logger.getLogger(GenericTagTreePanel.class.getName());
    private JTree tree;
    private Tag editedTag;
    private static final Map<Class, List<Field>> fieldCache = new HashMap<Class, List<Field>>();
    private static final int FIELD_INDEX = 0;
    private Tag tag;

    public GenericTagTreePanel(MainPanel mainPanel) {
        super(mainPanel);
        this.setLayout(new BorderLayout());
        this.tree = new MyTree();
        this.add((Component)new FasterScrollPane(this.tree), "Center");
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                FieldNode fnode;
                Field field;
                Object selObject;
                if (!GenericTagTreePanel.this.tree.isEditable()) {
                    return;
                }
                int selRow = GenericTagTreePanel.this.tree.getRowForLocation(e.getX(), e.getY());
                final TreePath selPath = GenericTagTreePanel.this.tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && selPath != null && e.getClickCount() == 1 && e.getButton() == 3 && (selObject = selPath.getLastPathComponent()) instanceof FieldNode && ReflectionTools.needsIndex((Field)(field = (fnode = (FieldNode)selObject).fieldSet.get(0)))) {
                    SWFArray swfArray = fnode.fieldSet.get(0).getAnnotation(SWFArray.class);
                    String itemStr = "";
                    if (swfArray != null) {
                        itemStr = swfArray.value();
                    }
                    if (((FieldNode)fnode).fieldSet.itemName != null && !((FieldNode)fnode).fieldSet.itemName.isEmpty()) {
                        itemStr = ((FieldNode)fnode).fieldSet.itemName;
                    }
                    if (itemStr.isEmpty()) {
                        itemStr = AppStrings.translate("generictag.array.item");
                    }
                    boolean canAdd = true;
                    if (!ReflectionTools.canAddToField((Object)fnode.obj, (Field)fnode.fieldSet.get(0))) {
                        canAdd = false;
                    }
                    JPopupMenu p = new JPopupMenu();
                    Class subtype = ReflectionTools.getFieldSubType((Object)fnode.obj, (Field)fnode.fieldSet.get(0));
                    if (!canAdd && subtype.isAnnotationPresent(ConcreteClasses.class)) {
                        Class[] availableClasses = subtype.getAnnotation(ConcreteClasses.class).value();
                        JMenu mBegin = new JMenu(AppStrings.translate("generictag.array.insertbeginning").replace("%item%", itemStr));
                        p.add(mBegin);
                        JMenu mBefore = new JMenu(AppStrings.translate("generictag.array.insertbefore").replace("%item%", itemStr));
                        p.add(mBefore);
                        JMenuItem mi = new JMenuItem(AppStrings.translate("generictag.array.remove").replace("%item%", itemStr));
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                TreePath[] tps = GenericTagTreePanel.this.tree.getSelectionPaths();
                                if (tps == null) {
                                    tps = new TreePath[]{selPath};
                                }
                                boolean somethingRemoved = false;
                                for (int t = tps.length - 1; t >= 0; --t) {
                                    TreePath tp = tps[t];
                                    Object selObject = tp.getLastPathComponent();
                                    if (!(selObject instanceof FieldNode)) continue;
                                    FieldNode fnode2 = (FieldNode)selObject;
                                    GenericTagTreePanel.this.removeItem(fnode2.obj, fnode2.fieldSet.get(0), fnode2.index);
                                    somethingRemoved = true;
                                }
                                if (!somethingRemoved) {
                                    GenericTagTreePanel.this.removeItem(fnode.obj, fnode.fieldSet.get(0), fnode.index);
                                }
                            }
                        });
                        p.add(mi);
                        JMenu mAfter = new JMenu(AppStrings.translate("generictag.array.insertafter").replace("%item%", itemStr));
                        p.add(mAfter);
                        JMenu mEnd = new JMenu(AppStrings.translate("generictag.array.insertend").replace("%item%", itemStr));
                        p.add(mEnd);
                        for (Class c : availableClasses) {
                            mi = new JMenuItem(c.getSimpleName());
                            mi.addActionListener(e1 -> GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), 0, c));
                            mBegin.add(mi);
                            mi = new JMenuItem(c.getSimpleName());
                            mi.addActionListener(e1 -> GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), fnode.index, c));
                            mBefore.add(mi);
                            mi = new JMenuItem(c.getSimpleName());
                            mi.addActionListener(e1 -> GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), fnode.index + 1, c));
                            mAfter.add(mi);
                            mi = new JMenuItem(c.getSimpleName());
                            mi.addActionListener(e1 -> GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), ReflectionTools.getFieldSubSize((Object)fnode.obj, (Field)fnode.fieldSet.get(0)), c));
                            mEnd.add(mi);
                        }
                    } else {
                        JMenuItem mi = new JMenuItem(AppStrings.translate("generictag.array.insertbeginning").replace("%item%", itemStr));
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), 0, null);
                            }
                        });
                        if (!canAdd) {
                            mi.setEnabled(false);
                        }
                        p.add(mi);
                        if (fnode.index > -1) {
                            mi = new JMenuItem(AppStrings.translate("generictag.array.insertbefore").replace("%item%", itemStr));
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), fnode.index, null);
                                }
                            });
                            if (!canAdd) {
                                mi.setEnabled(false);
                            }
                            p.add(mi);
                            mi = new JMenuItem(AppStrings.translate("generictag.array.remove").replace("%item%", itemStr));
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    TreePath[] tps = GenericTagTreePanel.this.tree.getSelectionPaths();
                                    if (tps == null) {
                                        tps = new TreePath[]{selPath};
                                    }
                                    boolean someRemoved = false;
                                    for (int t = tps.length - 1; t >= 0; --t) {
                                        FieldNode fnode2;
                                        TreePath tp = tps[t];
                                        Object selObject = tp.getLastPathComponent();
                                        if (!(selObject instanceof FieldNode) || (fnode2 = (FieldNode)selObject).index <= -1) continue;
                                        GenericTagTreePanel.this.removeItem(fnode2.obj, fnode2.fieldSet.get(0), fnode2.index);
                                        someRemoved = true;
                                    }
                                    if (!someRemoved) {
                                        GenericTagTreePanel.this.removeItem(fnode.obj, fnode.fieldSet.get(0), fnode.index);
                                    }
                                }
                            });
                            p.add(mi);
                            mi = new JMenuItem(AppStrings.translate("generictag.array.insertafter").replace("%item%", itemStr));
                            mi.addActionListener(new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), fnode.index + 1, null);
                                }
                            });
                            if (!canAdd) {
                                mi.setEnabled(false);
                            }
                            p.add(mi);
                        }
                        mi = new JMenuItem(AppStrings.translate("generictag.array.insertend").replace("%item%", itemStr));
                        mi.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                GenericTagTreePanel.this.addItem(fnode.obj, fnode.fieldSet.get(0), ReflectionTools.getFieldSubSize((Object)fnode.obj, (Field)fnode.fieldSet.get(0)), null);
                            }
                        });
                        if (!canAdd) {
                            mi.setEnabled(false);
                        }
                        p.add(mi);
                    }
                    p.show(GenericTagTreePanel.this.tree, e.getX(), e.getY());
                }
            }
        });
    }

    @Override
    public void clear() {
        this.tag = null;
        this.editedTag = null;
        this.tree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("root")));
        this.revalidate();
        this.repaint();
    }

    private TreeModel getModel() {
        if (this.editedTag == null) {
            return new DefaultTreeModel(new DefaultMutableTreeNode("root"));
        }
        return new MyTreeModel(this.editedTag);
    }

    @Override
    public void setEditMode(boolean edit, Tag tag) {
        if (tag == null) {
            tag = this.tag;
        }
        this.tag = tag;
        try {
            this.editedTag = tag == null ? null : tag.cloneTag();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        if (!edit && this.tree.isEditing()) {
            this.tree.stopEditing();
        }
        this.tree.setEditable(edit);
        this.refreshTree();
    }

    @Override
    public boolean save() {
        if (this.tree.isEditing() && !this.tree.stopEditing()) {
            return false;
        }
        SWF swf = this.tag.getSwf();
        this.assignTag(this.tag, this.editedTag);
        this.tag.setModified(true);
        this.tag.setSwf(swf);
        return true;
    }

    private void assignTag(Tag t, Tag assigned) {
        if (t.getClass() != assigned.getClass()) {
            return;
        }
        for (Field f : GenericTagTreePanel.getAvailableFields(t.getClass())) {
            try {
                f.set(t, f.get(assigned));
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public Tag getTag() {
        return this.tag;
    }

    private static boolean hasEditor(Object obj, Field field, int index) {
        Class<?> type;
        boolean isByteArray = field.getType().equals(byte[].class);
        if (!isByteArray && ReflectionTools.needsIndex((Field)field) && index == -1) {
            return false;
        }
        try {
            Object val = ReflectionTools.getValue((Object)obj, (Field)field, (int)index);
            if (val == null) {
                return false;
            }
            type = val.getClass();
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            return false;
        }
        SWFType swfType = field.getAnnotation(SWFType.class);
        Multiline multiline = field.getAnnotation(Multiline.class);
        if (type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Long.TYPE) || type.equals(Long.class) || type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(Float.TYPE) || type.equals(Float.class)) {
            return true;
        }
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return true;
        }
        if (type.equals(String.class)) {
            return true;
        }
        if (type.equals(RGB.class) || type.equals(RGBA.class) || type.equals(ARGB.class)) {
            return true;
        }
        if (isByteArray || type.equals(ByteArrayRange.class)) {
            return true;
        }
        return type.equals(Amf3Value.class);
    }

    private static List<FieldSet> filterFields(MyTreeModel mod, String parentPath, Class<?> cls, boolean limited) {
        ArrayList<FieldSet> ret = new ArrayList<FieldSet>();
        List<Field> fields = GenericTagTreePanel.getAvailableFields(cls);
        HashMap<String, ArrayList<Field>> tables = new HashMap<String, ArrayList<Field>>();
        for (Field f : fields) {
            Table t;
            Conditional cond;
            if (limited && (cond = f.getAnnotation(Conditional.class)) != null) {
                ConditionEvaluator ev = new ConditionEvaluator(cond);
                try {
                    HashMap<String, Boolean> fieldMap = new HashMap<String, Boolean>();
                    for (String sf : ev.getFields()) {
                        String fulldf = parentPath + "." + sf;
                        FieldNode condnode = (FieldNode)mod.getNodeByPath(fulldf);
                        if (condnode != null) {
                            Object value = ReflectionTools.getValue((Object)condnode.obj, (Field)condnode.fieldSet.get(0), (int)condnode.index);
                            if (value instanceof Boolean) {
                                fieldMap.put(sf, (Boolean)value);
                                continue;
                            }
                            if (!(value instanceof Integer)) continue;
                            int intValue = (Integer)value;
                            boolean found = false;
                            for (int i : cond.options()) {
                                if (i != intValue) continue;
                                found = true;
                            }
                            fieldMap.put(sf, found);
                            continue;
                        }
                        fieldMap.put(sf, true);
                    }
                    if (!ev.eval(fieldMap)) {
                        continue;
                    }
                }
                catch (AnnotationParseException | IllegalAccessException | IllegalArgumentException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if ((t = f.getAnnotation(Table.class)) != null) {
                String tableName = t.value();
                if (!tables.containsKey(tableName)) {
                    ArrayList<Field> ret1 = new ArrayList<Field>();
                    tables.put(tableName, ret1);
                    ret.add(new FieldSet(ret1, tableName, t.itemName()));
                }
                ((List)tables.get(tableName)).add(f);
                continue;
            }
            ret.add(new FieldSet(f));
        }
        return ret;
    }

    private static List<Field> getAvailableFields(Class<?> cls) {
        List<Field> ret = fieldCache.get(cls);
        if (ret == null) {
            Field[] fields;
            ret = new ArrayList<Field>();
            for (Field f : fields = cls.getFields()) {
                HideInRawEdit hide;
                if (Modifier.isStatic(f.getModifiers())) continue;
                f.setAccessible(true);
                Internal inter = f.getAnnotation(Internal.class);
                if (inter != null || (hide = f.getAnnotation(HideInRawEdit.class)) != null) continue;
                ret.add(f);
            }
            fieldCache.put(cls, ret);
        }
        return ret;
    }

    private void addItem(Object obj, Field field, int index, Class<?> cls) {
        SWFArray swfArray = field.getAnnotation(SWFArray.class);
        if (swfArray != null && !swfArray.countField().isEmpty()) {
            Field[] fields = obj.getClass().getDeclaredFields();
            ArrayList<Integer> sameFlds = new ArrayList<Integer>();
            for (int f = 0; f < fields.length; ++f) {
                SWFArray fieldSwfArray = fields[f].getAnnotation(SWFArray.class);
                if (fieldSwfArray == null || !fieldSwfArray.countField().equals(swfArray.countField())) continue;
                sameFlds.add(f);
                if (cls != null || ReflectionTools.canAddToField((Object)obj, (Field)fields[f])) continue;
                JOptionPane.showMessageDialog(this, "This field is abstract, cannot be instantiated, sorry.");
                return;
            }
            Iterator f = sameFlds.iterator();
            while (f.hasNext()) {
                int f2 = (Integer)f.next();
                ReflectionTools.addToField((Object)obj, (Field)fields[f2], (int)index, (boolean)true, cls);
                try {
                    Object v = ReflectionTools.getValue((Object)obj, (Field)fields[f2], (int)index);
                    if (!(v instanceof ASMSource)) continue;
                    ASMSource asv = (ASMSource)v;
                    asv.setSourceTag(this.editedTag);
                }
                catch (IllegalAccessException | IllegalArgumentException exception) {}
            }
            try {
                Field countField = obj.getClass().getDeclaredField(swfArray.countField());
                int cnt = countField.getInt(obj);
                countField.setInt(obj, ++cnt);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
        } else {
            if (cls == null && !ReflectionTools.canAddToField((Object)obj, (Field)field)) {
                JOptionPane.showMessageDialog(this, "This field is abstract, cannot be instantiated, sorry.");
                return;
            }
            ReflectionTools.addToField((Object)obj, (Field)field, (int)index, (boolean)true, cls);
            try {
                Object v = ReflectionTools.getValue((Object)obj, (Field)field, (int)index);
                if (v instanceof ASMSource) {
                    ASMSource asv = (ASMSource)v;
                    asv.setSourceTag(this.editedTag);
                }
                if (obj instanceof CLIPACTIONS && v instanceof CLIPACTIONRECORD) {
                    ((CLIPACTIONRECORD)v).setParentClipActions((CLIPACTIONS)obj);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        this.refreshTree();
    }

    public void refreshTree() {
        View.refreshTree(this.tree, this.getModel());
        this.revalidate();
        this.repaint();
    }

    private void removeItem(Object obj, Field field, int index) {
        SWFArray swfArray = field.getAnnotation(SWFArray.class);
        if (swfArray != null && !swfArray.countField().isEmpty()) {
            Field[] fields = obj.getClass().getDeclaredFields();
            for (int f = 0; f < fields.length; ++f) {
                SWFArray fieldSwfArray = fields[f].getAnnotation(SWFArray.class);
                if (fieldSwfArray == null || !fieldSwfArray.countField().equals(swfArray.countField())) continue;
                ReflectionTools.removeFromField((Object)obj, (Field)fields[f], (int)index);
            }
            try {
                Field countField = obj.getClass().getDeclaredField(swfArray.countField());
                int cnt = countField.getInt(obj);
                countField.setInt(obj, --cnt);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {}
        } else {
            ReflectionTools.removeFromField((Object)obj, (Field)field, (int)index);
        }
        this.refreshTree();
    }

    private static class FieldSet {
        public List<Field> fields;
        public String name;
        public String itemName;

        public FieldSet(Field field) {
            this.fields = new ArrayList<Field>();
            this.fields.add(field);
            this.name = field.getName();
        }

        public FieldSet(List<Field> fields, String name, String itemName) {
            this.fields = fields;
            this.name = name;
            this.itemName = itemName;
        }

        public Field get(int index) {
            return this.fields.get(index);
        }

        public int size() {
            return this.fields.size();
        }
    }

    private static class MyTreeModel
    extends DefaultTreeModel {
        private final Tag mtroot;
        private final List<TreeModelListener> listeners = new ArrayList<TreeModelListener>();
        private final Map<String, Object> nodeCache = new HashMap<String, Object>();
        private final Map<Object, String> nodeCacheReverse = new HashMap<Object, String>();

        private Object getNodeByPath(String path) {
            if (this.nodeCache.containsKey(path)) {
                return this.nodeCache.get(path);
            }
            return null;
        }

        public String getNodePathName(Object find) {
            if (this.nodeCacheReverse.containsKey(find)) {
                return this.nodeCacheReverse.get(find);
            }
            return null;
        }

        public List<FieldNode> getDependentFields(FieldNode fnode) {
            ArrayList<FieldNode> ret = new ArrayList<FieldNode>();
            this.getDependentFields(this.getNodePathName(fnode), this.mtroot.getClass().getSimpleName(), this.mtroot, ret);
            return ret;
        }

        public void getDependentFields(String dependence, String currentPath, Object node, List<FieldNode> ret) {
            FieldNode fnode;
            Conditional cond;
            if (node instanceof FieldNode && (cond = (fnode = (FieldNode)node).fieldSet.get(0).getAnnotation(Conditional.class)) != null) {
                ConditionEvaluator ev = new ConditionEvaluator(cond);
                String parentPath = currentPath.indexOf(46) == -1 ? "" : currentPath.substring(0, currentPath.lastIndexOf(46));
                try {
                    for (String cname : ev.getFields()) {
                        String fullPath = parentPath + "." + cname;
                        if (!fullPath.equals(dependence)) continue;
                        ret.add(fnode);
                        break;
                    }
                }
                catch (AnnotationParseException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            int count = this.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                FieldNode f = (FieldNode)this.getChild(node, i);
                this.getDependentFields(dependence, currentPath + "." + f.getName(0), f, ret);
            }
        }

        public MyTreeModel(Tag root) {
            super(new DefaultMutableTreeNode(root));
            this.mtroot = root;
            this.buildCache(root, "");
        }

        private void buildCache(Object obj, String parentPath) {
            if (!"".equals(parentPath)) {
                parentPath = parentPath + ".";
            }
            if (obj instanceof FieldNode) {
                FieldNode fn = (FieldNode)obj;
                parentPath = parentPath + fn.getName(0);
            } else {
                parentPath = parentPath + obj.getClass().getSimpleName();
            }
            this.nodeCache.put(parentPath, obj);
            this.nodeCacheReverse.put(obj, parentPath);
            int count = this.getChildCount(obj, false);
            for (int i = 0; i < count; ++i) {
                this.buildCache(this.getChild(obj, i, false), parentPath);
            }
        }

        @Override
        public Object getRoot() {
            return this.mtroot;
        }

        private Object getChild(Object parent, int index, boolean limited) {
            if (parent == this.mtroot) {
                return new FieldNode(this.mtroot, this.mtroot, (FieldSet)GenericTagTreePanel.filterFields(this, this.mtroot.getClass().getSimpleName(), this.mtroot.getClass(), limited).get(index), -1);
            }
            FieldNode fnode = (FieldNode)parent;
            Field field = fnode.fieldSet.get(0);
            if (ReflectionTools.needsIndex((Field)field) && fnode.index == -1) {
                return new FieldNode(this.mtroot, fnode.obj, fnode.fieldSet, index);
            }
            parent = fnode.getValue(0);
            return new FieldNode(this.mtroot, parent, (FieldSet)GenericTagTreePanel.filterFields(this, this.getNodePathName(fnode), parent.getClass(), limited).get(index), -1);
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.getChild(parent, index, true);
        }

        @Override
        public int getChildCount(Object parent) {
            return this.getChildCount(parent, true);
        }

        private int getChildCount(Object parent, boolean limited) {
            if (parent == this.mtroot) {
                return GenericTagTreePanel.filterFields(this, this.mtroot.getClass().getSimpleName(), this.mtroot.getClass(), limited).size();
            }
            FieldNode fnode = (FieldNode)parent;
            if (this.isLeaf(fnode)) {
                return 0;
            }
            Field field = fnode.fieldSet.get(0);
            if (ReflectionTools.needsIndex((Field)field) && fnode.index == -1) {
                try {
                    if (field.get(fnode.obj) == null) {
                        return 0;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    return 0;
                }
                return ReflectionTools.getFieldSubSize((Object)fnode.obj, (Field)field);
            }
            parent = fnode.getValue(0);
            return GenericTagTreePanel.filterFields(this, this.getNodePathName(fnode), parent.getClass(), limited).size();
        }

        @Override
        public boolean isLeaf(Object node) {
            if (node == this.mtroot) {
                return false;
            }
            FieldNode fnode = (FieldNode)node;
            Field field = fnode.fieldSet.get(0);
            boolean isByteArray = field.getType().equals(byte[].class);
            if (!isByteArray && ReflectionTools.needsIndex((Field)field) && fnode.index == -1) {
                return false;
            }
            boolean r = GenericTagTreePanel.hasEditor(fnode.obj, field, fnode.index);
            return r;
        }

        public void vchanged(TreePath path) {
            this.fireTreeNodesChanged(this, path.getPath(), null, null);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            int cnt = this.getChildCount(parent);
            for (int i = 0; i < cnt; ++i) {
                if (!this.getChild(parent, i).equals(child)) continue;
                return i;
            }
            return -1;
        }
    }

    private static final class FieldNode
    extends DefaultMutableTreeNode {
        private Tag tag;
        private Object obj;
        private FieldSet fieldSet;
        private int index;

        public FieldNode(Tag tag, Object obj, FieldSet fieldSet, int index) {
            this.tag = tag;
            this.obj = obj;
            this.fieldSet = fieldSet;
            this.index = index;
            for (int i = 0; i < fieldSet.size(); ++i) {
                if (this.getValue(i) != null) continue;
                try {
                    if (List.class.isAssignableFrom(fieldSet.get(i).getType())) {
                        ReflectionTools.setValue((Object)obj, (Field)fieldSet.get(i), new ArrayList());
                        continue;
                    }
                    if (!fieldSet.get(i).getType().isArray()) continue;
                    ReflectionTools.setValue((Object)obj, (Field)fieldSet.get(i), (Object)Array.newInstance(fieldSet.get(i).getType().getComponentType(), 0));
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }

        @Override
        public void setUserObject(Object userObject) {
        }

        @Override
        public String toString() {
            StringBuilder ret = new StringBuilder();
            if (this.index > -1) {
                for (int i = 0; i < this.fieldSet.size(); ++i) {
                    if (i > 0) {
                        ret.append(", ");
                    }
                    ret.append(this.toString(i));
                }
                return ret.toString();
            }
            if (this.fieldSet.size() == 1) {
                ret.append(this.toString(0));
            } else {
                ret.append(this.fieldSet.name);
                SWFArray t = this.fieldSet.get(0).getAnnotation(SWFArray.class);
                if (t != null) {
                    ret.append(" [").append(t.countField()).append("]");
                } else {
                    ret.append(" []");
                }
            }
            ret.insert(0, "<html>").append("</html>");
            return ret.toString();
        }

        public String toString(int fieldIndex) {
            String valStr = "";
            Field field = this.fieldSet.get(fieldIndex);
            if (ReflectionTools.needsIndex((Field)field) && this.index == -1) {
                valStr = valStr + "";
            } else if (GenericTagTreePanel.hasEditor(this.obj, field, this.index)) {
                Object val = this.getValue(fieldIndex);
                Color color = null;
                String colorAdd = "";
                if (val instanceof RGB) {
                    color = ((RGB)val).toColor();
                }
                if (val instanceof ARGB) {
                    color = ((ARGB)val).toColor();
                }
                if (color != null) {
                    colorAdd = "<cite style=\"color:rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ");\">\u25cf</cite> ";
                }
                EnumValues enumValues = field.getAnnotation(EnumValues.class);
                String enumAdd = "";
                if (enumValues != null && val instanceof Integer) {
                    HashMap<Integer, String> values = new HashMap<Integer, String>();
                    for (EnumValue enumValue : enumValues.value()) {
                        values.put(enumValue.value(), enumValue.text());
                    }
                    enumAdd = " - " + (String)values.get(val);
                }
                valStr = val instanceof byte[] ? valStr + " = " + ((byte[])val).length + " byte" : (val instanceof ByteArrayRange ? valStr + " = " + ((ByteArrayRange)val).getLength() + " byte" : valStr + " = " + colorAdd + val.toString() + enumAdd);
            }
            return this.getNameType(fieldIndex) + valStr;
        }

        public String getType(int fieldIndex) {
            SWFType swfType = this.fieldSet.get(fieldIndex).getAnnotation(SWFType.class);
            SWFArray swfArray = this.fieldSet.get(fieldIndex).getAnnotation(SWFArray.class);
            Class<?> declaredType = this.fieldSet.get(fieldIndex).getType();
            boolean isArray = ReflectionTools.needsIndex((Field)this.fieldSet.get(fieldIndex)) || swfArray != null;
            boolean isArrayParent = isArray && this.index == -1;
            Class<?> declaredSubType = isArray ? ReflectionTools.getFieldSubType((Object)this.obj, (Field)this.fieldSet.get(fieldIndex)) : null;
            Class<?> type = declaredType;
            if (declaredSubType != null) {
                type = declaredSubType;
            }
            if (isArray && !isArrayParent) {
                try {
                    Object val = ReflectionTools.getValue((Object)this.obj, (Field)this.fieldSet.get(fieldIndex), (int)this.index);
                    if (val != null) {
                        type = val.getClass();
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException val) {
                    // empty catch block
                }
            }
            String typeStr = type.getSimpleName();
            if (swfType != null && swfType.value() != BasicType.OTHER) {
                typeStr = "" + swfType.value();
                if (swfType.count() > 0) {
                    typeStr = typeStr + "[" + swfType.count();
                    if (swfType.countAdd() > 0) {
                        typeStr = typeStr + " + " + swfType.countAdd();
                    }
                    typeStr = typeStr + "]";
                } else if (!swfType.countField().isEmpty()) {
                    typeStr = typeStr + "[" + swfType.countField();
                    if (swfType.countAdd() > 0) {
                        typeStr = typeStr + " + " + swfType.countAdd();
                    }
                    typeStr = typeStr + "]";
                }
            }
            String arrayBrackets = "";
            if (isArrayParent) {
                arrayBrackets = swfArray != null ? (swfArray.count() > 0 ? "[" + swfArray.count() + "]" : (!swfArray.countField().isEmpty() ? "[" + swfArray.countField() + "]" : "[]")) : "[]";
            }
            typeStr = typeStr + arrayBrackets;
            return typeStr;
        }

        public String getNameType(int fieldIndex) {
            String typeStr = this.getType(fieldIndex);
            return this.getName(fieldIndex) + (typeStr != null ? " : " + typeStr : "");
        }

        public String getName(int fieldIndex) {
            SWFArray swfArray = this.fieldSet.get(fieldIndex).getAnnotation(SWFArray.class);
            boolean isArray = ReflectionTools.needsIndex((Field)this.fieldSet.get(fieldIndex)) || swfArray != null;
            boolean isArrayParent = isArray && this.index == -1;
            String name = "";
            if (!isArray || isArrayParent) {
                name = this.fieldSet.get(fieldIndex).getName();
            } else if (swfArray != null && !isArrayParent) {
                name = swfArray.value();
            }
            if (!isArrayParent && isArray) {
                name = name + "[" + this.index + "]";
            }
            return name;
        }

        public Object getValue(int fieldIndex) {
            try {
                if (ReflectionTools.needsIndex((Field)this.fieldSet.get(fieldIndex)) && this.index == -1) {
                    return ReflectionTools.getValue((Object)this.obj, (Field)this.fieldSet.get(fieldIndex));
                }
                Object val = ReflectionTools.getValue((Object)this.obj, (Field)this.fieldSet.get(fieldIndex), (int)this.index);
                if (val == null) {
                    try {
                        Class type = this.fieldSet.get(fieldIndex).getType();
                        ConditionalType cond = this.fieldSet.get(fieldIndex).getAnnotation(ConditionalType.class);
                        if (cond != null) {
                            boolean condEnabled = false;
                            int[] tags = cond.tags();
                            if (tags != null && tags.length > 0) {
                                int tagId = this.tag.getId();
                                for (int i = 0; i < tags.length; ++i) {
                                    if (tags[i] != tagId) continue;
                                    condEnabled = true;
                                    break;
                                }
                            }
                            if (condEnabled) {
                                type = cond.type();
                            }
                        }
                        val = ReflectionTools.newInstanceOf(type);
                        ReflectionTools.setValue((Object)this.obj, (Field)this.fieldSet.get(fieldIndex), (int)this.index, (Object)val);
                    }
                    catch (IllegalAccessException | InstantiationException ex) {
                        logger.log(Level.SEVERE, null, ex);
                        return null;
                    }
                }
                return val;
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                return null;
            }
        }

        public int hashCode() {
            int hash = 7;
            hash = 11 * hash + Objects.hashCode(this.obj);
            hash = 11 * hash + Objects.hashCode(this.fieldSet.get(0));
            hash = 11 * hash + this.index;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FieldNode other = (FieldNode)obj;
            if (!Objects.equals(this.obj, other.obj)) {
                return false;
            }
            if (!Objects.equals(this.fieldSet.get(0), other.fieldSet.get(0))) {
                return false;
            }
            return this.index == other.index;
        }
    }

    private static final class TableFieldNodes
    extends DefaultMutableTreeNode {
        List<FieldNode> subnodes;

        public TableFieldNodes(List<FieldNode> subnodes) {
            this.subnodes = subnodes;
        }
    }

    public class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public MyTreeCellRenderer() {
            if (View.isOceanic()) {
                this.setUI(new BasicLabelUI());
                this.setOpaque(false);
                this.setBackgroundNonSelectionColor(Color.white);
            }
        }
    }

    private class MyTreeCellEditor
    extends AbstractCellEditor
    implements TreeCellEditor {
        private List<GenericTagEditor> editors = null;
        private final JTree tree;
        private FieldNode fnode;

        public MyTreeCellEditor(JTree tree) {
            this.tree = tree;
        }

        @Override
        public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
            Rectangle cellRect = tree.getPathBounds(tree.getPathForRow(row));
            Rectangle treeVisibleRect = tree.getVisibleRect();
            int scrollBarSize = (Integer)UIManager.get("ScrollBar.width");
            Rectangle cellMaxVisibleRect = new Rectangle(cellRect.x, cellRect.y, treeVisibleRect.width - cellRect.x - tree.getInsets().left - tree.getInsets().right - scrollBarSize, cellRect.height);
            if (value instanceof FieldNode) {
                this.fnode = (FieldNode)value;
                JPanel panSum = new JPanel(new FlowLayout(0, 0, 0));
                panSum.setOpaque(false);
                for (int i = 0; i < this.fnode.fieldSet.size(); ++i) {
                    Class<byte[]> type;
                    Field field = this.fnode.fieldSet.get(i);
                    int index = this.fnode.index;
                    Object obj = this.fnode.obj;
                    boolean isByteArray = field.getType().equals(byte[].class);
                    try {
                        type = isByteArray ? byte[].class : ReflectionTools.getValue((Object)obj, (Field)field, (int)index).getClass();
                    }
                    catch (IllegalAccessException | IllegalArgumentException ex) {
                        logger.log(Level.SEVERE, "Fixing characters order failed, recursion detected.");
                        return null;
                    }
                    JComponent editor = null;
                    SWFType swfType = field.getAnnotation(SWFType.class);
                    Multiline multiline = field.getAnnotation(Multiline.class);
                    EnumValues enumValues = field.getAnnotation(EnumValues.class);
                    if (enumValues != null && (type.equals(Integer.TYPE) || type.equals(Integer.class))) {
                        HashMap<Integer, String> values = new HashMap<Integer, String>();
                        for (EnumValue enumValue : enumValues.value()) {
                            values.put(enumValue.value(), enumValue.text());
                        }
                        editor = new EnumEditor(field.getName(), obj, field, index, type, swfType, values);
                    } else if (type.equals(Integer.TYPE) || type.equals(Integer.class) || type.equals(Short.TYPE) || type.equals(Short.class) || type.equals(Long.TYPE) || type.equals(Long.class) || type.equals(Double.TYPE) || type.equals(Double.class) || type.equals(Float.TYPE) || type.equals(Float.class)) {
                        editor = new NumberEditor(field.getName(), obj, field, index, type, swfType);
                    } else if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
                        editor = new BooleanEditor(field.getName(), obj, field, index, type);
                    } else if (type.equals(String.class)) {
                        editor = new StringEditor(field.getName(), obj, field, index, type, multiline != null);
                    } else if (type.equals(RGB.class) || type.equals(RGBA.class) || type.equals(ARGB.class)) {
                        editor = new ColorEditor(field.getName(), obj, field, index, type);
                    } else if (type.equals(byte[].class) || type.equals(ByteArrayRange.class)) {
                        editor = new BinaryDataEditor(GenericTagTreePanel.this.mainPanel, field.getName(), obj, field, index, type);
                    } else if (type.equals(Amf3Value.class)) {
                        editor = new Amf3ValueEditor(field.getName(), obj, field, index, type);
                    }
                    if (editor != null) {
                        if (this.editors == null) {
                            this.editors = new ArrayList<GenericTagEditor>();
                        }
                        this.editors.add((GenericTagEditor)((Object)editor));
                    }
                    JPanel pan = new JPanel();
                    FlowLayout fl = new FlowLayout(0, 0, 0);
                    fl.setAlignOnBaseline(true);
                    pan.setLayout(fl);
                    JLabel nameLabel = new JLabel(this.fnode.getNameType(i) + " = "){

                        @Override
                        public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
                            return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
                        }

                        @Override
                        public int getBaseline(int width, int height) {
                            return 0;
                        }
                    };
                    pan.setOpaque(false);
                    nameLabel.setAlignmentY(0.0f);
                    pan.add(nameLabel);
                    JComponent editorComponent = editor;
                    if (editorComponent != null) {
                        nameLabel.setSize(nameLabel.getWidth(), editorComponent.getHeight());
                        editorComponent.setAlignmentY(0.0f);
                        pan.add(editorComponent);
                        if (editorComponent instanceof FullSized) {
                            editorComponent.setPreferredSize(new Dimension(cellMaxVisibleRect.width - (int)nameLabel.getPreferredSize().getWidth() - 5, editorComponent.getPreferredSize().height));
                        }
                        if (editorComponent instanceof GenericTagEditor) {
                            ((GenericTagEditor)((Object)editorComponent)).added();
                        }
                        pan.setPreferredSize(new Dimension((int)nameLabel.getPreferredSize().getWidth() + 5 + (int)editorComponent.getPreferredSize().getWidth(), (int)editorComponent.getPreferredSize().getHeight()));
                    } else {
                        pan.setPreferredSize(new Dimension((int)nameLabel.getPreferredSize().getWidth(), (int)nameLabel.getPreferredSize().getHeight()));
                    }
                    panSum.add(pan);
                }
                panSum.setPreferredSize(new Dimension(cellMaxVisibleRect.width, panSum.getPreferredSize().height));
                return panSum;
            }
            return null;
        }

        @Override
        public Object getCellEditorValue() {
            ArrayList<Object> ret = new ArrayList<Object>();
            if (this.editors != null) {
                for (GenericTagEditor editor : this.editors) {
                    ret.add(editor.getChangedValue());
                }
            }
            return ret;
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (!(e instanceof MouseEvent)) {
                return false;
            }
            MouseEvent me = (MouseEvent)e;
            TreePath path = this.tree.getPathForLocation(me.getX(), me.getY());
            if (path == null) {
                return false;
            }
            Object obj = path.getLastPathComponent();
            boolean ret = super.isCellEditable(e) && this.tree.getModel().isLeaf(obj);
            return ret;
        }

        @Override
        public boolean stopCellEditing() {
            if (this.editors != null) {
                for (GenericTagEditor editor : this.editors) {
                    try {
                        editor.validateValue();
                        editor.save();
                    }
                    catch (IllegalArgumentException iex) {
                        return false;
                    }
                }
            }
            super.stopCellEditing();
            this.editors = null;
            TreePath sp = this.tree.getSelectionPath();
            if (sp != null) {
                ((MyTreeModel)this.tree.getModel()).vchanged(sp);
            }
            GenericTagTreePanel.this.refreshTree();
            return true;
        }
    }

    private class MyTree
    extends JTree {
        public MyTree() {
            if (View.isOceanic()) {
                this.setBackground(Color.white);
            }
            this.setUI(new BasicTreeUI(){

                @Override
                public void paint(Graphics g, JComponent c) {
                    this.setHashColor(Color.gray);
                    super.paint(g, c);
                }
            });
            this.setCellRenderer(new MyTreeCellRenderer());
            this.setCellEditor(new MyTreeCellEditor(this));
            this.setInvokesStopCellEditing(true);
        }
    }
}

