/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.gui;

import com.jpexs.debugger.flash.DebugConnectionListener;
import com.jpexs.debugger.flash.DebugMessageListener;
import com.jpexs.debugger.flash.DebuggerCommands;
import com.jpexs.debugger.flash.DebuggerConnection;
import com.jpexs.debugger.flash.InDebuggerMessage;
import com.jpexs.debugger.flash.OutDebuggerMessage;
import com.jpexs.debugger.flash.Variable;
import com.jpexs.debugger.flash.messages.in.InAskBreakpoints;
import com.jpexs.debugger.flash.messages.in.InBreakAt;
import com.jpexs.debugger.flash.messages.in.InBreakAtExt;
import com.jpexs.debugger.flash.messages.in.InBreakReason;
import com.jpexs.debugger.flash.messages.in.InCallFunction;
import com.jpexs.debugger.flash.messages.in.InConstantPool;
import com.jpexs.debugger.flash.messages.in.InContinue;
import com.jpexs.debugger.flash.messages.in.InFrame;
import com.jpexs.debugger.flash.messages.in.InGetSwd;
import com.jpexs.debugger.flash.messages.in.InGetSwf;
import com.jpexs.debugger.flash.messages.in.InGetVariable;
import com.jpexs.debugger.flash.messages.in.InNumScript;
import com.jpexs.debugger.flash.messages.in.InProcessTag;
import com.jpexs.debugger.flash.messages.in.InScript;
import com.jpexs.debugger.flash.messages.in.InSetBreakpoint;
import com.jpexs.debugger.flash.messages.in.InSwfInfo;
import com.jpexs.debugger.flash.messages.in.InTrace;
import com.jpexs.debugger.flash.messages.in.InVersion;
import com.jpexs.debugger.flash.messages.out.OutAddWatch2;
import com.jpexs.debugger.flash.messages.out.OutGetBreakReason;
import com.jpexs.debugger.flash.messages.out.OutGetSwd;
import com.jpexs.debugger.flash.messages.out.OutGetSwf;
import com.jpexs.debugger.flash.messages.out.OutPlay;
import com.jpexs.debugger.flash.messages.out.OutProcessedTag;
import com.jpexs.debugger.flash.messages.out.OutRewind;
import com.jpexs.debugger.flash.messages.out.OutSwfInfo;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.gui.AppStrings;
import com.jpexs.decompiler.flash.gui.Main;
import com.jpexs.decompiler.flash.gui.View;
import com.jpexs.decompiler.flash.gui.ViewMessages;
import com.jpexs.decompiler.graph.DottedChain;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DebuggerHandler
implements DebugConnectionListener {
    private boolean connected = false;
    private DebuggerCommands commands = null;
    private List<InSwfInfo.SwfInfo> swfs = new ArrayList<InSwfInfo.SwfInfo>();
    private boolean paused = true;
    private Map<Integer, String> modulePaths = new HashMap<Integer, String>();
    private Map<Integer, Integer> moduleToSwfIndex = new HashMap<Integer, Integer>();
    private Map<String, Integer> scriptToModule = new HashMap<String, Integer>();
    private Map<Integer, Integer> moduleToTraitIndex = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> moduleToClassIndex = new HashMap<Integer, Integer>();
    private Map<Integer, Integer> moduleToMethodIndex = new HashMap<Integer, Integer>();
    private Map<String, Set<Integer>> toAddBPointMap = new HashMap<String, Set<Integer>>();
    private Map<String, Set<Integer>> confirmedPointMap = new HashMap<String, Set<Integer>>();
    private Map<String, Set<Integer>> invalidBreakPointMap = new HashMap<String, Set<Integer>>();
    private Map<String, Set<Integer>> toRemoveBPointMap = new HashMap<String, Set<Integer>>();
    private int breakIp = -1;
    private String breakScriptName = null;
    private int watchTag = 1;
    private InFrame frame;
    private InConstantPool pool;
    private InBreakAtExt breakInfo;
    private InBreakReason breakReason;
    private final List<BreakListener> breakListeners = new CopyOnWriteArrayList<BreakListener>();
    private final List<TraceListener> traceListeners = new ArrayList<TraceListener>();
    private final List<ConnectionListener> clisteners = new ArrayList<ConnectionListener>();

    public int getBreakIp() {
        if (!this.isPaused()) {
            return -1;
        }
        return this.breakIp;
    }

    public String getBreakScriptName() {
        if (!this.isPaused()) {
            return "-";
        }
        return this.breakScriptName;
    }

    public InGetVariable getVariable(long parentId, String varName, boolean children) {
        try {
            return this.commands.getVariable(parentId, varName, true, children);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public void setVariable(long parentId, String varName, int valueType, Object value) {
        try {
            String svalue = "";
            switch (valueType) {
                case 2: {
                    svalue = "" + value;
                    break;
                }
                case 0: {
                    svalue = "" + value;
                    break;
                }
                case 1: {
                    svalue = (Boolean)value != false ? "true" : "false";
                    break;
                }
                case 7: {
                    svalue = "undefined";
                    break;
                }
                case 6: {
                    svalue = "undefined";
                }
            }
            this.commands.setVariable(parentId, varName, valueType, svalue);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void removeBreakPoint(String scriptName, int line) {
        if (this.isBreakpointInvalid(scriptName, line)) {
            this.invalidBreakPointMap.get(scriptName).remove(line);
            if (this.invalidBreakPointMap.get(scriptName).isEmpty()) {
                this.invalidBreakPointMap.remove(scriptName);
            }
            return;
        }
        if (this.isBreakpointToAdd(scriptName, line)) {
            this.toAddBPointMap.get(scriptName).remove(line);
            if (this.toAddBPointMap.get(scriptName).isEmpty()) {
                this.toAddBPointMap.remove(scriptName);
            }
        } else if (this.isBreakpointConfirmed(scriptName, line)) {
            if (!this.toRemoveBPointMap.containsKey(scriptName)) {
                this.toRemoveBPointMap.put(scriptName, new TreeSet());
            }
            this.toRemoveBPointMap.get(scriptName).add(line);
        }
        try {
            this.sendBreakPoints(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized DebuggerCommands.Watch addWatch(Variable v, long v_id, boolean watchRead, boolean watchWrite) {
        int tag = this.watchTag++;
        try {
            return this.commands.addWatch(v_id, v.name, (watchRead ? OutAddWatch2.FLAG_READ : 0) | (watchWrite ? OutAddWatch2.FLAG_WRITE : 0), tag);
        }
        catch (IOException ex) {
            return null;
        }
    }

    public synchronized Set<Integer> getBreakPoints(String scriptName, boolean onlyValid) {
        TreeSet<Integer> lines = new TreeSet<Integer>();
        if (this.confirmedPointMap.containsKey(scriptName)) {
            lines.addAll((Collection)this.confirmedPointMap.get(scriptName));
        }
        if (this.toAddBPointMap.containsKey(scriptName)) {
            lines.addAll((Collection<Integer>)this.toAddBPointMap.get(scriptName));
        }
        if (!onlyValid && this.invalidBreakPointMap.containsKey(scriptName)) {
            lines.addAll((Collection<Integer>)this.invalidBreakPointMap.get(scriptName));
        }
        return lines;
    }

    public synchronized void clearBreakPoints() {
        for (String scriptName : this.confirmedPointMap.keySet()) {
            if (!this.toAddBPointMap.containsKey(scriptName)) {
                this.toAddBPointMap.put(scriptName, new TreeSet());
            }
            this.toAddBPointMap.get(scriptName).addAll((Collection<Integer>)this.confirmedPointMap.get(scriptName));
        }
        for (String scriptName : this.invalidBreakPointMap.keySet()) {
            if (!this.toAddBPointMap.containsKey(scriptName)) {
                this.toAddBPointMap.put(scriptName, new TreeSet());
            }
            this.toAddBPointMap.get(scriptName).addAll((Collection<Integer>)this.invalidBreakPointMap.get(scriptName));
        }
        this.confirmedPointMap.clear();
        this.invalidBreakPointMap.clear();
    }

    public synchronized Map<String, Set<Integer>> getAllBreakPoints(boolean validOnly) {
        HashMap<String, Set<Integer>> ret = new HashMap<String, Set<Integer>>();
        for (String scriptName : this.confirmedPointMap.keySet()) {
            TreeSet lines = new TreeSet();
            lines.addAll(this.confirmedPointMap.get(scriptName));
            ret.put(scriptName, lines);
        }
        for (String scriptName : this.toAddBPointMap.keySet()) {
            if (!ret.containsKey(scriptName)) {
                ret.put(scriptName, new TreeSet());
            }
            ((Set)ret.get(scriptName)).addAll((Collection)this.toAddBPointMap.get(scriptName));
        }
        if (!validOnly) {
            for (String scriptName : this.invalidBreakPointMap.keySet()) {
                if (!ret.containsKey(scriptName)) {
                    ret.put(scriptName, new TreeSet());
                }
                ((Set)ret.get(scriptName)).addAll((Collection)this.invalidBreakPointMap.get(scriptName));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addBreakPoint(String scriptName, int line) {
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "adding bp {0}:{1}", new Object[]{scriptName, line});
            if (this.isBreakpointToRemove(scriptName, line)) {
                this.toRemoveBPointMap.get(scriptName).remove(line);
                if (this.toRemoveBPointMap.get(scriptName).isEmpty()) {
                    this.toRemoveBPointMap.remove(scriptName);
                }
            }
            if (this.isBreakpointConfirmed(scriptName, line)) {
                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "bp {0}:{1} already confirmed", new Object[]{scriptName, line});
                return true;
            }
            if (this.isBreakpointInvalid(scriptName, line)) {
                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "bp {0}:{1} already invalid", new Object[]{scriptName, line});
                return false;
            }
            if (!this.toAddBPointMap.containsKey(scriptName)) {
                this.toAddBPointMap.put(scriptName, new TreeSet());
            }
            this.toAddBPointMap.get(scriptName).add(line);
            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "bp {0}:{1} added to todo", new Object[]{scriptName, line});
        }
        try {
            this.sendBreakPoints(false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public synchronized boolean isBreakpointConfirmed(String scriptName, int line) {
        return this.confirmedPointMap.containsKey(scriptName) && this.confirmedPointMap.get(scriptName).contains(line);
    }

    public synchronized boolean isBreakpointToAdd(String scriptName, int line) {
        return this.toAddBPointMap.containsKey(scriptName) && this.toAddBPointMap.get(scriptName).contains(line);
    }

    public synchronized boolean isBreakpointToRemove(String scriptName, int line) {
        return this.toRemoveBPointMap.containsKey(scriptName) && this.toRemoveBPointMap.get(scriptName).contains(line);
    }

    public synchronized boolean isBreakpointInvalid(String scriptName, int line) {
        return this.invalidBreakPointMap.containsKey(scriptName) && this.invalidBreakPointMap.get(scriptName).contains(line);
    }

    private synchronized void markBreakPointInvalid(String scriptName, int line) {
        if (!this.invalidBreakPointMap.containsKey(scriptName)) {
            this.invalidBreakPointMap.put(scriptName, new TreeSet());
        }
        this.invalidBreakPointMap.get(scriptName).add(line);
    }

    public String moduleToString(int file) {
        if (!this.modulePaths.containsKey(file)) {
            return "unknown";
        }
        return this.modulePaths.get(file);
    }

    public synchronized InBreakAtExt getBreakInfo() {
        if (!this.paused) {
            return null;
        }
        return this.breakInfo;
    }

    public synchronized InBreakReason getBreakReason() {
        if (!this.paused) {
            return null;
        }
        return this.breakReason;
    }

    public void addBreakListener(BreakListener l) {
        this.breakListeners.add(l);
    }

    public void addTraceListener(TraceListener l) {
        this.traceListeners.add(l);
    }

    public void removeTraceListener(TraceListener l) {
        this.traceListeners.remove(l);
    }

    public void removeBreakListener(BreakListener l) {
        this.breakListeners.remove(l);
    }

    public void addConnectionListener(ConnectionListener l) {
        this.clisteners.add(l);
    }

    public void removeConnectionListener(ConnectionListener l) {
        this.clisteners.remove(l);
    }

    public synchronized void refreshFrame() {
        if (!this.paused) {
            return;
        }
        try {
            this.frame = this.commands.getFrame(0);
            this.pool = this.commands.getConstantPool(0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized InFrame getFrame() {
        if (!this.paused) {
            return null;
        }
        return this.frame;
    }

    public synchronized int moduleIdOf(String pack) {
        if (this.scriptToModule.containsKey(pack)) {
            return this.scriptToModule.get(pack);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPaused() {
        if (!this.isConnected()) {
            return false;
        }
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            return this.paused;
        }
    }

    public List<InSwfInfo.SwfInfo> getSwfs() {
        return this.swfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        this.frame = null;
        this.pool = null;
        this.breakInfo = null;
        this.breakReason = null;
        this.connected = false;
        if (this.commands != null) {
            this.commands.disconnect();
        }
        this.commands = null;
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            for (String scriptName : this.confirmedPointMap.keySet()) {
                if (!this.toAddBPointMap.containsKey(scriptName)) {
                    this.toAddBPointMap.put(scriptName, new TreeSet());
                }
                this.toAddBPointMap.get(scriptName).addAll((Collection<Integer>)this.confirmedPointMap.get(scriptName));
            }
            this.confirmedPointMap.clear();
            for (String scriptName : this.invalidBreakPointMap.keySet()) {
                if (!this.toAddBPointMap.containsKey(scriptName)) {
                    this.toAddBPointMap.put(scriptName, new TreeSet());
                }
                this.toAddBPointMap.get(scriptName).addAll((Collection<Integer>)this.invalidBreakPointMap.get(scriptName));
            }
            this.invalidBreakPointMap.clear();
        }
        for (ConnectionListener l : this.clisteners) {
            l.disconnected();
        }
    }

    public synchronized boolean isConnected() {
        return this.connected;
    }

    public DebuggerCommands getCommands() throws IOException {
        if (!this.isConnected() || this.commands == null) {
            throw new IOException("Not connected");
        }
        return this.commands;
    }

    private static void enlog(Class<?> cls) {
        Level level = Level.FINEST;
        Logger mylog = Logger.getLogger(cls.getName());
        mylog.setLevel(level);
        ConsoleHandler ch = new ConsoleHandler();
        ch.setLevel(level);
        mylog.addHandler(ch);
    }

    public void failedListen(IOException ex) {
        View.execInEventDispatch(new Runnable(){

            @Override
            public void run() {
                DebuggerHandler.this.disconnect();
                Main.stopRun();
                Main.stopWork();
                ViewMessages.showMessageDialog(Main.getMainFrame().getPanel(), AppStrings.translate("error.debug.listen").replace("%port%", "7935"));
                Main.getMainFrame().getPanel().updateMenu();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connected(final DebuggerConnection con) {
        this.clearBreakPoints();
        Main.startWork(AppStrings.translate("work.debugging"), null);
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            this.paused = false;
        }
        Main.getMainFrame().getPanel().updateMenu();
        boolean isAS3 = Main.getMainFrame().getPanel().getCurrentSwf().isAS3();
        try {
            con.getMessage(InVersion.class);
        }
        catch (IOException ex) {
            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.SEVERE, null, ex);
        }
        con.addMessageListener((DebugMessageListener)new DebugMessageListener<InProcessTag>(){

            public void message(InProcessTag message) {
                try {
                    con.writeMessage((OutDebuggerMessage)new OutProcessedTag(con));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.swfs.clear();
        final HashMap moduleNames = new HashMap();
        final Pattern patAS3 = Pattern.compile("^(.*);(.*);(.*)\\.as$");
        final Pattern patAS3PCode = Pattern.compile("^#PCODE abc:([0-9]+),script:([0-9]+),class:(-?[0-9]+),trait:(-?[0-9]+),method:([0-9]+),body:([0-9]+);(.*)$");
        try {
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InNumScript>(){

                public void message(InNumScript t) {
                    con.dropMessage((InDebuggerMessage)t);
                }
            });
            this.modulePaths = new HashMap<Integer, String>();
            this.scriptToModule = new HashMap<String, Integer>();
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InScript>(){

                public void message(InScript sc) {
                    moduleNames.put(sc.module, sc.name);
                    DebuggerHandler.this.moduleToSwfIndex.put(sc.module, sc.swfIndex);
                    int file = sc.module;
                    String name = sc.name;
                    String[] parts = name.split(";");
                    Matcher m = patAS3.matcher(name);
                    if (m.matches()) {
                        String clsNameWithSuffix = m.group(3);
                        String pkg = m.group(2).replace("\\", ".");
                        m = patAS3PCode.matcher(name);
                        if (m.matches()) {
                            DebuggerHandler.this.moduleToClassIndex.put(file, Integer.parseInt(m.group(3)));
                            DebuggerHandler.this.moduleToTraitIndex.put(file, Integer.parseInt(m.group(4)));
                            DebuggerHandler.this.moduleToMethodIndex.put(file, Integer.parseInt(m.group(5)));
                            name = DottedChain.parseWithSuffix((String)pkg).addWithSuffix(clsNameWithSuffix).toString();
                            name = "#PCODE abc:" + m.group(1) + ",body:" + m.group(6) + ";" + name;
                        } else {
                            name = DottedChain.parseWithSuffix((String)pkg).addWithSuffix(clsNameWithSuffix).toString();
                        }
                    }
                    DebuggerHandler.this.modulePaths.put(file, name);
                    DebuggerHandler.this.scriptToModule.put(name, file);
                    con.dropMessage((InDebuggerMessage)sc);
                }
            });
            this.commands = new DebuggerCommands(con);
            this.commands.stopWarning();
            this.commands.setStopOnFault();
            this.commands.setEnumerateOverride();
            this.commands.setNotifyFailure();
            this.commands.setInvokeSetters();
            this.commands.setSwfLoadNotify();
            this.commands.setGetterTimeout(1500);
            this.commands.setSetterTimeout(5000);
            con.isAS3 = isAS3;
            if (isAS3) {
                con.wideLines = this.commands.getOption("wide_line_player", "false").equals("true");
                if (con.wideLines) {
                    this.commands.setOption("wide_line_debugger", "on");
                }
            }
            this.commands.squelch(true);
            con.writeMessage((OutDebuggerMessage)new OutSwfInfo(con, 0));
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InSwfInfo>(){

                public void message(InSwfInfo t) {
                    for (final InSwfInfo.SwfInfo s : t.swfInfos) {
                        DebuggerHandler.this.swfs.add(s);
                        View.execInEventDispatch(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    con.sendMessageWithTimeout((OutDebuggerMessage)new OutGetSwf(con, (int)s.index), InGetSwf.class);
                                    con.sendMessageWithTimeout((OutDebuggerMessage)new OutGetSwd(con, (int)s.index), InGetSwd.class);
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                    con.dropMessage((InDebuggerMessage)t);
                }
            });
            InSetBreakpoint isb = (InSetBreakpoint)con.getMessage(InSetBreakpoint.class);
            Object object = this;
            synchronized (object) {
                for (int i = 0; i < isb.files.size(); ++i) {
                    String sname = (String)moduleNames.get(isb.files.get(i));
                    if (!this.confirmedPointMap.containsKey(sname)) {
                        this.confirmedPointMap.put(sname, new TreeSet());
                    }
                    if (this.toAddBPointMap.containsKey(sname)) {
                        this.toAddBPointMap.get(sname).remove(isb.lines.get(i));
                        if (this.toAddBPointMap.get(sname).isEmpty()) {
                            this.toAddBPointMap.remove(sname);
                        }
                    }
                    this.confirmedPointMap.get(sname).add((Integer)isb.lines.get(i));
                    Logger.getLogger(DebuggerHandler.class.getName()).log(Level.INFO, "Breakpoint {0}:{1} submitted successfully", new Object[]{sname, isb.lines.get(i)});
                }
            }
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InAskBreakpoints>(){

                public void message(InAskBreakpoints message) {
                }
            });
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InContinue>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void message(InContinue msg) {
                    DebuggerHandler debuggerHandler = DebuggerHandler.this;
                    synchronized (debuggerHandler) {
                        DebuggerHandler.this.paused = false;
                        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "continued");
                    }
                    for (BreakListener bl : DebuggerHandler.this.breakListeners) {
                        bl.doContinue();
                    }
                }
            });
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InBreakAt>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void message(InBreakAt message) {
                    DebuggerHandler debuggerHandler = DebuggerHandler.this;
                    synchronized (debuggerHandler) {
                        DebuggerHandler.this.paused = true;
                        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "paused");
                    }
                    try {
                        DebuggerHandler.this.breakInfo = (InBreakAtExt)con.getMessage(InBreakAtExt.class, 750L);
                        DebuggerHandler.this.breakReason = (InBreakReason)con.sendMessageWithTimeout((OutDebuggerMessage)new OutGetBreakReason(con), InBreakReason.class);
                        int reasonInt = DebuggerHandler.this.breakReason == null ? 0 : ((DebuggerHandler)DebuggerHandler.this).breakReason.reason;
                        String newBreakScriptName = "unknown";
                        if (DebuggerHandler.this.modulePaths.containsKey(message.file)) {
                            newBreakScriptName = (String)DebuggerHandler.this.modulePaths.get(message.file);
                        } else if (reasonInt != InBreakReason.REASON_SCRIPT_LOADED) {
                            Logger.getLogger(DebuggerCommands.class.getName()).log(Level.SEVERE, "Invalid file: {0}", message.file);
                            return;
                        }
                        String[] reasonNames = new String[]{"unknown", "breakpoint", "watch", "fault", "stopRequest", "step", "halt", "scriptLoaded"};
                        String reason = reasonInt < reasonNames.length ? reasonNames[reasonInt] : reasonNames[0];
                        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINE, "break at {0}:{1}, reason: {2}", new Object[]{newBreakScriptName, message.line, reason});
                        DebuggerHandler.this.sendBreakPoints(false);
                        DebuggerHandler debuggerHandler2 = DebuggerHandler.this;
                        synchronized (debuggerHandler2) {
                            DebuggerHandler.this.breakScriptName = newBreakScriptName;
                            DebuggerHandler.this.breakIp = message.line;
                        }
                        if (reasonInt == InBreakReason.REASON_SCRIPT_LOADED) {
                            if (!((Boolean)Configuration.debugHalt.get()).booleanValue()) {
                                DebuggerHandler.this.commands.sendContinue();
                                return;
                            }
                            Main.startWork(AppStrings.translate("work.halted"), null);
                        } else {
                            Main.startWork(AppStrings.translate("work.breakat") + newBreakScriptName + ":" + message.line + " " + AppStrings.translate("debug.break.reason." + reason), null);
                        }
                        DebuggerHandler.this.frame = DebuggerHandler.this.commands.getFrame(0);
                        DebuggerHandler.this.pool = DebuggerHandler.this.commands.getConstantPool(0);
                        for (BreakListener l : DebuggerHandler.this.breakListeners) {
                            l.breakAt(newBreakScriptName, message.line, DebuggerHandler.this.moduleToClassIndex.containsKey(message.file) ? (Integer)DebuggerHandler.this.moduleToClassIndex.get(message.file) : -1, DebuggerHandler.this.moduleToTraitIndex.containsKey(message.file) ? (Integer)DebuggerHandler.this.moduleToTraitIndex.get(message.file) : -1, DebuggerHandler.this.moduleToMethodIndex.containsKey(message.file) ? (Integer)DebuggerHandler.this.moduleToMethodIndex.get(message.file) : -1);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            object = this;
            synchronized (object) {
                this.connected = true;
            }
            if (!isAS3) {
                try {
                    this.commands.getConnection().writeMessage((OutDebuggerMessage)new OutRewind(this.commands.getConnection()));
                }
                catch (IOException ex) {
                    Logger.getLogger(DebuggerHandler.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            for (ConnectionListener l : this.clisteners) {
                l.connected();
            }
            con.addMessageListener((DebugMessageListener)new DebugMessageListener<InTrace>(){

                public void message(InTrace tr) {
                    for (TraceListener l : DebuggerHandler.this.traceListeners) {
                        l.trace(tr.text);
                    }
                }
            });
            if (!isAS3) {
                Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINER, "End of connect - sending continue");
                con.writeMessage((OutDebuggerMessage)new OutRewind(con));
                con.writeMessage((OutDebuggerMessage)new OutPlay(con));
                this.commands.sendContinue();
            }
        }
        catch (IOException ex) {
            DebuggerHandler debuggerHandler2 = this;
            synchronized (debuggerHandler2) {
                this.connected = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBreakPoints(boolean force) throws IOException {
        if (!force && !this.isPaused()) {
            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINEST, "not sending bps, not paused");
            return;
        }
        DebuggerHandler debuggerHandler = this;
        synchronized (debuggerHandler) {
            int file;
            for (String scriptName : this.toRemoveBPointMap.keySet()) {
                file = this.moduleIdOf(scriptName);
                if (file <= -1) continue;
                for (int line : this.toRemoveBPointMap.get(scriptName)) {
                    if (this.isBreakpointConfirmed(scriptName, line)) {
                        this.commands.removeBreakPoint(file, line);
                        this.confirmedPointMap.get(scriptName).remove(line);
                        if (this.confirmedPointMap.get(scriptName).isEmpty()) {
                            this.confirmedPointMap.remove(scriptName);
                        }
                    }
                    Logger.getLogger(DebuggerHandler.class.getName()).log(Level.INFO, "Breakpoint {0}:{1} removed", new Object[]{scriptName, line});
                }
            }
            this.toRemoveBPointMap.clear();
            for (String scriptName : this.toAddBPointMap.keySet()) {
                file = this.moduleIdOf(scriptName);
                if (file > -1) {
                    for (int line : this.toAddBPointMap.get(scriptName)) {
                        if (this.commands.addBreakPoint(file, line)) {
                            Logger.getLogger(DebuggerHandler.class.getName()).log(Level.INFO, "Breakpoint {0}:{1} submitted successfully", new Object[]{scriptName, line});
                            if (!this.confirmedPointMap.containsKey(scriptName)) {
                                this.confirmedPointMap.put(scriptName, new TreeSet());
                            }
                            this.confirmedPointMap.get(scriptName).add(line);
                            continue;
                        }
                        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.INFO, "Breakpoint {0}:{1} unable to submit", new Object[]{scriptName, line});
                        this.markBreakPointInvalid(scriptName, line);
                    }
                    continue;
                }
                for (int line : this.toAddBPointMap.get(scriptName)) {
                    this.markBreakPointInvalid(scriptName, line);
                }
            }
            this.toAddBPointMap.clear();
        }
        Logger.getLogger(DebuggerHandler.class.getName()).log(Level.FINEST, "sending bps finished");
    }

    public synchronized InConstantPool getConstantPool() {
        if (!this.paused) {
            return null;
        }
        return this.pool;
    }

    public synchronized InCallFunction callMethod(Variable object, String methodName, List<Object> args) throws ActionScriptException {
        return this.callFunction(false, methodName, object, args);
    }

    public synchronized InCallFunction callMethod(String object, String methodName, List<Object> args) throws ActionScriptException {
        InGetVariable igv = this.getVariable(0L, object, false);
        return this.callMethod(igv.parent, methodName, args);
    }

    private static String typeAsStr(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Long || value instanceof Integer) {
            return "int";
        }
        if (value instanceof Number) {
            return "Number";
        }
        if (value instanceof String) {
            return "String";
        }
        if (value instanceof Variable) {
            Variable v = (Variable)value;
            return v.getTypeAsStr();
        }
        return "String";
    }

    private static String valueAsStr(Object value) {
        long longValue;
        double doubleValue;
        if (value == null) {
            return "null";
        }
        if (value instanceof Double && (doubleValue = ((Double)value).doubleValue()) == (double)(longValue = (long)doubleValue)) {
            return Long.toString(longValue);
        }
        if (value instanceof Variable) {
            Variable v = (Variable)value;
            return DebuggerHandler.valueAsStr(v.value);
        }
        return "" + value;
    }

    public synchronized InCallFunction callFunction(boolean isConstructor, String funcName, Variable thisValue, List<Object> args) throws ActionScriptException {
        ArrayList<String> argTypes = new ArrayList<String>();
        ArrayList<String> argValues = new ArrayList<String>();
        for (Object value : args) {
            argTypes.add(DebuggerHandler.typeAsStr(value));
            argValues.add(DebuggerHandler.valueAsStr(value));
        }
        String thisType = DebuggerHandler.typeAsStr(thisValue);
        String thisValueStr = DebuggerHandler.valueAsStr(thisValue);
        try {
            InCallFunction icf = this.commands.callFunction(isConstructor, funcName, thisType, thisValueStr, argTypes, argValues);
            if (!icf.variables.isEmpty() && (((Variable)icf.variables.get((int)0)).flags & 0x40000) > 0) {
                throw new ActionScriptException("" + ((Variable)icf.variables.get((int)0)).value);
            }
            return icf;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static interface BreakListener {
        public void breakAt(String var1, int var2, int var3, int var4, int var5);

        public void doContinue();
    }

    public static interface TraceListener {
        public void trace(String ... var1);
    }

    public static interface ConnectionListener {
        public void connected();

        public void disconnected();
    }

    public static class ActionScriptException
    extends Exception {
        private String errorClass;

        public ActionScriptException(String errorClass, String message) {
            super(message);
            this.errorClass = errorClass;
        }

        public ActionScriptException(String errorClsMessage) {
            this(errorClsMessage.substring(0, errorClsMessage.indexOf(": ")), errorClsMessage.substring(errorClsMessage.indexOf(": ") + 2));
        }

        public String getErrorClass() {
            return this.errorClass;
        }
    }
}

