/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.chrome;

import com.jpexs.browsers.cache.chrome.CacheAddr;
import com.jpexs.browsers.cache.chrome.EntryStore;
import com.jpexs.browsers.cache.chrome.IndexHeader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Index {
    IndexHeader header;
    CacheAddr[] table;
    public static final int kIndexTablesize = 65536;
    public File rootDir;
    private final Map<Integer, RandomAccessFile> dataFiles = new HashMap<Integer, RandomAccessFile>();
    private final File externalFilesDir;

    public void free() {
        for (RandomAccessFile r : this.dataFiles.values()) {
            try {
                r.close();
            }
            catch (IOException iOException) {}
        }
    }

    public List<EntryStore> getEntries() throws IOException {
        ArrayList<EntryStore> ret = new ArrayList<EntryStore>();
        for (CacheAddr ca : this.table) {
            InputStream is = ca.getInputStream();
            if (is == null) continue;
            EntryStore es = new EntryStore(is, this.rootDir, this.dataFiles, this.externalFilesDir);
            ret.add(es);
        }
        return ret;
    }

    public Index(File file, File externalFilesDir) throws IOException {
        this.externalFilesDir = externalFilesDir;
        try (FileInputStream is = new FileInputStream(file);){
            this.rootDir = file.getParentFile();
            this.header = new IndexHeader(is, this.rootDir, this.dataFiles, externalFilesDir);
            int tsize = 65536;
            if (this.header.table_len > 0) {
                tsize = this.header.table_len;
            }
            this.table = new CacheAddr[tsize];
            for (int i = 0; i < tsize; ++i) {
                this.table[i] = new CacheAddr(is, this.rootDir, this.dataFiles, externalFilesDir);
            }
        }
    }
}

