/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.browsers.cache.chrome;

import com.jpexs.browsers.cache.chrome.IndexInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class HttpResponseInfo {
    public long flags;
    public int version;
    public long request_time;
    public long response_time;
    public long payload_size;
    public List<String> headers;
    public static final int RESPONSE_INFO_VERSION = 3;
    public static final int RESPONSE_INFO_MINIMUM_VERSION = 1;
    public static final int RESPONSE_INFO_VERSION_MASK = 255;
    public static final int RESPONSE_INFO_HAS_CERT = 256;
    public static final int RESPONSE_INFO_HAS_SECURITY_BITS = 512;
    public static final int RESPONSE_INFO_HAS_CERT_STATUS = 1024;
    public static final int RESPONSE_INFO_HAS_VARY_DATA = 2048;
    public static final int RESPONSE_INFO_TRUNCATED = 4096;
    public static final int RESPONSE_INFO_WAS_SPDY = 8192;
    public static final int RESPONSE_INFO_WAS_NPN = 16384;
    public static final int RESPONSE_INFO_WAS_PROXY = 32768;
    public static final int RESPONSE_INFO_HAS_SSL_CONNECTION_STATUS = 65536;
    public static final int RESPONSE_INFO_HAS_NPN_NEGOTIATED_PROTOCOL = 131072;
    public static final int RESPONSE_INFO_HAS_CONNECTION_INFO = 262144;
    public static final int RESPONSE_INFO_USE_HTTP_AUTHENTICATION = 524288;

    public String getHeaderValue(String header) {
        for (String h : this.headers) {
            if (!h.contains(":")) continue;
            String[] keyval = h.split(":");
            String key = keyval[0].trim().toLowerCase(Locale.ENGLISH);
            String val = keyval[1].trim();
            if (!header.toLowerCase(Locale.ENGLISH).equals(key)) continue;
            return val;
        }
        return null;
    }

    public HttpResponseInfo(InputStream is) throws IOException {
        int nulpos;
        IndexInputStream iis = new IndexInputStream(is);
        this.payload_size = iis.readUInt32();
        this.flags = iis.readInt();
        this.version = (int)(this.flags & 0xFFL);
        if (this.version < 1 || this.version > 3) {
            throw new RuntimeException("unexpected response info version: " + this.version);
        }
        this.request_time = iis.readInt64();
        this.response_time = iis.readInt64();
        String headersStr = iis.readString();
        this.headers = new ArrayList<String>();
        while ((nulpos = headersStr.indexOf(0)) > 0) {
            String h = headersStr.substring(0, nulpos);
            headersStr = headersStr.substring(nulpos + 1);
            this.headers.add(h);
        }
    }
}

