/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.tool;

import com.jpexs.graphs.graphviz.dot.parser.DotParseException;
import com.jpexs.graphs.graphviz.dot.parser.DotParser;
import com.jpexs.graphs.graphviz.graph.Graph;
import com.jpexs.graphs.graphviz.graph.operations.StepHandler;
import com.jpexs.graphs.graphviz.graph.operations.StringOperation;
import com.jpexs.graphs.graphviz.graph.operations.TestOperation;
import com.jpexs.graphs.graphviz.graph.operations.codestructure.BasicDecomposedGraphOperation;
import com.jpexs.graphs.graphviz.graph.operations.codestructure.CodeStructureModifyOperation;
import com.jpexs.graphs.graphviz.graph.operations.codestructure.StructuredGraphFacade;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;

public class GraphTool {
    static JPanel imagePanel;
    static JScrollPane imageScrollPane;
    static BufferedImage img;
    static JFrame frame;
    static JSplitPane splitPane;
    static StringOperation op;
    private static String currentScriptName;
    private static final String EXTENSION = ".gv";
    private static final String FILES_PATH = "graphs";
    private static String dotExecutablePath;
    private static SwingWorker worker;
    private static JComboBox<String> scriptCombo;
    private static JEditorPane textArea;
    private static final String NOVY = "<new>";
    private static final String NOVY_TEXT = "digraph {\r\nstart;\r\nstart->end;\r\nend;\r\n}";
    private static final BufferedImage EMPTY_IMAGE;
    private static String SETTINGS_PROP_FILE;
    static StepHandler handlerDoStep;

    private static String makeFileName(String name) {
        return "graphs/" + name + EXTENSION;
    }

    private static synchronized void setGraphImage(BufferedImage newImage) {
        img = newImage;
        Dimension dim = new Dimension(img.getWidth(), img.getHeight());
        imagePanel.setMinimumSize(dim);
        imagePanel.setPreferredSize(dim);
        imagePanel.setSize(dim);
        imagePanel.repaint();
        imagePanel.updateUI();
    }

    private static void sortScriptCombo() {
        String selectedItem = (String)scriptCombo.getSelectedItem();
        scriptCombo.removeItem(NOVY);
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < scriptCombo.getItemCount(); ++i) {
            items.add(scriptCombo.getItemAt(i));
        }
        Collections.sort(items);
        items.add(NOVY);
        scriptCombo.setModel(new DefaultComboBoxModel<String>(items.toArray(new String[items.size()])));
        scriptCombo.setSelectedItem(selectedItem);
    }

    private static String regenerateText(String text) {
        StructuredGraphFacade f = new StructuredGraphFacade();
        return f.recompose(text);
    }

    private static BufferedImage textToImage(String text) throws IOException {
        if (!new File(dotExecutablePath).exists()) {
            throw new IOException("Dot executable not found");
        }
        File outGv = new File("out.gv");
        PrintWriter pw = new PrintWriter(outGv);
        pw.println(text);
        pw.close();
        GraphTool.runCommand("\"" + dotExecutablePath + "\" -Tpng -Nfontname=times-bold -Nfontsize=12 -o out.png out.gv");
        outGv.delete();
        BufferedImage br = ImageIO.read(new File("out.png"));
        return br;
    }

    private static void setOperation(BasicDecomposedGraphOperation op) {
        GraphTool.op = op;
    }

    private static void saveSettings() {
        Properties propOut = new Properties();
        propOut.setProperty("currentScriptName", currentScriptName);
        propOut.setProperty("window.width", "" + frame.getWidth());
        propOut.setProperty("window.height", "" + frame.getHeight());
        propOut.setProperty("window.location.x", "" + GraphTool.frame.getLocation().x);
        propOut.setProperty("window.location.y", "" + GraphTool.frame.getLocation().y);
        propOut.setProperty("window.splitter.location", "" + splitPane.getDividerLocation());
        propOut.setProperty("dotExecutablePath", dotExecutablePath);
        try (FileOutputStream output = new FileOutputStream(SETTINGS_PROP_FILE);){
            propOut.store(output, null);
        }
        catch (IOException ex) {
            System.err.println("Error saving current config");
        }
    }

    private static void loadSettings() {
        Properties propIn = new Properties();
        if (new File(SETTINGS_PROP_FILE).exists()) {
            try (FileInputStream input = new FileInputStream(SETTINGS_PROP_FILE);){
                propIn.load(input);
            }
            catch (IOException ex) {
                Logger.getLogger(GraphTool.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int windowWidth = Integer.parseInt(propIn.getProperty("window.width", "" + frame.getWidth()));
        int windowHeight = Integer.parseInt(propIn.getProperty("window.height", "" + frame.getHeight()));
        frame.setSize(windowWidth, windowHeight);
        int windowLocationX = Integer.parseInt(propIn.getProperty("window.location.x", "" + GraphTool.frame.getLocation().x));
        int windowLocationY = Integer.parseInt(propIn.getProperty("window.location.y", "" + GraphTool.frame.getLocation().y));
        frame.setLocation(windowLocationX, windowLocationY);
        int windowSplitterLocation = Integer.parseInt(propIn.getProperty("window.splitter.location", "" + splitPane.getDividerLocation()));
        splitPane.setDividerLocation(windowSplitterLocation);
        dotExecutablePath = propIn.getProperty("dotExecutablePath", "");
        currentScriptName = propIn.getProperty("currentScriptName", "");
        if (dotExecutablePath.isEmpty() || !new File(dotExecutablePath).exists()) {
            GraphTool.selectDotExecutable();
            GraphTool.saveSettings();
        }
    }

    private static void selectDotExecutable() {
        File directory = new File(dotExecutablePath).getParentFile();
        JFileChooser fc = new JFileChooser(directory);
        fc.setDialogTitle("Select dot executable path (GraphViz)");
        if (fc.showOpenDialog(frame) == 0) {
            dotExecutablePath = fc.getSelectedFile().getAbsolutePath();
        }
    }

    private static void saveCurrent() {
        if (!currentScriptName.isEmpty()) {
            try {
                PrintWriter pw = new PrintWriter(new File(GraphTool.makeFileName(currentScriptName)));
                pw.print(textArea.getText());
                pw.close();
            }
            catch (Exception ex) {
                System.err.println("Error saving script");
            }
        }
        GraphTool.saveSettings();
    }

    public static void main(String[] args) throws IOException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        frame = new JFrame("Graph structure detection");
        imagePanel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                if (img == null) {
                    return;
                }
                g.drawImage(img, 0, 0, null);
            }
        };
        GraphTool.initGui();
        GraphTool.loadSettings();
        GraphTool.setGraphImage(EMPTY_IMAGE);
        String fileName = GraphTool.makeFileName(currentScriptName);
        String text = new File(fileName).exists() ? new String(Files.readAllBytes(Paths.get(fileName, new String[0])), StandardCharsets.UTF_8) : NOVY_TEXT;
        textArea.setText(text);
        try {
            GraphTool.setGraphImage(GraphTool.textToImage(text));
        }
        catch (IOException ex) {
            GraphTool.setGraphImage(EMPTY_IMAGE);
        }
        scriptCombo.setSelectedItem(currentScriptName);
    }

    private static void initGui() {
        int WIN_HEIGHT = 800;
        frame.getContentPane().setLayout(new BorderLayout());
        MouseAdapter ma = new MouseAdapter(){
            private Point origin;

            @Override
            public void mousePressed(MouseEvent e) {
                this.origin = new Point(e.getPoint());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                JViewport viewPort;
                if (this.origin != null && (viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, imagePanel)) != null) {
                    int deltaX = this.origin.x - e.getX();
                    int deltaY = this.origin.y - e.getY();
                    Rectangle view = viewPort.getViewRect();
                    view.x += deltaX;
                    view.y += deltaY;
                    imagePanel.scrollRectToVisible(view);
                }
            }
        };
        imagePanel.addMouseListener(ma);
        imagePanel.addMouseMotionListener(ma);
        imageScrollPane = new JScrollPane(imagePanel);
        imageScrollPane.setPreferredSize(new Dimension(500, WIN_HEIGHT));
        textArea = new JEditorPane("text/plain", "");
        textArea.setContentType("text/plain");
        textArea.setFont(new Font("Courier New", 0, 12));
        Dimension textAreaSize = new Dimension(600, WIN_HEIGHT);
        textArea.setMinimumSize(textAreaSize);
        textArea.setPreferredSize(textAreaSize);
        JButton runInteractiveButton = new JButton("Run interactive");
        runInteractiveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String runText = textArea.getText();
                if (worker != null) {
                    worker.cancel(true);
                }
                worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            GraphTool.setOperation(new CodeStructureModifyOperation());
                            String newText = op.execute(runText, handlerDoStep);
                            try {
                                GraphTool.setGraphImage(GraphTool.textToImage(newText));
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                GraphTool.setGraphImage(EMPTY_IMAGE);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return null;
                    }
                };
                worker.execute();
            }
        });
        JButton runDetectionButton = new JButton("Run detection");
        runDetectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String runText = textArea.getText();
                if (worker != null) {
                    worker.cancel(true);
                }
                worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            GraphTool.setOperation(new CodeStructureModifyOperation());
                            String newText = op.execute(runText, null);
                            try {
                                GraphTool.setGraphImage(GraphTool.textToImage(newText));
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                GraphTool.setGraphImage(EMPTY_IMAGE);
                            }
                            imagePanel.repaint();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return null;
                    }
                };
                worker.execute();
            }
        });
        JButton showButton = new JButton("SHOW");
        showButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    GraphTool.setGraphImage(GraphTool.textToImage(textArea.getText()));
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                    GraphTool.setGraphImage(EMPTY_IMAGE);
                }
                try {
                    DotParser dotParser = new DotParser();
                    Graph graph = dotParser.parse(new StringReader(textArea.getText()));
                }
                catch (DotParseException ex) {
                    Logger.getLogger(GraphTool.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (IOException ex) {
                    Logger.getLogger(GraphTool.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        JButton testButton = new JButton("TEST");
        testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String runText = textArea.getText();
                if (worker != null) {
                    worker.cancel(true);
                }
                worker = new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            GraphTool.setOperation(new TestOperation());
                            String newText = op.execute(runText, handlerDoStep);
                            try {
                                GraphTool.setGraphImage(GraphTool.textToImage(newText));
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                GraphTool.setGraphImage(EMPTY_IMAGE);
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        return null;
                    }
                };
                worker.execute();
            }
        });
        imagePanel.setAlignmentX(0.5f);
        JPanel imagePanelBkg = new JPanel(new GridBagLayout());
        imagePanelBkg.setBackground(Color.white);
        imagePanelBkg.add((Component)imagePanel, new GridBagConstraints());
        JPanel codePanel = new JPanel(new BorderLayout());
        codePanel.add((Component)new JScrollPane(textArea), "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout());
        buttonsPanel.add(showButton);
        buttonsPanel.add(runDetectionButton);
        buttonsPanel.add(runInteractiveButton);
        buttonsPanel.add(testButton);
        codePanel.add((Component)buttonsPanel, "South");
        JPanel selectScriptPanel = new JPanel(new FlowLayout());
        String[] files = new File(FILES_PATH).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(GraphTool.EXTENSION);
            }
        });
        String[] files2 = new String[files.length + 1];
        for (int i = 0; i < files.length; ++i) {
            files2[i] = files[i].substring(0, files[i].length() - EXTENSION.length());
        }
        files2[files2.length - 1] = NOVY;
        files = files2;
        scriptCombo = new JComboBox<String>(files);
        selectScriptPanel.add(scriptCombo);
        JButton renameButton = new JButton("rename");
        JButton deleteButton = new JButton("delete");
        selectScriptPanel.add(renameButton);
        selectScriptPanel.add(deleteButton);
        scriptCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphTool.saveCurrent();
                String newName = (String)scriptCombo.getSelectedItem();
                if (newName.equals(GraphTool.NOVY)) {
                    newName = JOptionPane.showInputDialog("Enter new name: ");
                    if (newName == null) {
                        return;
                    }
                    scriptCombo.addItem(newName);
                    scriptCombo.setSelectedItem(newName);
                    currentScriptName = newName;
                    textArea.setText(GraphTool.NOVY_TEXT);
                    GraphTool.sortScriptCombo();
                    try {
                        GraphTool.setGraphImage(GraphTool.textToImage(textArea.getText()));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        GraphTool.setGraphImage(EMPTY_IMAGE);
                    }
                } else {
                    if (newName.equals(currentScriptName)) {
                        return;
                    }
                    currentScriptName = newName;
                    String fileName = GraphTool.makeFileName(newName);
                    String text = GraphTool.NOVY_TEXT;
                    if (new File(fileName).exists()) {
                        try {
                            text = new String(Files.readAllBytes(Paths.get(fileName, new String[0])), StandardCharsets.UTF_8);
                        }
                        catch (IOException ex) {
                            Logger.getLogger(GraphTool.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    textArea.setText(text);
                    try {
                        GraphTool.setGraphImage(GraphTool.textToImage(text));
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        GraphTool.setGraphImage(EMPTY_IMAGE);
                    }
                    currentScriptName = newName;
                }
            }
        });
        renameButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newName = JOptionPane.showInputDialog("Enter new name: ", (Object)currentScriptName);
                if (newName == null || newName.isEmpty()) {
                    return;
                }
                if (new File(GraphTool.makeFileName(newName)).exists()) {
                    JOptionPane.showMessageDialog(frame, "File " + newName + " already exists", "Error", 0);
                    return;
                }
                String oldFileName = currentScriptName;
                try {
                    PrintWriter pw = new PrintWriter(new File(GraphTool.makeFileName(newName)));
                    pw.print(textArea.getText());
                    pw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(GraphTool.class.getName()).log(Level.SEVERE, null, ex);
                }
                scriptCombo.addItem(newName);
                scriptCombo.setSelectedItem(newName);
                currentScriptName = newName;
                GraphTool.sortScriptCombo();
                scriptCombo.removeItem(oldFileName);
                new File(GraphTool.makeFileName(oldFileName)).delete();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JOptionPane.showConfirmDialog(frame, "Really delete " + currentScriptName + "?", "Delete", 2) == 0) {
                    String oldFileName = currentScriptName;
                    scriptCombo.removeItem(oldFileName);
                    currentScriptName = (String)scriptCombo.getSelectedItem();
                    String fname = GraphTool.makeFileName(oldFileName);
                    if (!new File(fname).delete()) {
                        System.err.println("cannot delete " + fname);
                    }
                }
            }
        });
        codePanel.add((Component)selectScriptPanel, "North");
        splitPane = new JSplitPane(1, new JScrollPane(imagePanelBkg), codePanel);
        frame.getContentPane().add((Component)splitPane, "Center");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GraphTool.saveCurrent();
                System.exit(0);
            }
        });
        frame.setSize(new Dimension(1024, 768));
        frame.setVisible(true);
        splitPane.setDividerLocation(0.3);
    }

    private static void runCommand(String command) throws IOException {
        String s;
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((s = reader.readLine()) != null) {
        }
    }

    static {
        op = null;
        currentScriptName = "in";
        dotExecutablePath = "";
        EMPTY_IMAGE = new BufferedImage(1, 1, 6);
        SETTINGS_PROP_FILE = "settings.properties";
        handlerDoStep = new StepHandler(){

            @Override
            public void step(String currentGraph) {
                try {
                    GraphTool.setGraphImage(GraphTool.textToImage(currentGraph));
                }
                catch (IOException ex) {
                    GraphTool.setGraphImage(EMPTY_IMAGE);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(GraphTool.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        };
    }
}

