/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.graphviz.graph.operations.codestructure;

import com.jpexs.graphs.codestructure.DecisionList;
import com.jpexs.graphs.codestructure.Edge;
import com.jpexs.graphs.codestructure.nodes.EditableEndIfNode;
import com.jpexs.graphs.codestructure.nodes.EditableJoinedNode;
import com.jpexs.graphs.codestructure.nodes.EditableNode;
import com.jpexs.graphs.codestructure.nodes.Node;
import com.jpexs.graphs.codestructure.operations.CodeStructureModifier;
import com.jpexs.graphs.codestructure.operations.CodeStructureModifierProgressListener;
import com.jpexs.graphs.codestructure.operations.DetectedEdgeType;
import com.jpexs.graphs.graphviz.dot.parser.DotId;
import com.jpexs.graphs.graphviz.graph.AttributesMap;
import com.jpexs.graphs.graphviz.graph.Graph;
import com.jpexs.graphs.graphviz.graph.operations.StepHandler;
import com.jpexs.graphs.graphviz.graph.operations.codestructure.BasicDecomposedGraphOperation;
import com.jpexs.graphs.graphviz.graph.operations.codestructure.DecomposedGraph;
import com.jpexs.graphs.graphviz.graph.operations.codestructure.StructuredGraphFacade;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CodeStructureModifyOperation
extends BasicDecomposedGraphOperation {
    private boolean displayDecisionLists = false;

    @Override
    protected void executeOnDecomposedGraph(List<DecomposedGraph> decomposedGraphs, StepHandler stepHandler) {
        for (DecomposedGraph dg : decomposedGraphs) {
            Executor ex = new Executor(decomposedGraphs, stepHandler, dg.nodes, dg.nodeAttributesMap, dg.edgeAttributesMap, dg.edgeCompassesMap);
            ex.execute();
        }
    }

    private void markTrueFalseOrder(EditableNode n, Set<EditableNode> visited, Map<Edge<EditableNode>, AttributesMap> edgeAttributesMap) {
        Edge<EditableNode> edge;
        int i;
        if (visited.contains(n)) {
            return;
        }
        String[] branchLabels = new String[]{"+", "-"};
        if (n instanceof EditableEndIfNode) {
            for (i = 0; i < n.getPrev().size(); ++i) {
                EditableNode editableNode = n.getPrev().get(i);
                edge = new Edge<EditableNode>(editableNode, n);
                if (!edgeAttributesMap.containsKey(edge)) {
                    edgeAttributesMap.put(edge, new AttributesMap());
                }
                edgeAttributesMap.get(edge).put("headlabel", branchLabels[i]);
            }
        }
        visited.add(n);
        if (n.getNext().size() == 2) {
            for (i = 0; i < n.getNext().size(); ++i) {
                EditableNode editableNode = n.getNext().get(i);
                edge = new Edge<EditableNode>(n, editableNode);
                if (!edgeAttributesMap.containsKey(edge)) {
                    edgeAttributesMap.put(edge, new AttributesMap());
                }
                edgeAttributesMap.get(edge).put("taillabel", branchLabels[i]);
            }
        }
        for (EditableNode editableNode : n.getNext()) {
            this.markTrueFalseOrder(editableNode, visited, edgeAttributesMap);
        }
    }

    private void updateDecisionLists(Graph g, Map<Edge<EditableNode>, DecisionList<EditableNode>> decistionLists, Map<Edge<EditableNode>, AttributesMap> edgeAttributesMap) {
        for (Edge<EditableNode> edge : decistionLists.keySet()) {
            if (!edgeAttributesMap.containsKey(edge)) {
                edgeAttributesMap.put(edge, new AttributesMap());
            }
            if (!this.displayDecisionLists) continue;
            edgeAttributesMap.get(edge).put("label", decistionLists.get(edge).isEmpty() ? "(empty)" : decistionLists.get(edge).toString());
            edgeAttributesMap.get(edge).put("fontcolor", "red");
        }
    }

    private class Executor
    implements CodeStructureModifierProgressListener {
        private List<DecomposedGraph> decomposedGraphs;
        private EditableNode startNode;
        private Set<EditableNode> nodes;
        private Map<Node, AttributesMap> nodeAttributesMap;
        private Map<Edge<EditableNode>, AttributesMap> edgeAttributesMap;
        private Map<Edge<EditableNode>, String> edgeCompassesMap;
        private StructuredGraphFacade f = new StructuredGraphFacade();
        private StepHandler stepHandler;
        private Graph currentGraph;

        public Executor(List<DecomposedGraph> decomposedGraphs, StepHandler stepHandler, Set<EditableNode> nodes, Map<Node, AttributesMap> nodeAttributesMap, Map<Edge<EditableNode>, AttributesMap> edgeAttributesMap, Map<Edge<EditableNode>, String> edgeCompassesMap) {
            this.decomposedGraphs = decomposedGraphs;
            this.startNode = nodes.iterator().next();
            this.nodes = nodes;
            this.nodeAttributesMap = nodeAttributesMap;
            this.edgeAttributesMap = edgeAttributesMap;
            this.edgeCompassesMap = edgeCompassesMap;
            this.stepHandler = stepHandler;
            this.regenerate();
        }

        public void execute() {
            CodeStructureModifier mod = new CodeStructureModifier();
            mod.addListener(this);
            CodeStructureModifyOperation.this.markTrueFalseOrder(this.startNode, new LinkedHashSet(), this.edgeAttributesMap);
            this.startNode = mod.execute(this.startNode, new ArrayList<Node>(), new ArrayList<Edge<EditableNode>>(), new ArrayList<Edge<EditableNode>>(), new ArrayList<Edge<EditableNode>>());
        }

        @Override
        public EditableNode endIfDetected(EditableNode decisionNode, List<EditableNode> endBranchNodes, EditableNode afterNode) {
            return afterNode;
        }

        @Override
        public void step() {
            CodeStructureModifyOperation.this.step(this.f.composeGraph(this.decomposedGraphs), this.stepHandler);
            this.regenerate();
        }

        @Override
        public void edgeMarked(Edge<EditableNode> edge, DetectedEdgeType edgeType) {
            String color = "black";
            String label = "";
            boolean alreadyHasColor = this.edgeAttributesMap.containsKey(edge) && this.edgeAttributesMap.get(edge).containsKey("color");
            switch (edgeType) {
                case BACK: {
                    color = "darkorchid1";
                    if (!this.edgeCompassesMap.containsKey(edge)) {
                        this.edgeCompassesMap.put(edge, ":");
                    }
                    String compass = this.edgeCompassesMap.get(edge);
                    String[] compasses = compass.split(":");
                    String newcompass = (((EditableNode)edge.from).getNext().size() > 1 ? "se" : "") + ":ne";
                    if (compasses.length > 0) {
                        newcompass = compasses[0] + ":ne";
                    }
                    this.edgeCompassesMap.put(edge, newcompass);
                    label = "back";
                    break;
                }
                case GOTO: {
                    color = "brown";
                    label = "goto";
                    break;
                }
                case OUTSIDEIF: {
                    if (alreadyHasColor) {
                        return;
                    }
                    int branchIndex = ((EditableNode)edge.from).getNext().indexOf(edge.to);
                    int otherBranchIndex = branchIndex == 0 ? 1 : 0;
                    Edge<EditableNode> otherEdge = new Edge<EditableNode>((EditableNode)edge.from, ((EditableNode)edge.from).getNext().get(otherBranchIndex));
                    this.edgeCompassesMap.put(edge, (branchIndex == 0 ? "sw" : "se") + ":n");
                    this.edgeCompassesMap.put(otherEdge, "s:n");
                    color = "chocolate1";
                    label = "outside";
                }
            }
            CodeStructureModifyOperation.this.markEdge(this.edgeAttributesMap, edge, color, label);
            this.regenerate();
        }

        @Override
        public void nodeSelected(EditableNode node) {
            CodeStructureModifyOperation.this.hilightOneNode(this.nodes, this.nodeAttributesMap, node);
            this.regenerate();
        }

        @Override
        public void updateDecisionLists(Map<Edge<EditableNode>, DecisionList<EditableNode>> decistionLists) {
            CodeStructureModifyOperation.this.updateDecisionLists(this.currentGraph, decistionLists, this.edgeAttributesMap);
            this.regenerate();
        }

        @Override
        public void noNodeSelected() {
            CodeStructureModifyOperation.this.hilightNoNode(this.nodes, this.nodeAttributesMap);
            this.regenerate();
        }

        @Override
        public void endIfAdded(EditableEndIfNode endIfNode) {
            this.nodes.add(endIfNode);
            for (EditableNode editableNode : endIfNode.getPrev()) {
                this.edgeCompassesMap.put(new Edge<EditableEndIfNode>((EditableEndIfNode)editableNode, endIfNode), "s:");
            }
            for (EditableNode editableNode : endIfNode.getNext()) {
                this.edgeCompassesMap.put(new Edge<EditableNode>(endIfNode, editableNode), "s:");
            }
            EditableNode ifNode = endIfNode.getIfNode();
            List<? extends EditableNode> list = ifNode.getNext();
            EditableNode onTrue = list.get(0);
            EditableNode onFalse = list.get(1);
            Edge<EditableNode> onTrueStartEdge = new Edge<EditableNode>(ifNode, onTrue);
            Edge<EditableNode> onFalseStartEdge = new Edge<EditableNode>(ifNode, onFalse);
            this.edgeCompassesMap.put(onTrueStartEdge, "sw:n");
            this.edgeCompassesMap.put(onFalseStartEdge, "se:n");
            if (!this.edgeAttributesMap.containsKey(onTrueStartEdge)) {
                this.edgeAttributesMap.put(onTrueStartEdge, new AttributesMap());
            }
            if (!this.edgeAttributesMap.containsKey(onFalseStartEdge)) {
                this.edgeAttributesMap.put(onFalseStartEdge, new AttributesMap());
            }
            AttributesMap onTrueAttr = this.edgeAttributesMap.get(onTrueStartEdge);
            AttributesMap onFalseAttr = this.edgeAttributesMap.get(onFalseStartEdge);
            if (!onTrueAttr.containsKey("color")) {
                onTrueAttr.put("color", "darkgreen");
            }
            if (!onFalseAttr.containsKey("color")) {
                onFalseAttr.put("color", "red");
            }
            EditableNode onTrueFinish = (EditableNode)endIfNode.getPrev().get(0);
            EditableNode onFalseFinish = (EditableNode)endIfNode.getPrev().get(1);
            Edge<EditableEndIfNode> onTrueFinishEdge = new Edge<EditableEndIfNode>((EditableEndIfNode)onTrueFinish, endIfNode);
            Edge<EditableEndIfNode> onFalseFinishEdge = new Edge<EditableEndIfNode>((EditableEndIfNode)onFalseFinish, endIfNode);
            if (onTrueFinishEdge.equals(onTrueStartEdge)) {
                this.edgeCompassesMap.put(onTrueFinishEdge, "sw:nw");
            } else {
                this.edgeCompassesMap.put(onTrueFinishEdge, "s:nw");
            }
            if (onFalseFinishEdge.equals(onFalseStartEdge)) {
                this.edgeCompassesMap.put(onFalseFinishEdge, "se:ne");
            } else {
                this.edgeCompassesMap.put(onFalseFinishEdge, "s:ne");
            }
            if (!this.edgeAttributesMap.containsKey(onTrueFinishEdge)) {
                this.edgeAttributesMap.put(onTrueFinishEdge, new AttributesMap());
            }
            if (!this.edgeAttributesMap.containsKey(onFalseFinishEdge)) {
                this.edgeAttributesMap.put(onFalseFinishEdge, new AttributesMap());
            }
            CodeStructureModifyOperation.this.markTrueFalseOrder(this.startNode, new LinkedHashSet(), this.edgeAttributesMap);
            this.regenerate();
        }

        private void regenerate() {
            this.currentGraph = CodeStructureModifyOperation.this.composeGraph(this.decomposedGraphs);
        }

        @Override
        public void nodesJoined(EditableJoinedNode node) {
            ArrayList<DotId> labels = new ArrayList<DotId>();
            DotId labelKey = new DotId("label", false);
            for (Node subNode : node.getAllSubNodes()) {
                if (subNode.getId().equals(this.startNode.getId())) {
                    this.startNode = node;
                }
                if (this.nodeAttributesMap.containsKey(subNode)) {
                    AttributesMap attr = this.nodeAttributesMap.get(subNode);
                    if (attr.containsKey(labelKey)) {
                        labels.add(attr.get(labelKey));
                    } else {
                        labels.add(DotId.fromString(subNode.getId()));
                    }
                } else {
                    labels.add(DotId.fromString(subNode.getId()));
                }
                this.nodes.remove((EditableNode)subNode);
            }
            String shape = "box";
            AttributesMap nattr = new AttributesMap();
            if (!labels.isEmpty()) {
                nattr.put(new DotId("label", false), DotId.join((CharSequence)"\\l", labels));
                this.nodeAttributesMap.put(node, nattr);
            }
            if (!shape.isEmpty()) {
                nattr.put("shape", shape);
                this.nodeAttributesMap.put(node, nattr);
            }
            if (node == this.startNode) {
                ArrayList<EditableNode> oldCopy = new ArrayList<EditableNode>(this.nodes);
                this.nodes.clear();
                this.nodes.add(this.startNode);
                this.nodes.addAll(oldCopy);
            } else {
                this.nodes.add(node);
            }
            CodeStructureModifyOperation.this.markTrueFalseOrder(this.startNode, new LinkedHashSet(), this.edgeAttributesMap);
        }
    }
}

