/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.graphviz.graph;

import com.jpexs.graphs.graphviz.dot.parser.DotId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class AttributesMap {
    private Map<DotId, DotId> values = new LinkedHashMap<DotId, DotId>();

    public AttributesMap(AttributesMap source) {
        this.values.putAll(source.values);
    }

    public AttributesMap(Map<String, String> source) {
        for (Map.Entry<String, String> entry : source.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public AttributesMap() {
    }

    public int size() {
        return this.values.size();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean containsKey(DotId key) {
        return this.values.containsKey(key);
    }

    public boolean containsKey(String key) {
        return this.containsKey(new DotId(key, false));
    }

    public boolean containsValue(DotId value) {
        return this.values.containsValue(value);
    }

    public DotId get(DotId key) {
        return this.values.get(key);
    }

    public String get(String key) {
        DotId ret = this.values.get(new DotId(key, false));
        if (ret == null) {
            return null;
        }
        return ret.toString();
    }

    public DotId put(DotId key, DotId value) {
        return this.values.put(key, value);
    }

    public String put(String key, String value) {
        DotId ret = this.values.put(new DotId(key, false), new DotId(value, false));
        if (ret == null) {
            return null;
        }
        return ret.toString();
    }

    public DotId remove(DotId key) {
        return this.values.remove(key);
    }

    public String remove(String key) {
        DotId ret = this.values.remove(new DotId(key, false));
        if (ret == null) {
            return null;
        }
        return ret.toString();
    }

    public void putAll(Map<? extends DotId, ? extends DotId> m) {
        this.values.putAll(m);
    }

    public void putAll(AttributesMap a) {
        this.values.putAll(a.values);
    }

    public void clear() {
        this.values.clear();
    }

    public Set<DotId> keySet() {
        return this.values.keySet();
    }

    public Set<String> stringKeySet() {
        LinkedHashSet<String> ret = new LinkedHashSet<String>();
        for (DotId value : this.values.keySet()) {
            ret.add(value.toString());
        }
        return ret;
    }

    public Collection<DotId> values() {
        return this.values.values();
    }

    public Collection<String> stringValues() {
        ArrayList<String> ret = new ArrayList<String>();
        for (DotId value : this.values.values()) {
            ret.add(value.toString());
        }
        return ret;
    }

    public Set<Map.Entry<DotId, DotId>> entrySet() {
        return this.values.entrySet();
    }

    public Set<Map.Entry<String, String>> stringEntrySet() {
        LinkedHashSet<Map.Entry<String, String>> ret = new LinkedHashSet<Map.Entry<String, String>>();
        for (Map.Entry<DotId, DotId> entry : this.values.entrySet()) {
            final String stringKey = entry.getKey().toString();
            ret.add(new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return stringKey;
                }

                @Override
                public String getValue() {
                    return AttributesMap.this.get(stringKey);
                }

                @Override
                public String setValue(String value) {
                    String oldValue = AttributesMap.this.get(stringKey);
                    AttributesMap.this.put(stringKey, value);
                    return oldValue;
                }
            });
        }
        return ret;
    }

    public AttributesMap clone() {
        return new AttributesMap(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty()) {
            sb.append("[");
            ArrayList<DotId> keys = new ArrayList<DotId>(this.keySet());
            for (int i = 0; i < keys.size(); ++i) {
                DotId key = (DotId)keys.get(i);
                DotId value = this.get(key);
                if (i > 0) {
                    sb.append(" ");
                }
                sb.append(key.toString());
                sb.append("=");
                sb.append(value.toString());
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

