/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.graphviz.dot.parser;

import com.jpexs.graphs.graphviz.dot.parser.DotLexer;
import com.jpexs.graphs.graphviz.dot.parser.DotParseException;
import com.jpexs.graphs.graphviz.dot.parser.DotParsedSymbol;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Pattern;

public final class DotId {
    static final String[] RESERVED_WORDS = new String[]{"node", "edge", "graph", "digraph", "subgraph", "strict"};
    static final Pattern RESERVED_PATTERN = Pattern.compile("^" + String.join((CharSequence)"|", RESERVED_WORDS) + "$", 2);
    static final Pattern NUMERAL_PATTERN = Pattern.compile("^[-]?(.[0-9]+|[0-9]+(.[0-9]*)?)$");
    static final String IDENTIFIER_FIRST_CHARS = "a-zA-Z\\u0200-\\u0377_";
    static final String IDENTIFIER_NEXT_CHARS = "a-zA-Z\\u0200-\\u0377_0-9";
    static final String CH = "^[a-zA-Z\\u0200-\\u0377_][a-zA-Z\\u0200-\\u0377_0-9]*$";
    static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^[a-zA-Z\\u0200-\\u0377_][a-zA-Z\\u0200-\\u0377_0-9]*$");
    static final Pattern HTML_PATTERN = Pattern.compile("^<.+>$");
    private String value;
    private boolean isHtml;
    private String toStringValue;

    public DotId(String value, boolean isHtml) {
        this.value = value;
        this.isHtml = isHtml;
        this.toStringValue = this.generateToString();
    }

    public static DotId fromString(String id) {
        DotLexer lex = new DotLexer(new StringReader(id));
        try {
            DotParsedSymbol symbol = lex.lex();
            if (symbol.type != 17) {
                return null;
            }
            boolean isHtml = false;
            if (symbol.idtype == 4) {
                isHtml = true;
            }
            DotParsedSymbol next = lex.lex();
            if (next.type != 18) {
                throw new RuntimeException("Invalid id: " + id);
            }
            return new DotId(symbol.getValueAsString(), isHtml);
        }
        catch (DotParseException | IOException ex) {
            throw new RuntimeException("Invalid id: " + id);
        }
    }

    public String toString() {
        return this.toStringValue;
    }

    private String generateToString() {
        if (this.isHtml) {
            return "<" + this.value + ">";
        }
        if (RESERVED_PATTERN.matcher(this.value).matches()) {
            return "\"" + this.value + "\"";
        }
        if (NUMERAL_PATTERN.matcher(this.value).matches()) {
            return this.value;
        }
        if (IDENTIFIER_PATTERN.matcher(this.value).matches()) {
            return this.value;
        }
        return "\"" + this.value.replace("\"", "\\\"") + "\"";
    }

    public int hashCode() {
        int hash = 5;
        hash = 89 * hash + Objects.hashCode(this.value);
        hash = 89 * hash + (this.isHtml ? 1 : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DotId other = (DotId)obj;
        if (this.isHtml != other.isHtml) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }

    public static DotId join(CharSequence delimiter, DotId ... ids) {
        return DotId.join(new DotId(delimiter.toString(), false), ids);
    }

    public static DotId join(DotId delimiter, DotId ... ids) {
        return DotId.join(delimiter, Arrays.asList(ids));
    }

    public static DotId join(CharSequence delimiter, Iterable<? extends DotId> ids) {
        return DotId.join(new DotId(delimiter.toString(), false), ids);
    }

    public static DotId join(DotId delimiter, Iterable<? extends DotId> ids) {
        StringBuilder sb = new StringBuilder();
        boolean retHtml = false;
        for (DotId dotId : ids) {
            if (!dotId.isHtml) continue;
            retHtml = true;
        }
        DotId usedDelimiter = delimiter;
        if (retHtml) {
            usedDelimiter = usedDelimiter.toHtmlDotId();
        }
        boolean bl = true;
        for (DotId dotId : ids) {
            boolean bl2;
            if (!bl2) {
                sb.append(usedDelimiter.value);
            }
            bl2 = false;
            DotId idToAppend = dotId;
            if (retHtml) {
                idToAppend = idToAppend.stripEndNewLine().toHtmlDotId();
            }
            sb.append(idToAppend.value);
        }
        return new DotId(sb.toString(), retHtml);
    }

    private DotId stripEndNewLine() {
        if (this.isHtml) {
            return this;
        }
        return new DotId(this.value.replaceFirst("\\\\(r|n|l)$", ""), false);
    }

    private DotId toHtmlDotId() {
        if (this.isHtml) {
            return this;
        }
        String htmlValue = this.value.replaceAll("\\\\(r|n|l)", "<BR/>");
        return new DotId(htmlValue, true);
    }
}

