/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.codestructure.operations;

import com.jpexs.graphs.codestructure.factories.BasicEditableEndIfFactory;
import com.jpexs.graphs.codestructure.factories.EditableEndIfFactory;
import com.jpexs.graphs.codestructure.nodes.EditableEndIfNode;
import com.jpexs.graphs.codestructure.nodes.EditableNode;
import com.jpexs.graphs.codestructure.nodes.Node;
import com.jpexs.graphs.codestructure.operations.EnfIfNodeInjectorProgressListener;
import java.util.ArrayList;
import java.util.List;

public class EndIfNodeInjector<N extends EditableNode> {
    private EditableEndIfFactory<EditableNode> endIfFactory = new BasicEditableEndIfFactory();
    private List<EnfIfNodeInjectorProgressListener> listeners = new ArrayList<EnfIfNodeInjectorProgressListener>();

    public void setEndIfFactory(EditableEndIfFactory<EditableNode> endIfFactory) {
        this.endIfFactory = endIfFactory;
    }

    public EditableEndIfNode injectEndIf(N decisionNode, List<N> endBranchNodes, N afterNode) {
        int i;
        int afterNodePrevIndex = Integer.MAX_VALUE;
        for (Node prev : endBranchNodes) {
            int index = afterNode.getPrev().indexOf(prev);
            if (index >= afterNodePrevIndex) continue;
            afterNodePrevIndex = index;
        }
        EditableEndIfNode endIfNode = this.endIfFactory.makeEndIfNode((EditableNode)decisionNode);
        for (i = 0; i < endBranchNodes.size(); ++i) {
            EditableNode prev = (EditableNode)endBranchNodes.get(i);
            endIfNode.addPrev(prev);
        }
        for (i = 0; i < endBranchNodes.size(); ++i) {
            EditableNode endBranchNode = (EditableNode)endBranchNodes.get(i);
            endBranchNode.setNext(endBranchNode.getNext().indexOf(afterNode), endIfNode);
        }
        for (i = 0; i < endBranchNodes.size(); ++i) {
            EditableNode endBranchNode = (EditableNode)endBranchNodes.get(i);
            afterNode.removePrev(endBranchNode);
        }
        endIfNode.addNext((EditableNode)afterNode);
        afterNode.addPrev(afterNodePrevIndex, endIfNode);
        this.fireEndIfAdded(endIfNode);
        return endIfNode;
    }

    public void addListener(EnfIfNodeInjectorProgressListener l) {
        this.listeners.add(l);
    }

    public void removeListener(EnfIfNodeInjectorProgressListener l) {
        this.listeners.remove(l);
    }

    private void fireEndIfAdded(EditableEndIfNode node) {
        for (EnfIfNodeInjectorProgressListener l : this.listeners) {
            l.endIfAdded(node);
        }
    }
}

