/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.codestructure.operations;

import com.jpexs.graphs.codestructure.Decision;
import com.jpexs.graphs.codestructure.DecisionList;
import com.jpexs.graphs.codestructure.Edge;
import com.jpexs.graphs.codestructure.nodes.Node;
import com.jpexs.graphs.codestructure.operations.CodeStructureDetectorProgressListener;
import com.jpexs.graphs.codestructure.operations.DetectedEdgeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class CodeStructureDetector<N extends Node> {
    private List<N> todoList = new ArrayList<N>();
    private List<Node> alreadyProcessed = new ArrayList<Node>();
    private Map<Edge<N>, DecisionList<N>> decistionLists = new HashMap<Edge<N>, DecisionList<N>>();
    private List<N> rememberedDecisionNodes = new ArrayList<N>();
    private List<N> waiting = new ArrayList<N>();
    private List<Node> loopContinues = new ArrayList<Node>();
    private List<Edge<N>> backEdges = new ArrayList<Edge<N>>();
    private List<Edge<N>> gotoEdges = new ArrayList<Edge<N>>();
    private List<Edge<N>> exitIfEdges = new ArrayList<Edge<N>>();
    private Set<Edge<N>> ignoredEdges = new LinkedHashSet<Edge<N>>();
    private List<CodeStructureDetectorProgressListener<N>> listeners = new ArrayList<CodeStructureDetectorProgressListener<N>>();

    public Node detect(N head, List<Node> loopContinues, List<Edge<N>> gotoEdges, List<Edge<N>> backEdges, List<Edge<N>> exitIfEdges) {
        LinkedHashSet<N> heads = new LinkedHashSet<N>();
        heads.add(head);
        Collection multiHeads = this.detect((Collection<N>)heads, loopContinues, gotoEdges, backEdges, exitIfEdges);
        return multiHeads.toArray(new Node[1])[0];
    }

    public Collection<N> detect(Collection<N> heads, List<Node> loopContinues, List<Edge<N>> gotoEdges, List<Edge<N>> backEdges, List<Edge<N>> exitIfEdges) {
        this.todoList.addAll(heads);
        this.walk();
        loopContinues.addAll(this.loopContinues);
        gotoEdges.addAll(this.gotoEdges);
        backEdges.addAll(this.backEdges);
        exitIfEdges.addAll(this.exitIfEdges);
        return heads;
    }

    private boolean walk() {
        this.walkDecisionLists();
        this.fireNoNodeSelected();
        for (int i = 0; i < this.waiting.size(); ++i) {
            LinkedHashSet<Node> visited;
            LinkedHashSet<Edge<N>> loopContinueEdges;
            LinkedHashSet<Edge<N>> loopExitEdges;
            LinkedHashSet<Node> insideLoopNodes;
            Node cek = (Node)this.waiting.get(i);
            if (!this.leadsTo(cek, cek, insideLoopNodes = new LinkedHashSet<Node>(), loopExitEdges = new LinkedHashSet<Edge<N>>(), loopContinueEdges = new LinkedHashSet<Edge<N>>(), visited = new LinkedHashSet<Node>())) continue;
            Node continueNode = cek;
            for (Edge edge : loopContinueEdges) {
                this.fireEdgeMarked(edge, DetectedEdgeType.BACK);
            }
            LinkedHashSet<Object> currentWaiting = new LinkedHashSet<Object>();
            currentWaiting.addAll(this.waiting);
            currentWaiting.remove(continueNode);
            this.loopContinues.add(continueNode);
            this.backEdges.addAll(loopContinueEdges);
            LinkedHashSet<Edge<Node>> linkedHashSet = new LinkedHashSet<Edge<Node>>();
            for (Node node : currentWaiting) {
                for (Node pc : this.getPrevNodes(node)) {
                    linkedHashSet.add(new Edge<Node>(pc, node));
                }
            }
            this.ignoredEdges.addAll(loopContinueEdges);
            for (Node node : this.getNextNodes(continueNode)) {
                if (insideLoopNodes.contains(node)) continue;
                linkedHashSet.add(new Edge<Node>(continueNode, node));
                currentWaiting.add(node);
            }
            this.ignoredEdges.addAll(linkedHashSet);
            this.waiting.clear();
            this.todoList.add(continueNode);
            this.walk();
            this.ignoredEdges.removeAll(linkedHashSet);
            this.alreadyProcessed.removeAll(currentWaiting);
            DecisionList<Node> loopDecisionList = this.calculateDecisionListFromPrevNodes(continueNode, this.getPrevNodes(continueNode)).lockForChanges();
            for (Edge edge : linkedHashSet) {
                if (!this.alreadyProcessed.contains(edge.from) || this.decistionLists.containsKey(edge)) continue;
                this.decistionLists.put(edge, loopDecisionList);
            }
            if (currentWaiting.isEmpty()) {
                return true;
            }
            this.todoList.addAll(currentWaiting);
            this.walk();
            return true;
        }
        return false;
    }

    private boolean leadsTo(N nodeSearchIn, N nodeSearchWhich, Set<Node> insideLoopNodes, Set<Edge<N>> noLeadEdges, Set<Edge<N>> foundEdges, Set<Node> visited) {
        if (visited.contains(nodeSearchIn)) {
            return insideLoopNodes.contains(nodeSearchIn);
        }
        visited.add((Node)nodeSearchIn);
        Iterator<N> iterator = this.getNextNodes(nodeSearchIn).iterator();
        while (iterator.hasNext()) {
            Node next;
            Node nextT = next = (Node)iterator.next();
            if (!next.equals(nodeSearchWhich)) continue;
            foundEdges.add(new Edge<Node>((Node)nodeSearchIn, nextT));
            return true;
        }
        boolean ret = false;
        LinkedHashSet<Edge<N>> currentNoLeadNodes = new LinkedHashSet<Edge<N>>();
        for (Node next : this.getNextNodes(nodeSearchIn)) {
            if (this.leadsTo(next, nodeSearchWhich, insideLoopNodes, currentNoLeadNodes, foundEdges, visited)) {
                insideLoopNodes.add(next);
                ret = true;
                continue;
            }
            currentNoLeadNodes.add(new Edge<Node>((Node)nodeSearchIn, next));
        }
        if (ret) {
            noLeadEdges.addAll(currentNoLeadNodes);
        }
        return ret;
    }

    private boolean removeExitPointFromPrevDlists(N prevNode, N node, N exitPoint, Set<N> processedNodes) {
        boolean lastOne = false;
        if (processedNodes.contains(node)) {
            return false;
        }
        processedNodes.add(node);
        if (exitPoint.equals(prevNode)) {
            int insideIfBranchIndex = prevNode.getNext().indexOf(node);
            for (int branchIndex = 0; branchIndex < exitPoint.getNext().size(); ++branchIndex) {
                if (branchIndex == insideIfBranchIndex) continue;
                Node branchNodeT = exitPoint.getNext().get(branchIndex);
                Edge<Node> edge = new Edge<Node>((Node)exitPoint, branchNodeT);
                this.exitIfEdges.add(edge);
                this.fireEdgeMarked(edge, DetectedEdgeType.OUTSIDEIF);
            }
            return true;
        }
        Edge<N> edge = new Edge<N>(prevNode, node);
        DecisionList<N> decisionList = this.decistionLists.get(edge);
        if (decisionList != null && !decisionList.isEmpty() && ((Decision)decisionList.get(decisionList.size() - 1)).getIfNode().equals(exitPoint)) {
            DecisionList truncDecisionList = new DecisionList();
            truncDecisionList.addAll(decisionList);
            truncDecisionList.remove(truncDecisionList.size() - 1);
            this.decistionLists.put(edge, truncDecisionList);
        }
        if (!lastOne) {
            for (Node node2 : prevNode.getPrev()) {
                Node prevT;
                if (this.loopContinues.contains(node2) || !this.removeExitPointFromPrevDlists(prevT = node2, prevNode, exitPoint, processedNodes)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private DecisionList<N> calculateDecisionListFromPrevNodes(N BOD, List<N> prevNodes) {
        prevDecisionLists = new ArrayList<DecisionList<T>>();
        decisionListNodes = new ArrayList<N>(prevNodes);
        for (Node prevNode : prevNodes) {
            edge = new Edge<Node>(prevNode, (Node)BOD);
            prevDL = this.decistionLists.get(edge);
            if (prevDL == null) {
                System.err.println("WARNING - no decisionList for edge " + edge);
            }
            prevDecisionLists.add(prevDL);
        }
        if (prevDecisionLists.isEmpty()) {
            nextDecisionList = new DecisionList<T>();
        } else if (prevDecisionLists.size() == 1) {
            nextDecisionList = new DecisionList<T>((Collection)prevDecisionLists.get(0));
        } else {
            for (i = prevDecisionLists.size() - 1; i >= 0; --i) {
                if (!((DecisionList)prevDecisionLists.get(i)).containsOneOfNodes(this.rememberedDecisionNodes)) continue;
                gotoEdge = new Edge<Node>((Node)prevNodes.get(i), (Node)BOD);
                this.gotoEdges.add(gotoEdge);
                this.fireEdgeMarked(gotoEdge, DetectedEdgeType.GOTO);
                prevDecisionLists.remove(i);
            }
            while (true) lbl-1000:
            // 5 sources

            {
                for (i = 0; i < prevDecisionLists.size(); ++i) {
                    decisionListI = (DecisionList)prevDecisionLists.get(i);
                    sameIndices = new TreeSet<Integer>(new Comparator<Integer>(){

                        @Override
                        public int compare(Integer o1, Integer o2) {
                            return o2 - o1;
                        }
                    });
                    sameIndices.add(i);
                    if (decisionListI.isEmpty()) continue;
                    for (j = 0; j < prevDecisionLists.size(); ++j) {
                        if (i == j || !(decisionListJ = (DecisionList)prevDecisionLists.get(j)).ifNodesEquals(decisionListI)) continue;
                        sameIndices.add(j);
                    }
                    numSame = sameIndices.size();
                    if (numSame <= 1 || numSame != (numBranches = this.getNextNodes(decisionNode = ((Decision)decisionListI.get(decisionListI.size() - 1)).getIfNode()).size())) continue;
                    shorterDecisionList = new DecisionList<T>(decisionListI);
                    shorterDecisionList.remove(shorterDecisionList.size() - 1);
                    endBranchNodes = new ArrayList<Node>();
                    var14_36 = sameIndices.iterator();
                    while (var14_36.hasNext()) {
                        index = (Integer)var14_36.next();
                        decision = (Decision)((DecisionList)prevDecisionLists.get(index)).get(decisionListI.size() - 1);
                        branchNum = decision.getBranchNum();
                        prevDecisionLists.remove(index);
                        prev = (Node)decisionListNodes.remove(index);
                        if (branchNum == 0) {
                            endBranchNodes.add(0, prev);
                            continue;
                        }
                        endBranchNodes.add(prev);
                    }
                    this.fireNoNodeSelected();
                    endIfNode = this.fireEndIfDetected(decisionNode, endBranchNodes, BOD);
                    this.alreadyProcessed.add((Node)endIfNode);
                    decisionListNodes.add(endIfNode);
                    prevDecisionLists.add(shorterDecisionList);
                    this.decistionLists.put(new Edge<T>(endIfNode, BOD), shorterDecisionList);
                    this.fireUpdateDecisionLists(this.decistionLists);
                    this.fireStep();
                }
                maxDecListSize = 0;
                for (i = 0; i < prevDecisionLists.size(); ++i) {
                    size = ((DecisionList)prevDecisionLists.get(i)).size();
                    if (size <= maxDecListSize) continue;
                    maxDecListSize = size;
                }
                for (findSize = maxDecListSize; findSize > 1; --findSize) {
                    for (j = 0; j < prevDecisionLists.size(); ++j) {
                        decisionListJ = (DecisionList)prevDecisionLists.get(j);
                        if (decisionListJ.size() != findSize) continue;
                        for (k = 0; k < prevDecisionLists.size(); ++k) {
                            if (j == k || (decisionListK = (DecisionList)prevDecisionLists.get(k)).size() != findSize - 1) continue;
                            decisionListJKratsi = new DecisionList<T>();
                            decisionListJKratsi.addAll(decisionListJ);
                            decisionListJKratsi.remove(decisionListJKratsi.size() - 1);
                            if (!decisionListJKratsi.ifNodesEquals(decisionListK)) continue;
                            prevDecisionLists.set(j, decisionListJKratsi.lockForChanges());
                            this.decistionLists.put(new Edge<Node>((Node)decisionListNodes.get(j), (Node)BOD), decisionListJKratsi);
                            decisionK = (Decision)decisionListK.get(decisionListK.size() - 1);
                            decisionJ = (Decision)decisionListJ.get(decisionListJKratsi.size() - 1);
                            this.rememberedDecisionNodes.add(decisionK.getIfNode());
                            decisionNode = decisionK.getIfNode();
                            exitDecision = (Decision)decisionListJ.get(decisionListJ.size() - 1);
                            exitNode = exitDecision.getIfNode();
                            endBranchNodes = new ArrayList<Node>();
                            higherIndex = j > k ? j : k;
                            lowerIndex = j < k ? j : k;
                            longerPrev = (Node)decisionListNodes.get(j);
                            prevDecisionLists.remove(higherIndex);
                            prevDecisionLists.remove(lowerIndex);
                            prevNodeK = (Node)decisionListNodes.get(k);
                            prevNodeJ = (Node)decisionListNodes.get(j);
                            decisionListNodes.remove(higherIndex);
                            decisionListNodes.remove(lowerIndex);
                            endBranchNodes.add(decisionJ.getBranchNum() == 0 ? prevNodeJ : prevNodeK);
                            endBranchNodes.add(decisionK.getBranchNum() == 1 ? prevNodeK : prevNodeJ);
                            this.fireNoNodeSelected();
                            shorterDecisionList = new DecisionList<T>(decisionListK);
                            shorterDecisionList.remove(shorterDecisionList.size() - 1);
                            endIfNode = this.fireEndIfDetected(decisionNode, endBranchNodes, BOD);
                            this.alreadyProcessed.add((Node)endIfNode);
                            decisionListNodes.add(endIfNode);
                            prevDecisionLists.add(shorterDecisionList);
                            this.decistionLists.put(new Edge<T>(endIfNode, BOD), shorterDecisionList);
                            this.fireUpdateDecisionLists(this.decistionLists);
                            this.fireStep();
                            this.removeExitPointFromPrevDlists(longerPrev, endIfNode, exitNode, new LinkedHashSet<E>());
                            this.fireUpdateDecisionLists(this.decistionLists);
                            this.fireStep();
                            ** continue;
                        }
                    }
                }
                break;
            }
            if (prevDecisionLists.isEmpty()) {
                nextDecisionList = new DecisionList<T>();
            } else if (prevDecisionLists.size() == 1) {
                nextDecisionList = new DecisionList<T>((Collection)prevDecisionLists.get(0));
            } else {
                prefix = new DecisionList<T>();
                numInPrefix = 0;
                block10: while (true) {
                    nextDecision = null;
                    for (DecisionList decisionList : prevDecisionLists) {
                        if (decisionList.size() == numInPrefix) break block10;
                        currentDecision = (Decision)decisionList.get(numInPrefix);
                        if (nextDecision == null) {
                            nextDecision = currentDecision;
                        }
                        if (currentDecision.getIfNode().equals(nextDecision.getIfNode())) continue;
                        break block10;
                    }
                    prefix.add(nextDecision);
                    ++numInPrefix;
                }
                for (i = 0; i < prevDecisionLists.size(); ++i) {
                    decisionList = (DecisionList)prevDecisionLists.get(i);
                    if (decisionList.size() <= prefix.size()) continue;
                    for (j = decisionList.size() - 1; j >= prefix.size(); --j) {
                        exitDecision = (Decision)decisionList.get(j);
                        exitNode = exitDecision.getIfNode();
                        this.removeExitPointFromPrevDlists((Node)decisionListNodes.get(i), BOD, exitNode, new LinkedHashSet<E>());
                    }
                }
                nextBod = BOD;
                if (!prefix.isEmpty()) {
                    endBranchNodes = new ArrayList<Node>();
                    decisionNode = null;
                    for (i = 0; i < prevDecisionLists.size(); ++i) {
                        decision = (Decision)((DecisionList)prevDecisionLists.get(i)).get(prefix.size() - 1);
                        decisionNode = (N)decision.getIfNode();
                        branchNum = decision.getBranchNum();
                        prev = (Node)decisionListNodes.get(i);
                        if (branchNum == 0) {
                            endBranchNodes.add(0, prev);
                            continue;
                        }
                        endBranchNodes.add(prev);
                    }
                    endIfNode = this.fireEndIfDetected(decisionNode, endBranchNodes, BOD);
                    this.alreadyProcessed.add((Node)endIfNode);
                    nextBod = endIfNode;
                }
                var10_26 = decisionListNodes.iterator();
                while (var10_26.hasNext()) {
                    prevT = prev = (Node)var10_26.next();
                    this.decistionLists.put(new Edge<Node>(prevT, (Node)nextBod), prefix);
                }
                this.fireStep();
                nextDecisionList = prefix;
            }
        }
        return nextDecisionList;
    }

    private List<N> getPrevNodes(N sourceNode) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node node : sourceNode.getPrev()) {
            Node prevT = node;
            if (this.ignoredEdges.contains(new Edge<Node>(prevT, (Node)sourceNode))) continue;
            ret.add(prevT);
        }
        return ret;
    }

    private List<N> getNextNodes(N sourceNode) {
        ArrayList<Node> ret = new ArrayList<Node>();
        for (Node node : sourceNode.getNext()) {
            Node nextT = node;
            if (this.ignoredEdges.contains(new Edge<Node>((Node)sourceNode, nextT))) continue;
            ret.add(nextT);
        }
        return ret;
    }

    private void walkDecisionLists() {
        do {
            Node currentPoint;
            if (this.alreadyProcessed.contains(currentPoint = (Node)this.todoList.remove(0))) continue;
            List<Node> prevNodes = this.getPrevNodes(currentPoint);
            boolean vsechnyPrevZpracovane = true;
            for (Node prevNode : prevNodes) {
                if (this.alreadyProcessed.contains(prevNode)) continue;
                vsechnyPrevZpracovane = false;
                break;
            }
            if (!vsechnyPrevZpracovane) {
                if (this.waiting.contains(currentPoint)) continue;
                this.waiting.add(currentPoint);
                continue;
            }
            this.waiting.remove(currentPoint);
            DecisionList<Node> mergedDecisionList = this.calculateDecisionListFromPrevNodes(currentPoint, prevNodes);
            this.alreadyProcessed.add(currentPoint);
            List<Node> nextNodes = this.getNextNodes(currentPoint);
            for (int branch = 0; branch < nextNodes.size(); ++branch) {
                Node next = nextNodes.get(branch);
                Edge<Node> edge = new Edge<Node>(currentPoint, next);
                DecisionList nextDecisionList = new DecisionList(mergedDecisionList);
                if (nextNodes.size() > 1) {
                    nextDecisionList.add(new Decision<Node>(currentPoint, branch));
                }
                this.decistionLists.put(edge, nextDecisionList.lockForChanges());
                this.todoList.add(next);
            }
            this.fireNodeSelected(currentPoint);
            this.fireUpdateDecisionLists(this.decistionLists);
            this.fireStep();
        } while (!this.todoList.isEmpty());
    }

    public void addListener(CodeStructureDetectorProgressListener<N> l) {
        this.listeners.add(l);
    }

    public void removeListener(CodeStructureDetectorProgressListener<N> l) {
        this.listeners.remove(l);
    }

    private N fireEndIfDetected(N decisionNode, List<N> endBranchNodes, N node) {
        ArrayList<Edge<Node>> beforeEdges = new ArrayList<Edge<Node>>();
        for (Node node2 : endBranchNodes) {
            beforeEdges.add(new Edge<Node>(node2, (Node)node));
        }
        for (CodeStructureDetectorProgressListener codeStructureDetectorProgressListener : this.listeners) {
            node = codeStructureDetectorProgressListener.endIfDetected(decisionNode, endBranchNodes, node);
        }
        for (int m = 0; m < node.getPrev().size(); ++m) {
            Node node3 = node.getPrev().get(m);
            this.decistionLists.put(new Edge<Node>(node3, (Node)node), this.decistionLists.get(beforeEdges.get(m)));
        }
        return node;
    }

    private void fireStep() {
        for (CodeStructureDetectorProgressListener<N> l : this.listeners) {
            l.step();
        }
    }

    private void fireEdgeMarked(Edge<N> edge, DetectedEdgeType edgeType) {
        for (CodeStructureDetectorProgressListener<N> l : this.listeners) {
            l.edgeMarked(edge, edgeType);
        }
    }

    private void fireNodeSelected(N node) {
        for (CodeStructureDetectorProgressListener<N> l : this.listeners) {
            l.nodeSelected(node);
        }
    }

    private void fireUpdateDecisionLists(Map<Edge<N>, DecisionList<N>> decistionLists) {
        for (CodeStructureDetectorProgressListener<N> l : this.listeners) {
            l.updateDecisionLists(decistionLists);
        }
    }

    private void fireNoNodeSelected() {
        for (CodeStructureDetectorProgressListener<N> l : this.listeners) {
            l.noNodeSelected();
        }
    }
}

