/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.graphs.codestructure;

import com.jpexs.graphs.codestructure.nodes.EditableNode;
import com.jpexs.graphs.codestructure.nodes.Node;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class BasicEditableNode
implements EditableNode {
    private String id;
    private List<EditableNode> nextNodes = new ArrayList<EditableNode>();
    private List<EditableNode> prevNodes = new ArrayList<EditableNode>();

    public BasicEditableNode(String id) {
        this.id = id;
    }

    public String toString() {
        return "\"" + this.id + "\"";
    }

    @Override
    public void addNext(EditableNode node) {
        this.nextNodes.add(node);
    }

    @Override
    public void addPrev(EditableNode node) {
        this.prevNodes.add(node);
    }

    @Override
    public List<? extends EditableNode> getNext() {
        return new ArrayList<EditableNode>(this.nextNodes);
    }

    @Override
    public List<? extends EditableNode> getPrev() {
        return new ArrayList<EditableNode>(this.prevNodes);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BasicEditableNode other = (BasicEditableNode)obj;
        return Objects.equals(this.id, other.id);
    }

    @Override
    public void removePrev(EditableNode node) {
        this.prevNodes.remove(node);
    }

    @Override
    public void removeNext(EditableNode node) {
        this.nextNodes.remove(node);
    }

    @Override
    public int compareTo(Node o) {
        return this.getId().compareTo(o.getId());
    }

    @Override
    public void setPrev(int index, EditableNode node) {
        this.prevNodes.set(index, node);
    }

    @Override
    public void setNext(int index, EditableNode node) {
        this.nextNodes.set(index, node);
    }

    @Override
    public void addNext(int index, EditableNode node) {
        this.nextNodes.add(index, node);
    }

    @Override
    public void addPrev(int index, EditableNode node) {
        this.prevNodes.add(index, node);
    }
}

