/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.io.File;
import java.io.IOException;

public class Path {
    public static String combine(String ... paths) {
        String result = "";
        String separator = File.separator;
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (i > 0) {
                if (path.startsWith(separator)) {
                    path = path.substring(separator.length());
                }
                if (!result.endsWith(separator)) {
                    result = result + separator;
                }
            }
            result = result + path;
        }
        return result;
    }

    public static String getExtension(String fileName) {
        return Path.getExtension(new File(fileName));
    }

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i).toLowerCase();
        }
        return ext;
    }

    public static String getFileNameWithoutExtension(File f) {
        String fileName = f.getName();
        int i = fileName.lastIndexOf(46);
        if (i > 0 && i < fileName.length() - 1) {
            fileName = fileName.substring(0, i);
        }
        return fileName;
    }

    public static void createDirectorySafe(File directory) throws IOException {
        if (!(directory.exists() || directory.mkdirs() || directory.exists())) {
            throw new IOException("Cannot create directory " + directory);
        }
    }
}

