/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.helpers;

import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends InputStream {
    private final InputStream is;
    private long pos = 0L;
    private final long limit;

    public LimitedInputStream(InputStream is, long limit) {
        this.is = is;
        this.limit = limit;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.limit) {
            return -1;
        }
        ++this.pos;
        return this.is.read();
    }

    @Override
    public int available() throws IOException {
        int avail = this.is.available();
        if (this.pos + (long)avail > this.limit) {
            avail = (int)(this.limit - this.pos);
        }
        return avail;
    }
}

