/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.precontinues;

import com.jpexs.decompiler.graph.GraphPart;
import java.util.ArrayList;
import java.util.List;

public class Node {
    public List<Node> next = new ArrayList<Node>();
    public List<Node> prev = new ArrayList<Node>();
    public GraphPart graphPart;
    private static int CURRENT_ID = 0;
    private int id = ++CURRENT_ID;
    public Node parentNode;

    public int getId() {
        return this.id;
    }

    public String toString() {
        return "node" + this.id + ":" + (this.graphPart == null ? "null" : this.graphPart.toString());
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + this.id;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        return this.id == other.id;
    }

    public void replacePrevs(Node newNode) {
        for (Node p : this.prev) {
            for (int i = 0; i < p.next.size(); ++i) {
                if (p.next.get(i) != this) continue;
                p.next.set(i, newNode);
            }
        }
    }

    public void replaceNexts(Node newNode) {
        for (Node n : this.next) {
            for (int i = 0; i < n.prev.size(); ++i) {
                if (n.prev.get(i) != this) continue;
                n.prev.set(i, newNode);
            }
        }
    }

    public void removeFromGraph() {
        int i;
        for (Node p : this.prev) {
            for (i = p.next.size() - 1; i >= 0; --i) {
                if (p.next.get(i) != this) continue;
                p.next.remove(i);
            }
        }
        for (Node n : this.next) {
            for (i = n.prev.size() - 1; i >= 0; --i) {
                if (n.prev.get(i) != this) continue;
                n.prev.remove(i);
            }
        }
        this.next.clear();
        this.prev.clear();
    }
}

