/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.LoopWithType;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.DefaultItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.LoopItem;
import java.util.ArrayList;
import java.util.List;

public class SwitchItem
extends LoopItem
implements Block {
    public GraphTargetItem switchedObject;
    public List<GraphTargetItem> caseValues;
    public List<List<GraphTargetItem>> caseCommands;
    public List<Integer> valuesMapping;
    private boolean labelUsed;

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        ret.addAll(this.caseCommands);
        return ret;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.switchedObject);
        visitor.visitAll(this.caseValues);
        for (List<GraphTargetItem> c : this.caseCommands) {
            visitor.visitAll(c);
        }
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.switchedObject);
        visitor.visitAll(this.caseValues);
    }

    public SwitchItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, Loop loop, GraphTargetItem switchedObject, List<GraphTargetItem> caseValues, List<List<GraphTargetItem>> caseCommands, List<Integer> valuesMapping) {
        super(instruction, lineStartIns, loop);
        this.switchedObject = switchedObject;
        this.caseValues = caseValues;
        this.caseCommands = caseCommands;
        this.valuesMapping = valuesMapping;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (writer instanceof NulWriter) {
            ((NulWriter)writer).startLoop(this.loop.id, LoopWithType.LOOP_TYPE_SWITCH);
        }
        if (this.labelUsed) {
            writer.append("loop").append(this.loop.id).append(":").newLine();
        }
        writer.append("switch");
        if (writer.getFormatting().spaceBeforeParenthesesSwitchParentheses) {
            writer.append(" ");
        }
        writer.append("(");
        this.switchedObject.toString(writer, localData);
        writer.append(")").startBlock();
        for (int i = 0; i < this.caseCommands.size(); ++i) {
            if (i == this.caseCommands.size() - 1 && this.caseCommands.get(i).isEmpty()) {
                boolean hasDefault = false;
                boolean hasNonDefault = false;
                for (int k = 0; k < this.valuesMapping.size(); ++k) {
                    if (this.valuesMapping.get(k) != i) continue;
                    if (this.caseValues.get(k) instanceof DefaultItem) {
                        hasDefault = true;
                        continue;
                    }
                    hasNonDefault = true;
                }
                if (hasDefault && !hasNonDefault) continue;
            }
            for (int k = 0; k < this.valuesMapping.size(); ++k) {
                if (this.valuesMapping.get(k) != i) continue;
                if (!(this.caseValues.get(k) instanceof DefaultItem)) {
                    writer.append("case ");
                }
                this.caseValues.get(k).toString(writer, localData);
                writer.append(":").newLine();
            }
            writer.indent();
            for (int j = 0; j < this.caseCommands.get(i).size(); ++j) {
                if (this.caseCommands.get(i).get(j).isEmpty()) continue;
                this.caseCommands.get(i).get(j).toStringSemicoloned(writer, localData).newLine();
            }
            writer.unindent();
        }
        writer.endBlock();
        if (writer instanceof NulWriter) {
            LoopWithType loopOjb = ((NulWriter)writer).endLoop(this.loop.id);
            this.labelUsed = loopOjb.used;
        }
        return writer;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        for (List<GraphTargetItem> onecase : this.caseCommands) {
            for (GraphTargetItem ti : onecase) {
                if (ti instanceof ContinueItem) {
                    ret.add((ContinueItem)ti);
                }
                if (!(ti instanceof Block)) continue;
                ret.addAll(((Block)((Object)ti)).getContinues());
            }
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return generator.generate(localData, this);
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }
}

