/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.LoopWithType;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.Loop;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.LoopItem;
import java.util.ArrayList;
import java.util.List;

public class DoWhileItem
extends LoopItem
implements Block {
    public List<GraphTargetItem> commands;
    public List<GraphTargetItem> expression;
    private boolean labelUsed;

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        if (this.expression != null) {
            ret.add(this.expression);
        }
        if (this.commands != null) {
            ret.add(this.commands);
        }
        return ret;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        if (this.commands != null) {
            visitor.visitAll(this.commands);
        }
        if (this.expression != null) {
            visitor.visitAll(this.expression);
        }
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
        if (this.expression != null) {
            visitor.visitAll(this.expression);
        }
    }

    public DoWhileItem(GraphSourceItem src, GraphSourceItem lineStartIns, Loop loop, List<GraphTargetItem> commands, List<GraphTargetItem> expression) {
        super(src, lineStartIns, loop);
        this.expression = expression;
        this.commands = commands;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (writer instanceof NulWriter) {
            ((NulWriter)writer).startLoop(this.loop.id, LoopWithType.LOOP_TYPE_LOOP);
        }
        if (this.labelUsed) {
            writer.append("loop").append(this.loop.id).append(":").newLine();
        }
        writer.append("do");
        this.appendBlock(null, writer, localData, this.commands);
        writer.newLine();
        writer.append("while");
        if (writer.getFormatting().spaceBeforeParenthesesWhileParentheses) {
            writer.append(" ");
        }
        writer.append("(");
        for (int i = 0; i < this.expression.size(); ++i) {
            if (this.expression.get(i).isEmpty()) continue;
            if (i != 0) {
                writer.append(", ");
            }
            if (i == this.expression.size() - 1) {
                this.expression.get(i).toStringBoolean(writer, localData);
                continue;
            }
            this.expression.get(i).toString(writer, localData);
        }
        writer.append(");").newLine();
        if (writer instanceof NulWriter) {
            LoopWithType loopOjb = ((NulWriter)writer).endLoop(this.loop.id);
            this.labelUsed = loopOjb.used;
        }
        return writer;
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        for (GraphTargetItem ti : this.commands) {
            if (ti instanceof ContinueItem) {
                ret.add((ContinueItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        return ret;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        return generator.generate(localData, this);
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }
}

