/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.graph;

import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.PopItem;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TranslateStack
extends Stack<GraphTargetItem> {
    private PopItem pop;
    private final String path;

    public void simplify() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, this.get(i).simplify(""));
        }
    }

    public TranslateStack(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    private PopItem getPop() {
        if (this.pop == null) {
            this.pop = new PopItem(null, null);
        }
        return this.pop;
    }

    @Override
    public synchronized GraphTargetItem get(int index) {
        if (this.path != null && (index >= this.size() || index < 0)) {
            Logger.getLogger(TranslateStack.class.getName()).log(Level.FINE, "{0}: Attemp to Get item outside of bounds of stack", this.path);
            return this.getPop();
        }
        return (GraphTargetItem)super.get(index);
    }

    @Override
    public synchronized GraphTargetItem peek() {
        if (this.path != null && this.isEmpty()) {
            Logger.getLogger(TranslateStack.class.getName()).log(Level.FINE, "{0}: Attemp to Peek empty stack", this.path);
            return this.getPop();
        }
        return (GraphTargetItem)super.peek();
    }

    public synchronized GraphTargetItem peek(int index) {
        if (this.path != null && index > this.size()) {
            Logger.getLogger(TranslateStack.class.getName()).log(Level.FINE, "{0}: Attemp to Peek item from stack", this.path);
            return this.getPop();
        }
        return (GraphTargetItem)super.get(this.size() - index);
    }

    @Override
    public synchronized GraphTargetItem pop() {
        if (this.path != null && this.isEmpty()) {
            PopItem oldpop = this.getPop();
            this.pop = null;
            Logger.getLogger(TranslateStack.class.getName()).log(Level.FINE, "{0}: Attemp to Pop empty stack", this.path);
            return oldpop;
        }
        return (GraphTargetItem)super.pop();
    }
}

