/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.timeline;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.BlendModeSetable;
import com.jpexs.decompiler.flash.exporters.FrameExporter;
import com.jpexs.decompiler.flash.exporters.commonshape.ExportRectangle;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.tags.DefineScalingGridTag;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.DoActionTag;
import com.jpexs.decompiler.flash.tags.DoInitActionTag;
import com.jpexs.decompiler.flash.tags.FrameLabelTag;
import com.jpexs.decompiler.flash.tags.SetBackgroundColorTag;
import com.jpexs.decompiler.flash.tags.ShowFrameTag;
import com.jpexs.decompiler.flash.tags.SoundStreamBlockTag;
import com.jpexs.decompiler.flash.tags.StartSound2Tag;
import com.jpexs.decompiler.flash.tags.StartSoundTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.decompiler.flash.tags.base.ASMSourceContainer;
import com.jpexs.decompiler.flash.tags.base.BoundedTag;
import com.jpexs.decompiler.flash.tags.base.ButtonTag;
import com.jpexs.decompiler.flash.tags.base.CharacterIdTag;
import com.jpexs.decompiler.flash.tags.base.CharacterTag;
import com.jpexs.decompiler.flash.tags.base.DisplayObjectCacheKey;
import com.jpexs.decompiler.flash.tags.base.DrawableTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.base.MorphShapeTag;
import com.jpexs.decompiler.flash.tags.base.PlaceObjectTypeTag;
import com.jpexs.decompiler.flash.tags.base.RemoveTag;
import com.jpexs.decompiler.flash.tags.base.RenderContext;
import com.jpexs.decompiler.flash.tags.base.ShapeTag;
import com.jpexs.decompiler.flash.tags.base.SoundStreamHeadTypeTag;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.timeline.AS2Package;
import com.jpexs.decompiler.flash.timeline.Clip;
import com.jpexs.decompiler.flash.timeline.DepthState;
import com.jpexs.decompiler.flash.timeline.Frame;
import com.jpexs.decompiler.flash.timeline.SvgClip;
import com.jpexs.decompiler.flash.timeline.Timelined;
import com.jpexs.decompiler.flash.timeline.TweenDetector;
import com.jpexs.decompiler.flash.timeline.TweenRange;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.filters.BlendComposite;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.w3c.dom.Element;

public class Timeline {
    public int id;
    public SWF swf;
    public RECT displayRect;
    public float frameRate;
    public Timelined timelined;
    public int maxDepth;
    public int fontFrameNum = -1;
    private final List<Frame> frames = new ArrayList<Frame>();
    private final Map<Integer, Integer> depthMaxFrame = new HashMap<Integer, Integer>();
    public final List<ASMSource> asmSources = new ArrayList<ASMSource>();
    private final List<ASMSourceContainer> asmSourceContainers = new ArrayList<ASMSourceContainer>();
    private final Map<ASMSource, Integer> actionFrames = new HashMap<ASMSource, Integer>();
    private final Map<SoundStreamHeadTypeTag, List<SoundStreamBlockTag>> soundStramBlocks = new HashMap<SoundStreamHeadTypeTag, List<SoundStreamBlockTag>>();
    private AS2Package as2RootPackage;
    public final List<Tag> otherTags = new ArrayList<Tag>();
    private boolean initialized = false;
    private Map<String, Integer> labelToFrame = new HashMap<String, Integer>();
    public static final int DRAW_MODE_ALL = 0;
    public static final int DRAW_MODE_SHAPES = 1;
    public static final int DRAW_MODE_SPRITES = 2;

    private void ensureInitialized() {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    public List<Frame> getFrames() {
        this.ensureInitialized();
        return this.frames;
    }

    public Frame getFrame(int index) {
        this.ensureInitialized();
        if (index >= this.frames.size()) {
            return null;
        }
        return this.frames.get(index);
    }

    public void addFrame(Frame frame) {
        this.ensureInitialized();
        this.frames.add(frame);
        this.maxDepth = this.getMaxDepthInternal();
        this.calculateMaxDepthFrames();
    }

    public AS2Package getAS2RootPackage() {
        this.ensureInitialized();
        return this.as2RootPackage;
    }

    public Map<Integer, Integer> getDepthMaxFrame() {
        this.ensureInitialized();
        return this.depthMaxFrame;
    }

    public List<SoundStreamBlockTag> getSoundStreamBlocks(SoundStreamHeadTypeTag head) {
        this.ensureInitialized();
        return this.soundStramBlocks.get(head);
    }

    public Tag getParentTag() {
        return this.timelined instanceof Tag ? (Tag)((Object)this.timelined) : null;
    }

    public void reset(SWF swf) {
        this.reset(swf, swf, 0, swf.displayRect);
    }

    public void reset(SWF swf, Timelined timelined, int id, RECT displayRect) {
        this.initialized = false;
        this.frames.clear();
        this.depthMaxFrame.clear();
        this.asmSources.clear();
        this.asmSourceContainers.clear();
        this.actionFrames.clear();
        this.soundStramBlocks.clear();
        this.otherTags.clear();
        this.id = id;
        this.swf = swf;
        this.displayRect = displayRect;
        this.frameRate = swf.frameRate;
        this.timelined = timelined;
        this.as2RootPackage = new AS2Package(null, null, swf);
    }

    public final int getMaxDepth() {
        this.ensureInitialized();
        return this.maxDepth;
    }

    private int getMaxDepthInternal() {
        int max_depth = 0;
        for (Frame f : this.frames) {
            for (int depth : f.layers.keySet()) {
                int clipDepth;
                if (depth > max_depth) {
                    max_depth = depth;
                }
                if ((clipDepth = f.layers.get((Object)Integer.valueOf((int)depth)).clipDepth) <= max_depth) continue;
                max_depth = clipDepth;
            }
        }
        return max_depth;
    }

    public int getFrameCount() {
        this.ensureInitialized();
        return this.frames.size();
    }

    public int getRealFrameCount() {
        this.ensureInitialized();
        int cnt = 1;
        for (int i = 1; i < this.frames.size(); ++i) {
            if (!this.frames.get((int)i).actions.isEmpty()) {
                ++cnt;
                continue;
            }
            if (!this.frames.get((int)i).layersChanged) continue;
            ++cnt;
        }
        return cnt;
    }

    public int getFrameForAction(ASMSource asm) {
        Integer frame = this.actionFrames.get(asm);
        if (frame == null) {
            return -1;
        }
        return frame;
    }

    public Timeline(SWF swf) {
        this(swf, swf, 0, swf.displayRect);
    }

    public Timeline(SWF swf, Timelined timelined, int id, RECT displayRect) {
        this.id = id;
        this.swf = swf;
        this.displayRect = displayRect;
        this.frameRate = swf.frameRate;
        this.timelined = timelined;
        this.as2RootPackage = new AS2Package(null, null, swf);
    }

    public int getFrameWithLabel(String label) {
        if (this.labelToFrame.containsKey(label)) {
            return this.labelToFrame.get(label);
        }
        return -1;
    }

    private void initialize() {
        int frameIdx = 0;
        Frame frame = new Frame(this, frameIdx++);
        frame.layersChanged = true;
        boolean newFrameNeeded = false;
        for (Tag t : this.timelined.getTags()) {
            int depth;
            ASMSourceContainer asmSourceContainer;
            boolean isNested = ShowFrameTag.isNestedTagType(t.getId());
            if (isNested) {
                newFrameNeeded = true;
                frame.innerTags.add(t);
            }
            if (t instanceof ASMSourceContainer && !(asmSourceContainer = (ASMSourceContainer)((Object)t)).getSubItems().isEmpty()) {
                if (isNested) {
                    frame.actionContainers.add(asmSourceContainer);
                } else {
                    this.asmSourceContainers.add(asmSourceContainer);
                }
            }
            if (t instanceof FrameLabelTag) {
                newFrameNeeded = true;
                frame.label = ((FrameLabelTag)t).getLabelName();
                frame.namedAnchor = ((FrameLabelTag)t).isNamedAnchor();
                this.labelToFrame.put(frame.label, this.frames.size());
                continue;
            }
            if (t instanceof StartSoundTag) {
                newFrameNeeded = true;
                frame.sounds.add(((StartSoundTag)t).soundId);
                frame.soundClasses.add(null);
                frame.soundInfos.add(((StartSoundTag)t).soundInfo);
                continue;
            }
            if (t instanceof StartSound2Tag) {
                newFrameNeeded = true;
                frame.sounds.add(-1);
                frame.soundClasses.add(((StartSound2Tag)t).soundClassName);
                frame.soundInfos.add(((StartSoundTag)t).soundInfo);
                continue;
            }
            if (t instanceof SetBackgroundColorTag) {
                newFrameNeeded = true;
                frame.backgroundColor = ((SetBackgroundColorTag)t).backgroundColor;
                continue;
            }
            if (t instanceof PlaceObjectTypeTag) {
                CharacterTag character;
                newFrameNeeded = true;
                PlaceObjectTypeTag po = (PlaceObjectTypeTag)t;
                depth = po.getDepth();
                DepthState fl = frame.layers.get(depth);
                if (fl == null) {
                    fl = new DepthState(this.swf, frame);
                    frame.layers.put(depth, fl);
                    fl.depth = depth;
                }
                frame.layersChanged = true;
                fl.placeObjectTag = po;
                fl.minPlaceObjectNum = Math.max(fl.minPlaceObjectNum, po.getPlaceObjectNum());
                int characterId = po.getCharacterId();
                if (characterId != -1) {
                    fl.characterId = characterId;
                    fl.hasImage = po.hasImage();
                }
                if ((character = this.swf.getCharacter(characterId)) instanceof DefineSpriteTag && this.swf.getCyclicCharacters().contains(characterId)) {
                    fl.characterId = -1;
                }
                if (po.flagMove()) {
                    int clipDepth2;
                    int ratio2;
                    List<FILTER> filters2;
                    int blendMode2;
                    CLIPACTIONS clipActions2;
                    ColorTransform colorTransForm2;
                    String instanceName2;
                    MATRIX matrix2 = po.getMatrix();
                    if (matrix2 != null) {
                        fl.matrix = matrix2;
                    }
                    if ((instanceName2 = po.getInstanceName()) != null) {
                        fl.instanceName = instanceName2;
                    }
                    if ((colorTransForm2 = po.getColorTransform()) != null) {
                        fl.colorTransForm = colorTransForm2;
                    }
                    if ((clipActions2 = po.getClipActions()) != null) {
                        fl.clipActions = clipActions2;
                    }
                    if (po.cacheAsBitmap()) {
                        fl.cacheAsBitmap = true;
                    }
                    if ((blendMode2 = po.getBlendMode()) > 0) {
                        fl.blendMode = blendMode2;
                    }
                    if ((filters2 = po.getFilters()) != null) {
                        fl.filters = filters2;
                    }
                    if ((ratio2 = po.getRatio()) > -1) {
                        fl.ratio = ratio2;
                    }
                    if ((clipDepth2 = po.getClipDepth()) > -1) {
                        fl.clipDepth = clipDepth2;
                    }
                    fl.isVisible = po.isVisible();
                } else {
                    fl.matrix = po.getMatrix();
                    fl.instanceName = po.getInstanceName();
                    fl.colorTransForm = po.getColorTransform();
                    fl.cacheAsBitmap = po.cacheAsBitmap();
                    fl.blendMode = po.getBlendMode();
                    fl.filters = po.getFilters();
                    fl.ratio = po.getRatio();
                    fl.clipActions = po.getClipActions();
                    fl.clipDepth = po.getClipDepth();
                    fl.isVisible = po.isVisible();
                }
                fl.key = characterId != -1;
                continue;
            }
            if (t instanceof RemoveTag) {
                newFrameNeeded = true;
                RemoveTag r = (RemoveTag)t;
                depth = r.getDepth();
                frame.layers.remove(depth);
                frame.layersChanged = true;
                continue;
            }
            if (t instanceof DoActionTag) {
                newFrameNeeded = true;
                frame.actions.add((DoActionTag)t);
                this.actionFrames.put((DoActionTag)t, frame.frame);
                continue;
            }
            if (t instanceof ShowFrameTag) {
                frame.showFrameTag = (ShowFrameTag)t;
                this.frames.add(frame);
                frame = new Frame(frame, frameIdx++);
                newFrameNeeded = false;
                continue;
            }
            if (t instanceof ASMSource) {
                this.asmSources.add((ASMSource)((Object)t));
                continue;
            }
            this.otherTags.add(t);
        }
        if (newFrameNeeded) {
            this.frames.add(frame);
        }
        this.maxDepth = this.getMaxDepthInternal();
        this.detectTweens();
        this.calculateMaxDepthFrames();
        this.createASPackages();
        if (this.timelined instanceof SWF) {
            this.populateSoundStreamBlocks(0, this.timelined.getTags());
        }
        this.initialized = true;
    }

    private void detectTweens() {
        for (int d = 1; d <= this.maxDepth; ++d) {
            int characterId = -1;
            int len = 0;
            for (int f = 0; f <= this.frames.size(); ++f) {
                DepthState ds;
                DepthState depthState = ds = f >= this.frames.size() ? null : this.frames.get((int)f).layers.get(d);
                if (ds != null && characterId != -1 && ds.characterId == characterId) {
                    ++len;
                } else {
                    if (characterId != -1) {
                        int startPos = f - len;
                        ArrayList<DepthState> matrices = new ArrayList<DepthState>(len);
                        for (int k = 0; k < len; ++k) {
                            matrices.add(this.frames.get((int)(startPos + k)).layers.get(d));
                        }
                        List<TweenRange> ranges = TweenDetector.detectRanges(matrices);
                        for (TweenRange r : ranges) {
                            for (int t = r.startPosition; t <= r.endPosition; ++t) {
                                DepthState layer = this.frames.get((int)(startPos + t)).layers.get(d);
                                layer.motionTween = true;
                                layer.key = false;
                            }
                            this.frames.get((int)(startPos + r.startPosition)).layers.get((Object)Integer.valueOf((int)d)).key = true;
                        }
                    }
                    len = 1;
                }
                characterId = ds == null ? -1 : ds.characterId;
            }
        }
    }

    private void calculateMaxDepthFrames() {
        this.depthMaxFrame.clear();
        block0: for (int d = 1; d <= this.maxDepth; ++d) {
            for (int f = this.frames.size() - 1; f >= 0; --f) {
                if (this.frames.get((int)f).layers.get(d) == null) continue;
                this.depthMaxFrame.put(d, f);
                continue block0;
            }
        }
    }

    private void createASPackages() {
        for (ASMSource asm : this.asmSources) {
            String[] stringArray;
            if (!(asm instanceof DoInitActionTag)) continue;
            DoInitActionTag initAction = (DoInitActionTag)asm;
            String path = this.swf.getExportName(initAction.spriteId);
            if (path == null) continue;
            if (path.isEmpty()) {
                path = initAction.getExportFileName();
            }
            if (path.contains(".")) {
                stringArray = path.split("\\.");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = path;
            }
            String[] pathParts = stringArray;
            AS2Package pkg = this.as2RootPackage;
            for (int pos = 0; pos < pathParts.length - 1; ++pos) {
                String pathPart = pathParts[pos];
                AS2Package subPkg = pkg.subPackages.get(pathPart);
                if (subPkg == null) {
                    subPkg = new AS2Package(pathPart, pkg, this.swf);
                    pkg.subPackages.put(pathPart, subPkg);
                }
                pkg = subPkg;
            }
            pkg.scripts.put(pathParts[pathParts.length - 1], asm);
        }
    }

    private void populateSoundStreamBlocks(int containerId, Iterable<Tag> tags) {
        ArrayList<SoundStreamBlockTag> blocks = null;
        for (Tag t : tags) {
            if (t instanceof SoundStreamHeadTypeTag) {
                SoundStreamHeadTypeTag head = (SoundStreamHeadTypeTag)((Object)t);
                head.setVirtualCharacterId(containerId);
                blocks = new ArrayList<SoundStreamBlockTag>();
                this.soundStramBlocks.put(head, blocks);
                continue;
            }
            if (t instanceof DefineSpriteTag) {
                DefineSpriteTag sprite = (DefineSpriteTag)t;
                this.populateSoundStreamBlocks(sprite.getCharacterId(), sprite.getTags());
            }
            if (blocks == null || !(t instanceof SoundStreamBlockTag)) continue;
            blocks.add((SoundStreamBlockTag)t);
        }
    }

    public void getNeededCharacters(Set<Integer> usedCharacters) {
        for (int i = 0; i < this.getFrameCount(); ++i) {
            this.getNeededCharacters(i, usedCharacters);
        }
    }

    public void getNeededCharacters(List<Integer> frames, Set<Integer> usedCharacters) {
        for (int frame = 0; frame < this.getFrameCount(); ++frame) {
            this.getNeededCharacters(frame, usedCharacters);
        }
    }

    public void getNeededCharacters(int frame, Set<Integer> usedCharacters) {
        Frame frameObj = this.getFrame(frame);
        for (int depth : frameObj.layers.keySet()) {
            DepthState layer = frameObj.layers.get(depth);
            if (layer.characterId == -1 || !this.swf.getCharacters().containsKey(layer.characterId)) continue;
            usedCharacters.add(layer.characterId);
            this.swf.getCharacter(layer.characterId).getNeededCharactersDeep(usedCharacters);
        }
    }

    public boolean replaceCharacter(int oldCharacterId, int newCharacterId) {
        boolean modified = false;
        for (int i = 0; i < this.timelined.getTags().size(); ++i) {
            Tag t = this.timelined.getTags().get(i);
            if (!(t instanceof CharacterIdTag) || ((CharacterIdTag)((Object)t)).getCharacterId() != oldCharacterId) continue;
            ((CharacterIdTag)((Object)t)).setCharacterId(newCharacterId);
            t.setModified(true);
            modified = true;
        }
        return modified;
    }

    public boolean removeCharacter(int characterId) {
        boolean modified = false;
        for (int i = 0; i < this.timelined.getTags().size(); ++i) {
            Tag t = this.timelined.getTags().get(i);
            if (!(t instanceof CharacterIdTag) || ((CharacterIdTag)((Object)t)).getCharacterId() != characterId) continue;
            this.timelined.removeTag(i);
            --i;
            modified = true;
        }
        return modified;
    }

    public double roundToPixel(double val) {
        return Math.rint(val / 20.0) * 20.0;
    }

    private void drawDrawable(Matrix strokeTransform, DepthState layer, Matrix layerMatrix, Graphics2D g, ColorTransform colorTransForm, int blendMode, List<Clip> clips, Matrix transformation, boolean isClip, int clipDepth, Matrix absMat, int time, int ratio, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, DrawableTag drawable, List<FILTER> filters, double unzoom, ColorTransform clrTrans, boolean sameImage, ExportRectangle viewRect, Matrix fullTransformation, boolean scaleStrokes, int drawMode) {
        Matrix drawMatrix = new Matrix();
        int drawableFrameCount = drawable.getNumFrames();
        if (drawableFrameCount == 0) {
            drawableFrameCount = 1;
        }
        RECT boundRect = drawable.getRectWithStrokes();
        ExportRectangle rect = new ExportRectangle(boundRect);
        Matrix mat = transformation.concatenate(layerMatrix);
        rect = mat.transform(rect);
        ExportRectangle viewRectZoom = new ExportRectangle(viewRect);
        viewRectZoom.xMin *= unzoom;
        viewRectZoom.xMax *= unzoom;
        viewRectZoom.yMin *= unzoom;
        viewRectZoom.yMax *= unzoom;
        ExportRectangle fullRect = fullTransformation.concatenate(layerMatrix).transform(new ExportRectangle(boundRect));
        viewRectZoom.xMax -= viewRectZoom.xMin;
        viewRectZoom.xMin = 0.0;
        viewRectZoom.yMax -= viewRectZoom.yMin;
        viewRectZoom.yMin = 0.0;
        if (!viewRectZoom.intersects(fullRect)) {
            return;
        }
        strokeTransform = strokeTransform.concatenate(layerMatrix);
        boolean cacheAsBitmap = layer.cacheAsBitmap() && layer.placeObjectTag != null && drawable.isSingleFrame();
        SerializableImage img = null;
        if (cacheAsBitmap && renderContext.displayObjectCache != null) {
            DisplayObjectCacheKey key = new DisplayObjectCacheKey(layer.placeObjectTag, unzoom, viewRect);
            img = renderContext.displayObjectCache.get(key);
        }
        int stateCount = renderContext.stateUnderCursor == null ? 0 : renderContext.stateUnderCursor.size();
        int dframe = this.fontFrameNum != -1 ? this.fontFrameNum : time % drawableFrameCount;
        ExportRectangle viewRect2 = new ExportRectangle(viewRect);
        if (filters != null && filters.size() > 0) {
            double deltaXMax = 0.0;
            double deltaYMax = 0.0;
            for (FILTER filter : filters) {
                double x = filter.getDeltaX();
                double y = filter.getDeltaY();
                deltaXMax = Math.max(x, deltaXMax);
                deltaYMax = Math.max(y, deltaYMax);
            }
            rect.xMin -= deltaXMax * unzoom * 20.0;
            rect.xMax += deltaXMax * unzoom * 20.0;
            rect.yMin -= deltaYMax * unzoom * 20.0;
            rect.yMax += deltaYMax * unzoom * 20.0;
            viewRect2.xMin -= deltaXMax * 20.0;
            viewRect2.xMax += deltaXMax * 20.0;
            viewRect2.yMin -= deltaXMax * 20.0;
            viewRect2.yMax += deltaXMax * 20.0;
        }
        rect.xMin -= 20.0;
        rect.yMin -= 20.0;
        drawMatrix.translate(rect.xMin, rect.yMin);
        drawMatrix.translateX /= 20.0;
        drawMatrix.translateY /= 20.0;
        boolean canUseSameImage = true;
        if (img == null) {
            int newWidth = (int)(rect.getWidth() / 20.0);
            int newHeight = (int)(rect.getHeight() / 20.0);
            int deltaX = (int)(rect.xMin / 20.0);
            int deltaY = (int)(rect.yMin / 20.0);
            newWidth = Math.min(image.getWidth() - deltaX, newWidth) + 1;
            newHeight = Math.min(image.getHeight() - deltaY, newHeight) + 1;
            if (newWidth <= 0 || newHeight <= 0) {
                return;
            }
            Matrix m = mat.preConcatenate(Matrix.getTranslateInstance(-rect.xMin, -rect.yMin));
            if (drawable instanceof ButtonTag) {
                dframe = ButtonTag.FRAME_UP;
                if (renderContext.cursorPosition != null) {
                    int dx = (int)(viewRect.xMin * unzoom);
                    int dy = (int)(viewRect.yMin * unzoom);
                    Point cursorPositionInView = new Point(renderContext.cursorPosition.x - dx, renderContext.cursorPosition.y - dy);
                    Shape buttonShape = drawable.getOutline(ButtonTag.FRAME_HITTEST, time, ratio, renderContext, absMat, true);
                    if (buttonShape.contains(cursorPositionInView)) {
                        renderContext.mouseOverButton = (ButtonTag)drawable;
                        dframe = renderContext.mouseButton > 0 ? ButtonTag.FRAME_DOWN : ButtonTag.FRAME_OVER;
                    }
                }
            }
            if (filters != null && !filters.isEmpty()) {
                canUseSameImage = false;
            }
            if (blendMode > 1) {
                canUseSameImage = false;
            }
            if (clipDepth > -1) {
                canUseSameImage = false;
            }
            Matrix mfull = fullTransformation.concatenate(layerMatrix);
            if (canUseSameImage && sameImage) {
                img = image;
                m = mat.clone();
                g.setTransform(new AffineTransform());
            } else {
                img = new SerializableImage(newWidth, newHeight, SerializableImage.TYPE_INT_ARGB_PRE);
                img.fillTransparent();
            }
            ColorTransform clrTrans2 = clrTrans;
            if (clipDepth > -1) {
                CXFORMWITHALPHA clrMask = new CXFORMWITHALPHA();
                clrMask.hasAddTerms = true;
                clrMask.hasMultTerms = true;
                clrMask.alphaAddTerm = 255;
                clrMask.redMultTerm = 0;
                clrMask.greenMultTerm = 0;
                clrMask.blueMultTerm = 0;
                clrTrans2 = clrMask;
            }
            if (!(drawable instanceof ImageTag) || this.swf.isAS3() && layer.hasImage) {
                drawable.toImage(dframe, time, ratio, renderContext, img, fullImage, isClip || clipDepth > -1, m, strokeTransform, absMat, mfull, clrTrans2, unzoom, sameImage, viewRect2, scaleStrokes, drawMode);
            }
            if (filters != null) {
                for (FILTER filter : filters) {
                    img = filter.apply(img, unzoom);
                }
            }
            if (blendMode > 1 && colorTransForm != null) {
                img = colorTransForm.apply(img);
            }
            if (!sameImage && cacheAsBitmap && renderContext.displayObjectCache != null) {
                renderContext.clearPlaceObjectCache(layer.placeObjectTag);
                renderContext.displayObjectCache.put(new DisplayObjectCacheKey(layer.placeObjectTag, unzoom, viewRect), img);
            }
        }
        AffineTransform trans = drawMatrix.toTransform();
        if (g instanceof BlendModeSetable) {
            ((BlendModeSetable)((Object)g)).setBlendMode(blendMode);
        } else {
            switch (blendMode) {
                case 0: 
                case 1: {
                    g.setComposite(AlphaComposite.SrcOver);
                    break;
                }
                case 2: {
                    g.setComposite(AlphaComposite.SrcOver);
                    break;
                }
                case 3: {
                    g.setComposite(BlendComposite.Multiply);
                    break;
                }
                case 4: {
                    g.setComposite(BlendComposite.Screen);
                    break;
                }
                case 5: {
                    g.setComposite(BlendComposite.Lighten);
                    break;
                }
                case 6: {
                    g.setComposite(BlendComposite.Darken);
                    break;
                }
                case 7: {
                    g.setComposite(BlendComposite.Difference);
                    break;
                }
                case 8: {
                    g.setComposite(BlendComposite.Add);
                    break;
                }
                case 9: {
                    g.setComposite(BlendComposite.Subtract);
                    break;
                }
                case 10: {
                    g.setComposite(BlendComposite.Invert);
                    break;
                }
                case 11: {
                    g.setComposite(BlendComposite.Alpha);
                    break;
                }
                case 12: {
                    g.setComposite(BlendComposite.Erase);
                    break;
                }
                case 13: {
                    g.setComposite(BlendComposite.Overlay);
                    break;
                }
                case 14: {
                    g.setComposite(BlendComposite.HardLight);
                    break;
                }
                default: {
                    g.setComposite(AlphaComposite.SrcOver);
                }
            }
        }
        if (clipDepth > -1) {
            BufferedImage mask = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
            Graphics2D gm = (Graphics2D)mask.getGraphics();
            gm.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            gm.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            gm.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gm.setComposite(AlphaComposite.Src);
            gm.setColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
            gm.fillRect(0, 0, image.getWidth(), image.getHeight());
            gm.setTransform(trans);
            gm.drawImage((Image)img.getBufferedImage(), 0, 0, null);
            Clip clip = new Clip(Helper.imageToShape(mask), clipDepth);
            clips.add(clip);
        } else {
            if (renderContext.cursorPosition != null) {
                Shape shape;
                int dx = (int)(viewRect.xMin * unzoom);
                int dy = (int)(viewRect.yMin * unzoom);
                Point cursorPositionInView = new Point(renderContext.cursorPosition.x - dx, renderContext.cursorPosition.y - dy);
                if (drawable instanceof DefineSpriteTag) {
                    if (renderContext.stateUnderCursor.size() > stateCount) {
                        renderContext.stateUnderCursor.add(layer);
                    }
                } else if (absMat.transform(new ExportRectangle(boundRect)).contains(cursorPositionInView) && (shape = drawable.getOutline(dframe, time, layer.ratio, renderContext, absMat, true)).contains(cursorPositionInView)) {
                    renderContext.stateUnderCursor.add(layer);
                }
            }
            if (renderContext.borderImage != null) {
                Graphics2D g2 = (Graphics2D)renderContext.borderImage.getGraphics();
                g2.setPaint(Color.red);
                g2.setStroke(new BasicStroke(2.0f));
                Shape shape = drawable.getOutline(dframe, time, layer.ratio, renderContext, absMat.preConcatenate(Matrix.getScaleInstance(0.05)), true);
                g2.draw(shape);
            }
            if (!sameImage || !canUseSameImage) {
                g.setTransform(drawMatrix.toTransform());
                g.drawImage((Image)img.getBufferedImage(), 0, 0, null);
            }
            if (g instanceof BlendModeSetable) {
                ((BlendModeSetable)((Object)g)).setBlendMode(0);
            }
        }
    }

    public void toImage(int frame, int time, RenderContext renderContext, SerializableImage image, SerializableImage fullImage, boolean isClip, Matrix transformation, Matrix strokeTransformation, Matrix absoluteTransformation, ColorTransform colorTransform, double unzoom, boolean sameImage, ExportRectangle viewRect, Matrix fullTransformation, boolean scaleStrokes, int drawMode) {
        if (this.getFrameCount() <= frame) {
            return;
        }
        Frame frameObj = this.getFrame(frame);
        Graphics2D g = (Graphics2D)image.getGraphics();
        Graphics2D fullG = (Graphics2D)fullImage.getGraphics();
        Shape prevClip = g.getClip();
        if (!sameImage) {
            g.setPaint(frameObj.backgroundColor.toColor());
            g.fill(new Rectangle(image.getWidth(), image.getHeight()));
        }
        sameImage = true;
        g.setTransform(transformation.toTransform());
        ArrayList<Clip> clips = new ArrayList<Clip>();
        int maxDepth = this.getMaxDepth();
        int clipCount = 0;
        for (int i = 1; i <= maxDepth; ++i) {
            boolean clipChanged = clipCount != clips.size();
            for (int c = 0; c < clips.size(); ++c) {
                if (((Clip)clips.get((int)c)).depth >= i) continue;
                clips.remove(c);
                clipChanged = true;
            }
            if (clipChanged) {
                if (clips.size() > 0) {
                    Area clip = null;
                    for (Clip clip1 : clips) {
                        Shape shape = clip1.shape;
                        if (clip == null) {
                            clip = new Area(shape);
                            continue;
                        }
                        clip.intersect(new Area(shape));
                    }
                    g.setTransform(new AffineTransform());
                    g.setClip(clip);
                } else {
                    g.setClip(null);
                }
                clipCount = clips.size();
            }
            if (!frameObj.layers.containsKey(i)) continue;
            DepthState layer = frameObj.layers.get(i);
            if (!this.swf.getCharacters().containsKey(layer.characterId) || !layer.isVisible) continue;
            CharacterTag character = this.swf.getCharacter(layer.characterId);
            Matrix layerMatrix = new Matrix(layer.matrix);
            boolean zeroScale = false;
            if (Double.compare(layerMatrix.scaleX, 0.0) == 0 || Double.compare(layerMatrix.scaleY, 0.0) == 0) {
                zeroScale = true;
            }
            if (zeroScale) continue;
            Matrix mat = transformation.concatenate(layerMatrix);
            Matrix absMat = absoluteTransformation.concatenate(layerMatrix);
            ColorTransform clrTrans = colorTransform;
            if (layer.colorTransForm != null && layer.blendMode <= 1) {
                clrTrans = clrTrans == null ? layer.colorTransForm : colorTransform.merge(layer.colorTransForm);
            }
            boolean showPlaceholder = false;
            if (drawMode != 0 && drawMode != 2 && !(character instanceof ShapeTag) || drawMode != 0 && drawMode != 1 && character instanceof ShapeTag) continue;
            if (character instanceof DrawableTag) {
                RECT scalingRect = null;
                DefineScalingGridTag sgt = character.getScalingGridTag();
                if (sgt != null) {
                    scalingRect = sgt.splitter;
                }
                if (scalingRect != null) {
                    ExportRectangle[] sourceRect = new ExportRectangle[9];
                    ExportRectangle[] targetRect = new ExportRectangle[9];
                    Matrix[] transforms = new Matrix[9];
                    DrawableTag dr = (DrawableTag)character;
                    ExportRectangle boundsRect = new ExportRectangle(dr.getRect());
                    ExportRectangle targetBoundsRect = layerMatrix.transform(boundsRect);
                    DefineScalingGridTag.getSlices(targetBoundsRect, boundsRect, new ExportRectangle(scalingRect), sourceRect, targetRect, transforms);
                    Shape c = g.getClip();
                    AffineTransform origTransform = g.getTransform();
                    int s = 0;
                    for (int sy = 0; sy < 3; ++sy) {
                        for (int sx = 0; sx < 3; ++sx) {
                            g.setTransform(new AffineTransform());
                            ExportRectangle p1 = transformation.transform(targetRect[s]);
                            if (sx == 0) {
                                p1.xMin = 0.0;
                            }
                            if (sy == 0) {
                                p1.yMin = 0.0;
                            }
                            if (sx == 2) {
                                p1.xMax = unzoom * viewRect.getWidth();
                            }
                            if (sy == 2) {
                                p1.yMax = unzoom * viewRect.getHeight();
                            }
                            p1.xMin /= 20.0;
                            p1.xMax /= 20.0;
                            p1.yMin /= 20.0;
                            p1.yMax /= 20.0;
                            Rectangle2D.Double r = new Rectangle2D.Double(p1.xMin, p1.yMin, p1.getWidth(), p1.getHeight());
                            g.setClip(r);
                            this.drawDrawable(strokeTransformation, layer, transforms[s], g, colorTransform, layer.blendMode, clips, transformation, isClip, layer.clipDepth, absMat, layer.time + time, layer.ratio, renderContext, image, fullImage, (DrawableTag)character, layer.filters, unzoom, clrTrans, sameImage, viewRect, fullTransformation, false, 1);
                            ++s;
                        }
                    }
                    g.setClip(c);
                    g.setTransform(origTransform);
                    this.drawDrawable(strokeTransformation, layer, layerMatrix, g, colorTransform, layer.blendMode, clips, transformation, isClip, layer.clipDepth, absMat, layer.time + time, layer.ratio, renderContext, image, fullImage, (DrawableTag)character, layer.filters, unzoom, clrTrans, sameImage, viewRect, fullTransformation, scaleStrokes, 2);
                } else {
                    boolean subScaleStrokes = scaleStrokes;
                    if (character instanceof DefineSpriteTag) {
                        subScaleStrokes = true;
                    }
                    this.drawDrawable(strokeTransformation, layer, layerMatrix, g, colorTransform, layer.blendMode, clips, transformation, isClip, layer.clipDepth, absMat, layer.time + time, layer.ratio, renderContext, image, fullImage, (DrawableTag)character, layer.filters, unzoom, clrTrans, sameImage, viewRect, fullTransformation, subScaleStrokes, 0);
                }
            } else if (character instanceof BoundedTag) {
                showPlaceholder = true;
            }
            if (!showPlaceholder) continue;
            AffineTransform trans = mat.preConcatenate(Matrix.getScaleInstance(0.05)).toTransform();
            g.setTransform(trans);
            BoundedTag b = (BoundedTag)((Object)character);
            g.setPaint(new Color(255, 255, 255, 128));
            g.setComposite(BlendComposite.Invert);
            g.setStroke(new BasicStroke(20.0f));
            RECT r = b.getRect();
            g.setFont(g.getFont().deriveFont(240.0f));
            g.drawString(character.toString(), r.Xmin + 60, r.Ymin + 300);
            g.draw(new Rectangle(r.Xmin, r.Ymin, r.getWidth(), r.getHeight()));
            g.drawLine(r.Xmin, r.Ymin, r.Xmax, r.Ymax);
            g.drawLine(r.Xmax, r.Ymin, r.Xmin, r.Ymax);
            g.setComposite(AlphaComposite.Dst);
        }
        g.setTransform(new AffineTransform());
        g.setClip(prevClip);
    }

    public void toSVG(int frame, int time, DepthState stateUnderCursor, int mouseButton, SVGExporter exporter, ColorTransform colorTransform, int level) throws IOException {
        if (this.getFrameCount() <= frame) {
            return;
        }
        Frame frameObj = this.getFrame(frame);
        ArrayList<SvgClip> clips = new ArrayList<SvgClip>();
        int maxDepth = this.getMaxDepth();
        int clipCount = 0;
        Element clipGroup = null;
        for (int i = 1; i <= maxDepth; ++i) {
            String assetName;
            DrawableTag drawable;
            boolean clipChanged = clipCount != clips.size();
            for (int c = 0; c < clips.size(); ++c) {
                if (((SvgClip)clips.get((int)c)).depth >= i) continue;
                clips.remove(c);
                clipChanged = true;
            }
            if (clipChanged) {
                if (clipGroup != null) {
                    exporter.endGroup();
                    clipGroup = null;
                }
                if (clips.size() > 0) {
                    String clip = ((SvgClip)clips.get((int)(clips.size() - 1))).shape;
                    clipGroup = exporter.createSubGroup((Matrix)null, (String)null);
                    clipGroup.setAttribute("clip-path", "url(#" + clip + ")");
                }
                clipCount = clips.size();
            }
            if (!frameObj.layers.containsKey(i)) continue;
            DepthState layer = frameObj.layers.get(i);
            if (!this.swf.getCharacters().containsKey(layer.characterId) || !layer.isVisible) continue;
            CharacterTag character = this.swf.getCharacter(layer.characterId);
            ColorTransform clrTrans = colorTransform;
            if (layer.colorTransForm != null && layer.blendMode <= 1) {
                ColorTransform colorTransform2 = clrTrans = clrTrans == null ? layer.colorTransForm : colorTransform.merge(layer.colorTransForm);
            }
            if (!(character instanceof DrawableTag)) continue;
            DrawableTag drawableTag = drawable = (DrawableTag)character;
            RECT boundRect = drawable.getRect();
            boolean createNew = false;
            if (exporter.exportedTags.containsKey(drawableTag)) {
                assetName = exporter.exportedTags.get(drawableTag);
            } else {
                assetName = Timeline.getTagIdPrefix(drawableTag, exporter);
                exporter.exportedTags.put(drawableTag, assetName);
                createNew = true;
            }
            ExportRectangle rect = new ExportRectangle(boundRect);
            DefineScalingGridTag scalingGrid = character.getScalingGridTag();
            if (layer.clipDepth > -1) {
                String clipName = exporter.getUniqueId("clipPath");
                Matrix mat = new Matrix(layer.matrix);
                exporter.createClipPath(mat, clipName);
                SvgClip clip = new SvgClip(clipName, layer.clipDepth);
                clips.add(clip);
                drawable.toSVG(exporter, layer.ratio, clrTrans, level + 1);
                exporter.endGroup();
                continue;
            }
            if (createNew) {
                exporter.createDefGroup(new ExportRectangle(boundRect), assetName);
                drawable.toSVG(exporter, layer.ratio, clrTrans, level + 1);
                exporter.endGroup();
            }
            Matrix mat = Matrix.getTranslateInstance(rect.xMin, rect.yMin).preConcatenate(new Matrix(layer.matrix));
            exporter.addUse(mat, boundRect, assetName, layer.instanceName, scalingGrid == null ? null : scalingGrid.splitter);
        }
        if (clipGroup != null) {
            exporter.endGroup();
        }
    }

    private static String getTagIdPrefix(Tag tag, SVGExporter exporter) {
        if (tag instanceof ShapeTag) {
            return exporter.getUniqueId("shape");
        }
        if (tag instanceof MorphShapeTag) {
            return exporter.getUniqueId("morphshape");
        }
        if (tag instanceof DefineSpriteTag) {
            return exporter.getUniqueId("sprite");
        }
        if (tag instanceof TextTag) {
            return exporter.getUniqueId("text");
        }
        if (tag instanceof ButtonTag) {
            return exporter.getUniqueId("button");
        }
        return exporter.getUniqueId("tag");
    }

    public void toHtmlCanvas(StringBuilder result, double unitDivisor, List<Integer> frames) {
        FrameExporter.framesToHtmlCanvas(result, unitDivisor, this, frames, 0, null, 0, this.displayRect, null, null);
    }

    public void getSounds(int frame, int time, ButtonTag mouseOverButton, int mouseButton, List<Integer> sounds, List<String> soundClasses, List<SOUNDINFO> soundInfos) {
        Frame fr = this.getFrame(frame);
        sounds.addAll(fr.sounds);
        soundClasses.addAll(fr.soundClasses);
        soundInfos.addAll(fr.soundInfos);
        for (int d = this.maxDepth; d >= 0; --d) {
            int frameCount;
            CharacterTag c;
            DepthState ds = fr.layers.get(d);
            if (ds == null || !((c = this.swf.getCharacter(ds.characterId)) instanceof Timelined) || (frameCount = ((Timelined)((Object)c)).getTimeline().frames.size()) == 0) continue;
            int dframe = time % frameCount;
            if (c instanceof ButtonTag) {
                dframe = ButtonTag.FRAME_UP;
                if (mouseOverButton == c) {
                    dframe = mouseButton > 0 ? ButtonTag.FRAME_DOWN : ButtonTag.FRAME_OVER;
                }
            }
            ((Timelined)((Object)c)).getTimeline().getSounds(dframe, time, mouseOverButton, mouseButton, sounds, soundClasses, soundInfos);
        }
    }

    public Shape getOutline(int frame, int time, RenderContext renderContext, Matrix transformation, boolean stroked) {
        Frame fr = this.getFrame(frame);
        Area area = new Area();
        Stack<Clip> clips = new Stack<Clip>();
        for (int d = this.maxDepth; d >= 0; --d) {
            CharacterTag character;
            DepthState layer;
            Clip currentClip = null;
            for (int i = clips.size() - 1; i >= 0; --i) {
                Clip cl = (Clip)clips.get(i);
                if (cl.depth > d) continue;
                clips.remove(i);
            }
            if (!clips.isEmpty()) {
                currentClip = (Clip)clips.peek();
            }
            if ((layer = fr.layers.get(d)) == null || !layer.isVisible || !((character = this.swf.getCharacter(layer.characterId)) instanceof DrawableTag)) continue;
            DrawableTag drawable = (DrawableTag)character;
            Matrix m = transformation.concatenate(new Matrix(layer.matrix));
            int drawableFrameCount = drawable.getNumFrames();
            if (drawableFrameCount == 0) {
                drawableFrameCount = 1;
            }
            int dframe = time % drawableFrameCount;
            if (character instanceof ButtonTag) {
                ButtonTag buttonTag;
                Shape buttonShape;
                dframe = ButtonTag.FRAME_UP;
                if (renderContext.cursorPosition != null && (buttonShape = (buttonTag = (ButtonTag)character).getOutline(ButtonTag.FRAME_HITTEST, time, layer.ratio, renderContext, m, stroked)).contains(renderContext.cursorPosition)) {
                    dframe = renderContext.mouseButton > 0 ? ButtonTag.FRAME_DOWN : ButtonTag.FRAME_OVER;
                }
            }
            Shape cshape = ((DrawableTag)character).getOutline(dframe, time, layer.ratio, renderContext, m, stroked);
            Area addArea = new Area(cshape);
            if (currentClip != null) {
                Area a = new Area(new Rectangle(this.displayRect.Xmin, this.displayRect.Ymin, this.displayRect.getWidth(), this.displayRect.getHeight()));
                a.subtract(new Area(currentClip.shape));
                addArea.subtract(a);
            }
            if (layer.clipDepth > -1) {
                Clip clip = new Clip(addArea, layer.clipDepth);
                clips.push(clip);
                continue;
            }
            area.add(addArea);
        }
        return area;
    }

    public boolean isSingleFrame() {
        for (int i = 0; i < this.getFrameCount(); ++i) {
            if (this.isSingleFrame(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleFrame(int frame) {
        Frame frameObj = this.getFrame(frame);
        for (int i = 1; i <= this.maxDepth; ++i) {
            DrawableTag drawable;
            CharacterTag character;
            if (!frameObj.layers.containsKey(i)) continue;
            DepthState layer = frameObj.layers.get(i);
            if (!this.swf.getCharacters().containsKey(layer.characterId) || !layer.isVisible || !((character = this.swf.getCharacter(layer.characterId)) instanceof DrawableTag) || (drawable = (DrawableTag)character).isSingleFrame()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Timeline) {
            Timeline timelineObj = (Timeline)obj;
            return this.timelined.equals(timelineObj.timelined);
        }
        return false;
    }
}

