/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.base.PasswordTag;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.HashType;
import com.jpexs.decompiler.flash.types.annotations.Password;
import com.jpexs.decompiler.flash.types.annotations.Reserved;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.MD5Crypt;
import java.io.IOException;

@SWFVersion(from=2)
public class ProtectTag
extends Tag
implements PasswordTag {
    public static final int ID = 24;
    public static final String NAME = "Protect";
    @Reserved
    @SWFType(value=BasicType.UI16)
    public int reserved;
    @Password(type=HashType.MD5CRYPT)
    public String passwordHash;

    public ProtectTag(SWF swf) {
        super(swf, 24, NAME, null);
        this.passwordHash = "";
        this.reserved = 0;
    }

    public ProtectTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 24, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        if (sis.available() > 0) {
            this.reserved = sis.readUI16("reserved");
        }
        this.passwordHash = sis.available() > 0 ? sis.readString("passwordHash") : "";
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.reserved);
        if (!"".equals(this.passwordHash)) {
            sos.writeString(this.passwordHash);
        }
    }

    @Override
    public void setPassword(String password) {
        this.passwordHash = MD5Crypt.crypt(password, 2);
    }

    @Override
    public boolean hasPassword(String password) {
        return this.passwordHash.equals(MD5Crypt.crypt(password, 2));
    }
}

