/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.DefineBitsJPEG3Tag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagChangedListener;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@SWFVersion(from=1)
public class DefineBitsTag
extends ImageTag
implements TagChangedListener {
    public static final int ID = 6;
    public static final String NAME = "DefineBits";
    @SWFType(value=BasicType.UI8)
    public ByteArrayRange jpegData;

    public DefineBitsTag(SWF swf) {
        super(swf, 6, NAME, null);
        this.characterID = swf.getNextCharacterId();
        this.jpegData = ByteArrayRange.EMPTY;
        this.forceWriteAsLong = true;
    }

    public DefineBitsTag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 6, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        this.jpegData = sis.readByteRangeEx(sis.available(), "jpegData");
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.write(this.jpegData);
    }

    @Override
    public boolean importSupported() {
        return true;
    }

    @Override
    public void setImage(byte[] data) {
        throw new UnsupportedOperationException("Set image is not supported for DefineBits");
    }

    @Override
    public ImageFormat getImageFormat() {
        return ImageFormat.JPEG;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageFormat.JPEG;
    }

    private static List<byte[]> parseJpegChunks(byte[] data) {
        int pos;
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        int n = data.length;
        for (pos = 0; pos < n && ((data[pos] & 0xFF) != 255 || pos + 1 < n && ((data[pos + 1] & 0xFF) == 0 || (data[pos + 1] & 0xFF) == 255)); ++pos) {
        }
        while (pos < n) {
            int code;
            int start = pos++;
            if ((code = data[pos++] & 0xFF) >= 192 && code <= 199 || code >= 201 && code <= 207 || code >= 218 && code <= 239 || code == 254) {
                int length = (data[pos] & 0xFF) << 8 + (data[pos + 1] & 0xFF);
                pos += length;
            }
            while (pos < n && ((data[pos] & 0xFF) != 255 || pos + 1 < n && ((data[pos + 1] & 0xFF) == 0 || (data[pos + 1] & 0xFF) == 255))) {
                ++pos;
            }
            if (code == 216 || code == 217) continue;
            ret.add(Arrays.copyOfRange(data, start, pos));
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InputStream getOriginalImageData() {
        if (this.swf.getJtt() == null) return null;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int errorLength = DefineBitsTag.hasErrorHeader(this.jpegData) ? 4 : 0;
            List<byte[]> jpegChunks = DefineBitsTag.parseJpegChunks(this.jpegData.getRangeData(errorLength, this.jpegData.getLength() - errorLength));
            ByteArrayRange jttdata = this.swf.getJtt().jpegData;
            if (jttdata.getLength() != 0) {
                int jttErrorLength = DefineBitsTag.hasErrorHeader(jttdata) ? 4 : 0;
                List<byte[]> chunksJtt = DefineBitsTag.parseJpegChunks(jttdata.getRangeData(jttErrorLength, jttdata.getLength() - jttErrorLength));
                for (int c = 0; c < jpegChunks.size(); ++c) {
                    int chunkType = jpegChunks.get(c)[1] & 0xFF;
                    if (chunkType < 192 || chunkType > 207) continue;
                    jpegChunks.addAll(c, chunksJtt);
                    break;
                }
            }
            jpegChunks.add(0, new byte[]{-1, -40});
            jpegChunks.add(new byte[]{-1, -39});
            for (byte[] chunk : jpegChunks) {
                baos.write(chunk);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
            return byteArrayInputStream;
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    @Override
    protected SerializableImage getImage() {
        InputStream imageStream = this.getOriginalImageData();
        if (imageStream != null) {
            try {
                BufferedImage image = ImageHelper.read(imageStream);
                if (image == null) {
                    Logger.getLogger(DefineBitsTag.class.getName()).log(Level.SEVERE, "Failed to load image");
                    return null;
                }
                SerializableImage img = new SerializableImage(image);
                return img;
            }
            catch (IOException ex) {
                Logger.getLogger(DefineBitsTag.class.getName()).log(Level.SEVERE, "Failed to get image", ex);
            }
        }
        return null;
    }

    @Override
    public Dimension getImageDimension() {
        if (this.cachedImage != null) {
            return new Dimension(this.cachedImage.getWidth(), this.cachedImage.getHeight());
        }
        InputStream imageStream = this.getOriginalImageData();
        if (imageStream != null) {
            try {
                return ImageHelper.getDimesion(imageStream);
            }
            catch (IOException ex) {
                Logger.getLogger(DefineBitsJPEG3Tag.class.getName()).log(Level.SEVERE, "Failed to get image dimension", ex);
            }
        }
        return null;
    }

    @Override
    public void handleEvent(Tag tag) {
        this.clearCache();
    }
}

