/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.tags;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.SWFInputStream;
import com.jpexs.decompiler.flash.SWFOutputStream;
import com.jpexs.decompiler.flash.dumpview.DumpInfoSpecialType;
import com.jpexs.decompiler.flash.helpers.ImageHelper;
import com.jpexs.decompiler.flash.tags.base.AloneTag;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.BasicType;
import com.jpexs.decompiler.flash.types.annotations.SWFType;
import com.jpexs.decompiler.flash.types.annotations.SWFVersion;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.JpegFixer;
import com.jpexs.helpers.SerializableImage;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

@SWFVersion(from=3)
public class DefineBitsJPEG3Tag
extends ImageTag
implements AloneTag {
    public static final int ID = 35;
    public static final String NAME = "DefineBitsJPEG3";
    @SWFType(value=BasicType.UI8)
    public ByteArrayRange imageData;
    @SWFType(value=BasicType.UI8)
    public ByteArrayRange bitmapAlphaData;

    public DefineBitsJPEG3Tag(SWF swf) {
        super(swf, 35, NAME, null);
        this.characterID = swf.getNextCharacterId();
        this.imageData = new ByteArrayRange(this.createEmptyImage());
        this.bitmapAlphaData = ByteArrayRange.EMPTY;
        this.forceWriteAsLong = true;
    }

    public DefineBitsJPEG3Tag(SWF swf, ByteArrayRange data, int characterID, byte[] imageData) throws IOException {
        super(swf, 35, NAME, data);
        this.characterID = characterID;
        this.imageData = new ByteArrayRange(imageData);
        this.bitmapAlphaData = ByteArrayRange.EMPTY;
        this.forceWriteAsLong = true;
    }

    public DefineBitsJPEG3Tag(SWFInputStream sis, ByteArrayRange data) throws IOException {
        super(sis.getSwf(), 35, NAME, data);
        this.readData(sis, data, 0, false, false, false);
    }

    @Override
    public final void readData(SWFInputStream sis, ByteArrayRange data, int level, boolean parallel, boolean skipUnusualTags, boolean lazy) throws IOException {
        this.characterID = sis.readUI16("characterID");
        long alphaDataOffset = sis.readUI32("alphaDataOffset");
        this.imageData = sis.readByteRangeEx(alphaDataOffset, "imageData");
        this.bitmapAlphaData = sis.readByteRangeEx(sis.available(), "bitmapAlphaData", DumpInfoSpecialType.ZLIB_DATA, null);
    }

    @Override
    public void getData(SWFOutputStream sos) throws IOException {
        sos.writeUI16(this.characterID);
        sos.writeUI32(this.imageData.getLength());
        sos.write(this.imageData);
        sos.write(this.bitmapAlphaData);
    }

    private byte[] createEmptyImage() {
        BufferedImage img = new BufferedImage(1, 1, 3);
        ByteArrayOutputStream bitmapDataOS = new ByteArrayOutputStream();
        ImageHelper.write(img, ImageFormat.JPEG, bitmapDataOS);
        return bitmapDataOS.toByteArray();
    }

    @Override
    public void setImage(byte[] data) throws IOException {
        if (ImageTag.getImageFormat(data) == ImageFormat.JPEG) {
            BufferedImage image = ImageHelper.read(data);
            byte[] ba = new byte[image.getWidth() * image.getHeight()];
            for (int i = 0; i < ba.length; ++i) {
                ba[i] = -1;
            }
            this.bitmapAlphaData = new ByteArrayRange(SWFOutputStream.compressByteArray(ba));
        } else {
            this.bitmapAlphaData = new ByteArrayRange(SWFOutputStream.compressByteArray(new byte[0]));
        }
        this.imageData = new ByteArrayRange(data);
        this.clearCache();
        this.setModified(true);
    }

    public byte[] getImageAlpha() throws IOException {
        return SWFInputStream.uncompressByteArray(this.bitmapAlphaData.getRangeData());
    }

    public void setImageAlpha(byte[] data) throws IOException {
        ImageFormat fmt = ImageTag.getImageFormat(this.imageData);
        if (fmt != ImageFormat.JPEG) {
            throw new IOException("Only Jpeg can have alpha channel.");
        }
        Dimension dimension = this.getImageDimension();
        if (data == null || (double)data.length != dimension.getWidth() * dimension.getHeight()) {
            throw new IOException("Data length must match the size of the image.");
        }
        this.bitmapAlphaData = new ByteArrayRange(SWFOutputStream.compressByteArray(data));
        this.clearCache();
        this.setModified(true);
    }

    @Override
    public ImageFormat getImageFormat() {
        ImageFormat fmt = this.getOriginalImageFormat();
        if (fmt == ImageFormat.JPEG && this.bitmapAlphaData.getLength() > 0) {
            fmt = ImageFormat.PNG;
        }
        return fmt;
    }

    @Override
    public ImageFormat getOriginalImageFormat() {
        return ImageTag.getImageFormat(this.imageData);
    }

    @Override
    public InputStream getOriginalImageData() {
        if (this.bitmapAlphaData.getLength() == 0) {
            int errorLength = DefineBitsJPEG3Tag.hasErrorHeader(this.imageData) ? 4 : 0;
            JpegFixer jpegFixer = new JpegFixer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                jpegFixer.fixJpeg(new ByteArrayInputStream(this.imageData.getArray(), this.imageData.getPos() + errorLength, this.imageData.getLength() - errorLength), baos);
            }
            catch (IOException ex) {
                Logger.getLogger(DefineBitsJPEG3Tag.class.getName()).log(Level.SEVERE, null, ex);
            }
            return new ByteArrayInputStream(baos.toByteArray());
        }
        return null;
    }

    @Override
    protected SerializableImage getImage() {
        try {
            int errorLength = DefineBitsJPEG3Tag.hasErrorHeader(this.imageData) ? 4 : 0;
            JpegFixer jpegFixer = new JpegFixer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                jpegFixer.fixJpeg(new ByteArrayInputStream(this.imageData.getArray(), this.imageData.getPos() + errorLength, this.imageData.getLength() - errorLength), baos);
            }
            catch (IOException ex) {
                Logger.getLogger(DefineBitsJPEG3Tag.class.getName()).log(Level.SEVERE, null, ex);
            }
            BufferedImage image = ImageHelper.read(new ByteArrayInputStream(baos.toByteArray()));
            if (image == null) {
                Logger.getLogger(DefineBitsJPEG3Tag.class.getName()).log(Level.SEVERE, "Failed to load image");
                return null;
            }
            SerializableImage img = new SerializableImage(image);
            if (this.bitmapAlphaData.getLength() == 0) {
                return img;
            }
            byte[] alphaData = this.getImageAlpha();
            if (alphaData.length == 0) {
                return img;
            }
            int width = img.getWidth();
            int height = img.getHeight();
            SerializableImage img2 = new SerializableImage(width, height, SerializableImage.TYPE_INT_ARGB);
            int[] pixels = ((DataBufferInt)img.getRaster().getDataBuffer()).getData();
            int[] pixels2 = ((DataBufferInt)img2.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < pixels.length; ++i) {
                int a = alphaData[i] & 0xFF;
                int b = pixels[i] >> 16 & 0xFF;
                int g = pixels[i] >> 8 & 0xFF;
                int r = pixels[i] & 0xFF;
                r = (int)Math.floor((double)r * 255.0 / (double)a);
                g = (int)Math.floor((double)g * 255.0 / (double)a);
                b = (int)Math.floor((double)b * 255.0 / (double)a);
                if (r > 255) {
                    r = 255;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b > 255) {
                    b = 255;
                }
                pixels2[i] = a << 24 | b << 16 | g << 8 | r;
            }
            return img2;
        }
        catch (IOException ex) {
            Logger.getLogger(DefineBitsJPEG3Tag.class.getName()).log(Level.SEVERE, "Failed to get image", ex);
            return null;
        }
    }

    @Override
    public Dimension getImageDimension() {
        if (this.cachedImage != null) {
            return new Dimension(this.cachedImage.getWidth(), this.cachedImage.getHeight());
        }
        try {
            int errorLength = DefineBitsJPEG3Tag.hasErrorHeader(this.imageData) ? 4 : 0;
            ByteArrayInputStream bis = new ByteArrayInputStream(this.imageData.getArray(), this.imageData.getPos() + errorLength, this.imageData.getLength() - errorLength);
            return ImageHelper.getDimesion(bis);
        }
        catch (IOException ex) {
            Logger.getLogger(DefineBitsJPEG3Tag.class.getName()).log(Level.SEVERE, "Failed to get image dimension", ex);
            return null;
        }
    }
}

