/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.search;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.search.ScriptNotFoundException;
import com.jpexs.decompiler.flash.search.ScriptSearchResult;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Map;

public class ActionSearchResult
implements ScriptSearchResult {
    private final ASMSource src;
    private final boolean pcode;
    private final String path;
    private static final int SERIAL_VERSION_MAJOR = 1;
    private static final int SERIAL_VERSION_MINOR = 0;

    public ActionSearchResult(SWF swf, InputStream is) throws IOException, ScriptNotFoundException {
        Map<String, ASMSource> asms = swf.getASMs(false);
        ObjectInputStream ois = new ObjectInputStream(is);
        int versionMajor = ois.read();
        ois.read();
        if (versionMajor != 1) {
            throw new IOException("Unknown search result version: " + versionMajor);
        }
        this.path = ois.readUTF();
        if (!asms.containsKey(this.path)) {
            throw new ScriptNotFoundException();
        }
        this.src = asms.get(this.path);
        this.pcode = ois.readBoolean();
    }

    public void save(OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.write(1);
        oos.write(0);
        oos.writeUTF(this.path);
        oos.writeBoolean(this.pcode);
        oos.flush();
        oos.close();
    }

    public ActionSearchResult(ASMSource src, boolean pcode, String path) {
        this.src = src;
        this.pcode = pcode;
        this.path = path;
    }

    public ASMSource getSrc() {
        return this.src;
    }

    public boolean isPcode() {
        return this.pcode;
    }

    public String toString() {
        return this.path;
    }

    @Override
    public SWF getSWF() {
        return this.src.getSwf();
    }
}

