/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.tags.base.MissingCharacterHandler;
import com.jpexs.decompiler.flash.tags.base.TextImportErrorHandler;
import com.jpexs.decompiler.flash.tags.base.TextTag;
import com.jpexs.decompiler.flash.tags.text.TextParseException;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.Path;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TextImporter {
    private final MissingCharacterHandler missingCharacterHandler;
    private final TextImportErrorHandler errorHandler;

    public TextImporter(MissingCharacterHandler missingCharacterHandler, TextImportErrorHandler errorHandler) {
        this.missingCharacterHandler = missingCharacterHandler;
        this.errorHandler = errorHandler;
    }

    private Map<Integer, String[]> splitTextRecords(String texts) {
        String[] textsArr = texts.split(Helper.newLine + Configuration.textExportSingleFileSeparator.get() + Helper.newLine);
        String recordSeparator = Helper.newLine + Configuration.textExportSingleFileRecordSeparator.get() + Helper.newLine;
        HashMap<Integer, String[]> result = new HashMap<Integer, String[]>();
        for (String text : textsArr) {
            String[] textArr = text.split(Helper.newLine, 2);
            String idLine = textArr[0];
            if (idLine.startsWith("ID:")) {
                int id = Integer.parseInt(idLine.substring(3).trim());
                String[] records = textArr[1].split(recordSeparator);
                result.put(id, records);
                continue;
            }
            if (!this.errorHandler.handle(null)) continue;
            return null;
        }
        return result;
    }

    public void importTextsSingleFile(File textsFile, SWF swf) {
        String texts = Helper.readTextFile(textsFile.getPath());
        Map<Integer, String[]> records = this.splitTextRecords(texts);
        boolean ignoreLetterSpacing = Configuration.resetLetterSpacingOnTextImport.get();
        if (records != null) {
            for (int characterId : records.keySet()) {
                String[] currentRecords;
                String text;
                TextTag textTag = swf.getText(characterId);
                if (textTag == null || this.saveText(textTag, text = textTag.getFormattedText((boolean)ignoreLetterSpacing).text, currentRecords = records.get(characterId))) continue;
                return;
            }
        }
    }

    public void importTextsSingleFileFormatted(File textsFile, SWF swf) {
        String texts = Helper.readTextFile(textsFile.getPath());
        Map<Integer, String[]> records = this.splitTextRecords(texts);
        if (records != null) {
            for (int characterId : records.keySet()) {
                String[] currentRecords;
                TextTag textTag = swf.getText(characterId);
                if (textTag == null || this.saveText(textTag, (currentRecords = records.get(characterId))[0], null)) continue;
                return;
            }
        }
    }

    public void importTextsMultipleFiles(String folder, SWF swf) {
        File textsFolder = new File(Path.combine(folder, "texts"));
        String[] files = textsFolder.list(new FilenameFilter(){
            private final Pattern pat = Pattern.compile("\\d+\\.txt", 2);

            @Override
            public boolean accept(File dir, String name) {
                return this.pat.matcher(name).matches();
            }
        });
        if (files == null) {
            return;
        }
        for (String fileName : files) {
            String texts = Helper.readTextFile(Path.combine(textsFolder.getPath(), fileName));
            int characterId = Integer.parseInt(fileName.split("\\.")[0]);
            TextTag textTag = swf.getText(characterId);
            if (this.importText(textTag, texts)) continue;
            return;
        }
    }

    public boolean importText(TextTag textTag, String newText) {
        String recordSeparator = Helper.newLine + Configuration.textExportSingleFileRecordSeparator.get() + Helper.newLine;
        boolean formatted = !newText.contains(recordSeparator) && newText.startsWith("[" + Helper.newLine);
        boolean ignoreLetterSpacing = Configuration.resetLetterSpacingOnTextImport.get();
        if (!formatted) {
            String text;
            String[] records = newText.split(recordSeparator);
            if (textTag != null && !this.saveText(textTag, text = textTag.getFormattedText((boolean)ignoreLetterSpacing).text, records)) {
                return false;
            }
        } else if (textTag != null && !this.saveText(textTag, newText, null)) {
            return false;
        }
        return true;
    }

    private boolean saveText(TextTag textTag, String formattedText, String[] texts) {
        try {
            if (textTag.setFormattedText(this.missingCharacterHandler, formattedText, texts)) {
                return true;
            }
            return !this.errorHandler.handle(textTag);
        }
        catch (TextParseException ex) {
            return !this.errorHandler.handle(textTag, ex.text, ex.line);
        }
    }

    public static int getTextTagType(String format) {
        int res = 0;
        switch (format) {
            case "text": {
                res = 11;
                break;
            }
            case "text2": {
                res = 33;
                break;
            }
            case "edittext": {
                res = 37;
            }
        }
        return res;
    }
}

