/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.importers;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.ABCVersion;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.flash.abc.types.ABCException;
import com.jpexs.decompiler.flash.abc.types.ClassInfo;
import com.jpexs.decompiler.flash.abc.types.Decimal;
import com.jpexs.decompiler.flash.abc.types.InstanceInfo;
import com.jpexs.decompiler.flash.abc.types.MetadataInfo;
import com.jpexs.decompiler.flash.abc.types.MethodBody;
import com.jpexs.decompiler.flash.abc.types.MethodInfo;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.Namespace;
import com.jpexs.decompiler.flash.abc.types.NamespaceSet;
import com.jpexs.decompiler.flash.abc.types.ScriptInfo;
import com.jpexs.decompiler.flash.abc.types.ValueKind;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitFunction;
import com.jpexs.decompiler.flash.abc.types.traits.TraitMethodGetterSetter;
import com.jpexs.decompiler.flash.abc.types.traits.TraitSlotConst;
import com.jpexs.decompiler.flash.abc.types.traits.Traits;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.tags.DefineSpriteTag;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.tags.TagTypeInfo;
import com.jpexs.decompiler.flash.tags.UnknownTag;
import com.jpexs.decompiler.flash.types.ALPHABITMAPDATA;
import com.jpexs.decompiler.flash.types.ALPHACOLORMAPDATA;
import com.jpexs.decompiler.flash.types.ARGB;
import com.jpexs.decompiler.flash.types.BITMAPDATA;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CLIPEVENTFLAGS;
import com.jpexs.decompiler.flash.types.COLORMAPDATA;
import com.jpexs.decompiler.flash.types.CXFORM;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.GRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.KERNINGRECORD;
import com.jpexs.decompiler.flash.types.LANGCODE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLE;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHFOCALGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADRECORD;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE2;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.PIX15;
import com.jpexs.decompiler.flash.types.PIX24;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.SOUNDENVELOPE;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.ZONEDATA;
import com.jpexs.decompiler.flash.types.ZONERECORD;
import com.jpexs.decompiler.flash.types.filters.BEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.BLURFILTER;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import com.jpexs.decompiler.flash.types.filters.DROPSHADOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GLOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.HashArrayList;
import com.jpexs.helpers.ReflectionTools;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SwfXmlImporter {
    private static final Logger logger = Logger.getLogger(SwfXmlImporter.class.getName());
    private Map<String, Class> swfTags;
    private Map<String, Class> swfObjects;
    private Map<String, Class> swfObjectsParam;

    public void importSwf(SWF swf, String xml) throws IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(new StringReader(xml)));
            this.processElement(doc.getDocumentElement(), swf, swf, null);
            swf.clearAllCache();
            this.setSwfAndTimelined(swf);
        }
        catch (ParserConfigurationException | SAXException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void setSwfAndTimelined(SWF swf) {
        for (Tag t : swf.getTags()) {
            t.setSwf(swf);
            t.setTimelined(swf);
            if (!(t instanceof DefineSpriteTag)) continue;
            DefineSpriteTag s = (DefineSpriteTag)t;
            for (Tag st : s.getTags()) {
                st.setSwf(swf);
                st.setTimelined(s);
            }
        }
    }

    public Object importObject(String xml, Class requiredType, SWF swf) throws IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(new StringReader(xml)));
            return this.processObject(doc.getDocumentElement(), requiredType, swf, null);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException | ParserConfigurationException | SAXException ex) {
            Logger.getLogger(SwfXmlImporter.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private Field getField(Class cls, String name) throws NoSuchFieldException {
        Field field;
        try {
            field = cls.getField(name);
        }
        catch (NoSuchFieldException ex) {
            field = cls.getDeclaredField(name);
            field.setAccessible(true);
        }
        return field;
    }

    private static void setFieldValue(Field field, Object obj, Object value) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        field.set(obj, value);
    }

    private void processElement(Element element, Object obj, SWF swf, Tag tag) {
        int i;
        Class<?> cls = obj.getClass();
        for (i = 0; i < element.getAttributes().getLength(); ++i) {
            Attr attr = (Attr)element.getAttributes().item(i);
            String name = attr.getName();
            if (name.equals("tagId") && "UnknownTag".equals(element.getAttribute("type")) || name.equals("type")) continue;
            try {
                Field field = this.getField(cls, name);
                String attrValue = attr.getValue();
                SwfXmlImporter.setFieldValue(field, obj, this.getAs(field.getType(), attrValue));
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        for (i = 0; i < element.getChildNodes().getLength(); ++i) {
            Node childNode = element.getChildNodes().item(i);
            if (!(childNode instanceof Element)) continue;
            Element child = (Element)childNode;
            String name = child.getTagName();
            try {
                Object childObj;
                Element childChild;
                int j;
                ArrayList<Object> list;
                Field field = this.getField(cls, name);
                Class<?> childCls = field.getType();
                if (List.class.isAssignableFrom(childCls)) {
                    list = HashArrayList.class.isAssignableFrom(childCls) ? new HashArrayList() : new ArrayList();
                    for (j = 0; j < child.getChildNodes().getLength(); ++j) {
                        Node childChildNode = child.getChildNodes().item(j);
                        if (!(childChildNode instanceof Element)) continue;
                        childChild = (Element)child.getChildNodes().item(j);
                        childObj = this.processObject(childChild, ReflectionTools.getFieldSubType(obj, field), swf, tag);
                        list.add(childObj);
                    }
                    SwfXmlImporter.setFieldValue(field, obj, list);
                    continue;
                }
                if (childCls.isArray()) {
                    list = new ArrayList<Object>();
                    for (j = 0; j < child.getChildNodes().getLength(); ++j) {
                        Node childChildNode = child.getChildNodes().item(j);
                        if (!(childChildNode instanceof Element)) continue;
                        childChild = (Element)child.getChildNodes().item(j);
                        childObj = this.processObject(childChild, childCls.getComponentType(), swf, tag);
                        list.add(childObj);
                    }
                    Object array = Array.newInstance(childCls.getComponentType(), list.size());
                    for (int j2 = 0; j2 < list.size(); ++j2) {
                        Array.set(array, j2, list.get(j2));
                    }
                    SwfXmlImporter.setFieldValue(field, obj, array);
                    continue;
                }
                Object childObj2 = this.processObject(child, null, swf, tag);
                SwfXmlImporter.setFieldValue(field, obj, childObj2);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, "Error while getting val from class " + cls + " field: " + name, ex);
            }
        }
    }

    private Object processObject(Element element, Class requiredType, SWF swf, Tag tag) throws IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InstantiationException, InvocationTargetException {
        String type = element.getAttribute("type");
        String tagTypeIdStr = element.getAttribute("tagId");
        int tagTypeId = -1;
        try {
            tagTypeId = Integer.parseInt(tagTypeIdStr);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if ("String".equals(type)) {
            return element.getTextContent();
        }
        if (type != null && !type.isEmpty()) {
            Object childObj = this.createObject(type, tagTypeId, swf, tag);
            if (childObj instanceof Tag) {
                tag = (Tag)childObj;
            }
            this.processElement(element, childObj, swf, tag);
            return childObj;
        }
        String isNullAttr = element.getAttribute("isNull");
        if (Boolean.parseBoolean(isNullAttr)) {
            return null;
        }
        return this.getAs(requiredType, element.getTextContent());
    }

    private Object createObject(String type, int tagTypeId, SWF swf, Tag tag) throws NoSuchMethodException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class[] knownObjects;
        HashMap<String, Class> objects;
        if (this.swfTags == null) {
            HashMap<String, Class> tags = new HashMap<String, Class>();
            Map<Integer, TagTypeInfo> knownTags = Tag.getKnownClasses();
            for (Integer key : knownTags.keySet()) {
                Class cls = knownTags.get(key).getCls();
                if (!ReflectionTools.canInstantiate(cls)) {
                    System.err.println("Can't instantiate: " + cls.getName());
                }
                tags.put(cls.getSimpleName(), cls);
            }
            this.swfTags = tags;
        }
        if ("UnknownTag".equals(type)) {
            return new UnknownTag(swf, tagTypeId);
        }
        Class cls = this.swfTags.get(type);
        if (cls != null) {
            return cls.getConstructor(SWF.class).newInstance(swf);
        }
        if (this.swfObjects == null) {
            objects = new HashMap<String, Class>();
            for (Class cls2 : knownObjects = new Class[]{ALPHABITMAPDATA.class, ALPHACOLORMAPDATA.class, ARGB.class, BITMAPDATA.class, BUTTONCONDACTION.class, BUTTONRECORD.class, CLIPACTIONRECORD.class, CLIPACTIONS.class, CLIPEVENTFLAGS.class, COLORMAPDATA.class, ColorTransform.class, CXFORM.class, CXFORMWITHALPHA.class, FILLSTYLE.class, FILLSTYLEARRAY.class, FOCALGRADIENT.class, GLYPHENTRY.class, GRADIENT.class, GRADRECORD.class, KERNINGRECORD.class, LANGCODE.class, LINESTYLE.class, LINESTYLE2.class, LINESTYLEARRAY.class, MATRIX.class, MORPHFILLSTYLE.class, MORPHFILLSTYLEARRAY.class, MORPHFOCALGRADIENT.class, MORPHGRADIENT.class, MORPHGRADRECORD.class, MORPHLINESTYLE.class, MORPHLINESTYLE2.class, MORPHLINESTYLEARRAY.class, PIX15.class, PIX24.class, RECT.class, RGB.class, RGBA.class, SHAPE.class, SHAPEWITHSTYLE.class, SOUNDENVELOPE.class, SOUNDINFO.class, TEXTRECORD.class, ZONEDATA.class, ZONERECORD.class, CurvedEdgeRecord.class, EndShapeRecord.class, StraightEdgeRecord.class, StyleChangeRecord.class, BEVELFILTER.class, BLURFILTER.class, COLORMATRIXFILTER.class, CONVOLUTIONFILTER.class, DROPSHADOWFILTER.class, GLOWFILTER.class, GRADIENTBEVELFILTER.class, GRADIENTGLOWFILTER.class, AVM2ConstantPool.class, Decimal.class, Namespace.class, NamespaceSet.class, Multiname.class, MethodInfo.class, MetadataInfo.class, ValueKind.class, InstanceInfo.class, Traits.class, TraitClass.class, TraitFunction.class, TraitMethodGetterSetter.class, TraitSlotConst.class, ClassInfo.class, ScriptInfo.class, MethodBody.class, ABCException.class, ABCVersion.class, Amf3Value.class}) {
                if (!ReflectionTools.canInstantiateDefaultConstructor(cls2)) {
                    System.err.println("Can't instantiate: " + cls2.getName());
                }
                objects.put(cls2.getSimpleName(), cls2);
            }
            this.swfObjects = objects;
        }
        if ((cls = this.swfObjects.get(type)) != null) {
            return cls.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (this.swfObjectsParam == null) {
            objects = new HashMap();
            for (Class cls2 : knownObjects = new Class[]{ABC.class}) {
                if (!ReflectionTools.canInstantiate(cls2)) {
                    System.err.println("Can't instantiate: " + cls2.getName());
                }
                objects.put(cls2.getSimpleName(), cls2);
            }
            this.swfObjectsParam = objects;
        }
        if ((cls = this.swfObjectsParam.get(type)) != null) {
            for (Constructor<?> constructor : cls.getConstructors()) {
                Class<?> parameterType;
                if (constructor.getParameterCount() != 1 || !(parameterType = constructor.getParameterTypes()[0]).isAssignableFrom(tag.getClass())) continue;
                return constructor.newInstance(tag);
            }
        }
        System.err.println("Type not found: " + type);
        return null;
    }

    private Object getAs(Class cls, String stringValue) throws IllegalArgumentException, IllegalAccessException {
        if (cls == Byte.class || cls == Byte.TYPE) {
            return Byte.parseByte(stringValue);
        }
        if (cls == Short.class || cls == Short.TYPE) {
            return Short.parseShort(stringValue);
        }
        if (cls == Integer.class || cls == Integer.TYPE) {
            return Integer.parseInt(stringValue);
        }
        if (cls == Long.class || cls == Long.TYPE) {
            return Long.parseLong(stringValue);
        }
        if (cls == Float.class || cls == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(stringValue));
        }
        if (cls == Double.class || cls == Double.TYPE) {
            return Double.parseDouble(stringValue);
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return Boolean.parseBoolean(stringValue);
        }
        if (cls == Character.class || cls == Character.TYPE) {
            return Character.valueOf(stringValue.charAt(0));
        }
        if (cls == String.class) {
            return stringValue;
        }
        if (cls == ByteArrayRange.class) {
            ByteArrayRange range = new ByteArrayRange(stringValue);
            return range;
        }
        if (cls == byte[].class) {
            ByteArrayRange range = new ByteArrayRange(stringValue);
            return range.getArray();
        }
        if (cls.isEnum()) {
            return Enum.valueOf(cls, stringValue);
        }
        throw new RuntimeException("Unsupported object type.");
    }
}

