/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.exporters.shape;

import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.exporters.commonshape.Matrix;
import com.jpexs.decompiler.flash.exporters.commonshape.SVGExporter;
import com.jpexs.decompiler.flash.exporters.shape.DefaultSVGShapeExporter;
import com.jpexs.decompiler.flash.tags.base.ImageTag;
import com.jpexs.decompiler.flash.tags.enums.ImageFormat;
import com.jpexs.decompiler.flash.types.ColorTransform;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.helpers.Helper;
import com.jpexs.helpers.SerializableImage;
import java.awt.Color;
import org.w3c.dom.Element;

public class SVGShapeExporter
extends DefaultSVGShapeExporter {
    protected Element path;
    protected int id;
    protected int lastPatternId;
    private final Color defaultColor;
    private final SWF swf;
    private final SVGExporter exporter;

    public SVGShapeExporter(SWF swf, SHAPE shape, int id, SVGExporter exporter, Color defaultColor, ColorTransform colorTransform, double zoom) {
        super(swf, shape, colorTransform, zoom);
        this.swf = swf;
        this.id = id;
        this.defaultColor = defaultColor;
        this.exporter = exporter;
    }

    @Override
    public void beginFill(RGB color) {
        if (color == null && this.defaultColor != null) {
            color = new RGB(this.defaultColor);
        }
        this.finalizePath();
        this.path.setAttribute("stroke", "none");
        if (color != null) {
            this.path.setAttribute("fill", color.toHexRGB());
        }
        this.path.setAttribute("fill-rule", "evenodd");
        if (color instanceof RGBA) {
            RGBA colorA = (RGBA)color;
            if (colorA.alpha != 255) {
                this.path.setAttribute("fill-opacity", Float.toString(colorA.getAlphaFloat()));
            }
        }
    }

    @Override
    public void beginGradientFill(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        this.finalizePath();
        Element gradient = type == 16 ? this.exporter.createElement("linearGradient") : this.exporter.createElement("radialGradient");
        this.populateGradientElement(gradient, type, gradientRecords, matrix, spreadMethod, interpolationMethod, focalPointRatio);
        int id = this.exporter.gradients.indexOf(gradient);
        if (id < 0) {
            id = this.exporter.gradients.size();
            this.exporter.gradients.add(gradient);
        }
        String gradientId = "gradient" + id;
        gradient.setAttribute("id", gradientId);
        this.path.setAttribute("stroke", "none");
        this.path.setAttribute("fill", "url(#" + gradientId + ")");
        this.path.setAttribute("fill-rule", "evenodd");
        this.exporter.addToDefs(gradient);
    }

    private String getPattern(int bitmapId, Matrix matrix, ColorTransform colorTransform) {
        SerializableImage img;
        ImageTag image = this.swf.getImage(bitmapId);
        if (image != null && (img = image.getImageCached()) != null) {
            if (colorTransform != null) {
                colorTransform.apply(img);
            }
            int width = img.getWidth();
            int height = img.getHeight();
            ++this.lastPatternId;
            String patternId = "PatternID_" + this.id + "_" + this.lastPatternId;
            ImageFormat format = image.getImageFormat();
            byte[] imageData = Helper.readStream(image.getImageData());
            String base64ImgData = Helper.byteArrayToBase64String(imageData);
            Element pattern = this.exporter.createElement("pattern");
            pattern.setAttribute("id", patternId);
            pattern.setAttribute("patternUnits", "userSpaceOnUse");
            pattern.setAttribute("overflow", "visible");
            pattern.setAttribute("width", "" + width);
            pattern.setAttribute("height", "" + height);
            pattern.setAttribute("viewBox", "0 0 " + width + " " + height);
            if (matrix != null) {
                pattern.setAttribute("patternTransform", matrix.getSvgTransformationString(20.0 / this.zoom, 20.0 / this.zoom));
            }
            Element imageElement = this.exporter.createElement("image");
            imageElement.setAttribute("width", "" + width);
            imageElement.setAttribute("height", "" + height);
            imageElement.setAttribute("xlink:href", "data:image/" + (Object)((Object)format) + ";base64," + base64ImgData);
            pattern.appendChild(imageElement);
            this.exporter.addToGroup(pattern);
            return patternId;
        }
        return null;
    }

    @Override
    public void beginBitmapFill(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        this.finalizePath();
        String patternId = this.getPattern(bitmapId, matrix, colorTransform);
        if (patternId != null) {
            this.path.setAttribute("style", "fill:url(#" + patternId + ")");
            return;
        }
        this.path.setAttribute("fill", "#ff0000");
    }

    @Override
    public void lineStyle(double thickness, RGB color, boolean pixelHinting, String scaleMode, int startCaps, int endCaps, int joints, float miterLimit) {
        this.finalizePath();
        thickness *= this.zoom / 20.0;
        this.path.setAttribute("fill", "none");
        if (color != null) {
            this.path.setAttribute("stroke", color.toHexRGB());
        }
        this.path.setAttribute("stroke-width", Double.toString(thickness == 0.0 ? 1.0 : thickness));
        if (color instanceof RGBA) {
            RGBA colorA = (RGBA)color;
            if (colorA.alpha != 255) {
                this.path.setAttribute("stroke-opacity", Float.toString(colorA.getAlphaFloat()));
            }
        }
        switch (startCaps) {
            case 1: {
                this.path.setAttribute("stroke-linecap", "butt");
                break;
            }
            case 2: {
                this.path.setAttribute("stroke-linecap", "square");
                break;
            }
            default: {
                this.path.setAttribute("stroke-linecap", "round");
            }
        }
        switch (joints) {
            case 1: {
                this.path.setAttribute("stroke-linejoin", "bevel");
                break;
            }
            case 0: {
                this.path.setAttribute("stroke-linejoin", "round");
                break;
            }
            default: {
                this.path.setAttribute("stroke-linejoin", "miter-clip");
                if (!(miterLimit >= 1.0f)) break;
                this.path.setAttribute("stroke-miterlimit", Double.toString(miterLimit));
            }
        }
    }

    @Override
    public void lineGradientStyle(int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        this.path.removeAttribute("stroke-opacity");
        Element gradient = type == 16 ? this.exporter.createElement("linearGradient") : this.exporter.createElement("radialGradient");
        this.populateGradientElement(gradient, type, gradientRecords, matrix, spreadMethod, interpolationMethod, focalPointRatio);
        int id = this.exporter.gradients.indexOf(gradient);
        if (id < 0) {
            id = this.exporter.gradients.size();
            this.exporter.gradients.add(gradient);
        }
        gradient.setAttribute("id", "gradient" + id);
        this.path.setAttribute("stroke", "url(#gradient" + id + ")");
        this.path.setAttribute("fill", "none");
        this.exporter.addToDefs(gradient);
    }

    @Override
    public void lineBitmapStyle(int bitmapId, Matrix matrix, boolean repeat, boolean smooth, ColorTransform colorTransform) {
        String patternId = this.getPattern(bitmapId, matrix, colorTransform);
        if (patternId != null) {
            this.path.setAttribute("stroke", "url(#" + patternId + ")");
            return;
        }
    }

    @Override
    protected void finalizePath() {
        if (this.path != null && this.pathData != null && this.pathData.length() > 0) {
            this.path.setAttribute("d", this.pathData.toString().trim());
            this.exporter.addToGroup(this.path);
        }
        this.path = this.exporter.createElement("path");
        super.finalizePath();
    }

    protected void populateGradientElement(Element gradient, int type, GRADRECORD[] gradientRecords, Matrix matrix, int spreadMethod, int interpolationMethod, float focalPointRatio) {
        gradient.setAttribute("gradientUnits", "userSpaceOnUse");
        if (type == 16) {
            gradient.setAttribute("x1", "-819.2");
            gradient.setAttribute("x2", "819.2");
        } else {
            gradient.setAttribute("r", "819.2");
            gradient.setAttribute("cx", "0");
            gradient.setAttribute("cy", "0");
            if (focalPointRatio != 0.0f) {
                gradient.setAttribute("fx", Double.toString(819.2 * (double)focalPointRatio));
                gradient.setAttribute("fy", "0");
            }
        }
        switch (spreadMethod) {
            case 0: {
                gradient.setAttribute("spreadMethod", "pad");
                break;
            }
            case 1: {
                gradient.setAttribute("spreadMethod", "reflect");
                break;
            }
            case 2: {
                gradient.setAttribute("spreadMethod", "repeat");
            }
        }
        if (interpolationMethod == 1) {
            gradient.setAttribute("color-interpolation", "linearRGB");
        }
        if (matrix != null) {
            gradient.setAttribute("gradientTransform", matrix.getSvgTransformationString(20.0 / this.zoom, 1.0));
        }
        for (int i = 0; i < gradientRecords.length; ++i) {
            GRADRECORD record = gradientRecords[i];
            Element gradientEntry = this.exporter.createElement("stop");
            gradientEntry.setAttribute("offset", Double.toString((double)record.ratio / 255.0));
            RGB color = record.color;
            gradientEntry.setAttribute("stop-color", color.toHexRGB());
            if (color instanceof RGBA) {
                RGBA colorA = (RGBA)color;
                if (colorA.alpha != 255) {
                    gradientEntry.setAttribute("stop-opacity", Float.toString(colorA.getAlphaFloat()));
                }
            }
            gradient.appendChild(gradientEntry);
        }
    }
}

