/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.ecma;

import com.jpexs.decompiler.flash.action.swf4.ConstantIndex;
import com.jpexs.decompiler.flash.ecma.EcmaNumberToString;
import com.jpexs.decompiler.flash.ecma.EcmaType;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.ObjectType;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class EcmaScript {
    public static Double toNumber(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o == Undefined.INSTANCE) {
            return Double.NaN;
        }
        if (o == Null.INSTANCE) {
            return 0.0;
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1.0 : 0.0;
        }
        if (o instanceof Float) {
            o = (double)((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Long) {
            return (double)((Long)o);
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        if (o instanceof String) {
            String str = (String)o;
            if (str.isEmpty()) {
                return 0.0;
            }
            try {
                return Double.parseDouble(str);
            }
            catch (NumberFormatException nfe) {
                return Double.NaN;
            }
        }
        return EcmaScript.toNumber(EcmaScript.toPrimitive(o, "Number"));
    }

    public static Object toPrimitive(Object o, String prefferedType) {
        if (o == Undefined.INSTANCE) {
            return o;
        }
        if (o == Null.INSTANCE) {
            return o;
        }
        if (o == Boolean.TRUE || o == Boolean.FALSE) {
            return o;
        }
        if (o instanceof Number) {
            return o;
        }
        if (o instanceof String) {
            return o;
        }
        if (o instanceof ObjectType) {
            return EcmaScript.object_defaultValue((ObjectType)o, prefferedType);
        }
        return Undefined.INSTANCE;
    }

    public static Object object_defaultValue(ObjectType o) {
        return EcmaScript.object_defaultValue(o, "Number");
    }

    public static Object object_get(ObjectType o, String p) {
        return EcmaScript.object_getProperty(o, p);
    }

    public static Object object_getProperty(ObjectType o, String p) {
        return o.getAttribute(p);
    }

    public static Object object_defaultValue(ObjectType o, String hint) {
        switch (hint) {
            case "String": {
                return o.call("toString", new ArrayList<Object>());
            }
            case "Number": {
                return o.call("valueOf", new ArrayList<Object>());
            }
        }
        return o.toPrimitive();
    }

    public static Double toNumberAs2(Object o) {
        if (o == Null.INSTANCE) {
            return Double.NaN;
        }
        if (o instanceof String && ((String)o).isEmpty()) {
            return Double.NaN;
        }
        return EcmaScript.toNumber(o);
    }

    public static EcmaType type(Object o) {
        if (o == null) {
            return EcmaType.NULL;
        }
        if (o.getClass() == String.class) {
            return EcmaType.STRING;
        }
        if (o.getClass() == Integer.class) {
            return EcmaType.NUMBER;
        }
        if (o.getClass() == Double.class) {
            return EcmaType.NUMBER;
        }
        if (o.getClass() == Long.class) {
            return EcmaType.NUMBER;
        }
        if (o.getClass() == Boolean.class) {
            return EcmaType.BOOLEAN;
        }
        if (o.getClass() == Null.class) {
            return EcmaType.NULL;
        }
        if (o.getClass() == Undefined.class) {
            return EcmaType.UNDEFINED;
        }
        return EcmaType.OBJECT;
    }

    public static String typeString(Object o) {
        String typeStr;
        EcmaType type = EcmaScript.type(o);
        switch (type) {
            case STRING: {
                typeStr = "string";
                break;
            }
            case BOOLEAN: {
                typeStr = "boolean";
                break;
            }
            case NUMBER: {
                typeStr = "number";
                break;
            }
            case OBJECT: {
                typeStr = "object";
                break;
            }
            case UNDEFINED: {
                typeStr = "undefined";
                break;
            }
            case NULL: {
                typeStr = "object";
                break;
            }
            default: {
                typeStr = "object";
            }
        }
        return typeStr;
    }

    public static Object compare(Object x, Object y) {
        return EcmaScript.compare(x, y, false);
    }

    public static Object compare(Object x, Object y, boolean as2) {
        Object px = x;
        Object py = y;
        if (EcmaScript.type(px) != EcmaType.STRING || EcmaScript.type(py) != EcmaType.STRING) {
            Double ny;
            Double nx = as2 ? EcmaScript.toNumberAs2(px) : EcmaScript.toNumber(px);
            Double d = ny = as2 ? EcmaScript.toNumberAs2(py) : EcmaScript.toNumber(py);
            if (nx.isNaN() || ny.isNaN()) {
                return Undefined.INSTANCE;
            }
            if (nx.compareTo(ny) == 0) {
                return 0;
            }
            if (Double.compare(nx, -0.0) == 0 && Double.compare(ny, 0.0) == 0) {
                return 0;
            }
            if (Double.compare(nx, 0.0) == 0 && Double.compare(ny, -0.0) == 0) {
                return 0;
            }
            if (nx.isInfinite() && nx > 0.0) {
                return 1;
            }
            if (ny.isInfinite() && ny > 0.0) {
                return -1;
            }
            if (nx.isInfinite() && nx < 0.0) {
                return 1;
            }
            if (ny.isInfinite() && ny < 0.0) {
                return -1;
            }
            if (nx.compareTo(ny) < 0) {
                return -1;
            }
            return 1;
        }
        String sx = (String)px;
        String sy = (String)py;
        if (sx.equals(sy)) {
            return 0;
        }
        if (as2) {
            if (sx.isEmpty()) {
                return 1;
            }
            if (sy.isEmpty()) {
                return -1;
            }
        }
        if (sx.startsWith(sy)) {
            return 1;
        }
        if (sy.startsWith(sx)) {
            return -1;
        }
        int len = sx.length() > sy.length() ? sx.length() : sy.length();
        for (int k = 0; k < len; ++k) {
            char m = '\u0000';
            char n = '\u0000';
            if (sx.length() > k) {
                m = sx.charAt(k);
            }
            if (sy.length() > k) {
                n = sy.charAt(k);
            }
            if (m == n) continue;
            if (m < n) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static boolean strictEquals(Object x, Object y) {
        return EcmaScript.strictEquals(false, x, y);
    }

    public static boolean equals(Object x, Object y) {
        return EcmaScript.equals(false, x, y);
    }

    public static boolean strictEquals(boolean as2, Object x, Object y) {
        if (EcmaScript.type(x) != EcmaScript.type(y)) {
            return false;
        }
        return EcmaScript.equals(as2, x, y);
    }

    public static boolean equals(boolean as2, Object x, Object y) {
        EcmaType typeY;
        EcmaType typeX = EcmaScript.type(x);
        if (typeX == (typeY = EcmaScript.type(y))) {
            if (typeX == null) {
                return true;
            }
            if (typeX == EcmaType.NULL) {
                return true;
            }
            if (typeX == EcmaType.UNDEFINED) {
                return true;
            }
            if (typeX == EcmaType.NUMBER) {
                if (x instanceof Integer) {
                    x = (double)((Integer)x).intValue();
                }
                if (x instanceof Long) {
                    x = (double)((Long)x).longValue();
                }
                if (y instanceof Integer) {
                    y = (double)((Integer)y).intValue();
                }
                if (y instanceof Long) {
                    y = (double)((Long)y).longValue();
                }
                if (((Double)x).isNaN()) {
                    return false;
                }
                if (((Double)y).isNaN()) {
                    return false;
                }
                if (((Double)x).compareTo((Double)y) == 0) {
                    return true;
                }
                if (Double.compare((Double)x, -0.0) == 0 && Double.compare((Double)y, 0.0) == 0) {
                    return true;
                }
                return Double.compare((Double)x, 0.0) == 0 && Double.compare((Double)y, -0.0) == 0;
            }
            if (typeX == EcmaType.STRING) {
                return ((String)x).equals((String)y);
            }
            if (typeX == EcmaType.BOOLEAN) {
                return x == y;
            }
            return x == y;
        }
        if (typeX == EcmaType.NULL && typeY == EcmaType.UNDEFINED) {
            return true;
        }
        if (typeX == EcmaType.UNDEFINED && typeY == EcmaType.NULL) {
            return true;
        }
        if (typeX == EcmaType.NUMBER && typeY == EcmaType.STRING) {
            return EcmaScript.equals(as2, x, as2 ? EcmaScript.toNumberAs2(y) : EcmaScript.toNumber(y));
        }
        if (typeX == EcmaType.STRING && typeY == EcmaType.NUMBER) {
            return EcmaScript.equals(as2, as2 ? EcmaScript.toNumberAs2(x) : EcmaScript.toNumber(x), y);
        }
        if (typeX == EcmaType.BOOLEAN) {
            return EcmaScript.equals(as2, as2 ? EcmaScript.toNumberAs2(x) : EcmaScript.toNumber(x), y);
        }
        if (typeY == EcmaType.BOOLEAN) {
            return EcmaScript.equals(as2, x, as2 ? EcmaScript.toNumberAs2(y) : EcmaScript.toNumber(y));
        }
        if (typeX == EcmaType.STRING || typeX == EcmaType.NUMBER) {
            // empty if block
        }
        if (typeY == EcmaType.STRING || typeY == EcmaType.NUMBER) {
            // empty if block
        }
        return false;
    }

    public static boolean toBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o == Undefined.INSTANCE) {
            return false;
        }
        if (o == Null.INSTANCE) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Long) {
            return (Long)o != 0L;
        }
        if (o instanceof Integer) {
            return (Integer)o != 0;
        }
        if (o instanceof Float) {
            o = (double)((Float)o).floatValue();
        }
        if (o instanceof Double) {
            Double d = (Double)o;
            if (d.isNaN()) {
                return false;
            }
            return Double.compare(d, 0.0) != 0;
        }
        if (o instanceof String) {
            String s = (String)o;
            return !s.isEmpty();
        }
        return true;
    }

    public static int toInt32(Object o) {
        return (int)EcmaScript.toUint32(o);
    }

    public static long toUint32(Object o) {
        Double n = EcmaScript.toNumber(o);
        if (n.isNaN()) {
            return 0L;
        }
        if (Double.compare(n, 0.0) == 0) {
            return 0L;
        }
        if (Double.compare(n, -0.0) == 0) {
            return 0L;
        }
        if (Double.isInfinite(n)) {
            return 0L;
        }
        long posInt = (long)(Math.signum(n) * Math.floor(Math.abs(n)));
        return posInt &= 0xFFFFFFFFL;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            double dn = n.doubleValue();
            if ((double)((int)dn) == dn) {
                return Integer.toString((int)dn);
            }
            if (dn == Double.POSITIVE_INFINITY) {
                return "Infinity";
            }
            if (dn == Double.NEGATIVE_INFINITY) {
                return "-Infinity";
            }
            if (Double.isNaN(dn)) {
                return "NaN";
            }
            return EcmaNumberToString.stringFor(dn);
        }
        return o.toString();
    }

    public static String toString(Object o, List<String> constantPool) {
        if (o instanceof ConstantIndex) {
            int index = ((ConstantIndex)o).index;
            if (constantPool != null && index < constantPool.size()) {
                return constantPool.get(index);
            }
        }
        return EcmaScript.toString(o);
    }

    public static Double parseFloat(Object string) {
        String inputString = EcmaScript.toString(string);
        String trimmedString = "";
        for (int startPos = 0; startPos < inputString.length(); ++startPos) {
            char c = inputString.charAt(startPos);
            if (Character.isWhitespace(c)) continue;
            trimmedString = inputString.substring(startPos);
            break;
        }
        try {
            return Double.parseDouble(trimmedString);
        }
        catch (NumberFormatException nfe) {
            return Double.NaN;
        }
    }

    public static Boolean isNaN(Object number) {
        return Double.isNaN(EcmaScript.toNumber(number));
    }

    public static Boolean isFinite(Object number) {
        return Double.isFinite(EcmaScript.toNumber(number));
    }

    public static Object parseInt(Object string, Object radix) {
        String inputString = EcmaScript.toString(string);
        String s = "";
        for (int startPos = 0; startPos < inputString.length(); ++startPos) {
            char c = inputString.charAt(startPos);
            if (Character.isWhitespace(c)) continue;
            s = inputString.substring(startPos);
            break;
        }
        int sign = 1;
        if (!s.isEmpty() && s.charAt(0) == '-') {
            sign = -1;
        }
        if (!(s.isEmpty() || s.charAt(0) != '+' && s.charAt(0) != '-')) {
            s = s.substring(1);
        }
        int r = EcmaScript.toInt32(radix);
        boolean stripPrefix = true;
        if (r != 0) {
            if (r < 2 || r > 36) {
                return Double.NaN;
            }
            if (r != 16) {
                stripPrefix = false;
            }
        } else {
            r = 10;
        }
        if (stripPrefix && s.length() >= 2 && s.substring(0, 2).toLowerCase().equals("0x")) {
            s = s.substring(2);
            r = 16;
        }
        String allDigits = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String allowedDigits = allDigits.substring(0, r);
        String z = s;
        for (int i = 0; i < s.length(); ++i) {
            if (!("" + s.charAt(i)).matches("[" + allowedDigits + "]")) continue;
            if (i == 0) {
                z = "";
                break;
            }
            z = s.substring(0, i);
            break;
        }
        if (z.isEmpty()) {
            return Double.NaN;
        }
        Long number = Long.parseLong(z, r);
        return (long)sign * number;
    }

    private static char toHex(int ch) {
        return (char)(ch < 10 ? 48 + ch : 65 + ch - 10);
    }

    private static String simpleCustomEncode(String input, String additionalValidChars) {
        String alphas = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String num = "0123456789";
        String alphaCases = alphas + alphas.toLowerCase();
        String alphanum = alphaCases + num;
        return EcmaScript.customEncode(input, alphanum + additionalValidChars);
    }

    private static String simpleCustomDecode(String input, String additionalValidChars) {
        String alphas = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        String num = "0123456789";
        String alphaCases = alphas + alphas.toLowerCase();
        String alphanum = alphaCases + num;
        return EcmaScript.customDecode(input, alphanum + additionalValidChars);
    }

    private static String customEncode(String input, String validChars) {
        StringBuilder resultStr = new StringBuilder();
        for (char ch : input.toCharArray()) {
            if (!validChars.contains("" + ch)) {
                resultStr.append('%');
                resultStr.append(EcmaScript.toHex(ch / 16));
                resultStr.append(EcmaScript.toHex(ch % 16));
                continue;
            }
            resultStr.append(ch);
        }
        return resultStr.toString();
    }

    private static String customDecode(String input, String reservedSet) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch != '%' || i + 2 >= input.length()) continue;
            try {
                int k;
                int b = Integer.parseInt(input.substring(k + 1, k + 2 + 1), 16);
                int msb = b >> 15 & 1;
                if (msb == 0) {
                    char c = (char)b;
                    if (!reservedSet.contains("" + c)) {
                        baos.write(c);
                        continue;
                    }
                    baos.write(Utf8Helper.getBytes(input.substring(k, k + 3)));
                    continue;
                }
                for (k = i; msb == 1 && k < input.length() && input.charAt(k) == '%'; k += 3) {
                    b = Integer.parseInt(input.substring(k + 1, k + 2 + 1), 16);
                    msb = b >> 15 & 1;
                    baos.write(b);
                }
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            return baos.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public static String encodeUriComponent(Object s) {
        return EcmaScript.simpleCustomEncode(EcmaScript.toString(s), "-_.!~*'()");
    }

    public static String encodeUri(Object s) {
        return EcmaScript.simpleCustomEncode(EcmaScript.toString(s), ";/?:@&=+$,#-_.!~*'()");
    }

    public static String escape(Object s) {
        return EcmaScript.simpleCustomEncode(EcmaScript.toString(s), "@-_.*+/");
    }

    public static String decodeUriComponent(Object s) {
        return EcmaScript.simpleCustomDecode(EcmaScript.toString(s), "-_.!~*'()");
    }

    public static String decodeUri(Object s) {
        return EcmaScript.simpleCustomDecode(EcmaScript.toString(s), ";/?:@&=+$,#-_.!~*'()");
    }

    public static String unescape(Object s) {
        return EcmaScript.simpleCustomDecode(EcmaScript.toString(s), "@-_.*+/");
    }
}

