/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.cache;

import com.jpexs.decompiler.flash.action.ActionList;
import com.jpexs.decompiler.flash.helpers.HighlightedText;
import com.jpexs.decompiler.flash.tags.base.ASMSource;
import com.jpexs.helpers.Cache;

public class AS2Cache {
    private final Cache<ASMSource, HighlightedText> cache = Cache.getInstance(true, false, "as2");
    private final Cache<ASMSource, ActionList> pcodeCache = Cache.getInstance(true, true, "as2pcode");

    public void clear() {
        this.pcodeCache.clear();
        this.cache.clear();
    }

    public boolean isCached(ASMSource src) {
        return this.cache.contains(src);
    }

    public boolean isPCodeCached(ASMSource src) {
        return this.pcodeCache.contains(src);
    }

    public HighlightedText get(ASMSource src) {
        return this.cache.get(src);
    }

    public ActionList getPCode(ASMSource src) {
        return this.pcodeCache.get(src);
    }

    public void put(ASMSource src, HighlightedText text) {
        this.cache.put(src, text);
    }

    public void put(ASMSource src, ActionList actionList) {
        this.pcodeCache.put(src, actionList);
    }

    public void remove(ASMSource src) {
        if (src != null) {
            this.cache.remove(src);
            this.pcodeCache.remove(src);
        }
    }
}

