/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model.clauses;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.SetMemberActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.collections.MyEntry;
import com.jpexs.decompiler.graph.Block;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.ContinueItem;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClassActionItem
extends ActionItem
implements Block {
    public GraphTargetItem extendsOp;
    public List<GraphTargetItem> implementsOp;
    public GraphTargetItem className;
    public List<MyEntry<GraphTargetItem, GraphTargetItem>> traits;
    public List<Boolean> traitsStatic;
    public Set<String> uninitializedVars;

    @Override
    public List<List<GraphTargetItem>> getSubs() {
        ArrayList<List<GraphTargetItem>> ret = new ArrayList<List<GraphTargetItem>>();
        return ret;
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
    }

    public ClassActionItem(GraphTargetItem className, GraphTargetItem extendsOp, List<GraphTargetItem> implementsOp, List<MyEntry<GraphTargetItem, GraphTargetItem>> traits, List<Boolean> traitsStatic) {
        super(null, null, 16);
        this.className = className;
        this.traits = traits;
        this.traitsStatic = traitsStatic;
        this.extendsOp = extendsOp;
        this.implementsOp = implementsOp;
        this.uninitializedVars = new HashSet<String>();
        ArrayList<GraphTargetItem> allUsages = new ArrayList<GraphTargetItem>();
        for (MyEntry<GraphTargetItem, GraphTargetItem> it : traits) {
            if (!(it.getValue() instanceof FunctionActionItem)) continue;
            FunctionActionItem functionActionItem = (FunctionActionItem)it.getValue();
            this.detectUnitializedVars(functionActionItem.actions, allUsages);
        }
        HashSet<String> allMembers = new HashSet<String>();
        for (GraphTargetItem graphTargetItem : allUsages) {
            allMembers.add(graphTargetItem.toStringNoQuotes(LocalData.empty));
        }
        this.uninitializedVars.addAll(allMembers);
        for (MyEntry myEntry : traits) {
            String s = ((GraphTargetItem)myEntry.getKey()).toStringNoQuotes(LocalData.empty);
            if (!this.uninitializedVars.contains(s)) continue;
            this.uninitializedVars.remove(s);
        }
    }

    private boolean isThis(GraphTargetItem item) {
        if (item instanceof VariableActionItem) {
            return "this".equals(((VariableActionItem)item).getVariableName());
        }
        return false;
    }

    private void detectUnitializedVars(GraphTargetItem item, List<GraphTargetItem> ret) {
        if (item == null) {
            return;
        }
        if (item instanceof GetMemberActionItem) {
            GetMemberActionItem gm = (GetMemberActionItem)item;
            if (this.isThis(gm.object)) {
                ret.add(gm.memberName);
            }
        }
        if (item instanceof SetMemberActionItem) {
            SetMemberActionItem sm = (SetMemberActionItem)item;
            if (this.isThis(sm.object)) {
                ret.add(sm.objectName);
            }
        }
        this.detectUnitializedVars(item.getAllSubItems(), ret);
    }

    private void detectUnitializedVars(List<GraphTargetItem> items, List<GraphTargetItem> ret) {
        for (GraphTargetItem it : items) {
            this.detectUnitializedVars(it, ret);
        }
    }

    private void makePrintObfuscated(GraphTargetItem item) {
        if (item == null) {
            return;
        }
        GraphTargetItem it = item;
        while (it instanceof GetMemberActionItem) {
            GetMemberActionItem m = (GetMemberActionItem)it;
            m.printObfuscatedMemberName = true;
            it = m.object;
        }
        if (it instanceof GetVariableActionItem) {
            GetVariableActionItem gv = (GetVariableActionItem)it;
            gv.printObfuscatedName = true;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        GraphTargetItem clsName = this.className;
        while (clsName instanceof GetMemberActionItem) {
            ((GetMemberActionItem)clsName).printObfuscatedMemberName = true;
            clsName = ((GetMemberActionItem)clsName).object;
        }
        if (clsName instanceof GetVariableActionItem) {
            ((GetVariableActionItem)clsName).printObfuscatedName = true;
        }
        this.makePrintObfuscated(this.extendsOp);
        for (GraphTargetItem graphTargetItem : this.implementsOp) {
            this.makePrintObfuscated(graphTargetItem);
        }
        writer.startClass(this.className.toStringNoQuotes(localData));
        writer.append("class ");
        this.className.toStringNoQuotes(writer, localData);
        if (this.extendsOp != null) {
            writer.append(" extends ");
            this.extendsOp.toStringNoQuotes(writer, localData);
        }
        if (!this.implementsOp.isEmpty()) {
            writer.append(" implements ");
            boolean first = true;
            for (GraphTargetItem t : this.implementsOp) {
                if (!first) {
                    writer.append(", ");
                }
                first = false;
                Action.getWithoutGlobal(t).toString(writer, localData);
            }
        }
        writer.startBlock();
        int pass = 1;
        while (true) {
            void var5_12;
            if (pass <= 2) {
                boolean bl = false;
            } else {
                Iterator<String> iterator = this.uninitializedVars.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        writer.endBlock();
                        writer.endClass();
                        return writer;
                    }
                    String string = iterator.next();
                    writer.append("var ");
                    writer.append(string);
                    writer.append(";").newLine();
                }
            }
            while (var5_12 < this.traits.size()) {
                block20: {
                    MyEntry<GraphTargetItem, GraphTargetItem> item = this.traits.get((int)var5_12);
                    switch (pass) {
                        case 1: {
                            if (!(item.getValue() instanceof FunctionActionItem)) break;
                            break block20;
                        }
                        case 2: {
                            if (!(item.getValue() instanceof FunctionActionItem)) break block20;
                        }
                    }
                    if (this.traitsStatic.get((int)var5_12).booleanValue()) {
                        writer.append("static ");
                    }
                    if (item.getValue() instanceof FunctionActionItem) {
                        item.getValue().toString(writer, localData).newLine();
                    } else {
                        writer.append("var ");
                        writer.append(IdentifiersDeobfuscation.printIdentifier(false, item.getKey().toStringNoQuotes(localData), new String[0]));
                        writer.append(" = ");
                        item.getValue().toString(writer, localData);
                        writer.append(";").newLine();
                    }
                }
                ++var5_12;
            }
            ++pass;
        }
    }

    @Override
    public List<ContinueItem> getContinues() {
        ArrayList<ContinueItem> ret = new ArrayList<ContinueItem>();
        return ret;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        SourceGeneratorLocalData localData2 = Helper.deepCopy(localData);
        asGenerator.setInMethod(localData2, true);
        ret.addAll(asGenerator.generateTraits(localData2, false, this.className, this.extendsOp, this.implementsOp, this.traits, this.traitsStatic));
        return ret;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }
}

