/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action.model;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.action.Action;
import com.jpexs.decompiler.flash.action.model.ActionItem;
import com.jpexs.decompiler.flash.action.model.DefineLocalActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.ReturnActionItem;
import com.jpexs.decompiler.flash.action.model.SetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.StoreRegisterActionItem;
import com.jpexs.decompiler.flash.action.parser.script.ActionSourceGenerator;
import com.jpexs.decompiler.flash.action.parser.script.VariableActionItem;
import com.jpexs.decompiler.flash.action.swf4.ActionPush;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.action.swf5.ActionDefineFunction;
import com.jpexs.decompiler.flash.action.swf7.ActionDefineFunction2;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.hilight.HighlightData;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.Graph;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphSourceItemPos;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.BranchStackResistant;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionActionItem
extends ActionItem
implements BranchStackResistant {
    public static final boolean DECOMPILE_GET_SET = true;
    public boolean isGetter = false;
    public boolean isSetter = false;
    public List<GraphTargetItem> actions;
    public List<String> constants;
    public String functionName;
    public List<String> paramNames;
    public Map<Integer, String> regNames;
    public GraphTargetItem calculatedFunctionName;
    public boolean hasEval = false;
    private int regStart;
    private List<VariableActionItem> variables;
    private List<FunctionActionItem> innerFunctions;
    public static final int REGISTER_THIS = 1;
    public static final int REGISTER_ARGUMENTS = 2;
    public static final int REGISTER_SUPER = 3;
    public static final int REGISTER_ROOT = 4;
    public static final int REGISTER_PARENT = 5;
    public static final int REGISTER_GLOBAL = 6;

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visitAll(this.actions);
    }

    @Override
    public void visitNoBlock(GraphTargetVisitorInterface visitor) {
    }

    public void addVariable(VariableActionItem variable) {
        this.variables.add(variable);
    }

    public FunctionActionItem() {
        super(null, null, 0);
    }

    public FunctionActionItem(GraphSourceItem instruction, GraphSourceItem lineStartIns, String functionName, List<String> paramNames, Map<Integer, String> regNames, List<GraphTargetItem> actions, List<String> constants, int regStart, List<VariableActionItem> variables, List<FunctionActionItem> innerFunctions, boolean hasEval) {
        super(instruction, lineStartIns, 0);
        this.actions = actions;
        this.constants = constants;
        this.functionName = functionName;
        this.paramNames = paramNames;
        this.regNames = regNames;
        this.regStart = regStart;
        this.variables = variables;
        this.innerFunctions = innerFunctions;
        this.hasEval = hasEval;
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        String fname;
        String n = this.calculatedFunctionName != null ? this.calculatedFunctionName.toStringNoQuotes(localData) : this.functionName;
        writer.startFunction(n);
        HighlightData srcData = this.getSrcData();
        if (n != null) {
            srcData.localName = n;
            srcData.declaration = true;
        }
        writer.append("function");
        if (this.isGetter) {
            writer.append(" get");
        }
        if (this.isSetter) {
            writer.append(" set");
        }
        if (this.calculatedFunctionName != null) {
            writer.append(" ");
            fname = this.calculatedFunctionName.toStringNoQuotes(localData);
            if (this.isGetter && fname.startsWith("__get__")) {
                fname = fname.substring(7);
            }
            if (this.isSetter && fname.startsWith("__set__")) {
                fname = fname.substring(7);
            }
            if (!IdentifiersDeobfuscation.isValidName(false, fname, new String[0])) {
                IdentifiersDeobfuscation.appendObfuscatedIdentifier(fname, writer);
            } else {
                writer.append(fname);
            }
        } else if (!this.functionName.isEmpty()) {
            fname = this.functionName;
            if (this.isGetter && fname.startsWith("__get__")) {
                fname = fname.substring(7);
            }
            if (this.isSetter && fname.startsWith("__set__")) {
                fname = fname.substring(7);
            }
            writer.append(" ");
            if (!IdentifiersDeobfuscation.isValidName(false, fname, new String[0])) {
                IdentifiersDeobfuscation.appendObfuscatedIdentifier(fname, writer);
            } else {
                writer.append(fname);
            }
        }
        writer.spaceBeforeCallParenthesies(this.paramNames.size());
        writer.append("(");
        HashMap<String, Integer> n2r = new HashMap<String, Integer>();
        for (int r : this.regNames.keySet()) {
            n2r.put(this.regNames.get(r), r);
        }
        for (int p = 0; p < this.paramNames.size(); ++p) {
            String pname;
            if (p > 0) {
                writer.append(", ");
            }
            if ((pname = this.paramNames.get(p)) == null || pname.isEmpty()) {
                pname = new RegisterNumber(this.regStart + p).translate();
            }
            HighlightData d = this.getSrcData();
            d.localName = pname;
            if (n2r.containsKey(pname)) {
                d.regIndex = (Integer)n2r.get(pname);
            }
            d.declaration = true;
            if (!IdentifiersDeobfuscation.isValidName(false, pname, new String[0])) {
                IdentifiersDeobfuscation.appendObfuscatedIdentifier(pname, writer);
                continue;
            }
            writer.append(pname);
        }
        writer.append(")").startBlock();
        Graph.graphToString(this.actions, writer, localData);
        writer.endBlock();
        writer.endMethod();
        return writer;
    }

    @Override
    public List<GraphSourceItemPos> getNeededSources() {
        List<GraphSourceItemPos> ret = super.getNeededSources();
        for (GraphTargetItem ti : this.actions) {
            ret.addAll(ti.getNeededSources());
        }
        return ret;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        for (GraphTargetItem a : this.actions) {
            if (dependencies.contains(a)) {
                return false;
            }
            dependencies.add(a);
            if (a.isCompileTime(dependencies)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getResult() {
        if (!this.actions.isEmpty() && this.actions.get(this.actions.size() - 1) instanceof ReturnActionItem) {
            ReturnActionItem r = (ReturnActionItem)this.actions.get(this.actions.size() - 1);
            return r.value.getResult();
        }
        return 0;
    }

    @Override
    public boolean needsNewLine() {
        return true;
    }

    private Set<String> getDefinedVariableNames(List<VariableActionItem> variables) {
        HashSet<String> ret = new HashSet<String>();
        for (VariableActionItem v : variables) {
            if (!v.isDefinition()) continue;
            ret.add(v.getVariableName());
        }
        return ret;
    }

    private void getDeeplyUsedVariableNames(Set<String> topLevelDefinedVariableNames, FunctionActionItem fun, Set<String> deeplyUsedVariableNames) {
        Set<String> definedVarNamesInFunc = this.getDefinedVariableNames(fun.variables);
        for (VariableActionItem v : fun.variables) {
            if (v.isDefinition() || definedVarNamesInFunc.contains(v.getVariableName()) || !topLevelDefinedVariableNames.contains(v.getVariableName())) continue;
            deeplyUsedVariableNames.add(v.getVariableName());
        }
        for (FunctionActionItem innerFun : fun.innerFunctions) {
            this.getDeeplyUsedVariableNames(topLevelDefinedVariableNames, innerFun, deeplyUsedVariableNames);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        void var22_33;
        SourceGeneratorLocalData localDataCopy;
        HashSet<String> usedNames = new HashSet<String>();
        for (VariableActionItem v : this.variables) {
            usedNames.add(v.getVariableName());
        }
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ActionSourceGenerator asGenerator = (ActionSourceGenerator)generator;
        ArrayList<Integer> paramRegs = new ArrayList<Integer>();
        SourceGeneratorLocalData sourceGeneratorLocalData = localDataCopy = Helper.deepCopy(localData);
        Integer n = sourceGeneratorLocalData.inFunction;
        Integer n2 = sourceGeneratorLocalData.inFunction = Integer.valueOf(sourceGeneratorLocalData.inFunction + 1);
        boolean preloadParentFlag = false;
        boolean preloadRootFlag = false;
        boolean preloadSuperFlag = false;
        boolean preloadArgumentsFlag = false;
        boolean preloadThisFlag = false;
        boolean preloadGlobalFlag = false;
        boolean suppressSuperFlag = false;
        boolean suppressArgumentsFlag = false;
        boolean suppressThisFlag = false;
        boolean needsFun2 = false;
        ArrayList<String> registerNames = new ArrayList<String>();
        registerNames.add("***** ZERO *****");
        if (usedNames.contains("this")) {
            needsFun2 = true;
            preloadThisFlag = true;
            registerNames.add("this");
        } else {
            suppressThisFlag = true;
        }
        if (usedNames.contains("arguments")) {
            preloadArgumentsFlag = true;
            needsFun2 = true;
            registerNames.add("arguments");
        } else {
            suppressArgumentsFlag = true;
        }
        if (usedNames.contains("super")) {
            preloadSuperFlag = true;
            needsFun2 = true;
            registerNames.add("super");
        } else {
            suppressSuperFlag = true;
        }
        if (usedNames.contains("_root")) {
            preloadRootFlag = true;
            needsFun2 = true;
            registerNames.add("_root");
        }
        if (usedNames.contains("_parent")) {
            preloadParentFlag = true;
            needsFun2 = true;
            registerNames.add("_parent");
        }
        if (usedNames.contains("_global")) {
            needsFun2 = true;
            preloadGlobalFlag = true;
            registerNames.add("_global");
        }
        int preloadedNumber = registerNames.size();
        if (!this.paramNames.isEmpty()) {
            needsFun2 = true;
        }
        if (localData.inMethod.booleanValue()) {
            // empty if block
        }
        if (localData.inFunction > 1) {
            needsFun2 = true;
        }
        HashSet<String> topLevelVariableNames = new HashSet<String>();
        for (VariableActionItem variableActionItem : this.variables) {
            if (!variableActionItem.isDefinition()) continue;
            topLevelVariableNames.add(variableActionItem.getVariableName());
        }
        for (String string : this.paramNames) {
            topLevelVariableNames.add(string);
        }
        HashSet<String> deeplyUsedVariableNames = new HashSet<String>();
        for (FunctionActionItem functionActionItem : this.innerFunctions) {
            this.getDeeplyUsedVariableNames(topLevelVariableNames, functionActionItem, deeplyUsedVariableNames);
        }
        if (needsFun2) {
            void var22_30;
            boolean bl = false;
            while (var22_30 < this.paramNames.size()) {
                if (deeplyUsedVariableNames.contains(this.paramNames.get((int)var22_30))) {
                    paramRegs.add(0);
                } else {
                    paramRegs.add(registerNames.size());
                    registerNames.add(this.paramNames.get((int)var22_30));
                }
                ++var22_30;
            }
        }
        boolean bl = false;
        if (this.actions != null && !this.actions.isEmpty()) {
            void var23_38;
            SourceGeneratorLocalData sourceGeneratorLocalData2 = localDataCopy;
            Integer n3 = sourceGeneratorLocalData2.inFunction;
            Integer n4 = sourceGeneratorLocalData2.inFunction = Integer.valueOf(sourceGeneratorLocalData2.inFunction + 1);
            for (VariableActionItem v : this.variables) {
                String varName = v.getVariableName();
                GraphTargetItem stored = v.getStoreValue();
                if (needsFun2 && v.isDefinition() && !registerNames.contains(varName) && !deeplyUsedVariableNames.contains(varName) && !this.hasEval) {
                    registerNames.add(varName);
                }
                if (registerNames.contains(varName)) {
                    if (stored != null) {
                        v.setBoxedValue(new StoreRegisterActionItem(null, null, new RegisterNumber(registerNames.indexOf(varName), varName), stored, false));
                        continue;
                    }
                    v.setBoxedValue(new DirectValueActionItem(new RegisterNumber(registerNames.indexOf(varName), varName)));
                    continue;
                }
                if (v.isDefinition()) {
                    v.setBoxedValue(new DefineLocalActionItem(null, null, ((ActionSourceGenerator)generator).pushConstTargetItem(varName), stored));
                    continue;
                }
                if (stored != null) {
                    v.setBoxedValue(new SetVariableActionItem(null, null, ((ActionSourceGenerator)generator).pushConstTargetItem(varName), stored));
                    continue;
                }
                v.setBoxedValue(new GetVariableActionItem(null, null, ((ActionSourceGenerator)generator).pushConstTargetItem(varName)));
            }
            boolean bl2 = true;
            while (var23_38 < registerNames.size()) {
                localDataCopy.registerVars.put((String)registerNames.get((int)var23_38), (int)var23_38);
                ++var23_38;
            }
            ret.addAll(asGenerator.toActionList(asGenerator.generate(localDataCopy, this.actions)));
            int n5 = registerNames.size();
            for (GraphSourceItem a : ret) {
                if (!(a instanceof ActionPush)) continue;
                ActionPush apu = (ActionPush)a;
                for (Object o : apu.values) {
                    if (!(o instanceof RegisterNumber)) continue;
                    RegisterNumber rn = (RegisterNumber)o;
                    if (rn.number < var22_33) continue;
                    ++var22_33;
                }
            }
        }
        int n6 = Action.actionsToBytes(asGenerator.toActionList(ret), false, 10).length;
        if (!needsFun2 && this.paramNames.isEmpty()) {
            ret.add(0, new ActionDefineFunction(this.functionName, this.paramNames, n6, 10));
        } else {
            ret.add(0, new ActionDefineFunction2(this.functionName, preloadParentFlag, preloadRootFlag, suppressSuperFlag, preloadSuperFlag, suppressArgumentsFlag, preloadArgumentsFlag, suppressThisFlag, preloadThisFlag, preloadGlobalFlag, (int)var22_33, n6, 10, this.paramNames, paramRegs));
        }
        return ret;
    }

    @Override
    public boolean hasReturnValue() {
        return false;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

