/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.action;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.action.model.CallFunctionActionItem;
import com.jpexs.decompiler.flash.action.model.CallMethodActionItem;
import com.jpexs.decompiler.flash.action.model.DirectValueActionItem;
import com.jpexs.decompiler.flash.action.model.ExtendsActionItem;
import com.jpexs.decompiler.flash.action.model.FunctionActionItem;
import com.jpexs.decompiler.flash.action.model.GetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.GetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.ImplementsOpActionItem;
import com.jpexs.decompiler.flash.action.model.NewMethodActionItem;
import com.jpexs.decompiler.flash.action.model.NewObjectActionItem;
import com.jpexs.decompiler.flash.action.model.ReturnActionItem;
import com.jpexs.decompiler.flash.action.model.SetMemberActionItem;
import com.jpexs.decompiler.flash.action.model.SetVariableActionItem;
import com.jpexs.decompiler.flash.action.model.StoreRegisterActionItem;
import com.jpexs.decompiler.flash.action.model.TemporaryRegister;
import com.jpexs.decompiler.flash.action.model.clauses.ClassActionItem;
import com.jpexs.decompiler.flash.action.model.clauses.InterfaceActionItem;
import com.jpexs.decompiler.flash.action.swf4.RegisterNumber;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.helpers.collections.MyEntry;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.model.CommaExpressionItem;
import com.jpexs.decompiler.graph.model.IfItem;
import com.jpexs.decompiler.graph.model.NotItem;
import com.jpexs.decompiler.graph.model.PopItem;
import com.jpexs.decompiler.graph.model.PushItem;
import com.jpexs.decompiler.graph.model.ScriptEndItem;
import com.jpexs.decompiler.graph.model.TernarOpItem;
import com.jpexs.helpers.Reference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActionScript2ClassDetector {
    private static final Logger logger = Logger.getLogger(ActionScript2ClassDetector.class.getName());

    private boolean isMemberOfPath(GraphTargetItem item, List<String> objectPath, Reference<String> newPathItem) {
        List<String> path = this.getMembersPath(item);
        if (path == null) {
            return false;
        }
        if (path.size() != objectPath.size() + 1) {
            return false;
        }
        for (int i = 0; i < objectPath.size(); ++i) {
            if (path.get(i).equals(objectPath.get(i))) continue;
            return false;
        }
        newPathItem.setVal(path.get(path.size() - 1));
        return true;
    }

    private List<String> getMembersPath(GraphTargetItem item) {
        DirectValueActionItem dv;
        ArrayList<String> ret = new ArrayList<String>();
        while (item instanceof GetMemberActionItem) {
            GetMemberActionItem mem = (GetMemberActionItem)item;
            if (!(mem.memberName instanceof DirectValueActionItem)) {
                return null;
            }
            dv = (DirectValueActionItem)mem.memberName;
            if (!dv.isString()) {
                return null;
            }
            ret.add(0, dv.getAsString());
            item = mem.object;
        }
        if (!(item instanceof GetVariableActionItem)) {
            return null;
        }
        GetVariableActionItem gv = (GetVariableActionItem)item;
        if (!(gv.name instanceof DirectValueActionItem)) {
            return null;
        }
        dv = (DirectValueActionItem)gv.name;
        if (!dv.isString()) {
            return null;
        }
        String varName = dv.getAsString();
        ret.add(0, varName);
        return ret;
    }

    private GraphTargetItem setMemberToGetMember(GraphTargetItem item) {
        if (item instanceof SetMemberActionItem) {
            return new GetMemberActionItem(null, null, ((SetMemberActionItem)item).object, ((SetMemberActionItem)item).objectName);
        }
        if (item instanceof SetVariableActionItem) {
            return new GetVariableActionItem(null, null, ((SetVariableActionItem)item).name);
        }
        return null;
    }

    private GraphTargetItem newToGetMember(GraphTargetItem nobj) throws AssertException {
        if (nobj instanceof NewMethodActionItem) {
            NewMethodActionItem nm = (NewMethodActionItem)nobj;
            return new GetMemberActionItem(nobj.getSrc(), nobj.getLineStartItem(), nm.scriptObject, nm.methodName);
        }
        if (nobj instanceof NewObjectActionItem) {
            NewObjectActionItem no = (NewObjectActionItem)nobj;
            return new GetVariableActionItem(nobj.getSrc(), nobj.getLineStartItem(), no.objectName);
        }
        throw new AssertException("NewMethod or NewObject expected");
    }

    private List<String> getSetMembersPath(GraphTargetItem item) {
        if (item instanceof SetVariableActionItem) {
            SetVariableActionItem sv = (SetVariableActionItem)item;
            if (!(sv.name instanceof DirectValueActionItem)) {
                return null;
            }
            DirectValueActionItem nDv = (DirectValueActionItem)sv.name;
            if (!nDv.isString()) {
                return null;
            }
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(nDv.getAsString());
            return ret;
        }
        if (item instanceof SetMemberActionItem) {
            SetMemberActionItem sm = (SetMemberActionItem)item;
            if (!(sm.objectName instanceof DirectValueActionItem)) {
                return null;
            }
            DirectValueActionItem onDv = (DirectValueActionItem)sm.objectName;
            if (!onDv.isString()) {
                return null;
            }
            String currentMemberName = onDv.getAsString();
            List<String> path = this.getMembersPath(sm.object);
            if (path == null) {
                return null;
            }
            path.add(currentMemberName);
            return path;
        }
        return null;
    }

    private int getAsRegisterNum(GraphTargetItem item, String assertName) throws AssertException {
        if (item instanceof DirectValueActionItem) {
            DirectValueActionItem dv = (DirectValueActionItem)item;
            if (dv.value instanceof RegisterNumber) {
                RegisterNumber rn = (RegisterNumber)dv.value;
                return rn.number;
            }
        }
        if (item instanceof TemporaryRegister) {
            TemporaryRegister tr = (TemporaryRegister)item;
            return tr.getRegId();
        }
        throw new AssertException("not a register - " + assertName);
    }

    private static GraphTargetItem getWithoutGlobal(GraphTargetItem ti) {
        GraphTargetItem t = ti;
        if (!(t instanceof GetMemberActionItem)) {
            return ti;
        }
        GetMemberActionItem lastMember = null;
        while (((GetMemberActionItem)t).object instanceof GetMemberActionItem) {
            lastMember = (GetMemberActionItem)t;
            t = ((GetMemberActionItem)t).object;
        }
        if (((GetMemberActionItem)t).object instanceof GetVariableActionItem) {
            GetVariableActionItem v = (GetVariableActionItem)((GetMemberActionItem)t).object;
            if (v.name instanceof DirectValueActionItem && ((DirectValueActionItem)v.name).value instanceof String && ((DirectValueActionItem)v.name).value.equals("_global")) {
                GetVariableActionItem gvt = new GetVariableActionItem(null, null, ((GetMemberActionItem)t).memberName);
                if (lastMember == null) {
                    return gvt;
                }
                lastMember.object = gvt;
            }
        }
        return ti;
    }

    private String getAsString(GraphTargetItem item, String itemName) throws AssertException {
        if (!(item instanceof DirectValueActionItem)) {
            throw new AssertException(itemName + " not DirectValue");
        }
        DirectValueActionItem mnDv = (DirectValueActionItem)item;
        if (!mnDv.isString()) {
            throw new AssertException(itemName + " not string");
        }
        return mnDv.getAsString();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkClassContent(List<GraphTargetItem> parts, HashMap<String, GraphTargetItem> variables, int partsPos, int commandsStartPos, int commandsEndPos, List<GraphTargetItem> commands, List<String> classNamePath, String scriptPath) {
        try {
            void var14_19;
            Object sr;
            GraphTargetItem extendsOp = null;
            List<GraphTargetItem> implementsOp = new ArrayList<GraphTargetItem>();
            GraphTargetItem item = null;
            int instanceReg = -1;
            int classReg = -1;
            Object var14_15 = null;
            GraphTargetItem constructor = null;
            Pattern regPattern = Pattern.compile("__register([0-9]+)");
            HashSet<Integer> definedRegisters = new HashSet<Integer>();
            for (int i = partsPos; i < parts.size(); ++i) {
                item = parts.get(i);
                if (!(item instanceof StoreRegisterActionItem)) continue;
                sr = (StoreRegisterActionItem)item;
                definedRegisters.add(((StoreRegisterActionItem)sr).register.number);
            }
            int numr = 0;
            for (String s : variables.keySet()) {
                int regId;
                Matcher m = regPattern.matcher(s);
                if (!m.matches() || !(variables.get(s) instanceof TemporaryRegister) || definedRegisters.contains(regId = Integer.parseInt(m.group(1)))) continue;
                parts.add(partsPos + numr, variables.get((Object)s).value);
                ++numr;
            }
            if (parts.size() > partsPos) {
                List<String> memPath;
                item = parts.get(partsPos);
                if (item instanceof SetMemberActionItem && (memPath = this.getSetMembersPath((SetMemberActionItem)item)) != null) {
                    if (memPath.get(0).equals("_global")) {
                        memPath.remove(0);
                    }
                    if (memPath.equals(classNamePath) && item.value instanceof StoreRegisterActionItem) {
                        constructor = item.value.value;
                        item = parts.size() > ++partsPos ? parts.get(partsPos) : null;
                    }
                }
                if (item instanceof ExtendsActionItem) {
                    ExtendsActionItem et = (ExtendsActionItem)parts.get(partsPos);
                    extendsOp = ActionScript2ClassDetector.getWithoutGlobal(et.superclass);
                    item = parts.size() > ++partsPos ? parts.get(partsPos) : null;
                }
                if (item instanceof SetMemberActionItem) {
                    SetMemberActionItem sm = (SetMemberActionItem)item;
                    ArrayList<String> protoPath = new ArrayList<String>(classNamePath);
                    protoPath.add("prototype");
                    List<String> smPath = this.getSetMembersPath(sm);
                    if (smPath.get(0).equals("_global")) {
                        smPath.remove(0);
                    }
                    if (smPath.equals(protoPath) && sm.value instanceof StoreRegisterActionItem) {
                        item = parts.size() > ++partsPos ? parts.get(partsPos) : null;
                    }
                }
                if (item instanceof StoreRegisterActionItem) {
                    sr = (StoreRegisterActionItem)item;
                    instanceReg = ((StoreRegisterActionItem)sr).register.number;
                    if (!(((StoreRegisterActionItem)sr).value instanceof GetMemberActionItem)) throw new AssertException("Not Getmember in StoreRegister");
                    GetMemberActionItem gm = (GetMemberActionItem)((StoreRegisterActionItem)sr).value;
                    if (!(gm.object instanceof TemporaryRegister)) throw new AssertException("Getmember does not have TemporaryRegister as object");
                    TemporaryRegister treg = (TemporaryRegister)gm.object;
                    classReg = treg.getRegId();
                    if (!"prototype".equals(this.getAsString(gm.memberName, "memberName"))) {
                        throw new AssertException("memberName not \"prototype\"");
                    }
                    if (!(treg.value instanceof SetMemberActionItem) && !(treg.value instanceof SetVariableActionItem)) throw new AssertException("temporaryreg value not setmember/setvariable");
                    List<String> path = this.getSetMembersPath(treg.value);
                    if (path == null || path.isEmpty()) {
                        throw new AssertException("Cannot detect class - tempreg value is not a path");
                    }
                    if ("_global".equals(path.get(0))) {
                        path.remove(0);
                    }
                    if (!classNamePath.equals(path)) throw new AssertException("temporaryreg value does not match class path");
                    GraphTargetItem graphTargetItem = ActionScript2ClassDetector.getWithoutGlobal(this.setMemberToGetMember(treg.value));
                    if (!(treg.value.value instanceof StoreRegisterActionItem)) {
                        throw new AssertException("Constructor expected to be in storeregister");
                    }
                    if (!(treg.value.value.value instanceof FunctionActionItem)) {
                        throw new AssertException("Constructor expected as functionitem");
                    }
                    constructor = treg.value.value.value;
                    ++partsPos;
                }
            }
            GetVariableActionItem getVariableActionItem = new GetVariableActionItem(null, null, new DirectValueActionItem(classNamePath.get(0)));
            for (int i = 1; i < classNamePath.size(); ++i) {
                GetMemberActionItem getMemberActionItem = new GetMemberActionItem(null, null, (GraphTargetItem)var14_19, (GraphTargetItem)new DirectValueActionItem(classNamePath.get(i)));
            }
            ArrayList<MyEntry<GraphTargetItem, GraphTargetItem>> traits = new ArrayList<MyEntry<GraphTargetItem, GraphTargetItem>>();
            ArrayList<Boolean> traitsStatic = new ArrayList<Boolean>();
            while (partsPos < parts.size()) {
                block77: {
                    block79: {
                        FunctionActionItem func;
                        String propertyNameStr;
                        GraphTargetItem propertySetter;
                        int rnumObject;
                        block82: {
                            GraphTargetItem propertyGetter;
                            block80: {
                                String getterNameStr;
                                block81: {
                                    block78: {
                                        block76: {
                                            GraphTargetItem regValue;
                                            item = parts.get(partsPos);
                                            if (item instanceof PushItem) {
                                                PushItem pi = (PushItem)item;
                                                item = pi.value;
                                            }
                                            if (!(item instanceof SetMemberActionItem)) break block76;
                                            SetMemberActionItem sm = (SetMemberActionItem)item;
                                            int currentRegId = -1;
                                            if (sm.object instanceof TemporaryRegister) {
                                                TemporaryRegister tempReg = (TemporaryRegister)sm.object;
                                                currentRegId = tempReg.getRegId();
                                                regValue = tempReg.value;
                                            } else if (sm.object instanceof DirectValueActionItem && ((DirectValueActionItem)sm.object).value instanceof RegisterNumber) {
                                                DirectValueActionItem dv = (DirectValueActionItem)sm.object;
                                                RegisterNumber rn = (RegisterNumber)dv.value;
                                                currentRegId = rn.number;
                                                regValue = dv.computedRegValue;
                                            } else {
                                                List<String> path = this.getSetMembersPath(item);
                                                if (path == null || path.isEmpty()) {
                                                    throw new AssertException("invalid setmember");
                                                }
                                                if ("_global".equals(path.get(0))) {
                                                    path.remove(0);
                                                }
                                                if (!path.equals(classNamePath)) {
                                                    throw new AssertException("wrong path in setmember");
                                                }
                                                GraphTargetItem interfaceClass = ActionScript2ClassDetector.getWithoutGlobal(this.setMemberToGetMember(item));
                                                if (!(sm.value instanceof FunctionActionItem)) {
                                                    throw new AssertException("not a function in setmember");
                                                }
                                                FunctionActionItem f = (FunctionActionItem)sm.value;
                                                if (!"".equals(f.functionName)) {
                                                    throw new AssertException("not unnamed func in setmember");
                                                }
                                                if (!f.actions.isEmpty()) {
                                                    throw new AssertException("not empty function in setmember");
                                                }
                                                if (!f.paramNames.isEmpty()) {
                                                    throw new AssertException("not empty params for function in setmember");
                                                }
                                                ++partsPos;
                                                while (partsPos < parts.size()) {
                                                    item = parts.get(partsPos);
                                                    if (!(item instanceof ImplementsOpActionItem)) throw new AssertException("unknown iface item: " + item.getClass().getSimpleName());
                                                    if (!implementsOp.isEmpty()) {
                                                        throw new AssertException("multiple implementsAction");
                                                    }
                                                    ImplementsOpActionItem io = (ImplementsOpActionItem)item;
                                                    implementsOp = io.superclasses;
                                                    ++partsPos;
                                                }
                                                InterfaceActionItem ifsItem = new InterfaceActionItem(interfaceClass, implementsOp);
                                                for (int k = commandsStartPos; k <= commandsEndPos; ++k) {
                                                    commands.remove(commandsStartPos);
                                                }
                                                commands.add(commandsStartPos, ifsItem);
                                                if (commandsStartPos + 1 >= commands.size() || !(commands.get(commandsStartPos + 1) instanceof PopItem)) return true;
                                                commands.remove(commandsStartPos + 1);
                                                return true;
                                            }
                                            if (currentRegId != instanceReg && currentRegId != classReg) {
                                                boolean isPrototype;
                                                GraphTargetItem pathSource;
                                                if (!(regValue instanceof SetMemberActionItem)) {
                                                    throw new AssertException("temp register do not contain setmember");
                                                }
                                                SetMemberActionItem sm2 = (SetMemberActionItem)regValue;
                                                if ("prototype".equals(this.getAsString(sm2.objectName, "objectName"))) {
                                                    pathSource = sm2.object;
                                                    isPrototype = true;
                                                } else {
                                                    pathSource = this.setMemberToGetMember(sm2);
                                                    isPrototype = false;
                                                }
                                                List<String> memPath = this.getMembersPath(pathSource);
                                                if (memPath == null) {
                                                    throw new AssertException("Invalid pathsource");
                                                }
                                                if (memPath.size() > 0 && "_global".equals(memPath.get(0))) {
                                                    memPath.remove(0);
                                                }
                                                if (!classNamePath.equals(memPath)) {
                                                    throw new AssertException("Invalid path of setmember:" + String.join((CharSequence)".", memPath));
                                                }
                                                if (!(sm2.value instanceof StoreRegisterActionItem)) {
                                                    throw new AssertException("Not storeregister");
                                                }
                                                StoreRegisterActionItem sr2 = (StoreRegisterActionItem)sm2.value;
                                                if (sr2.register.number != currentRegId) {
                                                    throw new AssertException("Invalid storeregister");
                                                }
                                                if (isPrototype && (sr2.value instanceof NewMethodActionItem || sr2.value instanceof NewObjectActionItem)) {
                                                    extendsOp = this.newToGetMember(sr2.value);
                                                    instanceReg = currentRegId;
                                                } else {
                                                    if (isPrototype || !(sr2.value instanceof FunctionActionItem)) throw new AssertException("invalid storeregister value: " + sr2.value.getClass().getSimpleName());
                                                    constructor = sr2.value;
                                                    classReg = currentRegId;
                                                }
                                            }
                                            MyEntry<GraphTargetItem, GraphTargetItem> trait = new MyEntry<GraphTargetItem, GraphTargetItem>(sm.objectName, sm.value);
                                            if (sm.value instanceof FunctionActionItem) {
                                                FunctionActionItem f = (FunctionActionItem)sm.value;
                                                f.calculatedFunctionName = sm.objectName;
                                            }
                                            traits.add(trait);
                                            if (currentRegId == instanceReg) {
                                                traitsStatic.add(false);
                                            } else if (currentRegId == classReg) {
                                                traitsStatic.add(true);
                                            }
                                            break block77;
                                        }
                                        if (!(item instanceof ImplementsOpActionItem)) break block78;
                                        ImplementsOpActionItem iot = (ImplementsOpActionItem)item;
                                        implementsOp = iot.superclasses;
                                        break block77;
                                    }
                                    if (!(item instanceof CallMethodActionItem)) break block79;
                                    CallMethodActionItem cm = (CallMethodActionItem)item;
                                    String pushMethodName = this.getAsString(cm.methodName, "push methodName");
                                    if (!"addProperty".equals(pushMethodName)) throw new AssertException("unknown push method name: " + pushMethodName);
                                    rnumObject = this.getAsRegisterNum(cm.scriptObject, "addProperty not on register");
                                    if (rnumObject != instanceReg && rnumObject != classReg) {
                                        throw new AssertException("unexpected addProperty object register " + rnumObject);
                                    }
                                    if (cm.arguments.size() != 3) {
                                        throw new AssertException("invalid number of arguments to addProperty: " + cm.arguments.size());
                                    }
                                    GraphTargetItem propertyName = cm.arguments.get(0);
                                    propertyGetter = cm.arguments.get(1);
                                    propertySetter = cm.arguments.get(2);
                                    propertyNameStr = this.getAsString(propertyName, "propertyName");
                                    if (!(propertyGetter instanceof GetMemberActionItem)) break block80;
                                    int regId = this.getAsRegisterNum(((GetMemberActionItem)propertyGetter).object, "getter member not register");
                                    if (rnumObject != regId) {
                                        throw new AssertException("getter register does not match property register " + regId + " <=> " + rnumObject);
                                    }
                                    getterNameStr = this.getAsString(((GetMemberActionItem)propertyGetter).memberName, "getter memberName");
                                    if (getterNameStr.equals("__get__" + propertyNameStr)) break block81;
                                    Logger.getLogger(ActionScript2ClassDetector.class.getName()).warning(scriptPath + ": getter " + IdentifiersDeobfuscation.printIdentifier(false, getterNameStr, new String[0]) + " does not match property name " + IdentifiersDeobfuscation.printIdentifier(false, propertyNameStr, new String[0]));
                                    break block77;
                                }
                                for (MyEntry myEntry : traits) {
                                    if (!(myEntry.getKey() instanceof DirectValueActionItem) || !((DirectValueActionItem)myEntry.getKey()).isString() || !((DirectValueActionItem)myEntry.getKey()).toString().equals(getterNameStr) || !(myEntry.getValue() instanceof FunctionActionItem)) continue;
                                    func = (FunctionActionItem)myEntry.getValue();
                                    func.isGetter = true;
                                }
                                break block82;
                            }
                            if (!(propertyGetter instanceof FunctionActionItem)) throw new AssertException("unexpected getter value for property " + propertyNameStr + ": " + propertyGetter.getClass().getSimpleName());
                            FunctionActionItem getterFunc = (FunctionActionItem)propertyGetter;
                            if (!(getterFunc.actions.isEmpty() && getterFunc.functionName.isEmpty() && ((FunctionActionItem)propertyGetter).paramNames.isEmpty())) {
                                throw new AssertException("unexpected getter value for property " + propertyNameStr);
                            }
                        }
                        if (propertySetter instanceof GetMemberActionItem) {
                            int regId = this.getAsRegisterNum(((GetMemberActionItem)propertySetter).object, "setter member");
                            if (rnumObject != regId) {
                                throw new AssertException("setter register does not match property register " + regId + " <=> " + rnumObject);
                            }
                            String setterNameStr = this.getAsString(((GetMemberActionItem)propertySetter).memberName, "setter memberNAme");
                            if (!setterNameStr.equals("__set__" + propertyNameStr)) {
                                Logger.getLogger(ActionScript2ClassDetector.class.getName()).warning(scriptPath + ": setter " + IdentifiersDeobfuscation.printIdentifier(false, setterNameStr, new String[0]) + " does not match property name " + IdentifiersDeobfuscation.printIdentifier(false, propertyNameStr, new String[0]));
                            } else {
                                for (MyEntry myEntry : traits) {
                                    if (!(myEntry.getKey() instanceof DirectValueActionItem) || !((DirectValueActionItem)myEntry.getKey()).isString() || !((DirectValueActionItem)myEntry.getKey()).toString().equals(setterNameStr) || !(myEntry.getValue() instanceof FunctionActionItem)) continue;
                                    func = (FunctionActionItem)myEntry.getValue();
                                    func.isSetter = true;
                                    if (func.actions.isEmpty()) continue;
                                    int pos = func.actions.size() - 1;
                                    if (func.actions.get(pos) instanceof ScriptEndItem) {
                                        --pos;
                                    }
                                    if (pos < 0 || !(func.actions.get(pos) instanceof ReturnActionItem)) continue;
                                    GraphTargetItem val = func.actions.get(pos);
                                    if (!(val.value instanceof CallMethodActionItem) || !(((CallMethodActionItem)val.value).methodName instanceof DirectValueActionItem) || !((CallMethodActionItem)val.value).methodName.toString().startsWith("__get__")) continue;
                                    func.actions.remove(pos);
                                }
                            }
                        } else {
                            if (!(propertySetter instanceof FunctionActionItem)) throw new AssertException("unexpected setter value for property " + propertyNameStr + ": " + propertySetter.getClass().getSimpleName());
                            FunctionActionItem setterFunc = (FunctionActionItem)propertySetter;
                            if (!(setterFunc.actions.isEmpty() && setterFunc.functionName.isEmpty() && ((FunctionActionItem)propertySetter).paramNames.isEmpty())) {
                                throw new AssertException("unexpected getter value for property " + propertyNameStr);
                            }
                        }
                        break block77;
                    }
                    if (item instanceof CallFunctionActionItem) {
                        CallFunctionActionItem cf = (CallFunctionActionItem)item;
                        String funName = this.getAsString(cf.functionName, "pushitem function name");
                        if (!funName.equals("ASSetPropFlags")) throw new AssertException("unknown pushitem function call " + funName);
                        if (cf.arguments.size() != 3) {
                            throw new AssertException("Invalid number of arguments to ASSetPropFlags:" + cf.arguments.size() + ", 3 expected");
                        }
                        GraphTargetItem obj = cf.arguments.get(0);
                        GraphTargetItem props = cf.arguments.get(1);
                        GraphTargetItem flags = cf.arguments.get(2);
                        if (obj instanceof DirectValueActionItem && ((DirectValueActionItem)obj).value instanceof RegisterNumber) {
                            RegisterNumber rn = (RegisterNumber)((DirectValueActionItem)obj).value;
                            if (rn.number != instanceReg) {
                                throw new AssertException("ASSetPropFlags not on instanceReg");
                            }
                        } else {
                            List<String> path = this.getMembersPath(obj);
                            if (path != null && !path.isEmpty() && "_global".equals(path.get(0))) {
                                path.remove(0);
                            }
                            ArrayList<String> classPathWithPrototype = new ArrayList<String>();
                            classPathWithPrototype.addAll(classNamePath);
                            classPathWithPrototype.add("prototype");
                            if (!classPathWithPrototype.equals(path)) {
                                throw new AssertException("ASSetPropFlags not on prototype");
                            }
                        }
                        if (!(props instanceof DirectValueActionItem) || ((DirectValueActionItem)props).value != Null.INSTANCE) {
                            throw new AssertException("ASSetPropFlags properties param not null");
                        }
                        if (!(flags instanceof DirectValueActionItem) || ((DirectValueActionItem)flags).value != Long.valueOf(1L)) {
                            throw new AssertException("ASSetPropFlags flags not set to 1");
                        }
                    } else if (!(item instanceof DirectValueActionItem)) {
                        throw new AssertException("unknown item - " + item.getClass().getSimpleName());
                    }
                }
                ++partsPos;
            }
            if (constructor != null) {
                traitsStatic.add(0, false);
                DirectValueActionItem classBaseName = new DirectValueActionItem(classNamePath.get(classNamePath.size() - 1));
                ((FunctionActionItem)constructor).calculatedFunctionName = classBaseName;
                traits.add(0, new MyEntry<DirectValueActionItem, GraphTargetItem>(classBaseName, constructor));
            }
            ClassActionItem clsItem = new ClassActionItem((GraphTargetItem)var14_19, extendsOp, implementsOp, traits, traitsStatic);
            for (int k = commandsStartPos; k <= commandsEndPos; ++k) {
                commands.remove(commandsStartPos);
            }
            commands.add(commandsStartPos, clsItem);
            if (commandsStartPos + 1 >= commands.size() || !(commands.get(commandsStartPos + 1) instanceof PopItem)) return true;
            commands.remove(commandsStartPos + 1);
            return true;
        }
        catch (AssertException ex) {
            logger.log(Level.WARNING, "{0}: Cannot detect class - {1}", new Object[]{scriptPath, ex.getCondition()});
            return false;
        }
    }

    private void expandTernars(List<GraphTargetItem> commands) {
        for (int i = 0; i < commands.size(); ++i) {
            if (!(commands.get(i) instanceof TernarOpItem)) continue;
            TernarOpItem ter = (TernarOpItem)commands.get(i);
            ArrayList<GraphTargetItem> onTrue = new ArrayList<GraphTargetItem>();
            if (ter.onTrue instanceof CommaExpressionItem) {
                CommaExpressionItem ce = (CommaExpressionItem)ter.onTrue;
                onTrue = ce.commands;
            } else {
                onTrue.add(ter.onTrue);
            }
            ArrayList<GraphTargetItem> onFalse = new ArrayList<GraphTargetItem>();
            if (ter.onFalse instanceof CommaExpressionItem) {
                CommaExpressionItem ce = (CommaExpressionItem)ter.onFalse;
                onFalse = ce.commands;
            } else {
                onFalse.add(ter.onFalse);
            }
            commands.set(i, new IfItem(null, null, ter.expression, onTrue, onFalse));
        }
    }

    private boolean checkIfVariants(List<GraphTargetItem> commands, HashMap<String, GraphTargetItem> variables, int pos, String scriptPath) {
        block9: {
            GraphTargetItem t;
            this.expandTernars(commands);
            ArrayList<String> pathToSearchVariant1 = new ArrayList<String>();
            pathToSearchVariant1.add("_global");
            for (int checkPos = pos; checkPos < commands.size() && (t = commands.get(checkPos)) instanceof IfItem; ++checkPos) {
                IfItem ifItem = (IfItem)t;
                if (!(ifItem.expression instanceof NotItem)) break;
                NotItem nti = (NotItem)ifItem.expression;
                GraphTargetItem condType = nti.value;
                Reference<String> newMemberNameRef = new Reference<String>("");
                if (!this.isMemberOfPath(condType, pathToSearchVariant1, newMemberNameRef)) break;
                pathToSearchVariant1.add(newMemberNameRef.getVal());
                if (ifItem.onTrue.size() == 1 && ifItem.onTrue.get(0) instanceof SetMemberActionItem && ((SetMemberActionItem)ifItem.onTrue.get((int)0)).value instanceof NewObjectActionItem) {
                    GraphTargetItem tnext;
                    if (checkPos + 1 >= commands.size() || !((tnext = commands.get(checkPos + 1)) instanceof PopItem)) continue;
                    ++checkPos;
                    continue;
                }
                ArrayList<String> classPath = pathToSearchVariant1;
                classPath.remove(0);
                if (!this.checkClassContent(ifItem.onTrue, variables, 0, pos, checkPos, commands, classPath, scriptPath)) break;
                return true;
            }
            ArrayList<String> variant2CurrentPath = new ArrayList<String>();
            if (commands.get(pos) instanceof IfItem) {
                IfItem ifItem = (IfItem)commands.get(pos);
                if (ifItem.expression instanceof NotItem) {
                    NotItem nti = (NotItem)ifItem.expression;
                    List<String> memPath = this.getMembersPath(nti.value);
                    if (memPath != null && ifItem.onTrue.size() >= memPath.size()) {
                        int checkPos;
                        variant2CurrentPath.clear();
                        List<GraphTargetItem> parts = ifItem.onTrue;
                        for (checkPos = 0; checkPos < memPath.size() - 1; ++checkPos) {
                            variant2CurrentPath.add(memPath.get(checkPos));
                            if (parts.get(checkPos) instanceof IfItem) {
                                IfItem ifItem2 = (IfItem)parts.get(checkPos);
                                if (!(ifItem2.expression instanceof NotItem)) continue;
                                NotItem nti2 = (NotItem)ifItem2.expression;
                                List<String> if2Path = this.getMembersPath(nti2.value);
                                if (variant2CurrentPath.equals(if2Path)) {
                                    continue;
                                }
                            }
                            break block9;
                        }
                        if (this.checkClassContent(parts, variables, checkPos, pos, pos, commands, memPath, scriptPath)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public void checkClass(List<GraphTargetItem> commands, HashMap<String, GraphTargetItem> variables, String scriptPath) {
        ArrayList<GraphTargetItem> localCommands = new ArrayList<GraphTargetItem>(commands);
        boolean changed = false;
        for (int pos = 0; pos < localCommands.size(); ++pos) {
            if (!this.checkIfVariants(localCommands, variables, pos, scriptPath)) continue;
            changed = true;
        }
        if (changed) {
            commands.clear();
            commands.addAll(localCommands);
        }
    }

    private class AssertException
    extends Exception {
        private final String condition;

        public AssertException(String condition) {
            super(condition);
            this.condition = condition;
        }

        public String getCondition() {
            return this.condition;
        }
    }
}

