/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.types.traits;

import com.jpexs.decompiler.flash.abc.ABC;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FullMultinameAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetLexAVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.GetPropertyAVM2Item;
import com.jpexs.decompiler.flash.abc.types.ConvertData;
import com.jpexs.decompiler.flash.abc.types.Multiname;
import com.jpexs.decompiler.flash.abc.types.traits.Trait;
import com.jpexs.decompiler.flash.abc.types.traits.TraitClass;
import com.jpexs.decompiler.flash.abc.types.traits.TraitType;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.exporters.modes.ScriptExportMode;
import com.jpexs.decompiler.flash.exporters.script.Dependency;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.flash.helpers.NulWriter;
import com.jpexs.decompiler.flash.search.MethodId;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.decompiler.graph.GraphTargetItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Traits
implements Cloneable,
Serializable {
    public List<Trait> traits;

    public Traits() {
        this.traits = new ArrayList<Trait>();
    }

    public Traits(int initialCapacity) {
        this.traits = new ArrayList<Trait>(initialCapacity);
    }

    public void delete(ABC abc, boolean d) {
        for (Trait t : this.traits) {
            t.delete(abc, d);
        }
    }

    public int addTrait(Trait t) {
        this.traits.add(t);
        return this.traits.size() - 1;
    }

    public int removeTraps(int scriptIndex, int classIndex, boolean isStatic, ABC abc, String path) throws InterruptedException {
        int ret = 0;
        for (Trait t : this.traits) {
            ret += t.removeTraps(scriptIndex, classIndex, isStatic, abc, path);
        }
        return ret;
    }

    public String toString() {
        String s = "";
        for (int t = 0; t < this.traits.size(); ++t) {
            if (t > 0) {
                s = s + "\r\n";
            }
            s = s + this.traits.get(t).toString();
        }
        return s;
    }

    public String toString(ABC abc, List<DottedChain> fullyQualifiedNames) {
        String s = "";
        for (int t = 0; t < this.traits.size(); ++t) {
            if (t > 0) {
                s = s + "\r\n";
            }
            s = s + this.traits.get(t).toString(abc, fullyQualifiedNames);
        }
        return s;
    }

    public GraphTextWriter toString(Class[] traitTypes, Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, boolean makePackages, int scriptIndex, int classIndex, GraphTextWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel, List<Integer> ignoredTraitNames) throws InterruptedException {
        ArrayList<Trait> ordered = new ArrayList<Trait>(this.traits);
        block0: for (int i = 0; i < ordered.size(); ++i) {
            for (int j = i + 1; j < ordered.size(); ++j) {
                if (i == j) continue;
                Trait o1 = (Trait)ordered.get(i);
                Trait o2 = (Trait)ordered.get(j);
                Multiname m2 = abc.constants.getMultiname(o2.name_index);
                if (!convertData.assignedValues.containsKey(o1)) continue;
                GraphTargetItem v1 = convertData.assignedValues.get((Object)o1).value;
                Set<GraphTargetItem> subitems1 = v1.getAllSubItemsRecursively();
                subitems1.add(v1);
                for (GraphTargetItem si : subitems1) {
                    if (si instanceof GetPropertyAVM2Item) {
                        GetPropertyAVM2Item getProp = (GetPropertyAVM2Item)si;
                        Multiname sm1 = abc.constants.getMultiname(((FullMultinameAVM2Item)getProp.propertyName).multinameIndex);
                        if (getProp.object instanceof FindPropertyAVM2Item && sm1.equals(m2)) {
                            ordered.add(j + 1, o1);
                            ordered.remove(i);
                            --i;
                            continue block0;
                        }
                    }
                    if (!(si instanceof GetLexAVM2Item)) continue;
                    GetLexAVM2Item lex = (GetLexAVM2Item)si;
                    if (!lex.propertyName.equals(m2)) continue;
                    ordered.add(j + 1, o1);
                    ordered.remove(i);
                    --i;
                    continue block0;
                }
            }
        }
        for (Trait trait : ordered) {
            int t = this.traits.indexOf(trait);
            if (traitTypes != null) {
                boolean found = false;
                for (Class c : traitTypes) {
                    if (!c.isInstance(trait)) continue;
                    found = true;
                    break;
                }
                if (!found) continue;
            }
            if (!trait.isVisible(isStatic, abc) || ignoredTraitNames.contains(trait.name_index)) continue;
            writer.newLine();
            int h = abc.getGlobalTraitId(TraitType.METHOD, isStatic, classIndex, t);
            if (trait instanceof TraitClass) {
                writer.startClass(((TraitClass)trait).class_info);
            } else {
                writer.startTrait(h);
            }
            if (makePackages) {
                trait.toStringPackaged(parent, convertData, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, parallel);
            } else {
                trait.toString(parent, convertData, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, parallel);
            }
            if (trait instanceof TraitClass) {
                writer.endClass();
                continue;
            }
            writer.endTrait();
        }
        return writer;
    }

    public void convert(Trait parent, ConvertData convertData, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, boolean makePackages, int scriptIndex, int classIndex, NulWriter writer, List<DottedChain> fullyQualifiedNames, boolean parallel) throws InterruptedException {
        if (!parallel || this.traits.size() < 2) {
            for (int t = 0; t < this.traits.size(); ++t) {
                TraitConvertTask task = new TraitConvertTask(this.traits.get(t), parent, convertData, makePackages, path, abc, isStatic, exportMode, scriptIndex, classIndex, writer, fullyQualifiedNames, t, parallel);
                task.call();
            }
        } else {
            ExecutorService executor = Executors.newFixedThreadPool(Configuration.getParallelThreadCount());
            ArrayList<Future<Void>> futureResults = new ArrayList<Future<Void>>();
            for (int t = 0; t < this.traits.size(); ++t) {
                TraitConvertTask task = new TraitConvertTask(this.traits.get(t), parent, convertData, makePackages, path, abc, isStatic, exportMode, scriptIndex, classIndex, new NulWriter(), fullyQualifiedNames, t, parallel);
                Future<Void> future = executor.submit(task);
                futureResults.add(future);
            }
            for (int f = 0; f < futureResults.size(); ++f) {
                try {
                    ((Future)futureResults.get(f)).get();
                    continue;
                }
                catch (InterruptedException ex) {
                    executor.shutdownNow();
                    throw ex;
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(Traits.class.getName()).log(Level.SEVERE, "Error during traits converting", ex);
                }
            }
            executor.shutdown();
        }
    }

    public Traits clone() {
        try {
            Traits ret = (Traits)super.clone();
            if (this.traits != null) {
                ret.traits = new ArrayList<Trait>(this.traits.size());
                for (int i = 0; i < this.traits.size(); ++i) {
                    ret.traits.add(this.traits.get(i).clone());
                }
            }
            return ret;
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException();
        }
    }

    public void getDependencies(int scriptIndex, int classIndex, boolean isStatic, String customNs, ABC abc, List<Dependency> dependencies, List<String> uses, DottedChain ignorePackage, List<DottedChain> fullyQualifiedNames) throws InterruptedException {
        for (Trait t : this.traits) {
            t.getDependencies(scriptIndex, classIndex, isStatic, customNs, abc, dependencies, uses, ignorePackage, fullyQualifiedNames);
        }
    }

    public void getMethodInfos(ABC abc, boolean isStatic, int classIndex, List<MethodId> methodInfos) {
        for (int t = 0; t < this.traits.size(); ++t) {
            Trait trait = this.traits.get(t);
            trait.getMethodInfos(abc, abc.getGlobalTraitId(TraitType.METHOD, isStatic, classIndex, t), classIndex, methodInfos);
        }
    }

    private class TraitConvertTask
    implements Callable<Void> {
        Trait trait;
        boolean makePackages;
        String path;
        ABC abc;
        boolean isStatic;
        ScriptExportMode exportMode;
        int scriptIndex;
        int classIndex;
        NulWriter writer;
        List<DottedChain> fullyQualifiedNames;
        int traitIndex;
        boolean parallel;
        Trait parent;
        ConvertData convertData;

        public TraitConvertTask(Trait trait, Trait parent, ConvertData convertData, boolean makePackages, String path, ABC abc, boolean isStatic, ScriptExportMode exportMode, int scriptIndex, int classIndex, NulWriter writer, List<DottedChain> fullyQualifiedNames, int traitIndex, boolean parallel) {
            this.trait = trait;
            this.parent = parent;
            this.convertData = convertData;
            this.makePackages = makePackages;
            this.path = path;
            this.abc = abc;
            this.isStatic = isStatic;
            this.exportMode = exportMode;
            this.scriptIndex = scriptIndex;
            this.classIndex = classIndex;
            this.writer = writer;
            this.fullyQualifiedNames = fullyQualifiedNames;
            this.traitIndex = traitIndex;
            this.parallel = parallel;
        }

        @Override
        public Void call() throws InterruptedException {
            if (this.makePackages) {
                this.trait.convertPackaged(this.parent, this.convertData, this.path, this.abc, this.isStatic, this.exportMode, this.scriptIndex, this.classIndex, this.writer, this.fullyQualifiedNames, this.parallel);
            } else {
                this.trait.convert(this.parent, this.convertData, this.path, this.abc, this.isStatic, this.exportMode, this.scriptIndex, this.classIndex, this.writer, this.fullyQualifiedNames, this.parallel);
            }
            return null;
        }
    }
}

