/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model.operations;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.IntegerValueAVM2Item;
import com.jpexs.decompiler.flash.ecma.EcmaScript;
import com.jpexs.decompiler.flash.ecma.EcmaType;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.model.BinaryOpItem;
import com.jpexs.decompiler.graph.model.CompoundableBinaryOp;
import com.jpexs.decompiler.graph.model.LocalData;
import com.jpexs.decompiler.graph.model.UnboundedTypeItem;
import java.util.ArrayList;
import java.util.List;

public class AddAVM2Item
extends BinaryOpItem
implements CompoundableBinaryOp {
    public AddAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem leftSide, GraphTargetItem rightSide) {
        super(instruction, lineStartIns, 4, leftSide, rightSide, "+", "", "");
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        if (this.rightSide.getPrecedence() >= this.precedence) {
            if (this.leftSide.getPrecedence() > this.precedence) {
                writer.append("(");
                this.leftSide.toString(writer, localData);
                writer.append(")");
            } else {
                this.leftSide.toString(writer, localData);
            }
            writer.append(" ");
            writer.append(this.operator);
            writer.append(" ");
            writer.append("(");
            this.rightSide.toString(writer, localData);
            return writer.append(")");
        }
        return super.appendTo(writer, localData);
    }

    @Override
    public Object getResult() {
        Object leftResult = this.leftSide.getResult();
        Object rightResult = this.rightSide.getResult();
        leftResult = EcmaScript.toPrimitive(leftResult, "");
        rightResult = EcmaScript.toPrimitive(rightResult, "");
        if (EcmaScript.type(leftResult) == EcmaType.STRING || EcmaScript.type(rightResult) == EcmaType.STRING) {
            return EcmaScript.toString(leftResult) + EcmaScript.toString(rightResult);
        }
        return EcmaScript.toNumber(leftResult) + EcmaScript.toNumber(rightResult);
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        if (this.rightSide instanceof IntegerValueAVM2Item) {
            IntegerValueAVM2Item iv = (IntegerValueAVM2Item)this.rightSide;
            if (iv.value == 1L) {
                return AddAVM2Item.toSourceMerge(localData, generator, this.leftSide, new AVM2Instruction(0L, 145, null));
            }
        }
        return AddAVM2Item.toSourceMerge(localData, generator, this.leftSide, this.rightSide, new AVM2Instruction(0L, 160, null));
    }

    @Override
    public GraphTargetItem returnType() {
        return new UnboundedTypeItem();
    }

    @Override
    public List<GraphSourceItem> getOperatorInstruction() {
        ArrayList<GraphSourceItem> ret = new ArrayList<GraphSourceItem>();
        ret.add(new AVM2Instruction(0L, 160, null));
        return ret;
    }
}

