/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.model.FindPropertyAVM2Item;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;

public class ConstructPropAVM2Item
extends AVM2Item {
    public GraphTargetItem object;
    public GraphTargetItem propertyName;
    public List<GraphTargetItem> args;

    public ConstructPropAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem object, GraphTargetItem propertyName, List<GraphTargetItem> args) {
        super(instruction, lineStartIns, 0);
        this.object = object;
        this.propertyName = propertyName;
        this.args = args;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.object);
        visitor.visit(this.propertyName);
        visitor.visitAll(this.args);
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        writer.append("new ");
        if (!(this.object.getThroughDuplicate() instanceof FindPropertyAVM2Item)) {
            this.object.toString(writer, localData);
            writer.append(".");
        }
        this.propertyName.toString(writer, localData);
        writer.spaceBeforeCallParenthesies(this.args.size());
        writer.append("(");
        for (int a = 0; a < this.args.size(); ++a) {
            if (a > 0) {
                writer.append(",");
            }
            this.args.get(a).toString(writer, localData);
        }
        return writer.append(")");
    }

    @Override
    public GraphTargetItem returnType() {
        return TypeItem.UNBOUNDED;
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.object);
        hash = 67 * hash + Objects.hashCode(this.propertyName);
        hash = 67 * hash + Objects.hashCode(this.args);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConstructPropAVM2Item other = (ConstructPropAVM2Item)obj;
        if (!Objects.equals(this.object, other.object)) {
            return false;
        }
        if (!Objects.equals(this.propertyName, other.propertyName)) {
            return false;
        }
        return Objects.equals(this.args, other.args);
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }
}

