/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2.model;

import com.jpexs.decompiler.flash.SourceGeneratorLocalData;
import com.jpexs.decompiler.flash.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.decompiler.flash.abc.avm2.model.AVM2Item;
import com.jpexs.decompiler.flash.abc.avm2.parser.script.AVM2SourceGenerator;
import com.jpexs.decompiler.flash.ecma.Null;
import com.jpexs.decompiler.flash.ecma.Undefined;
import com.jpexs.decompiler.flash.helpers.GraphTextWriter;
import com.jpexs.decompiler.graph.CompilationException;
import com.jpexs.decompiler.graph.GraphSourceItem;
import com.jpexs.decompiler.graph.GraphTargetItem;
import com.jpexs.decompiler.graph.GraphTargetVisitorInterface;
import com.jpexs.decompiler.graph.SourceGenerator;
import com.jpexs.decompiler.graph.TypeItem;
import com.jpexs.decompiler.graph.model.LocalData;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class CoerceAVM2Item
extends AVM2Item {
    public GraphTargetItem typeObj;

    public CoerceAVM2Item(GraphSourceItem instruction, GraphSourceItem lineStartIns, GraphTargetItem value, GraphTargetItem typeObj) {
        super(instruction, lineStartIns, value.getPrecedence(), value);
        this.typeObj = typeObj;
    }

    @Override
    public void visit(GraphTargetVisitorInterface visitor) {
        visitor.visit(this.typeObj);
        if (this.value != null) {
            visitor.visit(this.value);
        }
    }

    @Override
    public GraphTextWriter appendTo(GraphTextWriter writer, LocalData localData) throws InterruptedException {
        return this.value.toString(writer, localData);
    }

    @Override
    public GraphTargetItem getNotCoerced() {
        return this.value.getNotCoerced();
    }

    @Override
    public GraphTargetItem getNotCoercedNoDup() {
        return this.value.getNotCoercedNoDup();
    }

    @Override
    public boolean isCompileTime(Set<GraphTargetItem> dependencies) {
        if (dependencies.contains(this.value)) {
            return false;
        }
        dependencies.add(this.value);
        return this.value.isConvertedCompileTime(dependencies);
    }

    @Override
    public Object getResult() {
        Object ret = this.value.getResult();
        switch (this.typeObj.toString()) {
            case "String": {
                if (ret == Null.INSTANCE) {
                    return ret;
                }
                if (ret == Undefined.INSTANCE) {
                    return Null.INSTANCE;
                }
                return this.value.getResultAsString();
            }
        }
        return ret;
    }

    @Override
    public GraphTargetItem returnType() {
        return new TypeItem(this.typeObj.toString());
    }

    @Override
    public boolean hasReturnValue() {
        return true;
    }

    @Override
    public List<GraphSourceItem> toSource(SourceGeneratorLocalData localData, SourceGenerator generator) throws CompilationException {
        AVM2Instruction ins;
        switch (this.typeObj.toString()) {
            case "*": {
                ins = new AVM2Instruction(0L, 130, null);
                break;
            }
            case "String": {
                ins = new AVM2Instruction(0L, 133, null);
                break;
            }
            case "Boolean": {
                ins = new AVM2Instruction(0L, 118, null);
                break;
            }
            case "int": {
                ins = new AVM2Instruction(0L, 115, null);
                break;
            }
            case "uint": {
                ins = new AVM2Instruction(0L, 116, null);
                break;
            }
            case "Number": {
                ins = new AVM2Instruction(0L, 117, null);
                break;
            }
            default: {
                int type_index = AVM2SourceGenerator.resolveType(localData, this.typeObj, ((AVM2SourceGenerator)generator).abcIndex);
                ins = new AVM2Instruction(0L, 128, new int[]{type_index});
            }
        }
        return CoerceAVM2Item.toSourceMerge(localData, generator, this.value, ins);
    }

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + Objects.hashCode(this.typeObj);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoerceAVM2Item other = (CoerceAVM2Item)obj;
        if (!Objects.equals(this.typeObj, other.typeObj)) {
            return false;
        }
        return Objects.equals(this.value, other.value);
    }
}

