/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash.abc.avm2;

import com.jpexs.decompiler.flash.IdentifiersDeobfuscation;
import com.jpexs.decompiler.flash.SWF;
import com.jpexs.decompiler.flash.abc.RenameType;
import com.jpexs.decompiler.flash.abc.avm2.AVM2ConstantPool;
import com.jpexs.decompiler.graph.DottedChain;
import com.jpexs.helpers.Helper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class AVM2Deobfuscation {
    private static final int DEFAULT_FOO_SIZE = 10;
    public static final String VALID_FIRST_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$";
    public static final String VALID_NEXT_CHARACTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$0123456789";
    public static final String VALID_NS_CHARACTERS = ".:";
    private final SWF swf;
    private final AVM2ConstantPool constants;
    private final Map<String, Integer> usageTypesCount = new HashMap<String, Integer>();
    public static final DottedChain FLASH_PROXY = new DottedChain(new String[]{"flash", "utils", "flash_proxy"}, "");
    public static final DottedChain BUILTIN = new DottedChain(new String[]{"-"}, "");

    public AVM2Deobfuscation(SWF swf, AVM2ConstantPool constants) {
        this.swf = swf;
        this.constants = constants;
    }

    private boolean isValidNSPart(String s) {
        Pattern pat;
        boolean isValid = true;
        if (IdentifiersDeobfuscation.isReservedWord2(s)) {
            isValid = false;
        }
        if (isValid) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                isValid = false;
                break;
            }
        }
        if (isValid && !(pat = Pattern.compile("^([" + Pattern.quote(VALID_FIRST_CHARACTERS) + "][" + Pattern.quote("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$0123456789.:") + "]*)*$")).matcher(s).matches()) {
            isValid = false;
        }
        return isValid;
    }

    public DottedChain builtInNs(String ns) {
        if (ns == null) {
            return null;
        }
        if (ns.equals("http://www.adobe.com/2006/actionscript/flash/proxy")) {
            return FLASH_PROXY;
        }
        if (ns.equals("http://adobe.com/AS3/2006/builtin")) {
            return BUILTIN;
        }
        return null;
    }

    private String fooString(HashMap<DottedChain, DottedChain> deobfuscated, String orig, boolean firstUppercase, String usageType, RenameType renameType) {
        boolean found;
        if (usageType == null) {
            usageType = "name";
        }
        String ret = null;
        int rndSize = 10;
        do {
            found = false;
            if (renameType == RenameType.TYPENUMBER) {
                ret = Helper.getNextId(usageType, this.usageTypesCount, true);
            } else if (renameType == RenameType.RANDOMWORD) {
                ret = IdentifiersDeobfuscation.fooString(firstUppercase, rndSize);
            }
            if (!this.swf.as3StringConstantExists(ret) && !IdentifiersDeobfuscation.isReservedWord2(ret) && !deobfuscated.containsValue(DottedChain.parseWithSuffix(ret))) continue;
            found = true;
            ++rndSize;
        } while (found);
        deobfuscated.put(DottedChain.parseWithSuffix(orig), DottedChain.parseWithSuffix(ret));
        return ret;
    }

    public int deobfuscatePackageName(Map<Integer, String> stringUsageTypes, Set<Integer> stringUsages, HashMap<DottedChain, DottedChain> namesMap, int strIndex, RenameType renameType) {
        if (strIndex <= 0) {
            return strIndex;
        }
        String s = this.constants.getString(strIndex);
        if (this.builtInNs(s) != null) {
            return strIndex;
        }
        boolean isValid = this.isValidNSPart(s);
        if (!isValid) {
            DottedChain newName;
            DottedChain sChain = DottedChain.parseWithSuffix(s);
            if (namesMap.containsKey(sChain)) {
                newName = namesMap.get(sChain);
                this.constants.setString(strIndex, newName.toRawString());
            } else {
                ArrayList<String> ret = new ArrayList<String>();
                for (int p = 0; p < sChain.size(); ++p) {
                    String part = sChain.get(p);
                    if (!this.isValidNSPart(part)) {
                        ret.add(this.fooString(namesMap, part, false, "package", renameType));
                        continue;
                    }
                    ret.add(part);
                }
                newName = new DottedChain(ret);
                namesMap.put(sChain, newName);
            }
            if (stringUsages.contains(strIndex)) {
                strIndex = this.constants.addString(newName.toRawString());
            } else {
                this.constants.setString(strIndex, newName.toRawString());
            }
        }
        return strIndex;
    }

    public int deobfuscateName(Map<Integer, String> stringUsageTypes, Set<Integer> stringUsages, Set<Integer> namespaceUsages, HashMap<DottedChain, DottedChain> namesMap, int strIndex, boolean firstUppercase, RenameType renameType) {
        Pattern pat;
        if (strIndex <= 0) {
            return strIndex;
        }
        String s = this.constants.getString(strIndex);
        boolean isValid = true;
        if (IdentifiersDeobfuscation.isReservedWord2(s)) {
            isValid = false;
        }
        if (isValid) {
            for (int i = 0; i < s.length(); ++i) {
                if (s.charAt(i) <= '\u007f') continue;
                isValid = false;
                break;
            }
        }
        if (isValid && !(pat = Pattern.compile("^[" + Pattern.quote(VALID_FIRST_CHARACTERS) + "][" + Pattern.quote("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$0123456789") + "]*$")).matcher(s).matches()) {
            isValid = false;
        }
        if (!isValid) {
            DottedChain newname;
            DottedChain sChain = DottedChain.parseWithSuffix(s);
            if (namesMap.containsKey(sChain)) {
                newname = namesMap.get(sChain);
            } else {
                String str = this.fooString(namesMap, this.constants.getString(strIndex), firstUppercase, stringUsageTypes.get(strIndex), renameType);
                newname = DottedChain.parseWithSuffix(str);
            }
            if (stringUsages.contains(strIndex) || namespaceUsages.contains(strIndex)) {
                strIndex = this.constants.addString(s);
            }
            this.constants.setString(strIndex, newname.toRawString());
            if (!namesMap.containsKey(sChain)) {
                namesMap.put(sChain, DottedChain.parseWithSuffix(this.constants.getString(strIndex)));
            }
        }
        return strIndex;
    }
}

