/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.decompiler.flash;

import com.jpexs.decompiler.flash.amf.amf3.Amf3OutputStream;
import com.jpexs.decompiler.flash.amf.amf3.Amf3Value;
import com.jpexs.decompiler.flash.amf.amf3.NoSerializerExistsException;
import com.jpexs.decompiler.flash.amf.amf3.ObjectTypeSerializeHandler;
import com.jpexs.decompiler.flash.configuration.Configuration;
import com.jpexs.decompiler.flash.tags.Tag;
import com.jpexs.decompiler.flash.types.ALPHABITMAPDATA;
import com.jpexs.decompiler.flash.types.ARGB;
import com.jpexs.decompiler.flash.types.BITMAPDATA;
import com.jpexs.decompiler.flash.types.BUTTONCONDACTION;
import com.jpexs.decompiler.flash.types.BUTTONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONRECORD;
import com.jpexs.decompiler.flash.types.CLIPACTIONS;
import com.jpexs.decompiler.flash.types.CLIPEVENTFLAGS;
import com.jpexs.decompiler.flash.types.CXFORM;
import com.jpexs.decompiler.flash.types.CXFORMWITHALPHA;
import com.jpexs.decompiler.flash.types.FILLSTYLE;
import com.jpexs.decompiler.flash.types.FILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.FOCALGRADIENT;
import com.jpexs.decompiler.flash.types.GLYPHENTRY;
import com.jpexs.decompiler.flash.types.GRADIENT;
import com.jpexs.decompiler.flash.types.GRADRECORD;
import com.jpexs.decompiler.flash.types.KERNINGRECORD;
import com.jpexs.decompiler.flash.types.LANGCODE;
import com.jpexs.decompiler.flash.types.LINESTYLE;
import com.jpexs.decompiler.flash.types.LINESTYLE2;
import com.jpexs.decompiler.flash.types.LINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.MATRIX;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLE;
import com.jpexs.decompiler.flash.types.MORPHFILLSTYLEARRAY;
import com.jpexs.decompiler.flash.types.MORPHFOCALGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADIENT;
import com.jpexs.decompiler.flash.types.MORPHGRADRECORD;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLE2;
import com.jpexs.decompiler.flash.types.MORPHLINESTYLEARRAY;
import com.jpexs.decompiler.flash.types.PIX15;
import com.jpexs.decompiler.flash.types.PIX24;
import com.jpexs.decompiler.flash.types.RECT;
import com.jpexs.decompiler.flash.types.RGB;
import com.jpexs.decompiler.flash.types.RGBA;
import com.jpexs.decompiler.flash.types.SHAPE;
import com.jpexs.decompiler.flash.types.SHAPEWITHSTYLE;
import com.jpexs.decompiler.flash.types.SOUNDENVELOPE;
import com.jpexs.decompiler.flash.types.SOUNDINFO;
import com.jpexs.decompiler.flash.types.TEXTRECORD;
import com.jpexs.decompiler.flash.types.ZONEDATA;
import com.jpexs.decompiler.flash.types.ZONERECORD;
import com.jpexs.decompiler.flash.types.filters.BEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.BLURFILTER;
import com.jpexs.decompiler.flash.types.filters.COLORMATRIXFILTER;
import com.jpexs.decompiler.flash.types.filters.CONVOLUTIONFILTER;
import com.jpexs.decompiler.flash.types.filters.DROPSHADOWFILTER;
import com.jpexs.decompiler.flash.types.filters.FILTER;
import com.jpexs.decompiler.flash.types.filters.GLOWFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTBEVELFILTER;
import com.jpexs.decompiler.flash.types.filters.GRADIENTGLOWFILTER;
import com.jpexs.decompiler.flash.types.shaperecords.CurvedEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.EndShapeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.SHAPERECORD;
import com.jpexs.decompiler.flash.types.shaperecords.StraightEdgeRecord;
import com.jpexs.decompiler.flash.types.shaperecords.StyleChangeRecord;
import com.jpexs.helpers.ByteArrayRange;
import com.jpexs.helpers.utf8.Utf8Helper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class SWFOutputStream
extends OutputStream {
    private final OutputStream os;
    private final int version;
    private long pos = 0L;
    private int bitPos = 0;
    private int tempByte = 0;

    public long getPos() {
        return this.pos;
    }

    public SWFOutputStream(OutputStream os, int version) {
        this.version = version;
        this.os = os;
    }

    @Override
    public void write(int b) throws IOException {
        this.alignByte();
        this.os.write(b);
        ++this.pos;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.alignByte();
        this.os.write(b);
        this.pos += (long)b.length;
    }

    public void write(ByteArrayRange b) throws IOException {
        this.alignByte();
        this.os.write(b.getArray(), b.getPos(), b.getLength());
        this.pos += (long)b.getLength();
    }

    private void alignByte() throws IOException {
        if (this.bitPos > 0) {
            this.bitPos = 0;
            this.write(this.tempByte);
            this.tempByte = 0;
        }
    }

    public void writeUI8(int value) throws IOException {
        if (value > 255) {
            throw new IllegalArgumentException("Value is too large for UI8: " + value);
        }
        this.write(value);
    }

    public void writeString(String value) throws IOException {
        byte[] data = Utf8Helper.getBytes(value);
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 0) continue;
            throw new IOException("String should not contain null character.");
        }
        this.write(data);
        this.write(0);
    }

    public void writeNetString(String value) throws IOException {
        byte[] data = value.getBytes();
        this.writeUI8(data.length);
        this.write(data);
    }

    public void writeNetString(String value, Charset charset) throws IOException {
        byte[] data = value.getBytes(charset);
        this.writeUI8(data.length);
        this.write(data);
    }

    public void writeUI32(long value) throws IOException {
        if (value > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Value is too large for UI32: " + value);
        }
        this.write((int)(value & 0xFFL));
        this.write((int)(value >> 8 & 0xFFL));
        this.write((int)(value >> 16 & 0xFFL));
        this.write((int)(value >> 24 & 0xFFL));
    }

    public void writeUI16(int value) throws IOException {
        if (value > 65535) {
            throw new IllegalArgumentException("Value is too large for UI16: " + value);
        }
        this.write(value & 0xFF);
        this.write(value >> 8 & 0xFF);
    }

    public void writeSI32(long value) throws IOException {
        if (value > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value is too large for SI32: " + value);
        }
        this.writeUI32(value);
    }

    public void writeSI16(int value) throws IOException {
        if (value > Short.MAX_VALUE) {
            Logger.getLogger(SWFOutputStream.class.getName()).log(Level.WARNING, "Value is too large for SI16: " + value + ", 0 written", new Exception());
            value = 0;
        }
        this.writeUI16(value);
    }

    public void writeSI8(int value) throws IOException {
        if (value > 2047) {
            throw new IllegalArgumentException("Value is too large for SI8: " + value);
        }
        this.writeUI8(value);
    }

    public void writeFIXED(double value) throws IOException {
        long valueLong = (long)(value * 65536.0);
        int beforePoint = (int)valueLong >> 16;
        int afterPoint = (int)valueLong % 65536;
        this.writeUI16(afterPoint);
        this.writeUI16(beforePoint);
    }

    public void writeFIXED8(float value) throws IOException {
        int valueInt = (int)(value * 256.0f);
        int beforePoint = valueInt >> 8;
        int afterPoint = valueInt % 256;
        this.writeUI8(afterPoint);
        this.writeSI8(beforePoint);
    }

    private void writeLong(long value) throws IOException {
        byte[] writeBuffer = new byte[8];
        writeBuffer[3] = (byte)(value >>> 56);
        writeBuffer[2] = (byte)(value >>> 48);
        writeBuffer[1] = (byte)(value >>> 40);
        writeBuffer[0] = (byte)(value >>> 32);
        writeBuffer[7] = (byte)(value >>> 24);
        writeBuffer[6] = (byte)(value >>> 16);
        writeBuffer[5] = (byte)(value >>> 8);
        writeBuffer[4] = (byte)value;
        this.write(writeBuffer);
    }

    public void writeDOUBLE(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeFLOAT(float value) throws IOException {
        this.writeUI32(Float.floatToIntBits(value));
    }

    public void writeFLOAT16(float value) throws IOException {
        int bits = Float.floatToRawIntBits(value);
        int sign = bits >> 31;
        int exponent = bits >> 22 & 0xFF;
        int mantisa = bits & 0x3FFFFF;
        this.writeUI16((sign << 15) + (exponent << 10) + (mantisa >>= 13));
    }

    public void writeEncodedU32(long value) throws IOException {
        boolean loop = true;
        value &= 0xFFFFFFFFFFFFFFFFL;
        do {
            int ret = (int)(value & 0x7FL);
            if (value < 128L) {
                loop = false;
            }
            if (value > 127L) {
                ret += 128;
            }
            this.write(ret);
            value >>= 7;
        } while (loop);
    }

    @Override
    public void flush() throws IOException {
        if (this.bitPos > 0) {
            this.bitPos = 0;
            this.write(this.tempByte);
            this.tempByte = 0;
        }
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.os.close();
    }

    public void writeUB(int nBits, long value) throws IOException {
        for (int bit = 0; bit < nBits; ++bit) {
            int nb = (int)(value >> nBits - 1 - bit & 1L);
            this.tempByte += nb * (1 << 7 - this.bitPos);
            ++this.bitPos;
            if (this.bitPos != 8) continue;
            this.bitPos = 0;
            this.write(this.tempByte);
            this.tempByte = 0;
        }
    }

    public void writeSB(int nBits, long value) throws IOException {
        this.writeUB(nBits, value);
    }

    public void writeFB(int nBits, double value) throws IOException {
        if (nBits == 0) {
            return;
        }
        long longVal = (long)(value * 65536.0);
        this.writeSB(nBits, longVal);
    }

    public void writeRECT(RECT value) throws IOException {
        int nBits = 0;
        if (Configuration._debugCopy.get().booleanValue()) {
            nBits = Math.max(nBits, value.nbits);
        }
        int xMin = this.truncateTo31Bit(value.Xmin);
        int xMax = this.truncateTo31Bit(value.Xmax);
        int yMin = this.truncateTo31Bit(value.Ymin);
        int yMax = this.truncateTo31Bit(value.Ymax);
        nBits = SWFOutputStream.enlargeBitCountS(nBits, xMin);
        nBits = SWFOutputStream.enlargeBitCountS(nBits, xMax);
        nBits = SWFOutputStream.enlargeBitCountS(nBits, yMin);
        nBits = SWFOutputStream.enlargeBitCountS(nBits, yMax);
        if (Configuration._debugCopy.get().booleanValue()) {
            nBits = Math.max(nBits, value.nbits);
        }
        this.writeUB(5, nBits);
        this.writeSB(nBits, xMin);
        this.writeSB(nBits, xMax);
        this.writeSB(nBits, yMin);
        this.writeSB(nBits, yMax);
        this.alignByte();
    }

    private int truncateTo31Bit(int value) {
        if (value > 0x3FFFFFFF) {
            value = 0x3FFFFFFF;
        }
        if (value < -1073741823) {
            value = -1073741823;
        }
        return value;
    }

    public void writeTags(Iterable<Tag> tags) throws IOException {
        for (Tag tag : tags) {
            tag.writeTag(this);
        }
    }

    public static int getNeededBitsU(int value) {
        int nBits;
        if (value == 0) {
            return 0;
        }
        value = Math.abs(value);
        long x = 1L;
        for (nBits = 1; nBits <= 64 && (x <<= 1) <= (long)value; ++nBits) {
        }
        return nBits;
    }

    private static int getNeededBitsS(int v) {
        int counter;
        int val;
        int mask = Integer.MIN_VALUE;
        int n = val = v < 0 ? -v : v;
        for (counter = 32; (val & mask) == 0 && counter > 0; --counter) {
            mask >>>= 1;
        }
        return counter + 1;
    }

    public static int getNeededBitsS(int first, int ... params) {
        int nBits = 0;
        nBits = SWFOutputStream.enlargeBitCountS(nBits, first);
        for (int i = 0; i < params.length; ++i) {
            nBits = SWFOutputStream.enlargeBitCountS(nBits, params[i]);
        }
        return nBits;
    }

    public static int getNeededBitsU(int first, int ... params) {
        int nBits = 0;
        nBits = SWFOutputStream.enlargeBitCountU(nBits, first);
        for (int i = 0; i < params.length; ++i) {
            nBits = SWFOutputStream.enlargeBitCountU(nBits, params[i]);
        }
        return nBits;
    }

    public static int unsignedSize(int value) {
        int counter;
        int val = value < 0 ? -value - 1 : value;
        int mask = Integer.MIN_VALUE;
        for (counter = 32; (val & mask) == 0 && counter > 0; --counter) {
            mask >>>= 1;
        }
        return counter;
    }

    public static int getNeededBitsF(float value) {
        int k = (int)value;
        return SWFOutputStream.getNeededBitsS(k) + 16;
    }

    public static int enlargeBitCountS(int currentBitCount, int value) {
        if (value == 0) {
            return currentBitCount;
        }
        int neededNew = SWFOutputStream.getNeededBitsS(value);
        if (neededNew > currentBitCount) {
            return neededNew;
        }
        return currentBitCount;
    }

    public static int enlargeBitCountU(int currentBitCount, int value) {
        if (value == 0) {
            return currentBitCount;
        }
        int neededNew = SWFOutputStream.getNeededBitsU(value);
        if (neededNew > currentBitCount) {
            return neededNew;
        }
        return currentBitCount;
    }

    public void writeMatrix(MATRIX value) throws IOException {
        int nBits;
        this.writeUB(1, value.hasScale ? 1L : 0L);
        if (value.hasScale) {
            nBits = 0;
            nBits = SWFOutputStream.enlargeBitCountS(nBits, value.scaleX);
            nBits = SWFOutputStream.enlargeBitCountS(nBits, value.scaleY);
            if (Configuration._debugCopy.get().booleanValue()) {
                nBits = Math.max(nBits, value.nScaleBits);
            }
            this.writeUB(5, nBits);
            this.writeSB(nBits, value.scaleX);
            this.writeSB(nBits, value.scaleY);
        }
        this.writeUB(1, value.hasRotate ? 1L : 0L);
        if (value.hasRotate) {
            nBits = 0;
            nBits = SWFOutputStream.enlargeBitCountS(nBits, value.rotateSkew0);
            nBits = SWFOutputStream.enlargeBitCountS(nBits, value.rotateSkew1);
            if (Configuration._debugCopy.get().booleanValue()) {
                nBits = Math.max(nBits, value.nRotateBits);
            }
            this.writeUB(5, nBits);
            this.writeSB(nBits, value.rotateSkew0);
            this.writeSB(nBits, value.rotateSkew1);
        }
        int NTranslateBits = 0;
        NTranslateBits = SWFOutputStream.enlargeBitCountS(NTranslateBits, value.translateX);
        NTranslateBits = SWFOutputStream.enlargeBitCountS(NTranslateBits, value.translateY);
        if (Configuration._debugCopy.get().booleanValue()) {
            NTranslateBits = Math.max(NTranslateBits, value.nTranslateBits);
        }
        this.writeUB(5, NTranslateBits);
        this.writeSB(NTranslateBits, value.translateX);
        this.writeSB(NTranslateBits, value.translateY);
        this.alignByte();
    }

    public void writeCXFORM(CXFORM value) throws IOException {
        this.writeUB(1, value.hasAddTerms ? 1L : 0L);
        this.writeUB(1, value.hasMultTerms ? 1L : 0L);
        int Nbits = 1;
        if (value.hasMultTerms) {
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.redMultTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.greenMultTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.blueMultTerm);
        }
        if (value.hasAddTerms) {
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.redAddTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.greenAddTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.blueAddTerm);
        }
        if (Configuration._debugCopy.get().booleanValue()) {
            Nbits = Math.max(Nbits, value.nbits);
        }
        this.writeUB(4, Nbits);
        if (value.hasMultTerms) {
            this.writeSB(Nbits, value.redMultTerm);
            this.writeSB(Nbits, value.greenMultTerm);
            this.writeSB(Nbits, value.blueMultTerm);
        }
        if (value.hasAddTerms) {
            this.writeSB(Nbits, value.redAddTerm);
            this.writeSB(Nbits, value.greenAddTerm);
            this.writeSB(Nbits, value.blueAddTerm);
        }
        this.alignByte();
    }

    public void writeCXFORMWITHALPHA(CXFORMWITHALPHA value) throws IOException {
        this.writeUB(1, value.hasAddTerms ? 1L : 0L);
        this.writeUB(1, value.hasMultTerms ? 1L : 0L);
        int Nbits = 1;
        if (value.hasMultTerms) {
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.redMultTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.greenMultTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.blueMultTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.alphaMultTerm);
        }
        if (value.hasAddTerms) {
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.redAddTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.greenAddTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.blueAddTerm);
            Nbits = SWFOutputStream.enlargeBitCountS(Nbits, value.alphaAddTerm);
        }
        if (Configuration._debugCopy.get().booleanValue()) {
            Nbits = Math.max(Nbits, value.nbits);
        }
        this.writeUB(4, Nbits);
        if (value.hasMultTerms) {
            this.writeSB(Nbits, value.redMultTerm);
            this.writeSB(Nbits, value.greenMultTerm);
            this.writeSB(Nbits, value.blueMultTerm);
            this.writeSB(Nbits, value.alphaMultTerm);
        }
        if (value.hasAddTerms) {
            this.writeSB(Nbits, value.redAddTerm);
            this.writeSB(Nbits, value.greenAddTerm);
            this.writeSB(Nbits, value.blueAddTerm);
            this.writeSB(Nbits, value.alphaAddTerm);
        }
        this.alignByte();
    }

    public void writeCLIPEVENTFLAGS(CLIPEVENTFLAGS value) throws IOException {
        this.writeUB(1, value.clipEventKeyUp ? 1L : 0L);
        this.writeUB(1, value.clipEventKeyDown ? 1L : 0L);
        this.writeUB(1, value.clipEventMouseUp ? 1L : 0L);
        this.writeUB(1, value.clipEventMouseDown ? 1L : 0L);
        this.writeUB(1, value.clipEventMouseMove ? 1L : 0L);
        this.writeUB(1, value.clipEventUnload ? 1L : 0L);
        this.writeUB(1, value.clipEventEnterFrame ? 1L : 0L);
        this.writeUB(1, value.clipEventLoad ? 1L : 0L);
        this.writeUB(1, value.clipEventDragOver ? 1L : 0L);
        this.writeUB(1, value.clipEventRollOut ? 1L : 0L);
        this.writeUB(1, value.clipEventRollOver ? 1L : 0L);
        this.writeUB(1, value.clipEventReleaseOutside ? 1L : 0L);
        this.writeUB(1, value.clipEventRelease ? 1L : 0L);
        this.writeUB(1, value.clipEventPress ? 1L : 0L);
        this.writeUB(1, value.clipEventInitialize ? 1L : 0L);
        this.writeUB(1, value.clipEventData ? 1L : 0L);
        if (this.version >= 6) {
            this.writeUB(5, value.reserved);
            this.writeUB(1, value.clipEventConstruct ? 1L : 0L);
            this.writeUB(1, value.clipEventKeyPress ? 1L : 0L);
            this.writeUB(1, value.clipEventDragOut ? 1L : 0L);
            this.writeUB(8, value.reserved2);
        }
    }

    public void writeCLIPACTIONRECORD(CLIPACTIONRECORD value) throws IOException {
        this.writeCLIPEVENTFLAGS(value.eventFlags);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (SWFOutputStream sos = new SWFOutputStream(baos, this.version);){
            if (value.eventFlags.clipEventKeyPress) {
                sos.writeUI8(value.keyCode);
            }
            sos.write(value.actionBytes);
        }
        byte[] data = baos.toByteArray();
        this.writeUI32(data.length);
        this.write(data);
    }

    public void writeCLIPACTIONS(CLIPACTIONS value) throws IOException {
        this.writeUI16(value.reserved);
        this.writeCLIPEVENTFLAGS(value.allEventFlags);
        for (CLIPACTIONRECORD car : value.clipActionRecords) {
            this.writeCLIPACTIONRECORD(car);
        }
        if (this.version <= 5) {
            this.writeUI16(0);
        } else {
            this.writeUI32(0L);
        }
    }

    public void writeCOLORMATRIXFILTER(COLORMATRIXFILTER value) throws IOException {
        for (int i = 0; i < 20; ++i) {
            this.writeFLOAT(value.matrix[i]);
        }
    }

    public void writeRGBA(RGBA value) throws IOException {
        this.writeUI8(value.red);
        this.writeUI8(value.green);
        this.writeUI8(value.blue);
        this.writeUI8(value.alpha);
    }

    public void writeARGB(ARGB value) throws IOException {
        this.writeUI8(value.alpha);
        this.writeUI8(value.red);
        this.writeUI8(value.green);
        this.writeUI8(value.blue);
    }

    public void writeARGB(int value) throws IOException {
        this.writeUI8(value >> 24 & 0xFF);
        this.writeUI8(value >> 16 & 0xFF);
        this.writeUI8(value >> 8 & 0xFF);
        this.writeUI8(value & 0xFF);
    }

    public void writeRGB(RGB value) throws IOException {
        this.writeUI8(value.red);
        this.writeUI8(value.green);
        this.writeUI8(value.blue);
    }

    public void writeCONVOLUTIONFILTER(CONVOLUTIONFILTER value) throws IOException {
        this.writeUI8(value.matrixX);
        this.writeUI8(value.matrixY);
        this.writeFLOAT(value.divisor);
        this.writeFLOAT(value.bias);
        for (int x = 0; x < value.matrixX; ++x) {
            for (int y = 0; y < value.matrixY; ++y) {
                this.writeFLOAT(value.matrix[x][y]);
            }
        }
        this.writeRGBA(value.defaultColor);
        this.writeUB(6, value.reserved);
        this.writeUB(1, value.clamp ? 1L : 0L);
        this.writeUB(1, value.preserveAlpha ? 1L : 0L);
    }

    public void writeBLURFILTER(BLURFILTER value) throws IOException {
        this.writeFIXED(value.blurX);
        this.writeFIXED(value.blurY);
        this.writeUB(5, value.passes);
        this.writeUB(3, value.reserved);
    }

    public void writeDROPSHADOWFILTER(DROPSHADOWFILTER value) throws IOException {
        this.writeRGBA(value.dropShadowColor);
        this.writeFIXED(value.blurX);
        this.writeFIXED(value.blurY);
        this.writeFIXED(value.angle);
        this.writeFIXED(value.distance);
        this.writeFIXED8(value.strength);
        this.writeUB(1, value.innerShadow ? 1L : 0L);
        this.writeUB(1, value.knockout ? 1L : 0L);
        this.writeUB(1, value.compositeSource ? 1L : 0L);
        this.writeUB(5, value.passes);
    }

    public void writeGLOWFILTER(GLOWFILTER value) throws IOException {
        this.writeRGBA(value.glowColor);
        this.writeFIXED(value.blurX);
        this.writeFIXED(value.blurY);
        this.writeFIXED8(value.strength);
        this.writeUB(1, value.innerGlow ? 1L : 0L);
        this.writeUB(1, value.knockout ? 1L : 0L);
        this.writeUB(1, value.compositeSource ? 1L : 0L);
        this.writeUB(5, value.passes);
    }

    public void writeBEVELFILTER(BEVELFILTER value) throws IOException {
        this.writeRGBA(value.highlightColor);
        this.writeRGBA(value.shadowColor);
        this.writeFIXED(value.blurX);
        this.writeFIXED(value.blurY);
        this.writeFIXED(value.angle);
        this.writeFIXED(value.distance);
        this.writeFIXED8(value.strength);
        this.writeUB(1, value.innerShadow ? 1L : 0L);
        this.writeUB(1, value.knockout ? 1L : 0L);
        this.writeUB(1, value.compositeSource ? 1L : 0L);
        this.writeUB(1, value.onTop ? 1L : 0L);
        this.writeUB(4, value.passes);
    }

    public void writeGRADIENTGLOWFILTER(GRADIENTGLOWFILTER value) throws IOException {
        int i;
        this.writeUI8(value.gradientColors.length);
        for (i = 0; i < value.gradientColors.length; ++i) {
            this.writeRGBA(value.gradientColors[i]);
        }
        for (i = 0; i < value.gradientColors.length; ++i) {
            this.writeUI8(value.gradientRatio[i]);
        }
        this.writeFIXED(value.blurX);
        this.writeFIXED(value.blurY);
        this.writeFIXED(value.angle);
        this.writeFIXED(value.distance);
        this.writeFIXED8(value.strength);
        this.writeUB(1, value.innerShadow ? 1L : 0L);
        this.writeUB(1, value.knockout ? 1L : 0L);
        this.writeUB(1, value.compositeSource ? 1L : 0L);
        this.writeUB(1, value.onTop ? 1L : 0L);
        this.writeUB(4, value.passes);
    }

    public void writeGRADIENTBEVELFILTER(GRADIENTBEVELFILTER value) throws IOException {
        int i;
        this.writeUI8(value.gradientColors.length);
        for (i = 0; i < value.gradientColors.length; ++i) {
            this.writeRGBA(value.gradientColors[i]);
        }
        for (i = 0; i < value.gradientColors.length; ++i) {
            this.writeUI8(value.gradientRatio[i]);
        }
        this.writeFIXED(value.blurX);
        this.writeFIXED(value.blurY);
        this.writeFIXED(value.angle);
        this.writeFIXED(value.distance);
        this.writeFIXED8(value.strength);
        this.writeUB(1, value.innerShadow ? 1L : 0L);
        this.writeUB(1, value.knockout ? 1L : 0L);
        this.writeUB(1, value.compositeSource ? 1L : 0L);
        this.writeUB(1, value.onTop ? 1L : 0L);
        this.writeUB(4, value.passes);
    }

    public void writeFILTERLIST(List<FILTER> list) throws IOException {
        this.writeUI8(list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.writeFILTER(list.get(i));
        }
    }

    public void writeFILTER(FILTER value) throws IOException {
        this.writeUI8(value.id);
        if (value instanceof DROPSHADOWFILTER) {
            this.writeDROPSHADOWFILTER((DROPSHADOWFILTER)value);
        }
        if (value instanceof BLURFILTER) {
            this.writeBLURFILTER((BLURFILTER)value);
        }
        if (value instanceof GLOWFILTER) {
            this.writeGLOWFILTER((GLOWFILTER)value);
        }
        if (value instanceof BEVELFILTER) {
            this.writeBEVELFILTER((BEVELFILTER)value);
        }
        if (value instanceof GRADIENTGLOWFILTER) {
            this.writeGRADIENTGLOWFILTER((GRADIENTGLOWFILTER)value);
        }
        if (value instanceof CONVOLUTIONFILTER) {
            this.writeCONVOLUTIONFILTER((CONVOLUTIONFILTER)value);
        }
        if (value instanceof COLORMATRIXFILTER) {
            this.writeCOLORMATRIXFILTER((COLORMATRIXFILTER)value);
        }
        if (value instanceof GRADIENTBEVELFILTER) {
            this.writeGRADIENTBEVELFILTER((GRADIENTBEVELFILTER)value);
        }
    }

    public void writeBUTTONRECORDList(List<BUTTONRECORD> list, boolean inDefineButton2) throws IOException {
        for (BUTTONRECORD brec : list) {
            this.writeBUTTONRECORD(brec, inDefineButton2);
        }
        this.writeUI8(0);
    }

    public void writeBUTTONRECORD(BUTTONRECORD value, boolean inDefineButton2) throws IOException {
        this.writeUB(2, value.reserved);
        this.writeUB(1, value.buttonHasBlendMode ? 1L : 0L);
        this.writeUB(1, value.buttonHasFilterList ? 1L : 0L);
        this.writeUB(1, value.buttonStateHitTest ? 1L : 0L);
        this.writeUB(1, value.buttonStateDown ? 1L : 0L);
        this.writeUB(1, value.buttonStateOver ? 1L : 0L);
        this.writeUB(1, value.buttonStateUp ? 1L : 0L);
        this.writeUI16(value.characterId);
        this.writeUI16(value.placeDepth);
        this.writeMatrix(value.placeMatrix);
        if (inDefineButton2) {
            this.writeCXFORMWITHALPHA(value.colorTransform);
            if (value.buttonHasFilterList) {
                this.writeFILTERLIST(value.filterList);
            }
            if (value.buttonHasBlendMode) {
                this.writeUI8(value.blendMode);
            }
        }
    }

    public void writeBUTTONCONDACTIONList(List<BUTTONCONDACTION> list) throws IOException {
        for (int i = 0; i < list.size(); ++i) {
            this.writeBUTTONCONDACTION(list.get(i), i == list.size() - 1);
        }
    }

    public void writeBUTTONCONDACTION(BUTTONCONDACTION value, boolean isLast) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (SWFOutputStream sos = new SWFOutputStream(baos, this.version);){
            sos.writeUB(1, value.condIdleToOverDown ? 1L : 0L);
            sos.writeUB(1, value.condOutDownToIdle ? 1L : 0L);
            sos.writeUB(1, value.condOutDownToOverDown ? 1L : 0L);
            sos.writeUB(1, value.condOverDownToOutDown ? 1L : 0L);
            sos.writeUB(1, value.condOverDownToOverUp ? 1L : 0L);
            sos.writeUB(1, value.condOverUpToOverDown ? 1L : 0L);
            sos.writeUB(1, value.condOverUpToIddle ? 1L : 0L);
            sos.writeUB(1, value.condIdleToOverUp ? 1L : 0L);
            sos.writeUB(7, value.condKeyPress);
            sos.writeUB(1, value.condOverDownToIdle ? 1L : 0L);
            sos.write(value.actionBytes);
        }
        byte[] data = baos.toByteArray();
        if (isLast) {
            this.writeUI16(0);
        } else {
            this.writeUI16(data.length + 2);
        }
        this.write(data);
    }

    public void writeFILLSTYLE(FILLSTYLE value, int shapeNum) throws IOException {
        this.writeUI8(value.fillStyleType);
        if (value.fillStyleType == 0) {
            if (shapeNum >= 3) {
                this.writeRGBA((RGBA)value.color);
            } else if (shapeNum == 1 || shapeNum == 2) {
                this.writeRGB(value.color);
            }
        }
        if (value.fillStyleType == 16 || value.fillStyleType == 18 || value.fillStyleType == 19) {
            this.writeMatrix(value.gradientMatrix);
        }
        if (value.fillStyleType == 16 || value.fillStyleType == 18) {
            this.writeGRADIENT(value.gradient, shapeNum);
        } else if (value.fillStyleType == 19) {
            this.writeFOCALGRADIENT((FOCALGRADIENT)value.gradient, shapeNum);
        }
        if (value.fillStyleType == 64 || value.fillStyleType == 65 || value.fillStyleType == 66 || value.fillStyleType == 67) {
            this.writeUI16(value.bitmapId);
            this.writeMatrix(value.bitmapMatrix);
        }
    }

    public void writeFILLSTYLEARRAY(FILLSTYLEARRAY value, int shapeNum) throws IOException {
        int fillStyleCount = value.fillStyles.length;
        if (shapeNum > 1) {
            if (fillStyleCount >= 255) {
                this.writeUI8(255);
                this.writeUI16(fillStyleCount);
            } else {
                this.writeUI8(fillStyleCount);
            }
        } else {
            this.writeUI8(fillStyleCount);
        }
        for (int i = 0; i < value.fillStyles.length; ++i) {
            this.writeFILLSTYLE(value.fillStyles[i], shapeNum);
        }
    }

    public void writeFOCALGRADIENT(FOCALGRADIENT value, int shapeNum) throws IOException {
        this.writeUB(2, value.spreadMode);
        this.writeUB(2, value.interpolationMode);
        this.writeUB(4, value.gradientRecords.length);
        for (int i = 0; i < value.gradientRecords.length; ++i) {
            this.writeGRADRECORD(value.gradientRecords[i], shapeNum);
        }
        this.writeFIXED8(value.focalPoint);
    }

    public void writeGRADIENT(GRADIENT value, int shapeNum) throws IOException {
        this.writeUB(2, value.spreadMode);
        this.writeUB(2, value.interpolationMode);
        this.writeUB(4, value.gradientRecords.length);
        for (int i = 0; i < value.gradientRecords.length; ++i) {
            this.writeGRADRECORD(value.gradientRecords[i], shapeNum);
        }
    }

    public void writeGRADRECORD(GRADRECORD value, int shapeNum) throws IOException {
        this.writeUI8(value.ratio);
        if (shapeNum >= 3) {
            this.writeRGBA((RGBA)value.color);
        } else {
            this.writeRGB(value.color);
        }
    }

    public void writeLINESTYLE(LINESTYLE value, int shapeNum) throws IOException {
        this.writeUI16(value.width);
        if (shapeNum == 1 || shapeNum == 2) {
            this.writeRGB(value.color);
        } else if (shapeNum == 3) {
            this.writeRGBA((RGBA)value.color);
        }
    }

    public void writeLINESTYLE2(LINESTYLE2 value, int shapeNum) throws IOException {
        this.writeUI16(value.width);
        this.writeUB(2, value.startCapStyle);
        this.writeUB(2, value.joinStyle);
        this.writeUB(1, value.hasFillFlag ? 1L : 0L);
        this.writeUB(1, value.noHScaleFlag ? 1L : 0L);
        this.writeUB(1, value.noVScaleFlag ? 1L : 0L);
        this.writeUB(1, value.pixelHintingFlag ? 1L : 0L);
        this.writeUB(5, value.reserved);
        this.writeUB(1, value.noClose ? 1L : 0L);
        this.writeUB(2, value.endCapStyle);
        if (value.joinStyle == 2) {
            this.writeFIXED8(value.miterLimitFactor);
        }
        if (!value.hasFillFlag) {
            this.writeRGBA((RGBA)value.color);
        } else {
            this.writeFILLSTYLE(value.fillType, shapeNum);
        }
    }

    public void writeLINESTYLEARRAY(LINESTYLEARRAY value, int shapeNum) throws IOException {
        if (shapeNum <= 3) {
            int lineStyleCount = value.lineStyles.length;
            if (lineStyleCount >= 255) {
                this.writeUI8(255);
                this.writeUI16(lineStyleCount);
            } else {
                this.writeUI8(lineStyleCount);
            }
            for (int i = 0; i < lineStyleCount; ++i) {
                this.writeLINESTYLE(value.lineStyles[i], shapeNum);
            }
        } else {
            int lineStyleCount = value.lineStyles.length;
            if (lineStyleCount >= 255) {
                this.writeUI8(255);
                this.writeUI16(lineStyleCount);
            } else {
                this.writeUI8(lineStyleCount);
            }
            for (int i = 0; i < lineStyleCount; ++i) {
                this.writeLINESTYLE2((LINESTYLE2)value.lineStyles[i], shapeNum);
            }
        }
    }

    public void writeSHAPE(SHAPE value, int shapeNum) throws IOException {
        this.writeUB(4, value.numFillBits);
        this.writeUB(4, value.numLineBits);
        this.writeSHAPERECORDS(value.shapeRecords, value.numFillBits, value.numLineBits, shapeNum);
    }

    public void writeSHAPEWITHSTYLE(SHAPEWITHSTYLE value, int shapeNum) throws IOException {
        this.writeFILLSTYLEARRAY(value.fillStyles, shapeNum);
        this.writeLINESTYLEARRAY(value.lineStyles, shapeNum);
        value.numFillBits = SWFOutputStream.getNeededBitsU(value.fillStyles.fillStyles.length);
        value.numLineBits = SWFOutputStream.getNeededBitsU(value.lineStyles.lineStyles.length);
        this.writeUB(4, value.numFillBits);
        this.writeUB(4, value.numLineBits);
        this.writeSHAPERECORDS(value.shapeRecords, value.numFillBits, value.numLineBits, shapeNum);
    }

    private void writeSHAPERECORDS(List<SHAPERECORD> value, int fillBits, int lineBits, int shapeNum) throws IOException {
        for (SHAPERECORD sh : value) {
            int numBits;
            if (sh instanceof CurvedEdgeRecord) {
                CurvedEdgeRecord cer = (CurvedEdgeRecord)sh;
                this.writeUB(1, 1L);
                this.writeUB(1, 0L);
                numBits = Math.max(SWFOutputStream.getNeededBitsS(cer.controlDeltaX, cer.controlDeltaY, cer.anchorDeltaX, cer.anchorDeltaY) - 2, 0);
                if (Configuration._debugCopy.get().booleanValue()) {
                    numBits = Math.max(numBits, cer.numBits);
                }
                cer.numBits = numBits;
                this.writeUB(4, cer.numBits);
                this.writeSB(cer.numBits + 2, cer.controlDeltaX);
                this.writeSB(cer.numBits + 2, cer.controlDeltaY);
                this.writeSB(cer.numBits + 2, cer.anchorDeltaX);
                this.writeSB(cer.numBits + 2, cer.anchorDeltaY);
                continue;
            }
            if (sh instanceof StraightEdgeRecord) {
                StraightEdgeRecord ser = (StraightEdgeRecord)sh;
                this.writeUB(1, 1L);
                this.writeUB(1, 1L);
                numBits = Math.max(SWFOutputStream.getNeededBitsS(ser.deltaX, ser.deltaY) - 2, 0);
                if (Configuration._debugCopy.get().booleanValue()) {
                    numBits = Math.max(numBits, ser.numBits);
                }
                ser.numBits = numBits;
                this.writeUB(4, ser.numBits);
                this.writeUB(1, ser.generalLineFlag ? 1L : 0L);
                if (!ser.generalLineFlag) {
                    this.writeUB(1, ser.vertLineFlag ? 1L : 0L);
                }
                if (ser.generalLineFlag || !ser.vertLineFlag) {
                    this.writeSB(ser.numBits + 2, ser.deltaX);
                }
                if (!ser.generalLineFlag && !ser.vertLineFlag) continue;
                this.writeSB(ser.numBits + 2, ser.deltaY);
                continue;
            }
            if (sh instanceof StyleChangeRecord) {
                StyleChangeRecord scr = (StyleChangeRecord)sh;
                this.writeUB(1, 0L);
                this.writeUB(1, scr.stateNewStyles ? 1L : 0L);
                this.writeUB(1, scr.stateLineStyle ? 1L : 0L);
                this.writeUB(1, scr.stateFillStyle1 ? 1L : 0L);
                this.writeUB(1, scr.stateFillStyle0 ? 1L : 0L);
                this.writeUB(1, scr.stateMoveTo ? 1L : 0L);
                if (scr.stateMoveTo) {
                    int moveBits = SWFOutputStream.getNeededBitsS(scr.moveDeltaX, scr.moveDeltaY);
                    if (Configuration._debugCopy.get().booleanValue()) {
                        moveBits = Math.max(moveBits, scr.moveBits);
                    }
                    scr.moveBits = moveBits;
                    this.writeUB(5, scr.moveBits);
                    this.writeSB(scr.moveBits, scr.moveDeltaX);
                    this.writeSB(scr.moveBits, scr.moveDeltaY);
                }
                if (scr.stateFillStyle0) {
                    this.writeUB(fillBits, scr.fillStyle0);
                }
                if (scr.stateFillStyle1) {
                    this.writeUB(fillBits, scr.fillStyle1);
                }
                if (scr.stateLineStyle) {
                    this.writeUB(lineBits, scr.lineStyle);
                }
                if (!scr.stateNewStyles) continue;
                this.writeFILLSTYLEARRAY(scr.fillStyles, shapeNum);
                this.writeLINESTYLEARRAY(scr.lineStyles, shapeNum);
                fillBits = SWFOutputStream.getNeededBitsU(scr.fillStyles.fillStyles.length);
                lineBits = SWFOutputStream.getNeededBitsU(scr.lineStyles.lineStyles.length);
                if (Configuration._debugCopy.get().booleanValue()) {
                    fillBits = Math.max(fillBits, scr.numFillBits);
                    lineBits = Math.max(lineBits, scr.numLineBits);
                }
                scr.numFillBits = fillBits;
                scr.numLineBits = lineBits;
                this.writeUB(4, scr.numFillBits);
                this.writeUB(4, scr.numLineBits);
                continue;
            }
            if (!(sh instanceof EndShapeRecord)) continue;
            this.writeUB(1, 0L);
            this.writeUB(5, 0L);
        }
        this.alignByte();
    }

    public void writeSOUNDINFO(SOUNDINFO value) throws IOException {
        this.writeUB(2, value.reserved);
        this.writeUB(1, value.syncStop ? 1L : 0L);
        this.writeUB(1, value.syncNoMultiple ? 1L : 0L);
        this.writeUB(1, value.hasEnvelope ? 1L : 0L);
        this.writeUB(1, value.hasLoops ? 1L : 0L);
        this.writeUB(1, value.hasOutPoint ? 1L : 0L);
        this.writeUB(1, value.hasInPoint ? 1L : 0L);
        if (value.hasInPoint) {
            this.writeUI32(value.inPoint);
        }
        if (value.hasOutPoint) {
            this.writeUI32(value.outPoint);
        }
        if (value.hasLoops) {
            this.writeUI16(value.loopCount);
        }
        if (value.hasEnvelope) {
            this.writeUI8(value.envelopeRecords.length);
            for (SOUNDENVELOPE env : value.envelopeRecords) {
                this.writeSOUNDENVELOPE(env);
            }
        }
    }

    public void writeSOUNDENVELOPE(SOUNDENVELOPE value) throws IOException {
        this.writeUI32(value.pos44);
        this.writeUI16(value.leftLevel);
        this.writeUI16(value.rightLevel);
    }

    public void writeTEXTRECORD(TEXTRECORD value, int defineTextNum, int glyphBits, int advanceBits) throws IOException {
        this.writeUB(1, 1L);
        this.writeUB(3, 0L);
        this.writeUB(1, value.styleFlagsHasFont ? 1L : 0L);
        this.writeUB(1, value.styleFlagsHasColor ? 1L : 0L);
        this.writeUB(1, value.styleFlagsHasYOffset ? 1L : 0L);
        this.writeUB(1, value.styleFlagsHasXOffset ? 1L : 0L);
        if (value.styleFlagsHasFont) {
            this.writeUI16(value.fontId);
        }
        if (value.styleFlagsHasColor) {
            if (defineTextNum == 2) {
                this.writeRGBA(value.textColorA);
            } else {
                this.writeRGB(value.textColor);
            }
        }
        if (value.styleFlagsHasXOffset) {
            this.writeSI16(value.xOffset);
        }
        if (value.styleFlagsHasYOffset) {
            this.writeSI16(value.yOffset);
        }
        if (value.styleFlagsHasFont) {
            this.writeUI16(value.textHeight);
        }
        this.writeUI8(value.glyphEntries.size());
        for (GLYPHENTRY ge : value.glyphEntries) {
            this.writeGLYPHENTRY(ge, glyphBits, advanceBits);
        }
        this.alignByte();
    }

    public void writeGLYPHENTRY(GLYPHENTRY value, int glyphBits, int advanceBits) throws IOException {
        this.writeUB(glyphBits, value.glyphIndex);
        this.writeSB(advanceBits, value.glyphAdvance);
    }

    public void writeMORPHFILLSTYLE(MORPHFILLSTYLE value, int shapeNum) throws IOException {
        this.writeUI8(value.fillStyleType);
        if (value.fillStyleType == 0) {
            this.writeRGBA(value.startColor);
            this.writeRGBA(value.endColor);
        }
        if (value.fillStyleType == 16 || value.fillStyleType == 18 || value.fillStyleType == 19) {
            this.writeMatrix(value.startGradientMatrix);
            this.writeMatrix(value.endGradientMatrix);
        }
        if (value.fillStyleType == 16 || value.fillStyleType == 18) {
            this.writeMORPHGRADIENT(value.gradient, shapeNum);
        }
        if (value.fillStyleType == 19) {
            this.writeMORPHFOCALGRADIENT((MORPHFOCALGRADIENT)value.gradient, shapeNum);
        }
        if (value.fillStyleType == 64 || value.fillStyleType == 65 || value.fillStyleType == 66 || value.fillStyleType == 67) {
            this.writeUI16(value.bitmapId);
            this.writeMatrix(value.startBitmapMatrix);
            this.writeMatrix(value.endBitmapMatrix);
        }
    }

    public void writeMORPHFILLSTYLEARRAY(MORPHFILLSTYLEARRAY value, int morphShapeNum) throws IOException {
        int fillStyleCount = value.fillStyles.length;
        if (fillStyleCount >= 255) {
            this.writeUI8(255);
            this.writeUI16(fillStyleCount);
        } else {
            this.writeUI8(fillStyleCount);
        }
        for (int i = 0; i < value.fillStyles.length; ++i) {
            this.writeMORPHFILLSTYLE(value.fillStyles[i], morphShapeNum);
        }
    }

    public void writeMORPHGRADIENT(MORPHGRADIENT value, int shapeNum) throws IOException {
        this.writeUB(2, value.spreadMode);
        this.writeUB(2, value.interPolationMode);
        this.writeUB(4, value.gradientRecords.length);
        for (int i = 0; i < value.gradientRecords.length; ++i) {
            this.writeMORPHGRADRECORD(value.gradientRecords[i]);
        }
    }

    public void writeMORPHFOCALGRADIENT(MORPHFOCALGRADIENT value, int shapeNum) throws IOException {
        this.writeUB(2, value.spreadMode);
        this.writeUB(2, value.interPolationMode);
        this.writeUB(4, value.gradientRecords.length);
        for (int i = 0; i < value.gradientRecords.length; ++i) {
            this.writeMORPHGRADRECORD(value.gradientRecords[i]);
        }
        this.writeFIXED8(value.startFocalPoint);
        this.writeFIXED8(value.endFocalPoint);
    }

    public void writeMORPHGRADRECORD(MORPHGRADRECORD value) throws IOException {
        this.writeUI8(value.startRatio);
        this.writeRGBA(value.startColor);
        this.writeUI8(value.endRatio);
        this.writeRGBA(value.endColor);
    }

    public void writeMORPHLINESTYLE(MORPHLINESTYLE value, int shapeNum) throws IOException {
        this.writeUI16(value.startWidth);
        this.writeUI16(value.endWidth);
        this.writeRGBA(value.startColor);
        this.writeRGBA(value.endColor);
    }

    public void writeMORPHLINESTYLE2(MORPHLINESTYLE2 value, int shapeNum) throws IOException {
        this.writeUI16(value.startWidth);
        this.writeUI16(value.endWidth);
        this.writeUB(2, value.startCapStyle);
        this.writeUB(2, value.joinStyle);
        this.writeUB(1, value.hasFillFlag ? 1L : 0L);
        this.writeUB(1, value.noHScaleFlag ? 1L : 0L);
        this.writeUB(1, value.noVScaleFlag ? 1L : 0L);
        this.writeUB(1, value.pixelHintingFlag ? 1L : 0L);
        this.writeUB(5, value.reserved);
        this.writeUB(1, value.noClose ? 1L : 0L);
        this.writeUB(2, value.endCapStyle);
        if (value.joinStyle == 2) {
            this.writeUI16(value.miterLimitFactor);
        }
        if (!value.hasFillFlag) {
            this.writeRGBA(value.startColor);
            this.writeRGBA(value.endColor);
        } else {
            this.writeMORPHFILLSTYLE(value.fillType, shapeNum);
        }
    }

    public void writeMORPHLINESTYLEARRAY(MORPHLINESTYLEARRAY value, int morphShapeNum) throws IOException {
        block7: {
            block6: {
                if (morphShapeNum != 1) break block6;
                int lineStyleCount = value.lineStyles.length;
                if (lineStyleCount >= 255) {
                    this.writeUI8(255);
                    this.writeUI16(lineStyleCount);
                } else {
                    this.writeUI8(lineStyleCount);
                }
                for (int i = 0; i < lineStyleCount; ++i) {
                    this.writeMORPHLINESTYLE(value.lineStyles[i], morphShapeNum);
                }
                break block7;
            }
            if (morphShapeNum != 2) break block7;
            int lineStyleCount = value.lineStyles2.length;
            if (lineStyleCount >= 255) {
                this.writeUI8(255);
                this.writeUI16(lineStyleCount);
            } else {
                this.writeUI8(lineStyleCount);
            }
            for (int i = 0; i < lineStyleCount; ++i) {
                this.writeMORPHLINESTYLE2(value.lineStyles2[i], morphShapeNum);
            }
        }
    }

    public void writeKERNINGRECORD(KERNINGRECORD value, boolean fontFlagsWideCodes) throws IOException {
        if (fontFlagsWideCodes) {
            this.writeUI16(value.fontKerningCode1);
            this.writeUI16(value.fontKerningCode2);
        } else {
            this.writeUI8(value.fontKerningCode1);
            this.writeUI8(value.fontKerningCode2);
        }
        this.writeSI16(value.fontKerningAdjustment);
    }

    public void writeLANGCODE(LANGCODE value) throws IOException {
        this.writeUI8(value.languageCode);
    }

    public void writeZONERECORD(ZONERECORD value) throws IOException {
        this.writeUI8(value.zonedata.length);
        for (int i = 0; i < value.zonedata.length; ++i) {
            this.writeZONEDATA(value.zonedata[i]);
        }
        this.writeUB(6, 0L);
        this.writeUB(1, value.zoneMaskY ? 1L : 0L);
        this.writeUB(1, value.zoneMaskX ? 1L : 0L);
    }

    public void writeZONEDATA(ZONEDATA value) throws IOException {
        this.writeUI16(value.alignmentCoordinate);
        this.writeUI16(value.range);
    }

    public void writeBytesZlib(byte[] data) throws IOException {
        DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)this, new Deflater(9));
        deflater.write(data);
        deflater.finish();
    }

    public static byte[] compressByteArray(byte[] data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream deflater = new DeflaterOutputStream((OutputStream)baos, new Deflater(9));
        deflater.write(data);
        deflater.finish();
        return baos.toByteArray();
    }

    public void writeBITMAPDATA(BITMAPDATA value, int bitmapFormat, int bitmapWidth, int bitmapHeight) throws IOException {
        int dataLen = 0;
        int pos = 0;
        for (int y = 0; y < bitmapHeight; ++y) {
            for (int x = 0; x < bitmapWidth; ++x) {
                if (bitmapFormat == 4) {
                    dataLen += 2;
                    this.writePIX15(value.bitmapPixelDataPix15[pos]);
                }
                if (bitmapFormat == 5) {
                    dataLen += 4;
                    this.writePIX24(value.bitmapPixelDataPix24[pos]);
                }
                ++pos;
            }
            while (dataLen % 4 != 0) {
                ++dataLen;
                this.writeUI8(0);
            }
        }
    }

    public void writeALPHABITMAPDATA(ALPHABITMAPDATA value, int bitmapFormat, int bitmapWidth, int bitmapHeight) throws IOException {
        int pos = 0;
        for (int y = 0; y < bitmapHeight; ++y) {
            for (int x = 0; x < bitmapWidth; ++x) {
                this.writeARGB(value.bitmapPixelData[pos]);
                ++pos;
            }
        }
    }

    public void writePIX24(PIX24 value) throws IOException {
        this.writeUI8(value.reserved);
        this.writeUI8(value.red);
        this.writeUI8(value.green);
        this.writeUI8(value.blue);
    }

    public void writePIX24(int value) throws IOException {
        this.writeUI8(value >> 24 & 0xFF);
        this.writeUI8(value >> 16 & 0xFF);
        this.writeUI8(value >> 8 & 0xFF);
        this.writeUI8(value & 0xFF);
    }

    public void writePIX15(PIX15 value) throws IOException {
        this.writeUB(1, value.reserved);
        this.writeUB(5, value.red);
        this.writeUB(5, value.green);
        this.writeUB(5, value.blue);
    }

    public void writePIX15(int value) throws IOException {
        this.writeUB(1, value >> 24 & 0xFF);
        this.writeUB(5, value >> 19 & 0xFF);
        this.writeUB(5, value >> 11 & 0xFF);
        this.writeUB(5, value >> 3 & 0xFF);
    }

    public void writeAmf3Object(Amf3Value value, Map<String, ObjectTypeSerializeHandler> serializers) throws IOException, NoSerializerExistsException {
        Amf3OutputStream ao = new Amf3OutputStream(this.os);
        ao.writeValue(value.getValue(), serializers);
    }

    public void writeAmf3Object(Amf3Value value) throws IOException, NoSerializerExistsException {
        this.writeAmf3Object(value, new HashMap<String, ObjectTypeSerializeHandler>());
    }
}

