/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.debugger.flash;

public class Variable {
    public String name;
    public int vType;
    public Object value = null;
    public String typeName = "";
    public String className = "";
    public boolean isPrimitive = false;
    public int flags;

    public boolean hasFlag(int flag) {
        return (this.flags & flag) == flag;
    }

    public String getModifiers() {
        return this.getScopeModifier() + (this.hasFlag(131072) ? " dynamic" : "") + (this.hasFlag(0x200000) ? " static" : "");
    }

    public String getDeclaration() {
        return this.getModifiers() + (this.hasFlag(0x400000) ? " const " : " var ") + this.name + (!this.hasFlag(0x400000) && this.hasFlag(4) ? " [readonly]" : "");
    }

    public String getScopeModifier() {
        if (this.hasFlag(32)) {
            return "";
        }
        int scope = this.flags & 0x3800000;
        switch (scope) {
            case 0: {
                return "public";
            }
            case 0x1000000: {
                return "protected";
            }
            case 0x800000: {
                return "private";
            }
            case 0x2000000: {
                return "<ns>";
            }
            case 0x1800000: {
                return "";
            }
        }
        return "?";
    }

    public String toString() {
        return "var(name=" + this.name + ", type=" + this.getTypeAsStr() + "), value=" + this.getValueAsStr() + ", flags=" + this.flags;
    }

    public String getTypeAsStr() {
        return Variable.typeNameFor(this.vType);
    }

    public String getValueAsStr() {
        switch (this.vType) {
            case 3: 
            case 4: 
            case 5: {
                return this.getTypeAsStr() + "(" + this.value + ")";
            }
        }
        return "" + this.value;
    }

    public Variable(String name, int vType, Object value, String typeName, String className, boolean isPrimitive, int flags) {
        this.vType = vType;
        this.value = value;
        this.typeName = typeName;
        this.className = className;
        this.isPrimitive = isPrimitive;
        this.name = name;
        this.flags = flags;
    }

    public static String typeNameFor(int type) {
        switch (type) {
            case 0: {
                return "number";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "String";
            }
            case 3: {
                return "Object";
            }
            case 4: {
                return "Function";
            }
            case 5: {
                return "MovieClip";
            }
            case 6: {
                return "null";
            }
        }
        return "undefined";
    }
}

