/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.MyRect;
import java.awt.FontFormatException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TtfParser {
    private int ascent;
    private int descent;
    private int leading;
    private int maxWidth;
    private float scale;
    private int numberOfHMetrics;
    private Map<Integer, Integer> cw = new TreeMap<Integer, Integer>();
    private Map<Integer, Integer> ctg = new TreeMap<Integer, Integer>();
    private Map<Integer, MyRect> cbbox = new HashMap<Integer, MyRect>();
    private MyRect bbox;
    private int indexToLocFormat;
    private int flags;
    private String name;
    private float italicAngle;
    private int underlinePosition;
    private int underlineThickness;
    private int numGlyphs;
    private int xHeight;
    private int capHeight;
    private int missingWidth;
    private int avgWidth;
    private int stemV;
    private int stemH;
    private int dw;
    Map<Integer, Long> indexToLoc = new HashMap<Integer, Long>();
    Map<String, Long> tableOffsets = new HashMap<String, Long>();
    Map<String, Long> tableLengths = new HashMap<String, Long>();
    private byte[] cidtogidmap = new byte[131072];

    public void loadFromTTF(File file) throws IOException, FontFormatException {
        RandomAccessFile input = new RandomAccessFile(file, "r");
        this.readTableDirectory(input);
        this.readHEAD(input);
        this.readOS2(input);
        this.readHHEA(input);
        this.readCMAP(input);
        this.readLOCA(input);
        this.readNAME(input);
        this.readPOST(input);
        this.readMAXP(input);
        this.readGLYF(input);
        this.readHMTX(input);
        this.dw = this.missingWidth > 0 ? this.missingWidth : this.avgWidth;
        for (int cid : this.ctg.keySet()) {
            int gid = this.ctg.get(cid);
            if (gid < 0 || gid > 65535 || gid < 0) continue;
            if (gid > 65535) {
                gid -= 65536;
            }
            this.cidtogidmap[cid * 2] = (byte)(gid >> 8);
            this.cidtogidmap[cid * 2 + 1] = (byte)(gid & 0xFF);
        }
        input.close();
    }

    public byte[] getCidtogidmap() {
        return this.cidtogidmap;
    }

    public int getAvgWidth() {
        return this.avgWidth;
    }

    public MyRect getBbox() {
        return this.bbox;
    }

    public Map<Integer, MyRect> getCbbox() {
        return this.cbbox;
    }

    public Map<Integer, Integer> getCw() {
        return this.cw;
    }

    public Map<Integer, Integer> getCmap() {
        return this.ctg;
    }

    public int getLeading() {
        return this.leading;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public Map<Integer, Integer> getCtg() {
        return this.ctg;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getName() {
        return this.name;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public float getUnderlinePosition() {
        return this.underlinePosition;
    }

    public float getUnderlineThickness() {
        return this.underlineThickness;
    }

    public int getxHeight() {
        return this.xHeight;
    }

    public int getMissingWidth() {
        return this.missingWidth;
    }

    public int getStemV() {
        return this.stemV;
    }

    public int getStemH() {
        return this.stemH;
    }

    public int getDw() {
        return this.dw;
    }

    private void readTableDirectory(RandomAccessFile input) throws IOException {
        this.skip(input, 4L);
        int tableCount = this.readUnsignedShort(input);
        this.skip(input, 6L);
        byte[] tagBytes = new byte[4];
        long prevOffset = 0L;
        for (int i = 0; i < tableCount; ++i) {
            tagBytes[0] = this.readByte(input);
            tagBytes[1] = this.readByte(input);
            tagBytes[2] = this.readByte(input);
            tagBytes[3] = this.readByte(input);
            this.skip(input, 4L);
            long offset = this.readUnsignedLong(input);
            long length = this.readUnsignedLong(input);
            prevOffset = offset;
            String tag = new String(tagBytes, "ISO-8859-1");
            this.tableOffsets.put(tag, offset);
            this.tableLengths.put(tag, length);
        }
    }

    private void readCMAP(RandomAccessFile input) throws IOException {
        int i;
        this.seek(input, this.tableOffsets.get("cmap"));
        int version = this.readUnsignedShort(input);
        int numberSubtables = this.readUnsignedShort(input);
        ArrayList<Integer> platFormIds = new ArrayList<Integer>();
        ArrayList<Integer> platFormSpecificIds = new ArrayList<Integer>();
        ArrayList<Long> offsets = new ArrayList<Long>();
        for (i = 0; i < numberSubtables; ++i) {
            platFormIds.add(this.readUnsignedShort(input));
            platFormSpecificIds.add(this.readUnsignedShort(input));
            offsets.add(this.readUnsignedLong(input));
        }
        block11: for (i = 0; i < numberSubtables; ++i) {
            long offset = (Long)offsets.get(i);
            this.seek(input, this.tableOffsets.get("cmap") + offset);
            int format = this.readUnsignedShort(input);
            switch (format) {
                case 0: {
                    int length = this.readUnsignedShort(input);
                    int languageCode = this.readUnsignedShort(input);
                    for (int c = 0; c < 256; ++c) {
                        this.ctg.put(c, this.readUnsignedByte(input));
                    }
                    continue block11;
                }
                case 2: {
                    int length = this.readUnsignedShort(input);
                    int languageCode = this.readUnsignedShort(input);
                    int[] subHeaderKeys = new int[256];
                    int maxSubHeaderIndex = 0;
                    for (int c = 0; c < 256; ++c) {
                        subHeaderKeys[c] = this.readUnsignedShort(input);
                        maxSubHeaderIndex = Math.max(maxSubHeaderIndex, subHeaderKeys[i] / 8);
                    }
                    ArrayList<Integer> firstCodes = new ArrayList<Integer>();
                    ArrayList<Integer> entryCountCodes = new ArrayList<Integer>();
                    ArrayList<Short> idDeltas = new ArrayList<Short>();
                    ArrayList<Integer> idRangeOffsets = new ArrayList<Integer>();
                    for (int c = 0; c <= maxSubHeaderIndex; ++c) {
                        firstCodes.add(this.readUnsignedShort(input));
                        entryCountCodes.add(this.readUnsignedShort(input));
                        idDeltas.add(this.readShort(input));
                        idRangeOffsets.add(this.readUnsignedShort(input) - (maxSubHeaderIndex + 1 - i - 1) * 8 - 2);
                    }
                    long startGlyphIndexOffset = input.getFilePointer();
                    for (int c = 0; c <= maxSubHeaderIndex; ++c) {
                        int firstCode = (Integer)firstCodes.get(c);
                        int idRangeOffset = (Integer)idRangeOffsets.get(c);
                        short idDelta = (Short)idDeltas.get(c);
                        int entryCount = (Integer)entryCountCodes.get(c);
                        input.seek(startGlyphIndexOffset + (long)idRangeOffset);
                        for (int j = 0; j < entryCount; ++j) {
                            int charCode = i;
                            charCode = (charCode << 8) + (firstCode + j);
                            int p = this.readUnsignedShort(input);
                            if (p > 0 && (p = (p + idDelta) % 65536) < 0) {
                                p += 65536;
                            }
                            if (p >= this.numGlyphs) continue;
                            this.ctg.put(charCode, p);
                        }
                    }
                    continue block11;
                }
                case 4: {
                    long startA;
                    int j;
                    int length = this.readUnsignedShort(input);
                    int languageCode = this.readUnsignedShort(input);
                    int segCountX2 = this.readUnsignedShort(input);
                    int segCount = segCountX2 / 2;
                    int searchRange = this.readUnsignedShort(input);
                    int entrySelector = this.readUnsignedShort(input);
                    int rangeShift = this.readUnsignedShort(input);
                    ArrayList<Integer> endCodes = new ArrayList<Integer>();
                    ArrayList<Integer> startCodes = new ArrayList<Integer>();
                    ArrayList<Integer> idDeltas = new ArrayList<Integer>();
                    ArrayList<Integer> idRangeOffsets = new ArrayList<Integer>();
                    for (j = 0; j < segCount; ++j) {
                        int endCode = this.readUnsignedShort(input);
                        endCodes.add(endCode);
                    }
                    this.readUnsignedShort(input);
                    for (j = 0; j < segCount; ++j) {
                        int startCode = this.readUnsignedShort(input);
                        startCodes.add(startCode);
                    }
                    for (j = 0; j < segCount; ++j) {
                        short idDelta = this.readShort(input);
                        idDeltas.add(Integer.valueOf(idDelta));
                    }
                    for (j = 0; j < segCount; ++j) {
                        int idRangeOffset = this.readUnsignedShort(input);
                        idRangeOffsets.add(idRangeOffset);
                    }
                    ArrayList<Integer> glyphIndices = new ArrayList<Integer>();
                    for (long a = startA = input.getFilePointer(); a < this.tableOffsets.get("cmap") + offset + (long)length; a += 2L) {
                        int glyphIndex = this.readUnsignedShort(input);
                        glyphIndices.add(glyphIndex);
                    }
                    for (int j2 = 0; j2 < segCount; ++j2) {
                        for (int k = ((Integer)startCodes.get(j2)).intValue(); k <= (Integer)endCodes.get(j2); ++k) {
                            if (k == 65535) continue;
                            if ((Integer)idRangeOffsets.get(j2) == 0) {
                                int glyph = ((Integer)idDeltas.get(j2) + k) % 65536;
                                this.ctg.put(k, glyph);
                                continue;
                            }
                            int glyphIndex = ((Integer)idRangeOffsets.get(j2) - 2 * (segCount - j2)) / 2 + (k - (Integer)startCodes.get(j2));
                            int glyph = (Integer)glyphIndices.get(glyphIndex);
                            this.ctg.put(k, glyph);
                        }
                    }
                    continue block11;
                }
                case 6: {
                    int length = this.readUnsignedShort(input);
                    int languageCode = this.readUnsignedShort(input);
                    int firstCode = this.readUnsignedShort(input);
                    int entryCount = this.readUnsignedShort(input);
                    if (entryCount == 0) continue block11;
                    int[] glyphIdArray = this.readUnsignedShortArray(entryCount, input);
                    for (int c = 0; c < entryCount; ++c) {
                        this.ctg.put(firstCode + c, glyphIdArray[c]);
                    }
                    continue block11;
                }
                case 8: {
                    this.readUnsignedShort(input);
                    long length = this.readUnsignedLong(input);
                    long languageCode = this.readUnsignedLong(input);
                    long LEAD_OFFSET = 55232L;
                    long SURROGATE_OFFSET = -56613888L;
                    int[] is32 = this.readUnsignedByteArray(8192, input);
                    long nbGroups = this.readUnsignedLong(input);
                    if (nbGroups > 65536L) {
                        throw new IOException("CMap ( Subtype8 ) is invalid");
                    }
                    for (long c = 0L; c < nbGroups; ++c) {
                        long firstCode = this.readUnsignedLong(input);
                        long endCode = this.readUnsignedLong(input);
                        long startGlyph = this.readUnsignedLong(input);
                        if (firstCode > endCode || 0L > firstCode) {
                            throw new IOException("Range invalid");
                        }
                        for (long j = firstCode; j <= endCode; ++j) {
                            int currentCharCode;
                            if (j > Integer.MAX_VALUE) {
                                throw new IOException("[Sub Format 8] Invalid character code " + j);
                            }
                            if ((int)j / 8 >= is32.length) {
                                throw new IOException("[Sub Format 8] Invalid character code " + j);
                            }
                            if ((is32[(int)j / 8] & 1 << (int)j % 8) == 0) {
                                currentCharCode = (int)j;
                            } else {
                                long lead = 55232L + (j >> 10);
                                long trail = 56320L + (j & 0x3FFL);
                                long codepoint = (lead << 10) + trail + -56613888L;
                                if (codepoint > Integer.MAX_VALUE) {
                                    throw new IOException("[Sub Format 8] Invalid character code " + codepoint);
                                }
                                currentCharCode = (int)codepoint;
                            }
                            long glyphIndex = startGlyph + (j - firstCode);
                            if (glyphIndex > (long)this.numGlyphs || glyphIndex > Integer.MAX_VALUE) {
                                throw new IOException("CMap contains an invalid glyph index");
                            }
                            this.ctg.put(currentCharCode, (int)glyphIndex);
                        }
                    }
                    continue block11;
                }
                case 10: {
                    this.readUnsignedShort(input);
                    long length = this.readUnsignedLong(input);
                    long languageCode = this.readUnsignedLong(input);
                    long startCode = this.readUnsignedLong(input);
                    long numChars = this.readUnsignedLong(input);
                    if (numChars > Integer.MAX_VALUE) {
                        // empty if block
                    }
                    if (startCode < 0L || startCode > 0x10FFFFL || startCode + numChars > 0x10FFFFL || startCode + numChars < 55296L || startCode + numChars <= 57343L) {
                        // empty if block
                    }
                    for (long c = startCode; c < startCode + numChars; ++c) {
                        this.ctg.put((int)c, this.readUnsignedShort(input));
                    }
                    continue block11;
                }
                case 12: {
                    this.readUnsignedShort(input);
                    long length = this.readUnsignedLong(input);
                    long languageCode = this.readUnsignedLong(input);
                    long nbGroups = this.readUnsignedLong(input);
                    for (long c = 0L; c < nbGroups; ++c) {
                        long glyphIndex;
                        long firstCode = this.readUnsignedLong(input);
                        long endCode = this.readUnsignedLong(input);
                        long startGlyph = this.readUnsignedLong(input);
                        if (firstCode < 0L || firstCode > 0x10FFFFL || firstCode >= 55296L && firstCode <= 57343L) {
                            throw new IOException("Invalid characters codes");
                        }
                        if (endCode > 0L && endCode < firstCode || endCode > 0x10FFFFL || endCode >= 55296L && endCode <= 57343L) {
                            throw new IOException("Invalid characters codes");
                        }
                        for (long j = 0L; j <= endCode - firstCode && (glyphIndex = startGlyph + j) < (long)this.numGlyphs; ++j) {
                            if (firstCode + j > 0x10FFFFL) {
                                // empty if block
                            }
                            this.ctg.put((int)(firstCode + j), (int)glyphIndex);
                        }
                    }
                    continue block11;
                }
                case 13: {
                    this.readUnsignedShort(input);
                    long length = this.readUnsignedLong(input);
                    long languageCode = this.readUnsignedLong(input);
                    long nbGroups = this.readUnsignedLong(input);
                    for (long c = 0L; c < nbGroups; ++c) {
                        long firstCode = this.readUnsignedLong(input);
                        long endCode = this.readUnsignedLong(input);
                        long glyphId = this.readUnsignedLong(input);
                        if (glyphId > (long)this.numGlyphs) continue block11;
                        if (firstCode < 0L || firstCode > 0x10FFFFL || firstCode >= 55296L && firstCode <= 57343L) {
                            throw new IOException("Invalid Characters codes");
                        }
                        if (endCode > 0L && endCode < firstCode || endCode > 0x10FFFFL || endCode >= 55296L && endCode <= 57343L) {
                            throw new IOException("Invalid Characters codes");
                        }
                        for (long j = 0L; j <= endCode - firstCode; ++j) {
                            if (firstCode + j > Integer.MAX_VALUE) {
                                throw new IOException("Character Code greater than Integer.MAX_VALUE");
                            }
                            if (firstCode + j > 0x10FFFFL) {
                                // empty if block
                            }
                            this.ctg.put((int)(firstCode + j), (int)glyphId);
                        }
                    }
                    continue block11;
                }
            }
        }
        if (!this.ctg.containsKey(0)) {
            this.ctg.put(0, 0);
        }
    }

    private void readHMTX(RandomAccessFile input) throws IOException {
        int i;
        this.seek(input, this.tableOffsets.get("hmtx"));
        ArrayList<Integer> cw = new ArrayList<Integer>();
        for (i = 0; i < this.numberOfHMetrics; ++i) {
            int advanceWidth = this.readUnsignedShort(input);
            cw.add(Math.round(this.scale * (float)advanceWidth));
            this.skip(input, 2L);
        }
        if (this.numberOfHMetrics < this.numGlyphs) {
            for (i = this.numberOfHMetrics; i < this.numGlyphs; ++i) {
                cw.add((Integer)cw.get(this.numberOfHMetrics - 1));
            }
        }
        this.missingWidth = (Integer)cw.get(0);
        for (int cid = 0; cid <= 65535; ++cid) {
            if (!this.ctg.containsKey(cid) || this.ctg.get(cid) >= cw.size() || this.ctg.get(cid) < 0) continue;
            this.cw.put(cid, (Integer)cw.get(this.ctg.get(cid)));
        }
    }

    private void readHHEA(RandomAccessFile input) throws IOException {
        this.seek(input, this.tableOffsets.get("hhea"));
        this.skip(input, 4L);
        this.ascent = Math.round(this.scale * (float)this.readShort(input));
        this.descent = Math.round(this.scale * (float)this.readShort(input));
        this.leading = Math.round(this.scale * (float)this.readShort(input));
        this.maxWidth = Math.round(this.scale * (float)this.readShort(input));
        this.skip(input, 22L);
        this.numberOfHMetrics = this.readUnsignedShort(input);
    }

    private void readHEAD(RandomAccessFile input) throws IOException {
        this.seek(input, this.tableOffsets.get("head"));
        this.skip(input, 18L);
        int unitsPerEm = this.readUnsignedShort(input);
        this.scale = 1000.0f / (float)unitsPerEm;
        this.skip(input, 16L);
        int xMin = Math.round(this.scale * (float)this.readShort(input));
        int yMin = Math.round(this.scale * (float)this.readShort(input));
        int xMax = Math.round(this.scale * (float)this.readShort(input));
        int yMax = Math.round(this.scale * (float)this.readShort(input));
        this.bbox = new MyRect(xMin, yMin, xMax, yMax);
        this.flags = 32;
        int macStyle = this.readUnsignedShort(input);
        if ((macStyle & 2) == 2) {
            this.flags |= 0x40;
        }
        this.seek(input, this.tableOffsets.get("head") + 50L);
        this.indexToLocFormat = this.readShort(input);
    }

    private void readLOCA(RandomAccessFile input) throws IOException {
        boolean shortOffset;
        this.seek(input, this.tableOffsets.get("loca"));
        boolean bl = shortOffset = this.indexToLocFormat == 0;
        if (shortOffset) {
            int totNumGlyphs = (int)(this.tableLengths.get("local") / 2L);
            for (int i = 0; i < totNumGlyphs; ++i) {
                this.indexToLoc.put(i, (long)this.readUnsignedShort(input) * 2L);
                if (!this.indexToLoc.containsKey(i - 1) || this.indexToLoc.get(i).longValue() != this.indexToLoc.get(i - 1).longValue()) continue;
                this.indexToLoc.remove(i - 1);
            }
        } else {
            int totNumGlyphs = (int)Math.floor(this.tableLengths.get("loca") / 4L);
            for (int i = 0; i < totNumGlyphs; ++i) {
                this.indexToLoc.put(i, this.readUnsignedLong(input));
                if (!this.indexToLoc.containsKey(i - 1) || this.indexToLoc.get(i).longValue() != this.indexToLoc.get(i - 1).longValue()) continue;
                this.indexToLoc.remove(i - 1);
            }
        }
    }

    private void readOS2(RandomAccessFile input) throws IOException {
        this.seek(input, this.tableOffsets.get("OS/2"));
        this.skip(input, 2L);
        this.avgWidth = Math.round((float)this.readShort(input) * this.scale);
        float usWeightClass = (float)this.readUnsignedShort(input) * this.scale;
        this.stemV = Math.round(70.0f * usWeightClass / 400.0f);
        this.stemH = Math.round(30.0f * usWeightClass / 400.0f);
        this.skip(input, 2L);
        short fsType = this.readShort(input);
        if (fsType == 2) {
            // empty if block
        }
    }

    private void readNAME(RandomAccessFile input) throws IOException {
        this.seek(input, this.tableOffsets.get("name"));
        this.skip(input, 2L);
        int numNameRecords = this.readUnsignedShort(input);
        int stringStorageOffset = this.readUnsignedShort(input);
        for (int i = 0; i < numNameRecords; ++i) {
            this.skip(input, 6L);
            int nameID = this.readUnsignedShort(input);
            if (nameID == 6) {
                int stringLength = this.readUnsignedShort(input);
                int stringOffset = this.readUnsignedShort(input);
                long offset = this.tableOffsets.get("name") + (long)stringStorageOffset + (long)stringOffset;
                byte[] data = new byte[stringLength];
                this.seek(input, offset);
                input.read(data);
                this.name = new String(data);
                this.name = this.name.replaceAll("[^a-zA-Z0-9_\\-]", "");
                continue;
            }
            this.skip(input, 4L);
        }
    }

    private void readPOST(RandomAccessFile input) throws IOException {
        boolean isFixedPitch;
        this.seek(input, this.tableOffsets.get("post"));
        this.skip(input, 4L);
        this.italicAngle = this.readFixed(input);
        this.underlinePosition = Math.round((float)this.readShort(input) * this.scale);
        this.underlineThickness = Math.round((float)this.readShort(input) * this.scale);
        boolean bl = isFixedPitch = this.readUnsignedLong(input) != 0L;
        if (isFixedPitch) {
            this.flags |= 1;
        }
    }

    private void readMAXP(RandomAccessFile input) throws IOException {
        this.seek(input, this.tableOffsets.get("maxp"));
        this.skip(input, 4L);
        this.numGlyphs = this.readUnsignedShort(input);
    }

    private void readGLYF(RandomAccessFile input) throws IOException {
        short yMax;
        short yMin;
        if (this.ctg.containsKey(120)) {
            this.seek(input, this.tableOffsets.get("glyf") + this.indexToLoc.get(this.ctg.get(120)) + 4L);
            yMin = this.readShort(input);
            this.skip(input, 2L);
            yMax = this.readShort(input);
            this.xHeight = Math.round((float)(yMax - yMin) * this.scale);
        }
        if (this.ctg.containsKey(72)) {
            this.seek(input, this.tableOffsets.get("glyf") + this.indexToLoc.get(this.ctg.get(72)) + 4L);
            yMin = this.readShort(input);
            this.skip(input, 2L);
            yMax = this.readShort(input);
            this.capHeight = Math.round((float)(yMax - yMin) * this.scale);
        }
        for (int cid = 0; cid <= 65535; ++cid) {
            if (!this.ctg.containsKey(cid) || !this.indexToLoc.containsKey(this.ctg.get(cid))) continue;
            this.seek(input, this.tableOffsets.get("glyf") + this.indexToLoc.get(this.ctg.get(cid)));
            short xMin = this.readShort(input);
            short yMin2 = this.readShort(input);
            short xMax = this.readShort(input);
            short yMax2 = this.readShort(input);
            this.cbbox.put(cid, new MyRect(xMin, yMin2, xMax, yMax2));
        }
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getCapHeight() {
        return this.capHeight;
    }

    private float readFixed(RandomAccessFile input) throws IOException {
        short m = this.readShort(input);
        int f = this.readUnsignedShort(input);
        return Float.parseFloat("" + m + "." + f);
    }

    private int readUnsignedByte(RandomAccessFile input) throws IOException {
        int b = input.read();
        if (b == -1) {
            throw new EOFException("Unexpected end of file.");
        }
        return b;
    }

    private int[] readUnsignedByteArray(int size, RandomAccessFile input) throws IOException {
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readUnsignedByte(input);
        }
        return ret;
    }

    private int[] readUnsignedShortArray(int size, RandomAccessFile input) throws IOException {
        int[] ret = new int[size];
        for (int i = 0; i < size; ++i) {
            ret[i] = this.readUnsignedShort(input);
        }
        return ret;
    }

    private byte readByte(RandomAccessFile input) throws IOException {
        return (byte)this.readUnsignedByte(input);
    }

    private int readUnsignedShort(RandomAccessFile input) throws IOException {
        return (this.readUnsignedByte(input) << 8) + this.readUnsignedByte(input);
    }

    private short readShort(RandomAccessFile input) throws IOException {
        return (short)this.readUnsignedShort(input);
    }

    private long readUnsignedLong(RandomAccessFile input) throws IOException {
        long value = this.readUnsignedByte(input);
        value = (value << 8) + (long)this.readUnsignedByte(input);
        value = (value << 8) + (long)this.readUnsignedByte(input);
        value = (value << 8) + (long)this.readUnsignedByte(input);
        return value;
    }

    private void skip(RandomAccessFile input, long skip) throws IOException {
        input.seek(input.getFilePointer() + skip);
    }

    private void seek(RandomAccessFile input, long position) throws IOException {
        input.seek(position);
    }
}

