/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFGraphics;
import gnu.jpdf.PDFJob;
import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class Test {
    private static final Point POINT_NEG16384_0 = new Point(-16384, 0);
    private static final Point POINT_16384_0 = new Point(16384, 0);
    static double centerX = 150.0;
    static double centerY = 150.0;
    static double focalX = 125.0;
    static double focalY = 125.0;
    static float r = 50.0f;
    static float[] fractions;
    Color[] colors;

    public Test() {
        fractions = new float[]{0.0f, 0.23f, 0.25f, 0.28f, 0.48f, 0.5f, 0.52f, 0.73f, 0.75f, 0.77f, 0.99f, 1.0f};
        this.colors = new Color[]{Color.yellow, Color.yellow, Color.red, Color.yellow, Color.yellow, Color.red, Color.yellow, Color.yellow, Color.red, Color.yellow, Color.yellow, Color.red};
        fractions = new float[]{0.0f, 1.0f};
        this.colors = new Color[]{Color.black, Color.white};
    }

    private static float shade(int x, int y) {
        float fractionPos = 0.0f;
        double centerA = Math.sqrt((centerX - (double)x) * (centerX - (double)x) + (centerY - (double)y) * (centerY - (double)y));
        double focalA = Math.sqrt((focalX - (double)x) * (focalX - (double)x) + (focalY - (double)y) * (focalY - (double)y));
        double focalCenterA = Math.sqrt((focalX - centerX) * (focalX - centerX) + (focalY - centerY) * (focalY - centerY));
        double focalRatio = focalCenterA / (double)r;
        double a = (centerX - focalX) * (centerX - focalX) + (centerY - focalY) * (centerY - focalY) - (double)(r * r);
        double b = 2.0 * (focalX - (double)x) * (centerX - focalX) + 2.0 * (focalY - (double)y) * (centerY - focalY);
        double c = (focalX - (double)x) * (focalX - (double)x) + (focalY - (double)y) * (focalY - (double)y);
        System.err.println("a=" + a);
        System.err.println("b=" + b);
        System.err.println("c=" + c);
        double D = b * b - 4.0 * a * c;
        System.err.println("D=" + D);
        if (D == 0.0) {
            double x0 = -b / (2.0 * a);
            fractionPos = (float)x0;
            System.err.println("x=" + x0);
        } else if (D > 0.0) {
            double x1 = (-b + Math.sqrt(D)) / (2.0 * a);
            double x2 = (-b - Math.sqrt(D)) / (2.0 * a);
            System.err.println("x1=" + x1);
            System.err.println("x2=" + x2);
            fractionPos = (float)Math.max(x1, x2);
        }
        if ((double)fractionPos > 1.0) {
            fractionPos = (float)((double)fractionPos - Math.floor(fractionPos));
        }
        return fractionPos;
    }

    private static void printShape(Shape s) {
        if (s == null) {
            return;
        }
        PathIterator pi = s.getPathIterator(new AffineTransform());
        float[] coords = new float[6];
        while (!pi.isDone()) {
            int segtype = pi.currentSegment(coords);
            switch (segtype) {
                case 4: {
                    System.err.print(" close ");
                    break;
                }
                case 3: {
                    System.err.print(" curve " + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3] + " " + coords[4] + " " + coords[5]);
                    break;
                }
                case 1: {
                    System.err.print(" line " + coords[0] + " " + coords[1]);
                    break;
                }
                case 0: {
                    System.err.print(" move " + coords[0] + " " + coords[1]);
                    break;
                }
                case 2: {
                    System.err.println(" quad " + coords[0] + " " + coords[1] + " " + coords[2] + " " + coords[3]);
                }
            }
            pi.next();
            System.err.println();
        }
    }

    public static void main(String[] args) throws Exception {
        PDFJob job = new PDFJob(new FileOutputStream("test.pdf"));
        PageFormat pf = new PageFormat();
        pf.setOrientation(1);
        Paper p = new Paper();
        p.setSize(500.0, 400.0);
        pf.setPaper(p);
        BufferedImage img = ImageIO.read(new File("bitmapfill.png"));
        PDFGraphics g = (PDFGraphics)job.getGraphics(pf);
        Paint tp = new TexturePaint(img, new Rectangle2D.Double(0.0, 0.0, img.getWidth(), img.getHeight()));
        double w = 50.0;
        tp = new LinearGradientPaint(new Point2D.Double(-w, 0.0), new Point2D.Double(w, 0.0), new float[]{0.0f, 1.0f}, new Color[]{Color.yellow, Color.red}, MultipleGradientPaint.CycleMethod.REPEAT);
        tp = new LinearGradientPaint(POINT_NEG16384_0, POINT_16384_0, new float[]{0.0f, 1.0f}, new Color[]{Color.yellow, Color.red}, MultipleGradientPaint.CycleMethod.REPEAT);
        System.err.println("" + Test.shade(110, 140));
        double divider = 50.0 / w;
        double multiplier = 1.0 / divider;
        AffineTransform tr = new AffineTransform();
        tr.translate(10.0, 20.0);
        AffineTransform tr2 = new AffineTransform();
        tr2.translate(15.0, 25.0);
        tp = Color.red;
        PDFGraphics go = (PDFGraphics)g.createXObject();
        go.setColor(Color.red);
        go.fillRect(0, 0, 20, 20);
        PDFGraphics go2 = (PDFGraphics)go.createXObject();
        go2.setColor(Color.blue);
        go2.fillRect(10, 10, 20, 20);
        go.drawXObject(go2);
        g.drawXObject(go);
        g.setTransform(AffineTransform.getTranslateInstance(100.0, 100.0));
        g.drawXObject(go);
        g.dispose();
        job.end();
    }
}

