// overrideGlobal.js
// Tony Schilling
// Created:  11/12/2008
// Last Updated:  11/13/2008

// Constants
const CM_OG_ADD = 0;
const CM_OG_REMOVE = 1;
const CM_OG_REMOVE_ALL = 2;

var gOverrideGlobalWindow = {
	_bundle     : null,
	_currentHost: null,
	_list		: null,
	_listChanged: null,
  
	onLoad: function ()
	{
		this._bundle = document.getElementById("bundlePreferences");
		var params = window.arguments[0];
		this._listChanged = window.arguments[1];
		this.init(params);
	},
	  
	init: function (aParams)
	{		
		// Load override list array and check 
		// if prefilled host is already in list
		var urlField = document.getElementById("url");
		var addUrlButton = document.getElementById("btnAddUrl");
		var addUrlLabel = document.getElementById("urlLabel");
		var urlExistsLabel = document.getElementById("urlLabelExists");
		var closeButton = document.getElementById("btnClose");
		
		this._currentHost = aParams.prefilledHost;
		urlField.value = this._currentHost;
		
		this._loadOverrideList(aParams.globalOverrideList);

		if (aParams.globalOverrideList.indexOf(aParams.prefilledHost) > -1)
		{
			addUrlButton.disabled = true;
			addUrlLabel.hidden = true;
			urlExistsLabel.hidden = false;
			closeButton.focus();
		}
		else
		{
			addUrlButton.focus();			
		}
	},

	// Public Methods
	addOverrideGlobalURI: function ()
	{
		var urlField  = document.getElementById("url");
		this._list.appendItem(urlField.value);
		this._listChanged(urlField.value, CM_OG_ADD);
		
  		// Determine what buttons should de enabled/disabled
	    this._updateUI(urlField.value, CM_OG_ADD);
	},

	// Private Methods
	_loadOverrideList: function (aList)
	{
		this._list = document.getElementById("overrideList");
		
		// Load array values into list element
		aList.forEach(this._list.appendItem, this._list);
	},
	
	_updateUI: function (aItem, aOperation)
	{
		var addUrlButton = document.getElementById("btnAddUrl");
		var addUrlLabel = document.getElementById("urlLabel");
		var urlExistsLabel = document.getElementById("urlLabelExists");
		var closeButton = document.getElementById("btnClose");
		
		if ((aItem != null) && (aItem == this._currentHost))
		{
			if (aOperation == CM_OG_ADD)
			{
				addUrlButton.disabled = true;
				addUrlLabel.hidden = true;
				urlExistsLabel.hidden = false;				
			}
			else
			{
				addUrlButton.disabled = false;
				addUrlLabel.hidden = false;
				urlExistsLabel.hidden = true;
			}
		}
		else if (aOperation == CM_OG_REMOVE_ALL)
		{
			addUrlButton.disabled = false;
			addUrlLabel.hidden = false;
			urlExistsLabel.hidden = true;			
		}

		this.onListItemSelected();
		closeButton.focus();
	},
	
  	// Events
  	onListItemSelected: function ()
  	{
	    var hasSelection = this._list.selectedCount > 0;
	    var hasRows = this._list.getRowCount() > 0;
	    document.getElementById("removePermission").disabled = !hasRows || !hasSelection;
	    document.getElementById("removeAllPermissions").disabled = !hasRows;
  	},
  
	onListItemDeleted: function ()
  	{
  		var selectedItem = this._list.selectedItem;
		var hostInList = null;
		
  		// If an item is selected, remove from list and
  		// remove from globalOverrideList
  		if (selectedItem != null)
  		{
  			if (selectedItem.label == this._currentHost)
  			{
  				hostInList = this._currentHost;
  			}
			this._listChanged(selectedItem.label, CM_OG_REMOVE); 
  			this._list.removeItemAt(this._list.selectedIndex); 			
  		}
  		
  		// Determine what buttons should de enabled/disabled
	    this._updateUI(hostInList, CM_OG_REMOVE);
  	},
  
	onAllListItemsDeleted: function ()
	{
		var hostInList = null;
	    var numberRows = this._list.getRowCount();

		// Clear list and globalOverrideList and
	    // if current host is in list, pass back
	    // in _listChanged
	    while (this._list.getRowCount() > 0)
	    {
	    	if (this._list.getItemAtIndex(0).label == this._currentHost)
	    	{
	    		hostInList = this._currentHost;
	    	}
	    	
	    	this._list.removeItemAt(0);
	    }

		this._listChanged(hostInList, CM_OG_REMOVE_ALL);  			

  		// Determine what buttons should de enabled/disabled
	    this._updateUI(hostInList, CM_OG_REMOVE_ALL);
	    
		//document.getElementById("removePermission").disabled = true;
		//document.getElementById("removeAllPermissions").disabled = true;
	},
  
	onListKeyPress: function (aEvent)
	{
		if (aEvent.keyCode == 46)
			this.onListItemDeleted();
	},
  
	uninit: function ()
	{
	}	
}