/******************************************************************************
 *            Copyright (c) 2006-2009 Michel Gutierrez. All Rights Reserved.
 ******************************************************************************/

try {
	
var DWHelper={
	uuid: "{b9db16a4-6edc-47ec-a1f4-b86292ed211d}",
	prefViewers: [
	              ["dwhelper-statusbarpanel","show-in-statusbar"],
	              ["dwhelper-toolsmenu","show-in-toolsmenu"],
	              ["dwhelper-toolsmenu-separator","show-in-toolsmenu"],
	              ["dwhelper-ctxmenu","context-menu"],
	],
	quickKeys: [
	            "quickkey",
	            "opendirkey"
	],
	startupServices: [
	                  //"@downloadhelper.net/license-handler;1",
	                  //"@downloadhelper.net/convconf-handler;1",
	                  //"@downloadhelper.net/safe-mode-handler;1",
	                  //"@downloadhelper.net/youtube-probe;1",
	                  //"@downloadhelper.net/medialink-probe;1",
	                  //"@downloadhelper.net/network-probe;1",
	                  //"@downloadhelper.net/download-convert-processor;1",
	                  //"@downloadhelper.net/download-processor;1",
	                  //"@downloadhelper.net/quick-download-processor;1",
	                  //"@downloadhelper.net/socialshare-processor;1",
	                  //"@downloadhelper.net/flashgot-download-processor;1",
	                  //"@downloadhelper.net/copyurl-processor;1",
	                  //"@downloadhelper.net/dump-processor;1",
	                  //"@downloadhelper.net/add-to-blacklist-processor;1",
	                  //"@downloadhelper.net/mp3tunes-mobile-processor;1",
	                  //"@downloadhelper.net/mp3tunes-locker-processor;1",
	],
	pref: Components.classes["@mozilla.org/preferences-service;1"]
	                        .getService(Components.interfaces.nsIPrefService).getBranch("dwhelper."),
//	util: Components.classes["@downloadhelper.net/util-service;1"]
//	                     	.getService(Components.interfaces.dhIUtilService),
    firstSessionLaunch: true,
    handledWelcomeUpdate: false,
    createdWidgets: false 
};

//Components.classes["@mozilla.org/preferences-service;1"]
//                   .getService(Components.interfaces.nsIPrefService).getBranch("").setBoolPref("browser.dom.window.dump.enabled",true);

DWHelper_initComponents = function() {
	DWHelper.core=Components.classes["@downloadhelper.net/core;1"].getService(Components.interfaces.dhICore);
	Components.utils['import']("resource://dwhelper/dwhelper-util-service.jsm");
	DWHelper.util=DWHelperUtil;
	DWHelper_handleVersion();
	for(var i in DWHelper.startupServices) {
		var service=DWHelper.startupServices[i];
		try {
			Components.classes[service].getService();
			//dump("[DWHelper/startup]: loaded service "+service+"\n");
		} catch(e) {
			dump("!!! [DWHelper/startup]: loading service "+service+": "+e+"\n");
		}
	}
	try {
		Components.utils['import']("resource://dwhelper/license-handler.jsm");
		DWHelperLicenseHandlerService.start();
		Components.utils['import']("resource://dwhelper/convconf-handler.jsm");
		DWHelperConvConfHandlerService.start();
		Components.utils['import']("resource://dwhelper/safemode-handler.jsm");
		DWHelperSafeModeHandlerService.start();
		Components.utils['import']("resource://dwhelper/youtube-probe.jsm");
		DWHelperYouTubeProbeService.start();
		Components.utils['import']("resource://dwhelper/dm-probe.jsm");
		DWHelperDMProbeService.start();
		Components.utils['import']("resource://dwhelper/medialink-probe.jsm");
		DWHelperMediaLinkProbeService.start();
		Components.utils['import']("resource://dwhelper/network-probe.jsm");
		DWHelperNetworkProbeService.start();
		Components.utils['import']("resource://dwhelper/dump-processor.jsm");
		DWHelperDumpProcService.start();
		Components.utils['import']("resource://dwhelper/socialshare-processor.jsm");
		DWHelperSocialShareProcService.start();
		Components.utils['import']("resource://dwhelper/copyurl-processor.jsm");
		DWHelperCopyUrlProcService.start();
		Components.utils['import']("resource://dwhelper/addtoblacklist-processor.jsm");
		DWHelperAdd2BLProcService.start();
		Components.utils['import']("resource://dwhelper/flashgot-processor.jsm");
		DWHelperFDLProcService.start();
		Components.utils['import']("resource://dwhelper/download-processor.jsm");
		DWHelperDownloadProcService.start();
		Components.utils['import']("resource://dwhelper/quickdownload-processor.jsm");
		DWHelperQuickDownloadProcService.start();
		Components.utils['import']("resource://dwhelper/downloadconvert-processor.jsm");
		DWHelperDownloadConvertProcService.start();
		Components.utils['import']("resource://dwhelper/mp3tuneslocker-processor.jsm");
		DWHelperMP3TunesLockerProcService.start();
		Components.utils['import']("resource://dwhelper/mp3tunesmobile-processor.jsm");
		DWHelperMP3TunesMobileProcService.start();
		Components.utils['import']("resource://dwhelper/scap-manager.jsm");
		ScapManagerService.get().loadProcessors();
	} catch(e) {
		dump("!!! [DWHelper/startup] loading modules: "+e+"\n");
	}
}

function DWHelper_handleWelcomeUpdate(version) {
	if(!DWHelper.handledWelcomeUpdate) {
		DWHelper.handledWelcomeUpdate=true;
		DWHelper.version=version;
		if(DWHelper.pref.getBoolPref("first-time")) {
			try {
				function welcome(version) {
					try {
						var browser = top.getBrowser();
						browser.selectedTab=browser.addTab("http://www.downloadhelper.net/welcome.php?version="+version);
					} catch(e) {
					}
				}
				if(DWHelper.pref.getBoolPref("do-welcome"))
					setTimeout(welcome,100,version);
			} catch(e) {
			}
			DWHelper.pref.setBoolPref("first-time",false);
			DWHelper.pref.setCharPref("last-version",version);
			DWHelper_install();
		} else {
			var lastVersion="1.95";
			try {
				lastVersion=DWHelper.pref.getCharPref("last-version");
			} catch(e) {}
			if(lastVersion!=version) {
				DWHelper.pref.setCharPref("last-version",version);
				try {
					function install(lastVersion,version,cwe) {
						try {
							var browser = top.getBrowser();
							if(cwe)
								browser.selectedTab=browser.addTab("http://www.downloadhelper.net/update.php?to="+version+"&from="+lastVersion);
							else
								browser.selectedTab=browser.addTab("http://www.downloadhelper.net/update.php?from="+lastVersion+"&to="+version);
						} catch(e) {
						}
					}
					var cwe=false;
					try {
						cwe=DWHelper.pref.getBoolPref("conversion-was-enabled");
					} catch(e) {}
					if(lastVersion!="4.9.1" || version!="4.9.2") // too many updates in too short time: skip this update notice to not upset users.
						setTimeout(install,100,lastVersion,version,cwe);
				} catch(e) {}
			}
		}
	}
}

function DWHelper_handleVersion() {
	try {
		DWHelper.version=DWHelper.util.getVersion(DWHelper.uuid);
	} catch(e) {
		try {
			DWHelper.preventHandleWelcomeUpdate=true;
			Components.utils['import']("resource://gre/modules/AddonManager.jsm");
			AddonManager.getAddonByID(DWHelper.uuid, function(addon) {
				DWHelper_handleWelcomeUpdate(addon.version);
			});
		} catch(e) {
			dump("!!! [DWHelper/startup] Failed getting version: "+e+"\n");
		}
	}
}

function DWHelper_onLoad(e) {
	DWHelper.timerWidgets=window.setTimeout(DWHelper_onLoadDeferred,DWHelper.pref.getIntPref("startup-timer.widgets"),e);
}

function DWHelper_addDeferredWidgets() {
	
	if(DWHelper.createdWidgets==true) {
		dump("!!! [DWHelper] DWHelper_addDeferredWidgets: createdWidgets already executed\n");
		return;
	}

	try {
		
		var sbpanel=document.getElementById("dwhelper-statusbarpanel");
		if(sbpanel) {
			var counterLabel=document.createElement("CounterLabel");
			counterLabel.setAttribute("id","dwhelper-statusbar-count");
			sbpanel.appendChild(counterLabel);
			var tiPopup=document.createElement("menupopup");
			tiPopup.setAttribute("id","dwhelper-sbctxmenupopup");
			tiPopup.setAttribute("class","SystemMenu");
			sbpanel.appendChild(tiPopup);
			var tbPopup=document.createElement("menupopup");
			tbPopup.setAttribute("id","dwhelper-statusbar-menupopup");
			tbPopup.setAttribute("class","DownloadMenu");
			tbPopup.setAttribute("dh-controlled-button","dwhelper-statusbar-button");
			var sbbutton=document.getElementById("dwhelper-statusbar-button");
			if(sbbutton)
				sbbutton.appendChild(tbPopup);
		} else {
			dump("!!! [DWHelper] DWHelper_addDeferredWidgets: no dwhelper-statusbarpanel\n");
		}
		
		
		DWHelper.createdWidgets=true;
	} catch(e) {
		dump("[DWHelper] DWHelper_addDeferredWidgets: "+e+"\n");
	}
}

function DWHelper_onLoadDeferred(e) {
	try {
		DWHelper_initComponents();
		DWHelper_addDeferredWidgets();
		
		if(DWHelper.firstSessionLaunch) {
			DWHelper_fixPreferences();
			DWHelper_updateKeys();
			DWHelper.firstSessionLaunch=false;
			if(!DWHelper.preventHandleWelcomeUpdate) {
				var version=DWHelper.version;	
				DWHelper_handleWelcomeUpdate(version);
			}
			for(var i in DWHelper.prefViewers) {
				DWHelper_updateWidgetVisibility(DWHelper.prefViewers[i][0],DWHelper.prefViewers[i][1]);
			}
			DWHelper.core.registerWindow(window);
		}
	} catch(e) {
		dump("!!! [DWHelper] onload(): "+e+"\n");
	}
}

function DWHelper_onUnload(e) {
	DWHelper.core.unregisterWindow(window);
}

window.addEventListener("load", DWHelper_onLoad, false);
window.addEventListener("unload", DWHelper_onUnload, false);

function DWHelper_fixPreferences() {
	var downloadMode="controlled";
	try {
		downloadMode=DWHelper.pref.getCharPref("download-mode");
	} catch(e) {}
	if(downloadMode=="flashgot") {
		try {
			Components.classes["@maone.net/flashgot-service;1"].
				getService(Components.interfaces.nsISupports).wrappedJSObject;
			DWHelper.pref.setCharPref("processor-keymap","0:flashgot-download,2:convert-choice,3:quick-download");
		} catch(e) {}
		DWHelper.pref.setCharPref("download-mode","controlled");
	}
	
	function fixPrefKey(prefId) {
		try {
			DWHelper.pref.getCharPref(prefId);
		} catch(e) {
			var key=DWHelper.pref.getCharPref(prefId+".key");
			var modifier=DWHelper.pref.getCharPref(prefId+".modifier");
			var modifiers=modifier.split(" ");
			modifier=0;
			for(var i=0;i<modifiers.length;i++) {
				if(modifiers[i]=="control")
					modifier|=1;
				if(modifiers[i]=="shift")
					modifier|=2;
				if(modifiers[i]=="alt")
					modifier|=4;
			}
			DWHelper.pref.setCharPref(prefId,modifier+";"+key);
		}
	}
	fixPrefKey("quickkey");
	fixPrefKey("opendirkey");
	
	try {
		DWHelper.pref.getIntPref("menu-expiration");
	} catch(e) {
		var expiration=60;
		try {
			expiration=parseInt(DWHelper.pref.getIntPref("menu-http-expiration"))/1000;
			expiration=parseInt(""+expiration);
		} catch(e) {}
		DWHelper.pref.setIntPref("menu-expiration",expiration);
	}

	try {
		var mediaweight=DWHelper.pref.getIntPref("mediaweight");
		DWHelper.pref.setCharPref("mediaweight",""+mediaweight);
	} catch(e) {
	}
	
	var encoders=["ffmpeg","mencoder"];
	for(var i in encoders) {
		var encoder=encoders[i];
		try {
			DWHelper.pref.getCharPref("converter-path-"+encoder);
		} catch(e) {
			try {
				var encoderPath=DWHelper.pref.getCharPref(encoder+"-path");
				DWHelper.pref.setCharPref("converter-path-"+encoder,encoderPath);
			} catch(e) {}
		}
	}
	
	Components.utils['import']("resource://dwhelper/youtubeinfo-service.jsm");
	var ytInfo=YouTubeInfoService.get();
	var formats=ytInfo.getFixedFormatsList();
	DWHelper.pref.setCharPref("ythq-formats",formats);
	
	try {
		var osString = Components.classes["@mozilla.org/xre/app-info;1"]
		                                  .getService(Components.interfaces.nsIXULRuntime).OS;
		switch(osString) {
		case "Linux":
			if(DWHelper.pref.getCharPref("scap.file-ext").length==0) DWHelper.pref.setCharPref("scap.file-ext","ogv");
			if(DWHelper.pref.getCharPref("scap.start-pgm").length==0) {
				DWHelper.pref.setCharPref("scap.start-pgm","/usr/bin/recordmydesktop");
				DWHelper.pref.setBoolPref("scap.ignore-exit-value",true);
			}
			if(DWHelper.pref.getCharPref("scap.start-args").length==0) DWHelper.pref.setCharPref("scap.start-args",
					"--overwrite -x {x} -y {y} --width {width} --height {height} --on-the-fly-encoding -o {file}");
			if(DWHelper.pref.getCharPref("scap.stop-pgm").length==0) DWHelper.pref.setCharPref("scap.stop-pgm","/usr/bin/killall");
			if(DWHelper.pref.getCharPref("scap.stop-args").length==0) DWHelper.pref.setCharPref("scap.stop-args","-3 recordmydesktop");
			break;
		case "Darwin":
			// find a command line screen capture program on Mac OS X
			break;
		case "WINNT":
			// No need to configure on Windows: CSHelper contains the capture application
			break;
		}
	} catch(e) {
		dump("!!! [DWHelper] fixPreferences(): "+e+"\n");
	}
}

function DWHelper_install() {
	try {
		var dwhelperId="dwhelper-toolbaritem";
		/* Fix bug#525: toolbar icon default location 
		var afterId="urlbar-container";
		var afterElem=document.getElementById(afterId);
		if(afterElem) {
			var navBar=afterElem.parentNode;
			if(document.getElementById(dwhelperId)==null) {
				// waiting for firefox bug 403959 to be solved
				//navBar.insertItem(dwhelperId,afterElem.nextSibling);
				navBar.insertItem(dwhelperId,afterElem);
				navBar.setAttribute("currentset", navBar.currentSet );
				document.persist("nav-bar", "currentset");
			}
		}		
		*/
		var toolbar = document.getElementById("nav-bar");
        toolbar.insertItem(dwhelperId, null);
        toolbar.setAttribute("currentset", toolbar.currentSet);
        document.persist(toolbar.id, "currentset");

		DWHelper_addDeferredWidgets();
	} catch(e) {
		dump("!!! [DWHelper] DWHelper_install()\n");
	}
}

function DWHelper_observer() {
}
DWHelper_observer.prototype={
	observe: function(subject, topic , data) {
		if(topic=="nsPref:changed") {
			for(var i in DWHelper.prefViewers) {
				if(DWHelper.prefViewers[i][1]==data) {
					DWHelper_updateWidgetVisibility(DWHelper.prefViewers[i][0],DWHelper.prefViewers[i][1]);
				}
			}
			for(var i in DWHelper.quickKeys) {
				if(data==DWHelper.quickKeys[i]) {
					DWHelper_updateKeys();
				}
			}
		}
	},
	QueryInterface: function(iid) {
	    if(
	    	iid.equals(Components.interfaces.nsIObserver)==false &&
	    	iid.equals(Components.interfaces.nsISupports)==false
		) {
	            throw Components.results.NS_ERROR_NO_INTERFACE;
	        }
	    return this;
	}
	
}

DWHelper.observer=new DWHelper_observer();
DWHelper.prefBranch2=Components.classes["@mozilla.org/preferences-service;1"]
                                        .getService(Components.interfaces.nsIPrefService)
                                        .getBranch("dwhelper.")
                                        .QueryInterface(Components.interfaces.nsIPrefBranch2);
DWHelper.prefBranch2.addObserver("", DWHelper.observer, false);

function DWHelper_updateWidgetVisibility(widgetId,prefId) {
	//dump("DWHelper_updateWidgetVisibility("+widgetId+","+prefId+")\n");
	var widget=document.getElementById(widgetId);
	if(widget) {
		var enabled=false;
		try {
			enabled=DWHelper.pref.getBoolPref(prefId);
		} catch(e) {}
		//dump("=>"+enabled+"\n");
		widget.setAttribute("hidden",""+!enabled);
	} 
}

function DWHelper_updateKeys() {
	function updateKey(defKey,keyElemId,prefName) {
		var key=defKey;
		try {
			key=DWHelper.pref.getCharPref(prefName);
		} catch(e) {}
		var keyParts=key.split(";",2);
		var key=keyParts[1];
		var modifier=keyParts[0];
		if(!/^VK_/.test(key))
			key="VK_"+key;
	
		var keyElem=document.getElementById(keyElemId);
		if(keyElem) {
			if(/^VK_.$/.test(key)) {
				var m=/^VK_(.)$/.exec(key);
				keyElem.removeAttribute("keycode");
				keyElem.setAttribute("key",m[1]);
			} else {
				keyElem.removeAttribute("key");
				keyElem.setAttribute("keycode",key);
			}
			var modifiers=[];
			if(modifier&1)
				modifiers.push("control");
			if(modifier&2)
				modifiers.push("shift");
			if(modifier&4)
				modifiers.push("alt");
			keyElem.setAttribute("modifiers",modifiers.join(" "));
		}
	}
	updateKey("3;VK_Q","dwhelper-quick-key","quickkey");
	updateKey("3;VK_O","dwhelper-opendir-key","opendirkey");
}

} catch(e) {
	alert("!!! [dwhelper] init: "+e);
}