/******************************************************************************
 *            Copyright (c) 2006-20011 Michel Gutierrez. All Rights Reserved.
 ******************************************************************************/

var run = function() {
	//dump("[ConvertMgr/Processor] execConvert [run]\n");
	try {
		var result=false;
		if(this.dEntry.args2) {
			var file = Components.classes["@mozilla.org/file/directory_service;1"]
			                     .getService(Components.interfaces.nsIProperties)
			                     .get("TmpD", Components.interfaces.nsIFile);
			file.append("passlogfile.tmp");
			file.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0666);
			var r=this.convertPass(["-pass","1","-passlogfile",file.path].concat(this.dEntry.args),false);
			if(r) {
				result=this.convertPass(["-pass","2","-passlogfile",file.path].concat(this.dEntry.args2),true);
			}
			if(file.exists())
				file.remove(false);
		} else {
			result=this.convertPass(this.dEntry.args,true);
		}
		this.postMessage(result);
	} catch(e) {
		dump("!!! [ConvertMgr/Processor] execConvert [run]: "+e+"\n");
	}
}

var convertPass = function(args,lastPass) {
	var process = Components.classes["@mozilla.org/process/util;1"]
                        .createInstance(Components.interfaces.nsIProcess);
	process.init(this.dEntry.file);

	process.runw(true, args, args.length,{});
	
	var success;
	if(process.exitValue==0) {
		success=true;
		if(lastPass && this.dEntry.autoClear) {
			var keepOriginal=false;
			try {
				keepOriginal=this.pref.getBoolPref("convert.keep-original");
			} catch(e) {}
			if(!keepOriginal)
				this.dEntry.sourceFile.remove(false);
		}
	} else {
		success=false;
		if(this.dEntry.autoClear) {
			try {
				this.dEntry.targetFile.remove(false);
			} catch(e) {
				dump("!!! [ConvertMgr/Processor] execConvert [run] failed: "+e+"\n");
			}
			var keepOriginalOnFailure=true;
			try {
				keepOriginalOnFailure=this.pref.getBoolPref("convert.keep-original-on-failure");
			} catch(e) {}
			if(keepOriginalOnFailure) {
				var filename=this.dEntry.sourceFile.leafName;
				var recoveryLeafName=null;
				if(/^.+\..*$/.test(filename)) {
					var m=/^(.+)\.(.*)$/.exec(filename);
					recoveryLeafName=m[1]+".failed-conv."+m[2];
				} else {
					recoveryLeafName=filename+".failed-conv";
				}
				var recoveryFile=this.dEntry.targetFile.parent;
				recoveryFile.append(recoveryLeafName);
				recoveryFile.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0644);
				this.dEntry.sourceFile.moveTo(this.dEntry.targetFile.parent,recoveryFile.leafName);
			}
		}
	}
	return success;
}

onmessage = function(event) {
	Components=event.data.Components;
	this.dEntry=event.data.dEntry;
	try {
		this.dEntry.file = Components.classes["@mozilla.org/file/local;1"]
			                                	.createInstance(Components.interfaces.nsILocalFile);
		this.dEntry.file.initWithPath(this.dEntry.filePath);
		this.dEntry.sourceFile = Components.classes["@mozilla.org/file/local;1"]
			                                	.createInstance(Components.interfaces.nsILocalFile);
		this.dEntry.sourceFile.initWithPath(this.dEntry.sourceFilePath);
		this.dEntry.targetFile = Components.classes["@mozilla.org/file/local;1"]
			                                	.createInstance(Components.interfaces.nsILocalFile);
		this.dEntry.targetFile.initWithPath(this.dEntry.targetFilePath);
		this.run();
	} catch(e) {
		dump("!!! [ConvertMgr/Processor] execConvert [worker.onmessage]: "+e+"\n");
	}
};
