/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.preferences;

import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.ToolBar;
import ch.rakudave.jnetmap.view.preferences.PreferencePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;

public class ToolBarPanel
extends PreferencePanel {
    private JList active;
    private JList inactive;
    private JCheckBox showLabels;

    public ToolBarPanel() {
        this.title = Lang.getNoHTML("preferences.toolbar");
        this.active = new JList();
        this.inactive = new JList();
        this.setLayout(new BorderLayout());
        this.fillLists();
        this.showLabels = new JCheckBox(Lang.get("preferences.toolbar.labels"), Settings.getBoolean("toolbar.labels", false));
        JSplitPane pane = new JSplitPane(1);
        pane.setDividerLocation(180);
        pane.setDividerSize(0);
        JPanel left = new JPanel(new BorderLayout());
        this.active.setCellRenderer(new CellRenderer());
        this.active.setSelectionMode(1);
        ReorderListener listener = new ReorderListener();
        this.active.addMouseListener(listener);
        this.active.addMouseMotionListener(listener);
        left.add((Component)new JLabel(Lang.get("preferences.toolbar.active")), "North");
        left.add((Component)this.active, "Center");
        pane.setLeftComponent(left);
        JPanel right = new JPanel(new BorderLayout());
        JPanel movers = new JPanel();
        movers.setLayout(new BoxLayout(movers, 1));
        JButton moveLeft = new JButton(new AbstractAction("", Icons.get("left")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int inactiveSelectedItem = ToolBarPanel.this.inactive.getSelectedIndex();
                int activeSelectedItem = ToolBarPanel.this.active.getSelectedIndex();
                if (inactiveSelectedItem == -1) {
                    return;
                }
                if (activeSelectedItem == -1) {
                    ++activeSelectedItem;
                }
                DefaultListModel inactiveModel = (DefaultListModel)ToolBarPanel.this.inactive.getModel();
                DefaultListModel activeModel = (DefaultListModel)ToolBarPanel.this.active.getModel();
                Object obj = inactiveModel.getElementAt(inactiveSelectedItem);
                activeModel.add(activeSelectedItem, obj);
                if (obj instanceof ListItem && !"|".equals(((ListItem)obj).id) && !"-".equals(((ListItem)obj).id)) {
                    inactiveModel.remove(inactiveSelectedItem);
                }
                ToolBarPanel.this.active.setSelectedIndex(activeSelectedItem);
            }
        });
        JButton moveRight = new JButton(new AbstractAction("", Icons.get("right")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int inactiveSelectedItem = ToolBarPanel.this.inactive.getSelectedIndex();
                int activeSelectedItem = ToolBarPanel.this.active.getSelectedIndex();
                if (activeSelectedItem == -1) {
                    return;
                }
                if (inactiveSelectedItem == -1) {
                    ++inactiveSelectedItem;
                }
                DefaultListModel inactiveModel = (DefaultListModel)ToolBarPanel.this.inactive.getModel();
                DefaultListModel activeModel = (DefaultListModel)ToolBarPanel.this.active.getModel();
                Object obj = activeModel.getElementAt(activeSelectedItem);
                activeModel.remove(activeSelectedItem);
                if (obj instanceof ListItem && !"|".equals(((ListItem)obj).id) && !"-".equals(((ListItem)obj).id)) {
                    inactiveModel.add(inactiveSelectedItem, obj);
                }
                ToolBarPanel.this.inactive.setSelectedIndex(inactiveSelectedItem);
            }
        });
        movers.add(Box.createVerticalGlue());
        movers.add(moveLeft);
        movers.add(moveRight);
        movers.add(Box.createVerticalGlue());
        this.inactive.setCellRenderer(new CellRenderer());
        this.inactive.setSelectionMode(1);
        JPanel label = new JPanel();
        label.setLayout(new BoxLayout(label, 0));
        label.add(Box.createHorizontalStrut(28));
        label.add(new JLabel(Lang.get("preferences.toolbar.inactive")));
        right.add((Component)label, "North");
        right.add((Component)movers, "West");
        right.add((Component)this.inactive, "Center");
        pane.setRightComponent(right);
        this.add((Component)this.showLabels, "North");
        this.add((Component)pane, "Center");
    }

    @Override
    public void save() {
        Settings.put("toolbar.layout", this.active.getModel().toString().replaceAll("[\\[\\] ]", ""));
        Settings.put("toolbar.labels", this.showLabels.isSelected());
        ToolBar.getInstance().rebuildToolbarLayout();
    }

    private void fillLists() {
        HashMap<String, Action> actions = ToolBar.getInstance().getActions();
        List<String> layout = Arrays.asList(Settings.get("toolbar.layout", "new,open,save,|,undo,redo,|,map.pick,map.edit,map.transform,|,refresh,map.zoomin,map.zoomout,-,hamburger").split(","));
        DefaultListModel<ListItem> model = new DefaultListModel<ListItem>();
        for (String s : layout) {
            try {
                if ("|".equals(s)) {
                    model.addElement(new ListItem("|", null));
                    continue;
                }
                if ("-".equals(s)) {
                    model.addElement(new ListItem("-", null));
                    continue;
                }
                model.addElement(new ListItem(s, actions.get(s)));
                actions.remove(s);
            }
            catch (Exception e) {
                Logger.error("Unable to resolve the toolbar-action " + s);
            }
        }
        this.active.setModel(model);
        model = new DefaultListModel();
        for (String s : actions.keySet()) {
            model.addElement(new ListItem(s, actions.get(s)));
        }
        model.addElement(new ListItem("|", null));
        model.addElement(new ListItem("-", null));
        this.inactive.setModel(model);
    }

    private class ReorderListener
    extends MouseAdapter {
        private int pressIndex = 0;
        private int releaseIndex = 0;
        private Cursor grab = new Cursor(13);

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressIndex = ToolBarPanel.this.active.locationToIndex(e.getPoint());
            ToolBarPanel.this.active.setCursor(this.grab);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.releaseIndex = ToolBarPanel.this.active.locationToIndex(e.getPoint());
            if (this.releaseIndex != this.pressIndex && this.releaseIndex != -1) {
                this.reorder();
            }
            ToolBarPanel.this.active.setCursor(null);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseReleased(e);
            this.pressIndex = this.releaseIndex;
            ToolBarPanel.this.active.setCursor(this.grab);
        }

        private void reorder() {
            DefaultListModel model = (DefaultListModel)ToolBarPanel.this.active.getModel();
            Object dragee = model.elementAt(this.pressIndex);
            model.removeElementAt(this.pressIndex);
            model.insertElementAt(dragee, this.releaseIndex);
        }
    }

    private class ListItem {
        public String id;
        public String text;
        public ImageIcon icon;

        public ListItem(String id, Action a) {
            this.id = id;
            if (a != null) {
                this.text = (String)a.getValue("Name");
                this.icon = (ImageIcon)a.getValue("SmallIcon");
            } else if ("|".equals(id)) {
                this.text = "-----";
            } else if ("-".equals(id)) {
                this.text = " <-> ";
            }
        }

        public String toString() {
            return this.id;
        }
    }

    private class CellRenderer
    implements ListCellRenderer {
        private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

        private CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof ListItem) {
                ListItem item = (ListItem)value;
                JLabel label = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setText(item.text);
                label.setIcon(item.icon);
                return label;
            }
            return new JLabel(value.toString());
        }
    }
}

