/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import ch.rakudave.jnetmap.controller.Scheduler;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.IF.PhysicalIF;
import ch.rakudave.jnetmap.model.IF.TransparentIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.net.OUI;
import ch.rakudave.jnetmap.net.PortScan;
import ch.rakudave.jnetmap.net.SNMP;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.Tuple;
import ch.rakudave.jnetmap.view.components.PortScanner;
import ch.rakudave.jnetmap.view.properties.ConnectionProperties;
import ch.rakudave.jnetmap.view.properties.DeviceProperties;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class InfoPanel
extends JPanel
implements GraphMouseListener<Device> {
    private Device current;
    private JLabel icon;
    private JLabel status;
    private JTextArea description;
    private JTextArea history;
    private JList<Object> snmpLeft;
    private JList<Object> snmpRight;
    private JList<Object> interfaces;
    private JButton prefs;
    private JButton ports;

    public InfoPanel(final Frame owner) {
        this.setLayout(new BoxLayout(this, 1));
        JPanel infoPanel = new JPanel(new BorderLayout(5, 5));
        infoPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        infoPanel.setMaximumSize(new Dimension(2000, 135));
        this.icon = new JLabel("", Icons.getCisco("workstation"), 10);
        this.icon.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.description = new JTextArea();
        this.description.setLineWrap(true);
        this.description.setWrapStyleWord(true);
        this.description.setFocusable(false);
        this.description.setBackground(new Color(this.getBackground().getRGB()));
        JScrollPane spDescription = new JScrollPane(this.description);
        spDescription.setViewportBorder(BorderFactory.createEmptyBorder());
        this.status = new JLabel();
        infoPanel.add((Component)this.icon, "North");
        infoPanel.add((Component)spDescription, "Center");
        infoPanel.add((Component)this.status, "South");
        JPanel nifPanel = new JPanel(new GridLayout(1, 1));
        nifPanel.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("device.interfaces")));
        this.interfaces = new JList();
        this.interfaces.setCellRenderer(new IFListRenderer());
        this.interfaces.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    new ConnectionProperties(owner, ((NetworkIF)InfoPanel.this.interfaces.getSelectedValue()).getConnection());
                }
            }
        });
        nifPanel.add(this.interfaces);
        JScrollPane spNifs = new JScrollPane(nifPanel, 20, 30);
        spNifs.setViewportBorder(BorderFactory.createEmptyBorder());
        JPanel snmpPanel = new JPanel(new BorderLayout());
        snmpPanel.setBorder(BorderFactory.createTitledBorder("SNMP:"));
        JPanel inner = new JPanel(new BorderLayout());
        this.snmpLeft = new JList();
        this.snmpRight = new JList();
        this.snmpLeft.addListSelectionListener(e -> this.snmpRight.setSelectedIndex(this.snmpLeft.getSelectedIndex()));
        this.snmpRight.addListSelectionListener(e -> this.snmpLeft.setSelectedIndex(this.snmpRight.getSelectedIndex()));
        inner.add(this.snmpLeft, "West");
        inner.add(this.snmpRight, "Center");
        JScrollPane spSnmp = new JScrollPane(inner, 20, 30);
        spSnmp.setViewportBorder(BorderFactory.createEmptyBorder());
        snmpPanel.add((Component)spSnmp, "Center");
        JPanel historyPanel = new JPanel(new BorderLayout());
        historyPanel.setBorder(BorderFactory.createTitledBorder(Lang.getNoHTML("device.history")));
        this.history = new JTextArea();
        this.history.setEditable(false);
        this.history.setTabSize(2);
        this.history.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        JScrollPane spHistory = new JScrollPane(this.history, 20, 31);
        spHistory.setViewportBorder(BorderFactory.createEmptyBorder());
        historyPanel.add((Component)spHistory, "Center");
        JPanel buttons = new JPanel(new GridLayout(0, 2, 5, 5));
        buttons.setMaximumSize(new Dimension(2000, 30));
        this.prefs = new JButton(new AbstractAction(Lang.get("device.properties"), Icons.get("properties")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InfoPanel.this.current != null) {
                    new DeviceProperties(owner, InfoPanel.this.current, false);
                }
            }
        });
        this.prefs.setEnabled(false);
        this.ports = new JButton(new AbstractAction(Lang.getNoHTML("port.scan"), Icons.get("find")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InfoPanel.this.current != null && InfoPanel.this.current.getInterfaces().size() > 0) {
                    try {
                        new PortScanner(owner, InfoPanel.this.current.getInterfaces().get(0).getAddress().getHostAddress());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.ports.setEnabled(false);
        buttons.add(this.prefs);
        buttons.add(this.ports);
        this.add(Box.createVerticalStrut(5));
        this.add(infoPanel);
        this.add(spNifs);
        this.add(historyPanel);
        this.add(snmpPanel);
        this.add(buttons);
    }

    @Override
    public void graphReleased(Device device, MouseEvent event) {
    }

    @Override
    public void graphPressed(Device device, MouseEvent event) {
    }

    @Override
    public void graphClicked(Device device, MouseEvent event) {
        this.prefs.setEnabled(true);
        this.ports.setEnabled(true);
        this.current = device;
        InfoPanel.updateDeviceLabel(device, this.icon);
        this.description.setText(device.getDesctription());
        SimpleDateFormat df = new SimpleDateFormat(Settings.get("view.dateformat", "yyyy-MM-dd HH:mm"));
        StringBuilder sbStat = new StringBuilder();
        sbStat.append("<html>").append("<span style=\"color: ").append(device.getStatus().getHtmlValue()).append(";\">");
        sbStat.append(device.getStatus().getMessage()).append("</span>");
        if (device.getLastSeen() != null) {
            sbStat.append(" ").append(Lang.getNoHTML("since")).append(": ").append(df.format(device.getLastSeen()));
        }
        this.status.setText(sbStat.append("</html>").toString());
        Vector<Object> interfacesAndPorts = new Vector<Object>(device.getNrOfPorts());
        interfacesAndPorts.addAll(device.getInterfaces());
        for (int i = device.getInterfaces().size(); i < device.getNrOfPorts(); ++i) {
            interfacesAndPorts.add(Lang.getNoHTML("device.port") + " " + (i + 1));
        }
        this.interfaces.setListData(interfacesAndPorts);
        Scheduler.execute(() -> this.snmpScan(device));
        StringBuilder sbHist = new StringBuilder();
        Status prevStatus = Status.UNKNOWN;
        for (Tuple tuple : device.getStatusHistory()) {
            if (prevStatus == tuple.getSecond() || tuple.getSecond() == Status.UNKNOWN) continue;
            sbHist.insert(0, df.format((Date)tuple.getFirst()) + "  \t" + ((Status)((Object)tuple.getSecond())).getMessage() + "\n");
            prevStatus = (Status)((Object)tuple.getSecond());
        }
        this.history.setText(sbHist.toString());
    }

    public static void updateDeviceLabel(Device device, JLabel label) {
        label.setIcon("Other".equals(device.getType()) ? Icons.fromBase64(device.getOtherID()) : Icons.getCisco(device.getType().toLowerCase()));
        StringBuilder sbProps = new StringBuilder();
        sbProps.append("<html>").append(device.getName());
        if (!device.getVendor().isEmpty()) {
            sbProps.append("<br>").append(device.getVendor());
        }
        if (!device.getModel().isEmpty()) {
            sbProps.append(", ").append(device.getModel());
        }
        if (!device.getLocation().isEmpty()) {
            sbProps.append("<br>").append(device.getLocation());
        }
        sbProps.append("</html>");
        label.setText(sbProps.toString());
    }

    private void snmpScan(Device d) {
        HashMap<String, String> map;
        if (d == null) {
            return;
        }
        InetAddress address = null;
        for (NetworkIF nif : d.getInterfaces()) {
            if (!PortScan.isOpen(nif.getAddress(), 161)) continue;
            address = nif.getAddress();
            break;
        }
        if ((map = SNMP.getValues(address)) == null) {
            this.snmpLeft.setListData((Object[])new String[]{""});
            this.snmpRight.setListData((Object[])new String[]{""});
            return;
        }
        Vector<String> left = new Vector<String>();
        Vector<String> right = new Vector<String>();
        for (String s : new TreeSet(map.keySet())) {
            left.add(s);
            right.add((String)map.get(s));
        }
        if (d != this.current) {
            return;
        }
        this.snmpLeft.setListData(left);
        this.snmpRight.setListData(right);
    }

    private class IFListRenderer
    extends DefaultListCellRenderer {
        private IFListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            PhysicalIF pif;
            InetAddress addr;
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (!(value instanceof NetworkIF)) {
                label.setText("<html><span style=\"color: #999999;\">" + label.getText() + "</span></html>");
                return label;
            }
            NetworkIF nif = (NetworkIF)value;
            StringBuilder sb = new StringBuilder();
            sb.append("<span style=\"color: ").append(nif.getStatus().getHtmlValue()).append(";\">&#8226; </span>");
            sb.append(nif.getName());
            if (nif.getAddress() != null) {
                sb.append(": ").append(nif.getAddress().getHostAddress());
            } else if (nif instanceof TransparentIF && (addr = ((TransparentIF)nif).getCounterpart().getAddress()) != null) {
                sb.append(" &rarr; ").append(addr.getHostAddress());
            }
            if (Status.UP.equals((Object)nif.getStatus())) {
                sb.append(" (").append(nif.getLatency()).append("ms)");
            }
            if (nif instanceof PhysicalIF && (pif = (PhysicalIF)nif).getMacAddress() != null && !pif.getMacAddress().isEmpty()) {
                sb.append("<br>&nbsp;&nbsp;&nbsp;").append(pif.getMacAddress());
                String oui = OUI.getInstance().lookup(pif.getMacAddress());
                if (!"".equals(oui)) {
                    sb.append(" - <small>").append(oui).append("</small>");
                }
            }
            label.setText("<html>" + sb.toString() + "</html>");
            return label;
        }
    }
}

